/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

public enum QualityEncoding {
    BAM(0, false, 0, 93),
    SANGER(33, false, 0, 93),
    ILLUMINA(64, false, 0, 62),
    SOLEXA(59, true, -5, 62),
    PHRED(0, false, 0, 127);

    private final int asciiOffset;
    private final boolean solexaEncoding;
    private int minPhredScore;
    private int maxPhredScore;
    private boolean force = false;

    private QualityEncoding(int asciiOffset, boolean solexaEncoding, int minPhredScore, int maxPhredScore) {
        this.asciiOffset = asciiOffset;
        this.solexaEncoding = solexaEncoding;
        this.minPhredScore = minPhredScore;
        this.maxPhredScore = maxPhredScore;
    }

    public char phredQualityScoreToAsciiEncoding(byte qPhred) {
        if (this.solexaEncoding) {
            int qSolexa = (int)Math.round(10.0 * Math.log10(Math.pow(10.0, (double)qPhred / 10.0) - 1.0));
            return (char)(qSolexa + this.asciiOffset);
        }
        return (char)(qPhred + this.asciiOffset);
    }

    public byte asciiEncodingToPhredQualityScore(char asciiCharacter) {
        if (this.solexaEncoding) {
            int qSolexa = asciiCharacter - this.asciiOffset;
            byte qPhredScore = (byte)Math.round(10.0 * Math.log10(Math.pow(10.0, (double)qSolexa / 10.0) + 1.0));
            qPhredScore = this.forceInRange(qPhredScore);
            return qPhredScore;
        }
        return this.forceInRange((byte)(asciiCharacter - this.asciiOffset));
    }

    private byte forceInRange(byte value) {
        if (!this.force) {
            return value;
        }
        value = (byte)Math.min(this.maxPhredScore, value);
        value = (byte)Math.max(this.minPhredScore, value);
        return value;
    }

    public boolean isWithinValidRange(byte phredScore) {
        if (this.force) {
            return true;
        }
        return phredScore <= this.maxPhredScore && phredScore >= this.minPhredScore;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

