require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_MAP_H_)) {
    eval 'sub _UVM_UVM_MAP_H_ () {1;}' unless defined(&_UVM_UVM_MAP_H_);
    if(defined(&_KERNEL)) {
	eval 'sub UVM_MAP_CLIP_START {
	    my($MAP,$ENTRY,$VA) = @_;
    	    eval q({  &if (($VA) > ($ENTRY)-> &start  && ($VA) < ($ENTRY)-> &end) {  &uvm_map_clip_start($MAP,$ENTRY,$VA); } });
	}' unless defined(&UVM_MAP_CLIP_START);
	eval 'sub UVM_MAP_CLIP_END {
	    my($MAP,$ENTRY,$VA) = @_;
    	    eval q({  &if (($VA) > ($ENTRY)-> &start  && ($VA) < ($ENTRY)-> &end) {  &uvm_map_clip_end($MAP,$ENTRY,$VA); } });
	}' unless defined(&UVM_MAP_CLIP_END);
	eval 'sub UVM_EXTRACT_REMOVE () {0x1;}' unless defined(&UVM_EXTRACT_REMOVE);
	eval 'sub UVM_EXTRACT_CONTIG () {0x2;}' unless defined(&UVM_EXTRACT_CONTIG);
	eval 'sub UVM_EXTRACT_QREF () {0x4;}' unless defined(&UVM_EXTRACT_QREF);
	eval 'sub UVM_EXTRACT_FIXPROT () {0x8;}' unless defined(&UVM_EXTRACT_FIXPROT);
	eval 'sub UVM_EXTRACT_RESERVED () {0x10;}' unless defined(&UVM_EXTRACT_RESERVED);
	eval 'sub UVM_EXTRACT_PROT_ALL () {0x20;}' unless defined(&UVM_EXTRACT_PROT_ALL);
    }
    require 'sys/rbtree.ph';
    require 'sys/pool.ph';
    require 'sys/rwlock.ph';
    require 'sys/mutex.ph';
    require 'sys/condvar.ph';
    require 'uvm/uvm_anon.ph';
    eval 'sub uvm_map_entry_stop_copy () { &flags;}' unless defined(&uvm_map_entry_stop_copy);
    eval 'sub UVM_MAP_KERNEL () {0x1;}' unless defined(&UVM_MAP_KERNEL);
    eval 'sub UVM_MAP_STATIC () {0x4;}' unless defined(&UVM_MAP_STATIC);
    eval 'sub UVM_MAP_NOMERGE () {0x8;}' unless defined(&UVM_MAP_NOMERGE);
    eval 'sub VM_MAPENT_ISWIRED {
        my($entry) = @_;
	    eval q((($entry)-> &wired_count != 0));
    }' unless defined(&VM_MAPENT_ISWIRED);
    if(defined(&_KERNEL)) {
	require 'sys/callback.ph';
    }
    eval 'sub VM_MAP_IS_KERNEL {
        my($map) = @_;
	    eval q(( &vm_map_pmap($map) ==  &pmap_kernel()));
    }' unless defined(&VM_MAP_IS_KERNEL);
    eval 'sub VM_MAP_PAGEABLE () {0x1;}' unless defined(&VM_MAP_PAGEABLE);
    eval 'sub VM_MAP_WIREFUTURE () {0x4;}' unless defined(&VM_MAP_WIREFUTURE);
    eval 'sub VM_MAP_DYING () {0x20;}' unless defined(&VM_MAP_DYING);
    eval 'sub VM_MAP_TOPDOWN () {0x40;}' unless defined(&VM_MAP_TOPDOWN);
    eval 'sub VM_MAP_WANTVA () {0x100;}' unless defined(&VM_MAP_WANTVA);
    eval 'sub VM_MAP_BITS () {"\\177\\020b\\0PAGEABLE\\0b\\2WIREFUTURE\\0b\\5DYING\\0b\\6TOPDOWN\\0b\\10WANTVA\\0";}' unless defined(&VM_MAP_BITS);
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	require 'sys/proc.ph';
	if(defined(&PMAP_GROWKERNEL)) {
	}
	eval 'sub uvm_unmap {
	    my($map, $s, $e) = @_;
    	    eval q( &uvm_unmap1(($map), ($s), ($e), 0));
	}' unless defined(&uvm_unmap);
	eval 'sub UVM_MERGE_COPYING () {1;}' unless defined(&UVM_MERGE_COPYING);
    }
    eval 'sub vm_map_min {
        my($map) = @_;
	    eval q((($map)-> ($header->{end})));
    }' unless defined(&vm_map_min);
    eval 'sub vm_map_max {
        my($map) = @_;
	    eval q((($map)-> ($header->{start})));
    }' unless defined(&vm_map_max);
    eval 'sub vm_map_setmin {
        my($map, $v) = @_;
	    eval q((($map)-> ($header->{end}) = ($v)));
    }' unless defined(&vm_map_setmin);
    eval 'sub vm_map_setmax {
        my($map, $v) = @_;
	    eval q((($map)-> ($header->{start}) = ($v)));
    }' unless defined(&vm_map_setmax);
    eval 'sub vm_map_pmap {
        my($map) = @_;
	    eval q((($map)-> &pmap));
    }' unless defined(&vm_map_pmap);
}
1;
