/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import gov.nih.nlm.ncbi.ngs.Manager;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReferenceSequence;

public class NGS {
    private static Manager mgr = new Manager();

    public static boolean isSupported() {
        return mgr.isSupported();
    }

    public static ExceptionInInitializerError getInitializationError() {
        return NGS.mgr.invalid;
    }

    public static void setAppVersionString(String string) {
        mgr.setAppVersionString(string);
    }

    public static ReadCollection openReadCollection(String string) throws ErrorMsg {
        return mgr.openReadCollection(string);
    }

    public static ReferenceSequence openReferenceSequence(String string) throws ErrorMsg {
        return mgr.openReferenceSequence(string);
    }

    public static boolean isValid(String string) {
        return mgr.isValid(string);
    }

    private static void test(String string, boolean bl) {
        if (NGS.isValid(string) != bl) {
            System.err.println("ERRRRRRROR isValid(" + string + ") = " + !bl);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = System.getenv("HOME") + "/A/";
        try {
            NGS.isValid(null);
            System.exit(1);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        NGS.test("", false);
        NGS.test("SRR00000", false);
        NGS.test("SRR000000", false);
        NGS.test("SRR000001", true);
        NGS.test("https://sra-download.ncbi.nlm.nih.gov/srapub/SRR000001", true);
        NGS.test("SRR499924", true);
        NGS.test("https://sra-download.ncbi.nlm.nih.gov/srapub/SRR499924", true);
        NGS.test("SRR9000000", false);
        NGS.test("ERR000000", false);
        NGS.test("ERR000002", true);
        NGS.test("ERR900000", false);
        NGS.test("DRR000000", false);
        NGS.test("DRR000003", true);
        NGS.test("DRR900000", false);
        NGS.test(string + "notExisting", false);
        NGS.test(string + "empty", false);
        NGS.test(string + "text", false);
        NGS.test(string + "SRR053325.f", true);
        NGS.test(string + "SRR053325", true);
        NGS.test(string + "SRR600096.f", true);
        NGS.test(string + "SRR600096", true);
        NGS.test("https://w.gov/", false);
        NGS.test("https://www.nih.gov/", false);
        NGS.test("https://sra-download.ncbi.nlm.nih.gov/srapub/", false);
    }
}

