/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.classpath.SystemProperties;
import gnu.java.net.EmptyX509TrustManager;
import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import gnu.java.net.protocol.http.HTTPURLConnection;
import gnu.java.net.protocol.http.Request;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HTTPConnection {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private static final String userAgent = SystemProperties.getProperty("http.agent");
    protected final String hostname;
    protected final int port;
    protected final boolean secure;
    protected final int connectionTimeout;
    protected final int timeout;
    protected String proxyHostname;
    protected int proxyPort;
    protected int majorVersion;
    protected int minorVersion;
    private final List handshakeCompletedListeners;
    protected Socket socket;
    private SSLSocketFactory sslSocketFactory;
    protected InputStream in;
    protected OutputStream out;
    private Map nonceCounts;
    protected CookieManager cookieManager;
    private LinkedHashMap pool;
    int useCount;

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getVersion() {
        return "HTTP/" + this.majorVersion + '.' + this.minorVersion;
    }

    public void setVersion(int majorVersion, int minorVersion) {
        if (majorVersion != 1) {
            throw new IllegalArgumentException("major version not supported: " + majorVersion);
        }
        if (minorVersion < 0 || minorVersion > 1) {
            throw new IllegalArgumentException("minor version not supported: " + minorVersion);
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public void setProxy(String hostname, int port) {
        this.proxyHostname = hostname;
        this.proxyPort = port;
    }

    public boolean isUsingProxy() {
        boolean bl = false;
        if (this.proxyHostname != null && this.proxyPort > 0) {
            bl = true;
        }
        return bl;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    static Object getPoolKey(String h, int p, boolean sec) {
        StringBuilder buf = new StringBuilder(sec ? "https://" : "http://");
        buf.append(h);
        buf.append(':');
        buf.append(p);
        return buf.toString();
    }

    void setPool(LinkedHashMap p) {
        this.pool = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void release() {
        if (this.pool == null) return;
        LinkedHashMap linkedHashMap = this.pool;
        synchronized (linkedHashMap) {
            ++this.useCount;
            Object key = HTTPConnection.getPoolKey(this.hostname, this.port, this.secure);
            this.pool.put(key, this);
            while (this.pool.size() >= HTTPURLConnection.maxConnections) {
                Object lru = this.pool.keySet().iterator().next();
                HTTPConnection c = (HTTPConnection)this.pool.remove(lru);
                try {
                    c.closeConnection();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public Request newRequest(String method, String path) {
        Cookie[] cookies;
        if (method == null || method.length() == 0) {
            throw new IllegalArgumentException("method must have non-zero length");
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        Request ret = new Request(this, method, path);
        if (this.secure && this.port != 443 || !this.secure && this.port != 80) {
            ret.setHeader("Host", this.hostname + ':' + this.port);
        } else {
            ret.setHeader("Host", this.hostname);
        }
        ret.setHeader("User-Agent", userAgent);
        ret.setHeader("Connection", "keep-alive");
        ret.setHeader("Accept-Encoding", "chunked;q=1.0, gzip;q=0.9, deflate;q=0.8, identity;q=0.6, *;q=0");
        if (this.cookieManager != null && (cookies = this.cookieManager.getCookies(this.hostname, this.secure, path)) != null && cookies.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("$Version=1");
            int i = 0;
            while (i < cookies.length) {
                buf.append(',');
                buf.append(' ');
                buf.append(cookies[i].toString());
                ++i;
            }
            ret.setHeader("Cookie", buf.toString());
        }
        return ret;
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Socket getSocket() throws IOException {
        if (this.socket == null) {
            String connectHostname = this.hostname;
            int connectPort = this.port;
            if (this.isUsingProxy()) {
                connectHostname = this.proxyHostname;
                connectPort = this.proxyPort;
            }
            this.socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(connectHostname, connectPort);
            if (this.connectionTimeout > 0) {
                this.socket.connect(address, this.connectionTimeout);
            } else {
                this.socket.connect(address);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            if (this.secure) {
                try {
                    SSLSocket ss;
                    block12: {
                        SSLSocketFactory factory = this.getSSLSocketFactory();
                        ss = (SSLSocket)factory.createSocket(this.socket, connectHostname, connectPort, true);
                        String[] protocols = new String[]{"TLSv1", "SSLv3"};
                        ss.setEnabledProtocols(protocols);
                        ss.setUseClientMode(true);
                        List list2 = this.handshakeCompletedListeners;
                        synchronized (list2) {
                            if (this.handshakeCompletedListeners.isEmpty()) break block12;
                            Iterator i = this.handshakeCompletedListeners.iterator();
                            while (i.hasNext()) {
                                HandshakeCompletedListener l = (HandshakeCompletedListener)i.next();
                                ss.addHandshakeCompletedListener(l);
                            }
                        }
                    }
                    ss.startHandshake();
                    this.socket = ss;
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.in = this.socket.getInputStream();
            this.in = new BufferedInputStream(this.in);
            this.out = this.socket.getOutputStream();
            this.out = new BufferedOutputStream(this.out);
        }
        return this.socket;
    }

    SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException {
        if (this.sslSocketFactory == null) {
            EmptyX509TrustManager tm = new EmptyX509TrustManager();
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManager[] trust = new TrustManager[]{tm};
            context.init(null, trust, null);
            this.sslSocketFactory = context.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    void setSSLSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.out;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void closeConnection() throws IOException {
        if (this.socket == null) return;
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.socket = null;
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.socket = null;
            return;
        }
    }

    protected String getURI() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.secure ? "https://" : "http://");
        buf.append(this.hostname);
        if (this.secure) {
            if (this.port != 443) {
                buf.append(':');
                buf.append(this.port);
            }
        } else if (this.port != 80) {
            buf.append(':');
            buf.append(this.port);
        }
        return buf.toString();
    }

    int getNonceCount(String nonce) {
        if (this.nonceCounts == null) {
            return 0;
        }
        return (Integer)this.nonceCounts.get(nonce);
    }

    void incrementNonce(String nonce) {
        int current = this.getNonceCount(nonce);
        if (this.nonceCounts == null) {
            this.nonceCounts = new HashMap();
        }
        this.nonceCounts.put(nonce, new Integer(current + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addHandshakeCompletedListener(HandshakeCompletedListener l) {
        List list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            this.handshakeCompletedListeners.add(l);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeHandshakeCompletedListener(HandshakeCompletedListener l) {
        List list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            this.handshakeCompletedListeners.remove(l);
            return;
        }
    }

    public HTTPConnection(String hostname) {
        this(hostname, 80, false, 0, 0);
    }

    public HTTPConnection(String hostname, boolean secure) {
        this(hostname, secure ? 443 : 80, secure, 0, 0);
    }

    public HTTPConnection(String hostname, boolean secure, int connectionTimeout, int timeout) {
        this(hostname, secure ? 443 : 80, secure, connectionTimeout, timeout);
    }

    public HTTPConnection(String hostname, int port) {
        this(hostname, port, false, 0, 0);
    }

    public HTTPConnection(String hostname, int port, boolean secure) {
        this(hostname, port, secure, 0, 0);
    }

    public HTTPConnection(String hostname, int port, boolean secure, int connectionTimeout, int timeout) {
        this.hostname = hostname;
        this.port = port;
        this.secure = secure;
        this.connectionTimeout = connectionTimeout;
        this.timeout = timeout;
        this.minorVersion = 1;
        this.majorVersion = 1;
        this.handshakeCompletedListeners = new ArrayList(2);
    }
}

