/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class BasicComboBoxRenderer
extends JLabel
implements ListCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = value.toString();
        FontMetrics fm = this.getToolkit().getFontMetrics(list2.getFont());
        int strWidth = SwingUtilities.computeStringWidth(fm, s);
        int cbWidth = this.getSize().width;
        if (cbWidth != 0 && strWidth > cbWidth) {
            char[] str = s.toCharArray();
            int currWidth = 0;
            int i = 0;
            String postStr = "... ";
            cbWidth -= SwingUtilities.computeStringWidth(fm, postStr);
            while (i < str.length && currWidth < cbWidth) {
                currWidth = SwingUtilities.computeStringWidth(fm, new String(str, 0, ++i));
            }
            this.setText(new String(str, 0, i) + postStr);
        } else {
            this.setText(s);
        }
        this.setOpaque(true);
        if (isSelected || cellHasFocus) {
            this.setBackground(list2.getSelectionBackground());
            this.setForeground(list2.getSelectionForeground());
        } else {
            this.setBackground(list2.getBackground());
            this.setForeground(list2.getForeground());
        }
        this.setEnabled(list2.isEnabled());
        this.setFont(list2.getFont());
        return this;
    }

    public BasicComboBoxRenderer() {
        this.setHorizontalAlignment(2);
        this.setBorder(noFocusBorder);
    }

    public static class UIResource
    extends BasicComboBoxRenderer
    implements javax.swing.plaf.UIResource {
    }
}

