/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalIconFactory
implements Serializable {
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static RadioButtonIcon radioButtonIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeHardDriveIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new MetalCheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        return new HorizontalSliderThumbIcon();
    }

    public static Icon getInternalFrameCloseIcon(int size) {
        return new InternalFrameCloseIcon(size);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int size) {
        return new InternalFrameMaximizeIcon();
    }

    public static Icon getInternalFrameMinimizeIcon(int size) {
        return new InternalFrameMinimizeIcon();
    }

    public static Icon getInternalFrameAltMaximizeIcon(int size) {
        return new InternalFrameAltMaximizeIcon(size);
    }

    public static Icon getVerticalSliderThumbIcon() {
        return new VerticalSliderThumbIcon();
    }

    public static Icon getTreeFolderIcon() {
        return new TreeFolderIcon();
    }

    public static Icon getTreeLeafIcon() {
        return new TreeLeafIcon();
    }

    public static Icon getTreeControlIcon(boolean isCollapsed) {
        return new TreeControlIcon(isCollapsed);
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)c;
            if (item.isArmed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(x, y, x + 8, y);
            g.drawLine(x, y + 1, x, y + 8);
            g.drawLine(x + 2, y + 8, x + 8, y + 8);
            g.drawLine(x + 8, y + 2, x + 8, y + 7);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 1, y + 1, x + 7, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 7);
            g.drawLine(x + 1, y + 9, x + 9, y + 9);
            g.drawLine(x + 9, y + 1, x + 9, y + 8);
            if (item.isSelected()) {
                g.setColor(MetalLookAndFeel.getBlack());
                g.fillRect(x + 2, y + 2, 2, 5);
                int i = 0;
                while (i < 6) {
                    g.drawLine(x + 8 - i, y + i, x + 9 - i, y + i);
                    ++i;
                }
            }
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y + 2, x + 5, y + 2);
            g.drawLine(x + 6, y + 3, x + 6, y + 7);
            g.drawLine(x + 2, y + 7, x + 6, y + 7);
            g.drawLine(x + 2, y + 2, x + 2, y + 7);
            g.drawLine(x + 2, y + 10, x + 5, y + 10);
            g.drawLine(x + 6, y + 11, x + 6, y + 15);
            g.drawLine(x + 2, y + 15, x + 6, y + 15);
            g.drawLine(x + 2, y + 10, x + 2, y + 15);
            g.drawLine(x + 8, y + 5, x + 15, y + 5);
            g.drawLine(x + 8, y + 13, x + 15, y + 13);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 3, y + 3, 3, 4);
            g.fillRect(x + 3, y + 11, 3, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(x + 4, y + 4, x + 4, y + 5);
            g.drawLine(x + 4, y + 12, x + 4, y + 13);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 1, y + 8, x + 8, y + 1);
            g.drawLine(x + 8, y + 1, x + 15, y + 8);
            g.drawLine(x + 3, y + 6, x + 3, y + 15);
            g.drawLine(x + 3, y + 15, x + 13, y + 15);
            g.drawLine(x + 13, y + 6, x + 13, y + 15);
            g.drawLine(x + 6, y + 9, x + 6, y + 15);
            g.drawLine(x + 6, y + 9, x + 10, y + 9);
            g.drawLine(x + 10, y + 9, x + 10, y + 15);
            g.drawLine(x + 11, y + 2, x + 11, y + 4);
            g.drawLine(x + 12, y + 2, x + 12, y + 5);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            int xx = x + 8;
            int i = 0;
            while (i < 4) {
                g.drawLine(xx - i, y + 2 + i, xx + i, y + 2 + i);
                ++i;
            }
            g.fillRect(x + 4, y + 6, 9, 2);
            g.drawLine(x + 9, y + 12, x + 9, y + 12);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.drawLine(x + 4, y + 8, x + 12, y + 8);
            g.fillRect(x + 4, y + 9, 2, 6);
            g.fillRect(x + 11, y + 9, 2, 6);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y + 2, x + 5, y + 2);
            g.drawLine(x + 6, y + 3, x + 6, y + 7);
            g.drawLine(x + 2, y + 7, x + 6, y + 7);
            g.drawLine(x + 2, y + 2, x + 2, y + 7);
            g.drawLine(x + 2, y + 10, x + 5, y + 10);
            g.drawLine(x + 6, y + 11, x + 6, y + 15);
            g.drawLine(x + 2, y + 15, x + 6, y + 15);
            g.drawLine(x + 2, y + 10, x + 2, y + 15);
            g.drawLine(x + 10, y + 2, x + 13, y + 2);
            g.drawLine(x + 14, y + 3, x + 14, y + 7);
            g.drawLine(x + 10, y + 7, x + 14, y + 7);
            g.drawLine(x + 10, y + 2, x + 10, y + 7);
            g.drawLine(x + 10, y + 10, x + 13, y + 10);
            g.drawLine(x + 14, y + 11, x + 14, y + 15);
            g.drawLine(x + 10, y + 15, x + 14, y + 15);
            g.drawLine(x + 10, y + 10, x + 10, y + 15);
            g.drawLine(x + 8, y + 5, x + 8, y + 5);
            g.drawLine(x + 8, y + 13, x + 8, y + 13);
            g.drawLine(x + 16, y + 5, x + 16, y + 5);
            g.drawLine(x + 16, y + 13, x + 16, y + 13);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 3, y + 3, 3, 4);
            g.fillRect(x + 3, y + 11, 3, 4);
            g.fillRect(x + 11, y + 3, 3, 4);
            g.fillRect(x + 11, y + 11, 3, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(x + 4, y + 4, x + 4, y + 5);
            g.drawLine(x + 4, y + 12, x + 4, y + 13);
            g.drawLine(x + 12, y + 4, x + 12, y + 5);
            g.drawLine(x + 12, y + 12, x + 12, y + 13);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y + 5, x + 9, y + 5);
            g.drawLine(x + 10, y + 6, x + 15, y + 6);
            g.drawLine(x + 15, y + 5, x + 15, y + 14);
            g.drawLine(x + 2, y + 14, x + 15, y + 14);
            g.drawLine(x + 1, y + 6, x + 1, y + 14);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(x + 11, y + 3, x + 15, y + 3);
            g.drawLine(x + 10, y + 4, x + 15, y + 4);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 3, y + 7, 7, 7);
            g.fillRect(x + 10, y + 8, 5, 6);
            g.drawLine(x + 10, y + 5, x + 14, y + 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(x + 10, y + 7, x + 14, y + 7);
            g.drawLine(x + 2, y + 6, x + 9, y + 6);
            g.drawLine(x + 2, y + 6, x + 2, y + 13);
            g.setColor(savedColor);
        }
    }

    private static class FileChooserUpFolderIcon
    extends FileChooserNewFolderIcon
    implements Icon,
    Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            super.paintIcon(c, g, x, y);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 8, y + 9, x + 8, y + 16);
            int xx = x + 8;
            int i = 0;
            while (i < 4) {
                g.drawLine(xx - i, y + 9 + i, xx + i, y + 9 + i);
                ++i;
            }
            g.setColor(savedColor);
        }
    }

    static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            JRadioButton b = (JRadioButton)c;
            if (b.isEnabled()) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlDisabled());
            }
            g.drawLine(x + 2, y + 1, x + 3, y + 1);
            g.drawLine(x + 4, y, x + 7, y);
            g.drawLine(x + 8, y + 1, x + 9, y + 1);
            g.drawLine(x + 10, y + 2, x + 10, y + 3);
            g.drawLine(x + 11, y + 4, x + 11, y + 7);
            g.drawLine(x + 10, y + 8, x + 10, y + 9);
            g.drawLine(x + 8, y + 10, x + 9, y + 10);
            g.drawLine(x + 4, y + 11, x + 7, y + 11);
            g.drawLine(x + 2, y + 10, x + 3, y + 10);
            g.drawLine(x + 1, y + 9, x + 1, y + 8);
            g.drawLine(x, y + 7, x, y + 4);
            g.drawLine(x + 1, y + 2, x + 1, y + 3);
            if (b.getModel().isArmed()) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawLine(x + 4, y + 1, x + 7, y + 1);
                g.drawLine(x + 4, y + 10, x + 7, y + 10);
                g.drawLine(x + 1, y + 4, x + 1, y + 7);
                g.drawLine(x + 10, y + 4, x + 10, y + 7);
                g.fillRect(x + 2, y + 2, 8, 8);
            } else if (b.isEnabled()) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 2, y + 8, x + 2, y + 9);
                g.drawLine(x + 1, y + 4, x + 1, y + 7);
                g.drawLine(x + 2, y + 2, x + 2, y + 3);
                g.drawLine(x + 3, y + 2, x + 3, y + 2);
                g.drawLine(x + 4, y + 1, x + 7, y + 1);
                g.drawLine(x + 8, y + 2, x + 9, y + 2);
            }
            if (b.isEnabled()) {
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x + 10, y + 1, x + 10, y + 1);
                g.drawLine(x + 11, y + 2, x + 11, y + 3);
                g.drawLine(x + 12, y + 4, x + 12, y + 7);
                g.drawLine(x + 11, y + 8, x + 11, y + 9);
                g.drawLine(x + 10, y + 10, x + 10, y + 10);
                g.drawLine(x + 8, y + 11, x + 9, y + 11);
                g.drawLine(x + 4, y + 12, x + 7, y + 12);
                g.drawLine(x + 2, y + 11, x + 3, y + 11);
            }
            if (b.isSelected()) {
                if (b.isEnabled()) {
                    g.setColor(MetalLookAndFeel.getBlack());
                } else {
                    g.setColor(MetalLookAndFeel.getControlDisabled());
                }
                g.drawLine(x + 4, y + 3, x + 7, y + 3);
                g.fillRect(x + 3, y + 4, 6, 4);
                g.drawLine(x + 4, y + 8, x + 7, y + 8);
            }
            g.setColor(savedColor);
        }

        RadioButtonIcon() {
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)c;
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 2, y, x + 6, y);
            g.drawLine(x + 7, y + 1, x + 7, y + 1);
            g.drawLine(x + 8, y + 2, x + 8, y + 6);
            g.drawLine(x + 7, y + 7, x + 7, y + 7);
            g.drawLine(x + 2, y + 8, x + 6, y + 8);
            g.drawLine(x + 1, y + 7, x + 1, y + 7);
            g.drawLine(x, y + 2, x, y + 6);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            if (item.isSelected()) {
                g.drawLine(x + 3, y + 2, x + 5, y + 2);
                g.fillRect(x + 2, y + 3, 5, 3);
                g.drawLine(x + 3, y + 6, x + 5, y + 6);
            }
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 3, y + 1, x + 6, y + 1);
            g.drawLine(x + 8, y + 1, x + 8, y + 1);
            g.drawLine(x + 9, y + 2, x + 9, y + 7);
            g.drawLine(x + 8, y + 8, x + 8, y + 8);
            g.drawLine(x + 2, y + 9, x + 7, y + 9);
            g.drawLine(x + 1, y + 8, x + 1, y + 8);
            g.drawLine(x + 1, y + 3, x + 1, y + 6);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.setColor(savedColor);
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean enabled = false;
            boolean focus = false;
            if (c != null) {
                enabled = c.isEnabled();
                focus = c.hasFocus();
            }
            if (enabled) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(x + 1, y, x + 13, y);
            g.drawLine(x + 14, y + 1, x + 14, y + 7);
            g.drawLine(x + 14, y + 8, x + 7, y + 15);
            g.drawLine(x + 6, y + 14, x, y + 8);
            g.drawLine(x, y + 7, x, y + 1);
            if (focus) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControl());
            }
            g.fillRect(x + 1, y + 2, 13, 7);
            g.drawLine(x + 2, y + 9, x + 12, y + 9);
            g.drawLine(x + 3, y + 10, x + 11, y + 10);
            g.drawLine(x + 4, y + 11, x + 10, y + 11);
            g.drawLine(x + 5, y + 12, x + 9, y + 12);
            g.drawLine(x + 6, y + 13, x + 8, y + 13);
            g.drawLine(x + 7, y + 14, x + 7, y + 14);
            if (c.isEnabled()) {
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    g.setColor(MetalLookAndFeel.getBlack());
                }
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
                g.drawLine(x + 7, y + 3, x + 7, y + 3);
                g.drawLine(x + 11, y + 3, x + 11, y + 3);
                g.drawLine(x + 5, y + 5, x + 5, y + 5);
                g.drawLine(x + 9, y + 5, x + 9, y + 5);
                g.drawLine(x + 3, y + 7, x + 3, y + 7);
                g.drawLine(x + 7, y + 7, x + 7, y + 7);
                g.drawLine(x + 11, y + 7, x + 11, y + 7);
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(MetalLookAndFeel.getWhite());
                }
                g.drawLine(x + 1, y + 1, x + 13, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 8);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 6, y + 2, x + 6, y + 2);
                g.drawLine(x + 10, y + 2, x + 10, y + 2);
                g.drawLine(x + 4, y + 4, x + 4, y + 4);
                g.drawLine(x + 8, y + 4, x + 8, y + 4);
                g.drawLine(x + 2, y + 6, x + 2, y + 6);
                g.drawLine(x + 6, y + 6, x + 6, y + 6);
                g.drawLine(x + 10, y + 6, x + 10, y + 6);
            }
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    Serializable {
        private int size;

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            g.fillRect(x + 2, y + 2, 10, 10);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                boolean selected = true;
                if (selected) {
                    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
            }
            g.drawLine(x + 1, y + 1, x + 13, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 12);
            g.drawLine(x + 1, y + 13, x + 13, y + 13);
            g.drawLine(x + 13, y + 2, x + 13, y + 12);
            g.drawLine(x + 2, y + 12, x + 2, y + 12);
            g.drawLine(x + 12, y + 2, x + 12, y + 2);
            g.fillRect(x + 4, y + 4, 2, 2);
            g.fillRect(x + 5, y + 5, 4, 4);
            g.drawLine(x + 9, y + 4, x + 10, y + 4);
            g.drawLine(x + 9, y + 4, x + 9, y + 5);
            g.drawLine(x + 4, y + 9, x + 4, y + 10);
            g.drawLine(x + 4, y + 9, x + 5, y + 9);
            g.drawLine(x + 9, y + 8, x + 9, y + 10);
            g.drawLine(x + 8, y + 9, x + 10, y + 9);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x, y, x + 13, y);
            g.drawLine(x, y + 1, x, y + 13);
            g.drawLine(x + 3, y + 4, x + 4, y + 3);
            g.drawLine(x + 3, y + 9, x + 5, y + 7);
            g.drawLine(x + 7, y + 5, x + 9, y + 3);
            g.drawLine(x + 12, y + 3, x + 12, y + 11);
            g.drawLine(x + 3, y + 12, x + 12, y + 12);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 1, y + 14, x + 14, y + 14);
            g.drawLine(x + 14, y + 1, x + 14, y + 14);
            if (!b.getModel().isPressed()) {
                g.drawLine(x + 5, y + 10, x + 5, y + 10);
                g.drawLine(x + 6, y + 9, x + 7, y + 9);
                g.drawLine(x + 10, y + 5, x + 10, y + 5);
                g.drawLine(x + 9, y + 6, x + 9, y + 7);
                g.drawLine(x + 10, y + 10, x + 11, y + 10);
                g.drawLine(x + 10, y + 11, x + 10, y + 11);
            }
            g.setColor(savedColor);
        }

        public InternalFrameCloseIcon(int size) {
            this.size = size;
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(new Color(102, 102, 153));
            g.fillRect(x + 1, y, 14, 2);
            g.fillRect(x, y + 1, 2, 14);
            g.fillRect(x + 1, y + 14, 14, 2);
            g.fillRect(x + 14, y + 1, 2, 14);
            g.drawLine(x + 2, y + 5, x + 14, y + 5);
            g.setColor(new Color(204, 204, 255));
            g.fillRect(x + 2, y + 2, 12, 3);
            g.setColor(new Color(102, 102, 153));
            g.drawLine(x + 3, y + 3, x + 3, y + 3);
            g.drawLine(x + 6, y + 3, x + 6, y + 3);
            g.drawLine(x + 9, y + 3, x + 9, y + 3);
            g.drawLine(x + 12, y + 3, x + 12, y + 3);
            g.setColor(Color.white);
            g.fillRect(x + 2, y + 6, 12, 8);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.drawLine(x + 5, y + 2, x + 5, y + 2);
            g.drawLine(x + 8, y + 2, x + 8, y + 2);
            g.drawLine(x + 11, y + 2, x + 11, y + 2);
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            g.fillRect(x + 2, y + 6, 7, 7);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            g.drawLine(x + 9, y + 1, x + 10, y + 1);
            g.fillRect(x + 11, y + 1, 3, 3);
            g.fillRect(x + 12, y + 4, 2, 2);
            g.drawLine(x + 10, y + 3, x + 10, y + 3);
            g.drawLine(x + 9, y + 4, x + 10, y + 4);
            g.drawLine(x + 1, y + 5, x + 9, y + 5);
            g.drawLine(x + 1, y + 6, x + 1, y + 12);
            g.drawLine(x + 9, y + 6, x + 9, y + 12);
            g.drawLine(x + 1, y + 13, x + 9, y + 13);
            g.drawLine(x + 7, y + 6, x + 8, y + 6);
            g.drawLine(x + 6, y + 7, x + 8, y + 7);
            g.drawLine(x + 5, y + 8, x + 6, y + 8);
            g.drawLine(x + 4, y + 9, x + 5, y + 9);
            g.drawLine(x + 3, y + 10, x + 4, y + 10);
            g.drawLine(x + 2, y + 11, x + 3, y + 11);
            g.drawLine(x + 2, y + 12, x + 4, y + 12);
            g.drawLine(x + 8, y + 8, x + 8, y + 8);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 8, y, x + 13, y);
            g.drawLine(x + 8, y + 1, x + 8, y + 1);
            g.drawLine(x + 10, y + 2, x + 9, y + 3);
            g.drawLine(x, y + 4, x + 8, y + 4);
            g.drawLine(x, y + 5, x, y + 13);
            g.drawLine(x + 2, y + 10, x + 6, y + 6);
            g.drawLine(x + 8, y + 9, x + 8, y + 11);
            g.drawLine(x + 5, y + 12, x + 8, y + 12);
            g.setColor(MetalLookAndFeel.getWhite());
            if (!b.getModel().isPressed()) {
                g.drawLine(x + 2, y + 6, x + 5, y + 6);
                g.drawLine(x + 2, y + 7, x + 2, y + 9);
                g.drawLine(x + 4, y + 11, x + 7, y + 8);
            }
            g.drawLine(x + 1, y + 14, x + 10, y + 14);
            g.drawLine(x + 10, y + 5, x + 10, y + 13);
            g.drawLine(x + 9, y + 2, x + 9, y + 2);
            g.drawLine(x + 11, y + 4, x + 11, y + 5);
            g.drawLine(x + 13, y + 6, x + 14, y + 6);
            g.drawLine(x + 14, y + 1, x + 14, y + 5);
            g.setColor(savedColor);
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            g.drawLine(x + 12, y + 1, x + 13, y + 1);
            g.drawLine(x + 11, y + 2, x + 12, y + 2);
            g.drawLine(x + 10, y + 3, x + 11, y + 3);
            g.drawLine(x + 8, y + 2, x + 8, y + 3);
            g.fillRect(x + 8, y + 4, 3, 3);
            g.drawLine(x + 11, y + 6, x + 12, y + 6);
            g.drawLine(x + 1, y + 8, x + 6, y + 8);
            g.drawLine(x + 1, y + 9, x + 1, y + 12);
            g.drawLine(x + 6, y + 9, x + 6, y + 12);
            g.drawLine(x + 1, y + 13, x + 6, y + 13);
            g.drawLine(x + 5, y + 9, x + 5, y + 9);
            g.drawLine(x + 2, y + 12, x + 2, y + 12);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 12, y, x + 9, y + 3);
            g.drawLine(x + 7, y + 1, x + 8, y + 1);
            g.drawLine(x + 7, y + 2, x + 7, y + 6);
            g.drawLine(x, y + 7, x + 6, y + 7);
            g.drawLine(x, y + 8, x, y + 13);
            g.drawLine(x + 3, y + 12, x + 5, y + 12);
            g.drawLine(x + 5, y + 10, x + 5, y + 11);
            g.drawLine(x + 11, y + 5, x + 12, y + 5);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 9, y + 2, x + 9, y + 2);
            g.drawLine(x + 11, y + 4, x + 13, y + 2);
            g.drawLine(x + 13, y + 6, x + 13, y + 6);
            g.drawLine(x + 8, y + 7, x + 13, y + 7);
            g.drawLine(x + 7, y + 9, x + 7, y + 13);
            g.drawLine(x + 1, y + 14, x + 7, y + 14);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                g.fillRect(x + 2, y + 9, 3, 3);
            } else {
                g.drawLine(x + 2, y + 9, x + 4, y + 9);
                g.drawLine(x + 2, y + 10, x + 2, y + 11);
            }
            g.setColor(savedColor);
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    Serializable {
        private int size;

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton b = (AbstractButton)c;
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            g.fillRect(x + 2, y + 6, 7, 7);
            if (b.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            g.drawLine(x + 12, y + 1, x + 13, y + 1);
            g.drawLine(x + 11, y + 2, x + 12, y + 2);
            g.drawLine(x + 10, y + 3, x + 11, y + 3);
            g.drawLine(x + 8, y + 2, x + 8, y + 3);
            g.fillRect(x + 8, y + 4, 3, 3);
            g.drawLine(x + 11, y + 6, x + 12, y + 6);
            g.drawLine(x + 1, y + 5, x + 5, y + 5);
            g.drawLine(x + 1, y + 6, x + 1, y + 12);
            g.drawLine(x + 9, y + 9, x + 9, y + 12);
            g.drawLine(x + 1, y + 13, x + 9, y + 13);
            g.drawLine(x + 2, y + 12, x + 2, y + 12);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 12, y, x + 9, y + 3);
            g.drawLine(x + 7, y + 1, x + 8, y + 1);
            g.drawLine(x + 7, y + 2, x + 7, y + 6);
            g.drawLine(x + 11, y + 5, x + 12, y + 5);
            g.drawLine(x, y + 4, x + 5, y + 4);
            g.drawLine(x, y + 5, x, y + 13);
            g.drawLine(x + 3, y + 12, x + 8, y + 12);
            g.drawLine(x + 8, y + 8, x + 8, y + 11);
            g.drawLine(x + 9, y + 8, x + 9, y + 8);
            g.setColor(MetalLookAndFeel.getWhite());
            g.drawLine(x + 9, y + 2, x + 9, y + 2);
            g.drawLine(x + 11, y + 4, x + 13, y + 2);
            g.drawLine(x + 13, y + 6, x + 13, y + 6);
            g.drawLine(x + 8, y + 7, x + 13, y + 7);
            g.drawLine(x + 6, y + 5, x + 6, y + 5);
            g.drawLine(x + 10, y + 8, x + 10, y + 13);
            g.drawLine(x + 1, y + 14, x + 10, y + 14);
            if (!b.getModel().isPressed()) {
                g.drawLine(x + 2, y + 6, x + 6, y + 6);
                g.drawLine(x + 2, y + 6, x + 2, y + 11);
            }
            g.setColor(savedColor);
        }

        public InternalFrameAltMaximizeIcon(int size) {
            this.size = size;
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean enabled = false;
            boolean focus = false;
            if (c != null) {
                enabled = c.isEnabled();
                focus = c.hasFocus();
            }
            if (enabled) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(x + 1, y, x + 7, y);
            g.drawLine(x + 8, y, x + 15, y + 7);
            g.drawLine(x + 14, y + 8, x + 8, y + 14);
            g.drawLine(x + 8, y + 14, x + 1, y + 14);
            g.drawLine(x, y + 13, x, y + 1);
            if (focus) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControl());
            }
            g.fillRect(x + 2, y + 1, 7, 13);
            g.drawLine(x + 9, y + 2, x + 9, y + 12);
            g.drawLine(x + 10, y + 3, x + 10, y + 11);
            g.drawLine(x + 11, y + 4, x + 11, y + 10);
            g.drawLine(x + 12, y + 5, x + 12, y + 9);
            g.drawLine(x + 13, y + 6, x + 13, y + 8);
            g.drawLine(x + 14, y + 7, x + 14, y + 7);
            if (enabled) {
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    g.setColor(MetalLookAndFeel.getBlack());
                }
                g.drawLine(x + 3, y + 3, x + 3, y + 3);
                g.drawLine(x + 3, y + 7, x + 3, y + 7);
                g.drawLine(x + 3, y + 11, x + 3, y + 11);
                g.drawLine(x + 5, y + 5, x + 5, y + 5);
                g.drawLine(x + 5, y + 9, x + 5, y + 9);
                g.drawLine(x + 7, y + 3, x + 7, y + 3);
                g.drawLine(x + 7, y + 7, x + 7, y + 7);
                g.drawLine(x + 7, y + 11, x + 7, y + 11);
                if (focus) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(MetalLookAndFeel.getWhite());
                }
                g.drawLine(x + 1, y + 1, x + 8, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 13);
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 2, y + 6, x + 2, y + 6);
                g.drawLine(x + 2, y + 10, x + 2, y + 10);
                g.drawLine(x + 4, y + 4, x + 4, y + 4);
                g.drawLine(x + 4, y + 8, x + 4, y + 8);
                g.drawLine(x + 6, y + 2, x + 6, y + 2);
                g.drawLine(x + 6, y + 6, x + 6, y + 6);
                g.drawLine(x + 6, y + 10, x + 6, y + 10);
            }
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getAdditionalHeight() {
            return 2;
        }

        public int getShift() {
            return -1;
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getAdditionalHeight() {
            return 4;
        }

        public int getShift() {
            return 2;
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;
        private boolean collapsed;

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            x += 5;
            y += 5;
            if (this.collapsed) {
                g.setColor(Color.black);
                g.drawLine(x + 2, y, x + 5, y);
                g.drawLine(x + 6, y + 1, x + 7, y + 2);
                g.fillRect(x + 7, y + 3, 5, 2);
                g.drawLine(x + 7, y + 5, x + 6, y + 6);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x, y + 2, x, y + 5);
                g.drawLine(x + 1, y + 6, x + 1, y + 6);
                g.drawLine(x + 2, y + 7, x + 5, y + 7);
                g.fillRect(x + 3, y + 3, 2, 2);
                g.setColor(new Color(204, 204, 255));
                g.drawLine(x + 3, y + 2, x + 4, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 4);
                g.drawLine(x + 3, y + 5, x + 3, y + 5);
                g.drawLine(x + 5, y + 3, x + 5, y + 3);
                g.setColor(new Color(153, 153, 204));
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 2, y + 5, x + 2, y + 5);
                g.drawLine(x + 2, y + 6, x + 5, y + 6);
                g.drawLine(x + 5, y + 2, x + 5, y + 2);
                g.drawLine(x + 6, y + 2, x + 6, y + 5);
                g.setColor(new Color(102, 102, 153));
                g.drawLine(x + 2, y + 1, x + 5, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 5);
            } else {
                g.setColor(Color.black);
                g.drawLine(x + 2, y, x + 5, y);
                g.drawLine(x + 6, y + 1, x + 7, y + 2);
                g.drawLine(x + 7, y + 2, x + 7, y + 5);
                g.fillRect(x + 3, y + 7, 2, 5);
                g.drawLine(x + 7, y + 5, x + 6, y + 6);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x, y + 2, x, y + 5);
                g.drawLine(x + 1, y + 6, x + 1, y + 6);
                g.drawLine(x + 2, y + 7, x + 5, y + 7);
                g.fillRect(x + 3, y + 3, 2, 2);
                g.setColor(new Color(204, 204, 255));
                g.drawLine(x + 3, y + 2, x + 4, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 4);
                g.drawLine(x + 3, y + 5, x + 3, y + 5);
                g.drawLine(x + 5, y + 3, x + 5, y + 3);
                g.setColor(new Color(153, 153, 204));
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 2, y + 5, x + 2, y + 5);
                g.drawLine(x + 2, y + 6, x + 5, y + 6);
                g.drawLine(x + 5, y + 2, x + 5, y + 2);
                g.drawLine(x + 6, y + 2, x + 6, y + 5);
                g.setColor(new Color(102, 102, 153));
                g.drawLine(x + 2, y + 1, x + 5, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 5);
            }
        }

        public void paintMe(Component c, Graphics g, int x, int y) {
            this.paintIcon(c, g, x, y);
        }

        public TreeControlIcon(boolean isCollapsed) {
            this.collapsed = isCollapsed;
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saved = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 3, y + 1, x + 12, y + 1);
            g.drawLine(x + 2, y + 2, x + 2, y + 8);
            g.drawLine(x + 13, y + 2, x + 13, y + 8);
            g.drawLine(x + 3, y + 9, x + 3, y + 9);
            g.drawLine(x + 12, y + 9, x + 12, y + 9);
            g.drawRect(x + 1, y + 10, 13, 4);
            g.drawLine(x + 5, y + 3, x + 10, y + 3);
            g.drawLine(x + 5, y + 8, x + 10, y + 8);
            g.drawLine(x + 4, y + 4, x + 4, y + 7);
            g.drawLine(x + 11, y + 4, x + 11, y + 7);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 5, y + 4, 6, 4);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(x + 6, y + 12, x + 8, y + 12);
            g.drawLine(x + 10, y + 12, x + 12, y + 12);
            g.setColor(saved);
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saved = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 1, y + 1, x + 13, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + 14);
            g.drawLine(x + 1, y + 14, x + 14, y + 14);
            g.drawLine(x + 14, y + 2, x + 14, y + 14);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(x + 2, y + 2, 12, 12);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.fillRect(x + 5, y + 2, 6, 5);
            g.drawLine(x + 4, y + 8, x + 11, y + 8);
            g.drawLine(x + 3, y + 9, x + 3, y + 13);
            g.drawLine(x + 12, y + 9, x + 12, y + 13);
            g.setColor(MetalLookAndFeel.getWhite());
            g.fillRect(x + 8, y + 3, 2, 3);
            g.fillRect(x + 4, y + 9, 8, 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            g.drawLine(x + 5, y + 10, x + 9, y + 10);
            g.drawLine(x + 5, y + 12, x + 8, y + 12);
            g.setColor(saved);
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color saved = g.getColor();
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 1, y + 4, x + 1, y + 5);
            g.drawLine(x + 14, y + 4, x + 14, y + 5);
            g.drawLine(x + 1, y + 7, x + 1, y + 8);
            g.drawLine(x + 14, y + 7, x + 14, y + 8);
            g.drawLine(x + 1, y + 10, x + 1, y + 11);
            g.drawLine(x + 14, y + 10, x + 14, y + 11);
            g.drawLine(x + 2, y + 3, x + 3, y + 3);
            g.drawLine(x + 12, y + 3, x + 13, y + 3);
            g.drawLine(x + 2, y + 6, x + 3, y + 6);
            g.drawLine(x + 12, y + 6, x + 13, y + 6);
            g.drawLine(x + 2, y + 9, x + 3, y + 9);
            g.drawLine(x + 12, y + 9, x + 13, y + 9);
            g.drawLine(x + 2, y + 12, x + 3, y + 12);
            g.drawLine(x + 12, y + 12, x + 13, y + 12);
            g.drawLine(x + 4, y + 2, x + 11, y + 2);
            g.drawLine(x + 4, y + 7, x + 11, y + 7);
            g.drawLine(x + 4, y + 10, x + 11, y + 10);
            g.drawLine(x + 4, y + 13, x + 11, y + 13);
            g.setColor(MetalLookAndFeel.getWhite());
            g.fillRect(x + 4, y + 3, 2, 2);
            g.drawLine(x + 6, y + 4, x + 6, y + 4);
            g.drawLine(x + 7, y + 3, x + 9, y + 3);
            g.drawLine(x + 8, y + 4, x + 8, y + 4);
            g.drawLine(x + 11, y + 3, x + 11, y + 3);
            g.fillRect(x + 2, y + 4, 2, 2);
            g.fillRect(x + 2, y + 7, 2, 2);
            g.fillRect(x + 2, y + 10, 2, 2);
            g.drawLine(x + 4, y + 6, x + 4, y + 6);
            g.drawLine(x + 4, y + 9, x + 4, y + 9);
            g.drawLine(x + 4, y + 12, x + 4, y + 12);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(x + 13, y + 4, x + 13, y + 4);
            g.drawLine(x + 12, y + 5, x + 13, y + 5);
            g.drawLine(x + 13, y + 7, x + 13, y + 7);
            g.drawLine(x + 12, y + 8, x + 13, y + 8);
            g.drawLine(x + 13, y + 10, x + 13, y + 10);
            g.drawLine(x + 12, y + 11, x + 13, y + 11);
            g.drawLine(x + 10, y + 5, x + 10, y + 5);
            g.drawLine(x + 7, y + 6, x + 7, y + 6);
            g.drawLine(x + 9, y + 6, x + 9, y + 6);
            g.drawLine(x + 11, y + 6, x + 11, y + 6);
            g.drawLine(x + 10, y + 8, x + 10, y + 8);
            g.drawLine(x + 7, y + 9, x + 7, y + 9);
            g.drawLine(x + 9, y + 9, x + 9, y + 9);
            g.drawLine(x + 11, y + 9, x + 11, y + 9);
            g.drawLine(x + 10, y + 11, x + 10, y + 11);
            g.drawLine(x + 7, y + 12, x + 7, y + 12);
            g.drawLine(x + 9, y + 12, x + 9, y + 12);
            g.drawLine(x + 11, y + 12, x + 11, y + 12);
            g.setColor(saved);
        }
    }

    public static class PaletteCloseIcon
    implements Icon,
    Serializable,
    UIResource {
        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            AbstractButton button = (AbstractButton)c;
            if (button.getModel().isPressed()) {
                g.setColor(MetalLookAndFeel.getBlack());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.fillRect(x + 2, y + 2, 3, 3);
            g.drawLine(x + 1, y, x + 1, y + 2);
            g.drawLine(x, y + 1, x + 2, y + 1);
            g.drawLine(x + 5, y, x + 5, y + 2);
            g.drawLine(x + 4, y + 1, x + 6, y + 1);
            g.drawLine(x + 1, y + 4, x + 1, y + 6);
            g.drawLine(x, y + 5, x + 2, y + 5);
            g.drawLine(x + 5, y + 4, x + 5, y + 6);
            g.drawLine(x + 4, y + 5, x + 6, y + 5);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(x + 2, y + 6, x + 3, y + 5);
            g.drawLine(x + 5, y + 3, x + 6, y + 2);
            g.drawLine(x + 6, y + 6, x + 6, y + 6);
            g.setColor(savedColor);
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16 + this.getAdditionalHeight();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawLine(x, y + 3, x, y + 12);
            g.drawLine(x, y + 12, x + 15, y + 12);
            g.drawLine(x + 15, y + 12, x + 15, y + 2);
            g.drawLine(x + 14, y + 3, x + 9, y + 3);
            g.drawLine(x + 8, y + 2, x + 1, y + 2);
            g.setColor(new Color(204, 204, 255));
            g.fillRect(x + 2, y + 4, 7, 8);
            g.fillRect(x + 9, y + 5, 6, 7);
            g.setColor(new Color(102, 102, 153));
            g.drawLine(x + 9, y + 2, x + 14, y + 2);
            g.setColor(new Color(50, 50, 120));
            g.drawLine(x + 9, y + 1, x + 15, y + 1);
            g.drawLine(x + 10, y, x + 15, y);
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getShift() {
            return 0;
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16 + this.getAdditionalHeight();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawLine(x, y, x + 9, y);
            g.drawLine(x, y + 1, x, y + 15);
            g.drawLine(x, y + 15, x + 12, y + 15);
            g.drawLine(x + 12, y + 15, x + 12, y + 6);
            g.drawLine(x + 12, y + 6, x + 9, y);
            g.drawLine(x + 7, y + 2, x + 11, y + 6);
            g.drawLine(x + 8, y + 1, x + 9, y + 1);
            g.setColor(new Color(204, 204, 255));
            g.drawLine(x + 1, y + 1, x + 7, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + 14);
            g.drawLine(x + 1, y + 14, x + 11, y + 14);
            g.drawLine(x + 11, y + 14, x + 11, y + 7);
            g.drawLine(x + 8, y + 2, x + 10, y + 4);
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getShift() {
            return 0;
        }
    }
}

