package XML::Entities::Data;
use strict;
my @names;

# ISOBOX
push @names, 'isobox';
{ my $rv; sub isobox {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'boxDL' => chr(0x02557),
        'boxDl' => chr(0x02556),
        'boxdL' => chr(0x02555),
        'boxdl' => chr(0x02510),
        'boxDR' => chr(0x02554),
        'boxDr' => chr(0x02553),
        'boxdR' => chr(0x02552),
        'boxdr' => chr(0x0250C),
        'boxH' => chr(0x02550),
        'boxh' => chr(0x02500),
        'boxHD' => chr(0x02566),
        'boxHd' => chr(0x02564),
        'boxhD' => chr(0x02565),
        'boxhd' => chr(0x0252C),
        'boxHU' => chr(0x02569),
        'boxHu' => chr(0x02567),
        'boxhU' => chr(0x02568),
        'boxhu' => chr(0x02534),
        'boxUL' => chr(0x0255D),
        'boxUl' => chr(0x0255C),
        'boxuL' => chr(0x0255B),
        'boxul' => chr(0x02518),
        'boxUR' => chr(0x0255A),
        'boxUr' => chr(0x02559),
        'boxuR' => chr(0x02558),
        'boxur' => chr(0x02514),
        'boxV' => chr(0x02551),
        'boxv' => chr(0x02502),
        'boxVH' => chr(0x0256C),
        'boxVh' => chr(0x0256B),
        'boxvH' => chr(0x0256A),
        'boxvh' => chr(0x0253C),
        'boxVL' => chr(0x02563),
        'boxVl' => chr(0x02562),
        'boxvL' => chr(0x02561),
        'boxvl' => chr(0x02524),
        'boxVR' => chr(0x02560),
        'boxVr' => chr(0x0255F),
        'boxvR' => chr(0x0255E),
        'boxvr' => chr(0x0251C),
    }
}}

# ISOCYR1
push @names, 'isocyr1';
{ my $rv; sub isocyr1 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Acy' => chr(0x00410),
        'acy' => chr(0x00430),
        'Bcy' => chr(0x00411),
        'bcy' => chr(0x00431),
        'CHcy' => chr(0x00427),
        'chcy' => chr(0x00447),
        'Dcy' => chr(0x00414),
        'dcy' => chr(0x00434),
        'Ecy' => chr(0x0042D),
        'ecy' => chr(0x0044D),
        'Fcy' => chr(0x00424),
        'fcy' => chr(0x00444),
        'Gcy' => chr(0x00413),
        'gcy' => chr(0x00433),
        'HARDcy' => chr(0x0042A),
        'hardcy' => chr(0x0044A),
        'Icy' => chr(0x00418),
        'icy' => chr(0x00438),
        'IEcy' => chr(0x00415),
        'iecy' => chr(0x00435),
        'IOcy' => chr(0x00401),
        'iocy' => chr(0x00451),
        'Jcy' => chr(0x00419),
        'jcy' => chr(0x00439),
        'Kcy' => chr(0x0041A),
        'kcy' => chr(0x0043A),
        'KHcy' => chr(0x00425),
        'khcy' => chr(0x00445),
        'Lcy' => chr(0x0041B),
        'lcy' => chr(0x0043B),
        'Mcy' => chr(0x0041C),
        'mcy' => chr(0x0043C),
        'Ncy' => chr(0x0041D),
        'ncy' => chr(0x0043D),
        'numero' => chr(0x02116),
        'Ocy' => chr(0x0041E),
        'ocy' => chr(0x0043E),
        'Pcy' => chr(0x0041F),
        'pcy' => chr(0x0043F),
        'Rcy' => chr(0x00420),
        'rcy' => chr(0x00440),
        'Scy' => chr(0x00421),
        'scy' => chr(0x00441),
        'SHCHcy' => chr(0x00429),
        'shchcy' => chr(0x00449),
        'SHcy' => chr(0x00428),
        'shcy' => chr(0x00448),
        'SOFTcy' => chr(0x0042C),
        'softcy' => chr(0x0044C),
        'Tcy' => chr(0x00422),
        'tcy' => chr(0x00442),
        'TScy' => chr(0x00426),
        'tscy' => chr(0x00446),
        'Ucy' => chr(0x00423),
        'ucy' => chr(0x00443),
        'Vcy' => chr(0x00412),
        'vcy' => chr(0x00432),
        'YAcy' => chr(0x0042F),
        'yacy' => chr(0x0044F),
        'Ycy' => chr(0x0042B),
        'ycy' => chr(0x0044B),
        'YUcy' => chr(0x0042E),
        'yucy' => chr(0x0044E),
        'Zcy' => chr(0x00417),
        'zcy' => chr(0x00437),
        'ZHcy' => chr(0x00416),
        'zhcy' => chr(0x00436),
    }
}}

# ISOCYR2
push @names, 'isocyr2';
{ my $rv; sub isocyr2 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'DJcy' => chr(0x00402),
        'djcy' => chr(0x00452),
        'DScy' => chr(0x00405),
        'dscy' => chr(0x00455),
        'DZcy' => chr(0x0040F),
        'dzcy' => chr(0x0045F),
        'GJcy' => chr(0x00403),
        'gjcy' => chr(0x00453),
        'Iukcy' => chr(0x00406),
        'iukcy' => chr(0x00456),
        'Jsercy' => chr(0x00408),
        'jsercy' => chr(0x00458),
        'Jukcy' => chr(0x00404),
        'jukcy' => chr(0x00454),
        'KJcy' => chr(0x0040C),
        'kjcy' => chr(0x0045C),
        'LJcy' => chr(0x00409),
        'ljcy' => chr(0x00459),
        'NJcy' => chr(0x0040A),
        'njcy' => chr(0x0045A),
        'TSHcy' => chr(0x0040B),
        'tshcy' => chr(0x0045B),
        'Ubrcy' => chr(0x0040E),
        'ubrcy' => chr(0x0045E),
        'YIcy' => chr(0x00407),
        'yicy' => chr(0x00457),
    }
}}

# ISODIA
push @names, 'isodia';
{ my $rv; sub isodia {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'acute' => chr(0x000B4),
        'breve' => chr(0x002D8),
        'caron' => chr(0x002C7),
        'cedil' => chr(0x000B8),
        'circ' => chr(0x002C6),
        'dblac' => chr(0x002DD),
        'die' => chr(0x000A8),
        'dot' => chr(0x002D9),
        'grave' => chr(0x00060),
        'macr' => chr(0x000AF),
        'ogon' => chr(0x002DB),
        'ring' => chr(0x002DA),
        'tilde' => chr(0x002DC),
        'uml' => chr(0x000A8),
    }
}}

# ISOLAT1
push @names, 'isolat1';
{ my $rv; sub isolat1 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Aacute' => chr(0x000C1),
        'aacute' => chr(0x000E1),
        'Acirc' => chr(0x000C2),
        'acirc' => chr(0x000E2),
        'AElig' => chr(0x000C6),
        'aelig' => chr(0x000E6),
        'Agrave' => chr(0x000C0),
        'agrave' => chr(0x000E0),
        'Aring' => chr(0x000C5),
        'aring' => chr(0x000E5),
        'Atilde' => chr(0x000C3),
        'atilde' => chr(0x000E3),
        'Auml' => chr(0x000C4),
        'auml' => chr(0x000E4),
        'Ccedil' => chr(0x000C7),
        'ccedil' => chr(0x000E7),
        'Eacute' => chr(0x000C9),
        'eacute' => chr(0x000E9),
        'Ecirc' => chr(0x000CA),
        'ecirc' => chr(0x000EA),
        'Egrave' => chr(0x000C8),
        'egrave' => chr(0x000E8),
        'ETH' => chr(0x000D0),
        'eth' => chr(0x000F0),
        'Euml' => chr(0x000CB),
        'euml' => chr(0x000EB),
        'Iacute' => chr(0x000CD),
        'iacute' => chr(0x000ED),
        'Icirc' => chr(0x000CE),
        'icirc' => chr(0x000EE),
        'Igrave' => chr(0x000CC),
        'igrave' => chr(0x000EC),
        'Iuml' => chr(0x000CF),
        'iuml' => chr(0x000EF),
        'Ntilde' => chr(0x000D1),
        'ntilde' => chr(0x000F1),
        'Oacute' => chr(0x000D3),
        'oacute' => chr(0x000F3),
        'Ocirc' => chr(0x000D4),
        'ocirc' => chr(0x000F4),
        'Ograve' => chr(0x000D2),
        'ograve' => chr(0x000F2),
        'Oslash' => chr(0x000D8),
        'oslash' => chr(0x000F8),
        'Otilde' => chr(0x000D5),
        'otilde' => chr(0x000F5),
        'Ouml' => chr(0x000D6),
        'ouml' => chr(0x000F6),
        'szlig' => chr(0x000DF),
        'THORN' => chr(0x000DE),
        'thorn' => chr(0x000FE),
        'Uacute' => chr(0x000DA),
        'uacute' => chr(0x000FA),
        'Ucirc' => chr(0x000DB),
        'ucirc' => chr(0x000FB),
        'Ugrave' => chr(0x000D9),
        'ugrave' => chr(0x000F9),
        'Uuml' => chr(0x000DC),
        'uuml' => chr(0x000FC),
        'Yacute' => chr(0x000DD),
        'yacute' => chr(0x000FD),
        'yuml' => chr(0x000FF),
    }
}}

# ISOLAT2
push @names, 'isolat2';
{ my $rv; sub isolat2 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Abreve' => chr(0x00102),
        'abreve' => chr(0x00103),
        'Amacr' => chr(0x00100),
        'amacr' => chr(0x00101),
        'Aogon' => chr(0x00104),
        'aogon' => chr(0x00105),
        'Cacute' => chr(0x00106),
        'cacute' => chr(0x00107),
        'Ccaron' => chr(0x0010C),
        'ccaron' => chr(0x0010D),
        'Ccirc' => chr(0x00108),
        'ccirc' => chr(0x00109),
        'Cdot' => chr(0x0010A),
        'cdot' => chr(0x0010B),
        'Dcaron' => chr(0x0010E),
        'dcaron' => chr(0x0010F),
        'Dstrok' => chr(0x00110),
        'dstrok' => chr(0x00111),
        'Ecaron' => chr(0x0011A),
        'ecaron' => chr(0x0011B),
        'Edot' => chr(0x00116),
        'edot' => chr(0x00117),
        'Emacr' => chr(0x00112),
        'emacr' => chr(0x00113),
        'ENG' => chr(0x0014A),
        'eng' => chr(0x0014B),
        'Eogon' => chr(0x00118),
        'eogon' => chr(0x00119),
        'gacute' => chr(0x001F5),
        'Gbreve' => chr(0x0011E),
        'gbreve' => chr(0x0011F),
        'Gcedil' => chr(0x00122),
        'Gcirc' => chr(0x0011C),
        'gcirc' => chr(0x0011D),
        'Gdot' => chr(0x00120),
        'gdot' => chr(0x00121),
        'Hcirc' => chr(0x00124),
        'hcirc' => chr(0x00125),
        'Hstrok' => chr(0x00126),
        'hstrok' => chr(0x00127),
        'Idot' => chr(0x00130),
        'IJlig' => chr(0x00132),
        'ijlig' => chr(0x00133),
        'Imacr' => chr(0x0012A),
        'imacr' => chr(0x0012B),
        'inodot' => chr(0x00131),
        'Iogon' => chr(0x0012E),
        'iogon' => chr(0x0012F),
        'Itilde' => chr(0x00128),
        'itilde' => chr(0x00129),
        'Jcirc' => chr(0x00134),
        'jcirc' => chr(0x00135),
        'Kcedil' => chr(0x00136),
        'kcedil' => chr(0x00137),
        'kgreen' => chr(0x00138),
        'Lacute' => chr(0x00139),
        'lacute' => chr(0x0013A),
        'Lcaron' => chr(0x0013D),
        'lcaron' => chr(0x0013E),
        'Lcedil' => chr(0x0013B),
        'lcedil' => chr(0x0013C),
        'Lmidot' => chr(0x0013F),
        'lmidot' => chr(0x00140),
        'Lstrok' => chr(0x00141),
        'lstrok' => chr(0x00142),
        'Nacute' => chr(0x00143),
        'nacute' => chr(0x00144),
        'napos' => chr(0x00149),
        'Ncaron' => chr(0x00147),
        'ncaron' => chr(0x00148),
        'Ncedil' => chr(0x00145),
        'ncedil' => chr(0x00146),
        'Odblac' => chr(0x00150),
        'odblac' => chr(0x00151),
        'OElig' => chr(0x00152),
        'oelig' => chr(0x00153),
        'Omacr' => chr(0x0014C),
        'omacr' => chr(0x0014D),
        'Racute' => chr(0x00154),
        'racute' => chr(0x00155),
        'Rcaron' => chr(0x00158),
        'rcaron' => chr(0x00159),
        'Rcedil' => chr(0x00156),
        'rcedil' => chr(0x00157),
        'Sacute' => chr(0x0015A),
        'sacute' => chr(0x0015B),
        'Scaron' => chr(0x00160),
        'scaron' => chr(0x00161),
        'Scedil' => chr(0x0015E),
        'scedil' => chr(0x0015F),
        'Scirc' => chr(0x0015C),
        'scirc' => chr(0x0015D),
        'Tcaron' => chr(0x00164),
        'tcaron' => chr(0x00165),
        'Tcedil' => chr(0x00162),
        'tcedil' => chr(0x00163),
        'Tstrok' => chr(0x00166),
        'tstrok' => chr(0x00167),
        'Ubreve' => chr(0x0016C),
        'ubreve' => chr(0x0016D),
        'Udblac' => chr(0x00170),
        'udblac' => chr(0x00171),
        'Umacr' => chr(0x0016A),
        'umacr' => chr(0x0016B),
        'Uogon' => chr(0x00172),
        'uogon' => chr(0x00173),
        'Uring' => chr(0x0016E),
        'uring' => chr(0x0016F),
        'Utilde' => chr(0x00168),
        'utilde' => chr(0x00169),
        'Wcirc' => chr(0x00174),
        'wcirc' => chr(0x00175),
        'Ycirc' => chr(0x00176),
        'ycirc' => chr(0x00177),
        'Yuml' => chr(0x00178),
        'Zacute' => chr(0x00179),
        'zacute' => chr(0x0017A),
        'Zcaron' => chr(0x0017D),
        'zcaron' => chr(0x0017E),
        'Zdot' => chr(0x0017B),
        'zdot' => chr(0x0017C),
    }
}}

# ISONUM
push @names, 'isonum';
{ my $rv; sub isonum {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'amp' => chr(38),
        'apos' => chr(0x00027),
        'ast' => chr(0x0002A),
        'brvbar' => chr(0x000A6),
        'bsol' => chr(0x0005C),
        'cent' => chr(0x000A2),
        'colon' => chr(0x0003A),
        'comma' => chr(0x0002C),
        'commat' => chr(0x00040),
        'copy' => chr(0x000A9),
        'curren' => chr(0x000A4),
        'darr' => chr(0x02193),
        'deg' => chr(0x000B0),
        'divide' => chr(0x000F7),
        'dollar' => chr(0x00024),
        'equals' => chr(0x0003D),
        'excl' => chr(0x00021),
        'frac12' => chr(0x000BD),
        'frac14' => chr(0x000BC),
        'frac18' => chr(0x0215B),
        'frac34' => chr(0x000BE),
        'frac38' => chr(0x0215C),
        'frac58' => chr(0x0215D),
        'frac78' => chr(0x0215E),
        'gt' => chr(0x0003E),
        'half' => chr(0x000BD),
        'horbar' => chr(0x02015),
        'hyphen' => chr(0x02010),
        'iexcl' => chr(0x000A1),
        'iquest' => chr(0x000BF),
        'laquo' => chr(0x000AB),
        'larr' => chr(0x02190),
        'lcub' => chr(0x0007B),
        'ldquo' => chr(0x0201C),
        'lowbar' => chr(0x0005F),
        'lpar' => chr(0x00028),
        'lsqb' => chr(0x0005B),
        'lsquo' => chr(0x02018),
        'lt' => chr(60),
        'micro' => chr(0x000B5),
        'middot' => chr(0x000B7),
        'nbsp' => chr(0x000A0),
        'not' => chr(0x000AC),
        'num' => chr(0x00023),
        'ohm' => chr(0x02126),
        'ordf' => chr(0x000AA),
        'ordm' => chr(0x000BA),
        'para' => chr(0x000B6),
        'percnt' => chr(0x00025),
        'period' => chr(0x0002E),
        'plus' => chr(0x0002B),
        'plusmn' => chr(0x000B1),
        'pound' => chr(0x000A3),
        'quest' => chr(0x0003F),
        'quot' => chr(0x00022),
        'raquo' => chr(0x000BB),
        'rarr' => chr(0x02192),
        'rcub' => chr(0x0007D),
        'rdquo' => chr(0x0201D),
        'reg' => chr(0x000AE),
        'rpar' => chr(0x00029),
        'rsqb' => chr(0x0005D),
        'rsquo' => chr(0x02019),
        'sect' => chr(0x000A7),
        'semi' => chr(0x0003B),
        'shy' => chr(0x000AD),
        'sol' => chr(0x0002F),
        'sung' => chr(0x0266A),
        'sup1' => chr(0x000B9),
        'sup2' => chr(0x000B2),
        'sup3' => chr(0x000B3),
        'times' => chr(0x000D7),
        'trade' => chr(0x02122),
        'uarr' => chr(0x02191),
        'verbar' => chr(0x0007C),
        'yen' => chr(0x000A5),
    }
}}

# ISOPUB
push @names, 'isopub';
{ my $rv; sub isopub {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'blank' => chr(0x02423),
        'blk12' => chr(0x02592),
        'blk14' => chr(0x02591),
        'blk34' => chr(0x02593),
        'block' => chr(0x02588),
        'bull' => chr(0x02022),
        'caret' => chr(0x02041),
        'check' => chr(0x02713),
        'cir' => chr(0x025CB),
        'clubs' => chr(0x02663),
        'copysr' => chr(0x02117),
        'cross' => chr(0x02717),
        'Dagger' => chr(0x02021),
        'dagger' => chr(0x02020),
        'dash' => chr(0x02010),
        'diams' => chr(0x02666),
        'dlcrop' => chr(0x0230D),
        'drcrop' => chr(0x0230C),
        'dtri' => chr(0x025BF),
        'dtrif' => chr(0x025BE),
        'emsp' => chr(0x02003),
        'emsp13' => chr(0x02004),
        'emsp14' => chr(0x02005),
        'ensp' => chr(0x02002),
        'female' => chr(0x02640),
        'ffilig' => chr(0x0FB03),
        'fflig' => chr(0x0FB00),
        'ffllig' => chr(0x0FB04),
        'filig' => chr(0x0FB01),
        'flat' => chr(0x0266D),
        'fllig' => chr(0x0FB02),
        'frac13' => chr(0x02153),
        'frac15' => chr(0x02155),
        'frac16' => chr(0x02159),
        'frac23' => chr(0x02154),
        'frac25' => chr(0x02156),
        'frac35' => chr(0x02157),
        'frac45' => chr(0x02158),
        'frac56' => chr(0x0215A),
        'hairsp' => chr(0x0200A),
        'hearts' => chr(0x02665),
        'hellip' => chr(0x02026),
        'hybull' => chr(0x02043),
        'incare' => chr(0x02105),
        'ldquor' => chr(0x0201E),
        'lhblk' => chr(0x02584),
        'loz' => chr(0x025CA),
        'lozf' => chr(0x029EB),
        'lsquor' => chr(0x0201A),
        'ltri' => chr(0x025C3),
        'ltrif' => chr(0x025C2),
        'male' => chr(0x02642),
        'malt' => chr(0x02720),
        'marker' => chr(0x025AE),
        'mdash' => chr(0x02014),
        'mldr' => chr(0x02026),
        'natur' => chr(0x0266E),
        'ndash' => chr(0x02013),
        'nldr' => chr(0x02025),
        'numsp' => chr(0x02007),
        'phone' => chr(0x0260E),
        'puncsp' => chr(0x02008),
        'rdquor' => chr(0x0201D),
        'rect' => chr(0x025AD),
        'rsquor' => chr(0x02019),
        'rtri' => chr(0x025B9),
        'rtrif' => chr(0x025B8),
        'rx' => chr(0x0211E),
        'sext' => chr(0x02736),
        'sharp' => chr(0x0266F),
        'spades' => chr(0x02660),
        'squ' => chr(0x025A1),
        'squf' => chr(0x025AA),
        'star' => chr(0x02606),
        'starf' => chr(0x02605),
        'target' => chr(0x02316),
        'telrec' => chr(0x02315),
        'thinsp' => chr(0x02009),
        'uhblk' => chr(0x02580),
        'ulcrop' => chr(0x0230F),
        'urcrop' => chr(0x0230E),
        'utri' => chr(0x025B5),
        'utrif' => chr(0x025B4),
        'vellip' => chr(0x022EE),
    }
}}

# ISOAMSA
push @names, 'isoamsa';
{ my $rv; sub isoamsa {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'angzarr' => chr(0x0237C),
        'cirmid' => chr(0x02AEF),
        'cudarrl' => chr(0x02938),
        'cudarrr' => chr(0x02935),
        'cularr' => chr(0x021B6),
        'cularrp' => chr(0x0293D),
        'curarr' => chr(0x021B7),
        'curarrm' => chr(0x0293C),
        'Darr' => chr(0x021A1),
        'dArr' => chr(0x021D3),
        'ddarr' => chr(0x021CA),
        'DDotrahd' => chr(0x02911),
        'dfisht' => chr(0x0297F),
        'dHar' => chr(0x02965),
        'dharl' => chr(0x021C3),
        'dharr' => chr(0x021C2),
        'duarr' => chr(0x021F5),
        'duhar' => chr(0x0296F),
        'dzigrarr' => chr(0x027FF),
        'erarr' => chr(0x02971),
        'hArr' => chr(0x021D4),
        'harr' => chr(0x02194),
        'harrcir' => chr(0x02948),
        'harrw' => chr(0x021AD),
        'hoarr' => chr(0x021FF),
        'imof' => chr(0x022B7),
        'lAarr' => chr(0x021DA),
        'Larr' => chr(0x0219E),
        'larrbfs' => chr(0x0291F),
        'larrfs' => chr(0x0291D),
        'larrhk' => chr(0x021A9),
        'larrlp' => chr(0x021AB),
        'larrpl' => chr(0x02939),
        'larrsim' => chr(0x02973),
        'larrtl' => chr(0x021A2),
        'lAtail' => chr(0x0291B),
        'latail' => chr(0x02919),
        'lBarr' => chr(0x0290E),
        'lbarr' => chr(0x0290C),
        'ldca' => chr(0x02936),
        'ldrdhar' => chr(0x02967),
        'ldrushar' => chr(0x0294B),
        'ldsh' => chr(0x021B2),
        'lfisht' => chr(0x0297C),
        'lHar' => chr(0x02962),
        'lhard' => chr(0x021BD),
        'lharu' => chr(0x021BC),
        'lharul' => chr(0x0296A),
        'llarr' => chr(0x021C7),
        'llhard' => chr(0x0296B),
        'loarr' => chr(0x021FD),
        'lrarr' => chr(0x021C6),
        'lrhar' => chr(0x021CB),
        'lrhard' => chr(0x0296D),
        'lsh' => chr(0x021B0),
        'lurdshar' => chr(0x0294A),
        'luruhar' => chr(0x02966),
        'Map' => chr(0x02905),
        'map' => chr(0x021A6),
        'midcir' => chr(0x02AF0),
        'mumap' => chr(0x022B8),
        'nearhk' => chr(0x02924),
        'neArr' => chr(0x021D7),
        'nearr' => chr(0x02197),
        'nesear' => chr(0x02928),
        'nhArr' => chr(0x021CE),
        'nharr' => chr(0x021AE),
        'nlArr' => chr(0x021CD),
        'nlarr' => chr(0x0219A),
        'nrArr' => chr(0x021CF),
        'nrarr' => chr(0x0219B),
        'nrarrc' => chr(0x02933).chr(0x00338),
        'nrarrw' => chr(0x0219D).chr(0x00338),
        'nvHarr' => chr(0x02904),
        'nvlArr' => chr(0x02902),
        'nvrArr' => chr(0x02903),
        'nwarhk' => chr(0x02923),
        'nwArr' => chr(0x021D6),
        'nwarr' => chr(0x02196),
        'nwnear' => chr(0x02927),
        'olarr' => chr(0x021BA),
        'orarr' => chr(0x021BB),
        'origof' => chr(0x022B6),
        'rAarr' => chr(0x021DB),
        'Rarr' => chr(0x021A0),
        'rarrap' => chr(0x02975),
        'rarrbfs' => chr(0x02920),
        'rarrc' => chr(0x02933),
        'rarrfs' => chr(0x0291E),
        'rarrhk' => chr(0x021AA),
        'rarrlp' => chr(0x021AC),
        'rarrpl' => chr(0x02945),
        'rarrsim' => chr(0x02974),
        'Rarrtl' => chr(0x02916),
        'rarrtl' => chr(0x021A3),
        'rarrw' => chr(0x0219D),
        'rAtail' => chr(0x0291C),
        'ratail' => chr(0x0291A),
        'RBarr' => chr(0x02910),
        'rBarr' => chr(0x0290F),
        'rbarr' => chr(0x0290D),
        'rdca' => chr(0x02937),
        'rdldhar' => chr(0x02969),
        'rdsh' => chr(0x021B3),
        'rfisht' => chr(0x0297D),
        'rHar' => chr(0x02964),
        'rhard' => chr(0x021C1),
        'rharu' => chr(0x021C0),
        'rharul' => chr(0x0296C),
        'rlarr' => chr(0x021C4),
        'rlhar' => chr(0x021CC),
        'roarr' => chr(0x021FE),
        'rrarr' => chr(0x021C9),
        'rsh' => chr(0x021B1),
        'ruluhar' => chr(0x02968),
        'searhk' => chr(0x02925),
        'seArr' => chr(0x021D8),
        'searr' => chr(0x02198),
        'seswar' => chr(0x02929),
        'simrarr' => chr(0x02972),
        'slarr' => chr(0x02190),
        'srarr' => chr(0x02192),
        'swarhk' => chr(0x02926),
        'swArr' => chr(0x021D9),
        'swarr' => chr(0x02199),
        'swnwar' => chr(0x0292A),
        'Uarr' => chr(0x0219F),
        'uArr' => chr(0x021D1),
        'Uarrocir' => chr(0x02949),
        'udarr' => chr(0x021C5),
        'udhar' => chr(0x0296E),
        'ufisht' => chr(0x0297E),
        'uHar' => chr(0x02963),
        'uharl' => chr(0x021BF),
        'uharr' => chr(0x021BE),
        'uuarr' => chr(0x021C8),
        'vArr' => chr(0x021D5),
        'varr' => chr(0x02195),
        'xhArr' => chr(0x027FA),
        'xharr' => chr(0x027F7),
        'xlArr' => chr(0x027F8),
        'xlarr' => chr(0x027F5),
        'xmap' => chr(0x027FC),
        'xrArr' => chr(0x027F9),
        'xrarr' => chr(0x027F6),
        'zigrarr' => chr(0x021DD),
    }
}}

# ISOAMSB
push @names, 'isoamsb';
{ my $rv; sub isoamsb {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'ac' => chr(0x0223E),
        'acE' => chr(0x0223E).chr(0x00333),
        'amalg' => chr(0x02A3F),
        'barvee' => chr(0x022BD),
        'Barwed' => chr(0x02306),
        'barwed' => chr(0x02305),
        'bsolb' => chr(0x029C5),
        'Cap' => chr(0x022D2),
        'capand' => chr(0x02A44),
        'capbrcup' => chr(0x02A49),
        'capcap' => chr(0x02A4B),
        'capcup' => chr(0x02A47),
        'capdot' => chr(0x02A40),
        'caps' => chr(0x02229).chr(0x0FE00),
        'ccaps' => chr(0x02A4D),
        'ccups' => chr(0x02A4C),
        'ccupssm' => chr(0x02A50),
        'coprod' => chr(0x02210),
        'Cup' => chr(0x022D3),
        'cupbrcap' => chr(0x02A48),
        'cupcap' => chr(0x02A46),
        'cupcup' => chr(0x02A4A),
        'cupdot' => chr(0x0228D),
        'cupor' => chr(0x02A45),
        'cups' => chr(0x0222A).chr(0x0FE00),
        'cuvee' => chr(0x022CE),
        'cuwed' => chr(0x022CF),
        'Dagger' => chr(0x02021),
        'dagger' => chr(0x02020),
        'diam' => chr(0x022C4),
        'divonx' => chr(0x022C7),
        'eplus' => chr(0x02A71),
        'hercon' => chr(0x022B9),
        'intcal' => chr(0x022BA),
        'iprod' => chr(0x02A3C),
        'loplus' => chr(0x02A2D),
        'lotimes' => chr(0x02A34),
        'lthree' => chr(0x022CB),
        'ltimes' => chr(0x022C9),
        'midast' => chr(0x0002A),
        'minusb' => chr(0x0229F),
        'minusd' => chr(0x02238),
        'minusdu' => chr(0x02A2A),
        'ncap' => chr(0x02A43),
        'ncup' => chr(0x02A42),
        'oast' => chr(0x0229B),
        'ocir' => chr(0x0229A),
        'odash' => chr(0x0229D),
        'odiv' => chr(0x02A38),
        'odot' => chr(0x02299),
        'odsold' => chr(0x029BC),
        'ofcir' => chr(0x029BF),
        'ogt' => chr(0x029C1),
        'ohbar' => chr(0x029B5),
        'olcir' => chr(0x029BE),
        'olt' => chr(0x029C0),
        'omid' => chr(0x029B6),
        'ominus' => chr(0x02296),
        'opar' => chr(0x029B7),
        'operp' => chr(0x029B9),
        'oplus' => chr(0x02295),
        'osol' => chr(0x02298),
        'Otimes' => chr(0x02A37),
        'otimes' => chr(0x02297),
        'otimesas' => chr(0x02A36),
        'ovbar' => chr(0x0233D),
        'plusacir' => chr(0x02A23),
        'plusb' => chr(0x0229E),
        'pluscir' => chr(0x02A22),
        'plusdo' => chr(0x02214),
        'plusdu' => chr(0x02A25),
        'pluse' => chr(0x02A72),
        'plussim' => chr(0x02A26),
        'plustwo' => chr(0x02A27),
        'prod' => chr(0x0220F),
        'race' => chr(0x029DA),
        'roplus' => chr(0x02A2E),
        'rotimes' => chr(0x02A35),
        'rthree' => chr(0x022CC),
        'rtimes' => chr(0x022CA),
        'sdot' => chr(0x022C5),
        'sdotb' => chr(0x022A1),
        'setmn' => chr(0x02216),
        'simplus' => chr(0x02A24),
        'smashp' => chr(0x02A33),
        'solb' => chr(0x029C4),
        'sqcap' => chr(0x02293),
        'sqcaps' => chr(0x02293).chr(0x0FE00),
        'sqcup' => chr(0x02294),
        'sqcups' => chr(0x02294).chr(0x0FE00),
        'ssetmn' => chr(0x02216),
        'sstarf' => chr(0x022C6),
        'subdot' => chr(0x02ABD),
        'sum' => chr(0x02211),
        'supdot' => chr(0x02ABE),
        'timesb' => chr(0x022A0),
        'timesbar' => chr(0x02A31),
        'timesd' => chr(0x02A30),
        'tridot' => chr(0x025EC),
        'triminus' => chr(0x02A3A),
        'triplus' => chr(0x02A39),
        'trisb' => chr(0x029CD),
        'tritime' => chr(0x02A3B),
        'uplus' => chr(0x0228E),
        'veebar' => chr(0x022BB),
        'wedbar' => chr(0x02A5F),
        'wreath' => chr(0x02240),
        'xcap' => chr(0x022C2),
        'xcirc' => chr(0x025EF),
        'xcup' => chr(0x022C3),
        'xdtri' => chr(0x025BD),
        'xodot' => chr(0x02A00),
        'xoplus' => chr(0x02A01),
        'xotime' => chr(0x02A02),
        'xsqcup' => chr(0x02A06),
        'xuplus' => chr(0x02A04),
        'xutri' => chr(0x025B3),
        'xvee' => chr(0x022C1),
        'xwedge' => chr(0x022C0),
    }
}}

# ISOAMSC
push @names, 'isoamsc';
{ my $rv; sub isoamsc {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'dlcorn' => chr(0x0231E),
        'drcorn' => chr(0x0231F),
        'gtlPar' => chr(0x02995),
        'langd' => chr(0x02991),
        'lbrke' => chr(0x0298B),
        'lbrksld' => chr(0x0298F),
        'lbrkslu' => chr(0x0298D),
        'lceil' => chr(0x02308),
        'lfloor' => chr(0x0230A),
        'lmoust' => chr(0x023B0),
        'lparlt' => chr(0x02993),
        'ltrPar' => chr(0x02996),
        'rangd' => chr(0x02992),
        'rbrke' => chr(0x0298C),
        'rbrksld' => chr(0x0298E),
        'rbrkslu' => chr(0x02990),
        'rceil' => chr(0x02309),
        'rfloor' => chr(0x0230B),
        'rmoust' => chr(0x023B1),
        'rpargt' => chr(0x02994),
        'ulcorn' => chr(0x0231C),
        'urcorn' => chr(0x0231D),
    }
}}

# ISOAMSN
push @names, 'isoamsn';
{ my $rv; sub isoamsn {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'gnap' => chr(0x02A8A),
        'gnE' => chr(0x02269),
        'gne' => chr(0x02A88),
        'gnsim' => chr(0x022E7),
        'gvnE' => chr(0x02269).chr(0x0FE00),
        'lnap' => chr(0x02A89),
        'lnE' => chr(0x02268),
        'lne' => chr(0x02A87),
        'lnsim' => chr(0x022E6),
        'lvnE' => chr(0x02268).chr(0x0FE00),
        'nap' => chr(0x02249),
        'napE' => chr(0x02A70).chr(0x00338),
        'napid' => chr(0x0224B).chr(0x00338),
        'ncong' => chr(0x02247),
        'ncongdot' => chr(0x02A6D).chr(0x00338),
        'nequiv' => chr(0x02262),
        'ngE' => chr(0x02267).chr(0x00338),
        'nge' => chr(0x02271),
        'nges' => chr(0x02A7E).chr(0x00338),
        'nGg' => chr(0x022D9).chr(0x00338),
        'ngsim' => chr(0x02275),
        'nGt' => chr(0x0226B).chr(0x020D2),
        'ngt' => chr(0x0226F),
        'nGtv' => chr(0x0226B).chr(0x00338),
        'nlE' => chr(0x02266).chr(0x00338),
        'nle' => chr(0x02270),
        'nles' => chr(0x02A7D).chr(0x00338),
        'nLl' => chr(0x022D8).chr(0x00338),
        'nlsim' => chr(0x02274),
        'nLt' => chr(0x0226A).chr(0x020D2),
        'nlt' => chr(0x0226E),
        'nltri' => chr(0x022EA),
        'nltrie' => chr(0x022EC),
        'nLtv' => chr(0x0226A).chr(0x00338),
        'nmid' => chr(0x02224),
        'npar' => chr(0x02226),
        'npr' => chr(0x02280),
        'nprcue' => chr(0x022E0),
        'npre' => chr(0x02AAF).chr(0x00338),
        'nrtri' => chr(0x022EB),
        'nrtrie' => chr(0x022ED),
        'nsc' => chr(0x02281),
        'nsccue' => chr(0x022E1),
        'nsce' => chr(0x02AB0).chr(0x00338),
        'nsim' => chr(0x02241),
        'nsime' => chr(0x02244),
        'nsmid' => chr(0x02224),
        'nspar' => chr(0x02226),
        'nsqsube' => chr(0x022E2),
        'nsqsupe' => chr(0x022E3),
        'nsub' => chr(0x02284),
        'nsubE' => chr(0x02AC5).chr(0x00338),
        'nsube' => chr(0x02288),
        'nsup' => chr(0x02285),
        'nsupE' => chr(0x02AC6).chr(0x00338),
        'nsupe' => chr(0x02289),
        'ntgl' => chr(0x02279),
        'ntlg' => chr(0x02278),
        'nvap' => chr(0x0224D).chr(0x020D2),
        'nVDash' => chr(0x022AF),
        'nVdash' => chr(0x022AE),
        'nvDash' => chr(0x022AD),
        'nvdash' => chr(0x022AC),
        'nvge' => chr(0x02265).chr(0x020D2),
        'nvgt' => chr(0x0003E).chr(0x020D2),
        'nvle' => chr(0x02264).chr(0x020D2),
        'nvlt' => chr(0x0003C).chr(0x020D2),
        'nvltrie' => chr(0x022B4).chr(0x020D2),
        'nvrtrie' => chr(0x022B5).chr(0x020D2),
        'nvsim' => chr(0x0223C).chr(0x020D2),
        'parsim' => chr(0x02AF3),
        'prnap' => chr(0x02AB9),
        'prnE' => chr(0x02AB5),
        'prnsim' => chr(0x022E8),
        'rnmid' => chr(0x02AEE),
        'scnap' => chr(0x02ABA),
        'scnE' => chr(0x02AB6),
        'scnsim' => chr(0x022E9),
        'simne' => chr(0x02246),
        'solbar' => chr(0x0233F),
        'subnE' => chr(0x02ACB),
        'subne' => chr(0x0228A),
        'supnE' => chr(0x02ACC),
        'supne' => chr(0x0228B),
        'vnsub' => chr(0x02282).chr(0x020D2),
        'vnsup' => chr(0x02283).chr(0x020D2),
        'vsubnE' => chr(0x02ACB).chr(0x0FE00),
        'vsubne' => chr(0x0228A).chr(0x0FE00),
        'vsupnE' => chr(0x02ACC).chr(0x0FE00),
        'vsupne' => chr(0x0228B).chr(0x0FE00),
    }
}}

# ISOAMSO
push @names, 'isoamso';
{ my $rv; sub isoamso {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'ang' => chr(0x02220),
        'ange' => chr(0x029A4),
        'angmsd' => chr(0x02221),
        'angmsdaa' => chr(0x029A8),
        'angmsdab' => chr(0x029A9),
        'angmsdac' => chr(0x029AA),
        'angmsdad' => chr(0x029AB),
        'angmsdae' => chr(0x029AC),
        'angmsdaf' => chr(0x029AD),
        'angmsdag' => chr(0x029AE),
        'angmsdah' => chr(0x029AF),
        'angrtvb' => chr(0x022BE),
        'angrtvbd' => chr(0x0299D),
        'bbrk' => chr(0x023B5),
        'bbrktbrk' => chr(0x023B6),
        'bemptyv' => chr(0x029B0),
        'beth' => chr(0x02136),
        'boxbox' => chr(0x029C9),
        'bprime' => chr(0x02035),
        'bsemi' => chr(0x0204F),
        'cemptyv' => chr(0x029B2),
        'cirE' => chr(0x029C3),
        'cirscir' => chr(0x029C2),
        'comp' => chr(0x02201),
        'daleth' => chr(0x02138),
        'demptyv' => chr(0x029B1),
        'ell' => chr(0x02113),
        'empty' => chr(0x02205),
        'emptyv' => chr(0x02205),
        'gimel' => chr(0x02137),
        'iiota' => chr(0x02129),
        'image' => chr(0x02111),
        'imath' => chr(0x00131),
        'jmath' => chr(0x0006A),
        'laemptyv' => chr(0x029B4),
        'lltri' => chr(0x025FA),
        'lrtri' => chr(0x022BF),
        'mho' => chr(0x02127),
        'nang' => chr(0x02220).chr(0x020D2),
        'nexist' => chr(0x02204),
        'oS' => chr(0x024C8),
        'planck' => chr(0x0210F),
        'plankv' => chr(0x0210F),
        'raemptyv' => chr(0x029B3),
        'range' => chr(0x029A5),
        'real' => chr(0x0211C),
        'tbrk' => chr(0x023B4),
        'trpezium' => chr(0x0FFFD),
        'ultri' => chr(0x025F8),
        'urtri' => chr(0x025F9),
        'vzigzag' => chr(0x0299A),
        'weierp' => chr(0x02118),
    }
}}

# ISOAMSR
push @names, 'isoamsr';
{ my $rv; sub isoamsr {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'apE' => chr(0x02A70),
        'ape' => chr(0x0224A),
        'apid' => chr(0x0224B),
        'asymp' => chr(0x02248),
        'Barv' => chr(0x02AE7),
        'bcong' => chr(0x0224C),
        'bepsi' => chr(0x003F6),
        'bowtie' => chr(0x022C8),
        'bsim' => chr(0x0223D),
        'bsime' => chr(0x022CD),
        'bsolhsub' => chr(0x0005C).chr(0x02282),
        'bump' => chr(0x0224E),
        'bumpE' => chr(0x02AAE),
        'bumpe' => chr(0x0224F),
        'cire' => chr(0x02257),
        'Colon' => chr(0x02237),
        'Colone' => chr(0x02A74),
        'colone' => chr(0x02254),
        'congdot' => chr(0x02A6D),
        'csub' => chr(0x02ACF),
        'csube' => chr(0x02AD1),
        'csup' => chr(0x02AD0),
        'csupe' => chr(0x02AD2),
        'cuepr' => chr(0x022DE),
        'cuesc' => chr(0x022DF),
        'Dashv' => chr(0x02AE4),
        'dashv' => chr(0x022A3),
        'easter' => chr(0x02A6E),
        'ecir' => chr(0x02256),
        'ecolon' => chr(0x02255),
        'eDDot' => chr(0x02A77),
        'eDot' => chr(0x02251),
        'efDot' => chr(0x02252),
        'eg' => chr(0x02A9A),
        'egs' => chr(0x02A96),
        'egsdot' => chr(0x02A98),
        'el' => chr(0x02A99),
        'els' => chr(0x02A95),
        'elsdot' => chr(0x02A97),
        'equest' => chr(0x0225F),
        'equivDD' => chr(0x02A78),
        'erDot' => chr(0x02253),
        'esdot' => chr(0x02250),
        'Esim' => chr(0x02A73),
        'esim' => chr(0x02242),
        'fork' => chr(0x022D4),
        'forkv' => chr(0x02AD9),
        'frown' => chr(0x02322),
        'gap' => chr(0x02A86),
        'gE' => chr(0x02267),
        'gEl' => chr(0x02A8C),
        'gel' => chr(0x022DB),
        'ges' => chr(0x02A7E),
        'gescc' => chr(0x02AA9),
        'gesdot' => chr(0x02A80),
        'gesdoto' => chr(0x02A82),
        'gesdotol' => chr(0x02A84),
        'gesl' => chr(0x022DB).chr(0x0FE00),
        'gesles' => chr(0x02A94),
        'Gg' => chr(0x022D9),
        'gl' => chr(0x02277),
        'gla' => chr(0x02AA5),
        'glE' => chr(0x02A92),
        'glj' => chr(0x02AA4),
        'gsim' => chr(0x02273),
        'gsime' => chr(0x02A8E),
        'gsiml' => chr(0x02A90),
        'Gt' => chr(0x0226B),
        'gtcc' => chr(0x02AA7),
        'gtcir' => chr(0x02A7A),
        'gtdot' => chr(0x022D7),
        'gtquest' => chr(0x02A7C),
        'gtrarr' => chr(0x02978),
        'homtht' => chr(0x0223B),
        'lap' => chr(0x02A85),
        'lat' => chr(0x02AAB),
        'late' => chr(0x02AAD),
        'lates' => chr(0x02AAD).chr(0x0FE00),
        'lE' => chr(0x02266),
        'lEg' => chr(0x02A8B),
        'leg' => chr(0x022DA),
        'les' => chr(0x02A7D),
        'lescc' => chr(0x02AA8),
        'lesdot' => chr(0x02A7F),
        'lesdoto' => chr(0x02A81),
        'lesdotor' => chr(0x02A83),
        'lesg' => chr(0x022DA).chr(0x0FE00),
        'lesges' => chr(0x02A93),
        'lg' => chr(0x02276),
        'lgE' => chr(0x02A91),
        'Ll' => chr(0x022D8),
        'lsim' => chr(0x02272),
        'lsime' => chr(0x02A8D),
        'lsimg' => chr(0x02A8F),
        'Lt' => chr(0x0226A),
        'ltcc' => chr(0x02AA6),
        'ltcir' => chr(0x02A79),
        'ltdot' => chr(0x022D6),
        'ltlarr' => chr(0x02976),
        'ltquest' => chr(0x02A7B),
        'ltrie' => chr(0x022B4),
        'mcomma' => chr(0x02A29),
        'mDDot' => chr(0x0223A),
        'mid' => chr(0x02223),
        'mlcp' => chr(0x02ADB),
        'models' => chr(0x022A7),
        'mstpos' => chr(0x0223E),
        'Pr' => chr(0x02ABB),
        'pr' => chr(0x0227A),
        'prap' => chr(0x02AB7),
        'prcue' => chr(0x0227C),
        'prE' => chr(0x02AB3),
        'pre' => chr(0x02AAF),
        'prsim' => chr(0x0227E),
        'prurel' => chr(0x022B0),
        'ratio' => chr(0x02236),
        'rtrie' => chr(0x022B5),
        'rtriltri' => chr(0x029CE),
        'Sc' => chr(0x02ABC),
        'sc' => chr(0x0227B),
        'scap' => chr(0x02AB8),
        'sccue' => chr(0x0227D),
        'scE' => chr(0x02AB4),
        'sce' => chr(0x02AB0),
        'scsim' => chr(0x0227F),
        'sdote' => chr(0x02A66),
        'sfrown' => chr(0x02322),
        'simg' => chr(0x02A9E),
        'simgE' => chr(0x02AA0),
        'siml' => chr(0x02A9D),
        'simlE' => chr(0x02A9F),
        'smid' => chr(0x02223),
        'smile' => chr(0x02323),
        'smt' => chr(0x02AAA),
        'smte' => chr(0x02AAC),
        'smtes' => chr(0x02AAC).chr(0x0FE00),
        'spar' => chr(0x02225),
        'sqsub' => chr(0x0228F),
        'sqsube' => chr(0x02291),
        'sqsup' => chr(0x02290),
        'sqsupe' => chr(0x02292),
        'ssmile' => chr(0x02323),
        'Sub' => chr(0x022D0),
        'subE' => chr(0x02AC5),
        'subedot' => chr(0x02AC3),
        'submult' => chr(0x02AC1),
        'subplus' => chr(0x02ABF),
        'subrarr' => chr(0x02979),
        'subsim' => chr(0x02AC7),
        'subsub' => chr(0x02AD5),
        'subsup' => chr(0x02AD3),
        'Sup' => chr(0x022D1),
        'supdsub' => chr(0x02AD8),
        'supE' => chr(0x02AC6),
        'supedot' => chr(0x02AC4),
        'suphsol' => chr(0x02283).chr(0x0002F),
        'suphsub' => chr(0x02AD7),
        'suplarr' => chr(0x0297B),
        'supmult' => chr(0x02AC2),
        'supplus' => chr(0x02AC0),
        'supsim' => chr(0x02AC8),
        'supsub' => chr(0x02AD4),
        'supsup' => chr(0x02AD6),
        'thkap' => chr(0x02248),
        'thksim' => chr(0x0223C),
        'topfork' => chr(0x02ADA),
        'trie' => chr(0x0225C),
        'twixt' => chr(0x0226C),
        'Vbar' => chr(0x02AEB),
        'vBar' => chr(0x02AE8),
        'vBarv' => chr(0x02AE9),
        'VDash' => chr(0x022AB),
        'Vdash' => chr(0x022A9),
        'vDash' => chr(0x022A8),
        'vdash' => chr(0x022A2),
        'Vdashl' => chr(0x02AE6),
        'vltri' => chr(0x022B2),
        'vprop' => chr(0x0221D),
        'vrtri' => chr(0x022B3),
        'Vvdash' => chr(0x022AA),
    }
}}

# ISOGRK1
push @names, 'isogrk1';
{ my $rv; sub isogrk1 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Agr' => chr(0x00391),
        'agr' => chr(0x003B1),
        'Bgr' => chr(0x00392),
        'bgr' => chr(0x003B2),
        'Dgr' => chr(0x00394),
        'dgr' => chr(0x003B4),
        'EEgr' => chr(0x00397),
        'eegr' => chr(0x003B7),
        'Egr' => chr(0x00395),
        'egr' => chr(0x003B5),
        'Ggr' => chr(0x00393),
        'ggr' => chr(0x003B3),
        'Igr' => chr(0x00399),
        'igr' => chr(0x003B9),
        'Kgr' => chr(0x0039A),
        'kgr' => chr(0x003BA),
        'KHgr' => chr(0x003A7),
        'khgr' => chr(0x003C7),
        'Lgr' => chr(0x0039B),
        'lgr' => chr(0x003BB),
        'Mgr' => chr(0x0039C),
        'mgr' => chr(0x003BC),
        'Ngr' => chr(0x0039D),
        'ngr' => chr(0x003BD),
        'Ogr' => chr(0x0039F),
        'ogr' => chr(0x003BF),
        'OHgr' => chr(0x003A9),
        'ohgr' => chr(0x003C9),
        'Pgr' => chr(0x003A0),
        'pgr' => chr(0x003C0),
        'PHgr' => chr(0x003A6),
        'phgr' => chr(0x003C6),
        'PSgr' => chr(0x003A8),
        'psgr' => chr(0x003C8),
        'Rgr' => chr(0x003A1),
        'rgr' => chr(0x003C1),
        'sfgr' => chr(0x003C2),
        'Sgr' => chr(0x003A3),
        'sgr' => chr(0x003C3),
        'Tgr' => chr(0x003A4),
        'tgr' => chr(0x003C4),
        'THgr' => chr(0x00398),
        'thgr' => chr(0x003B8),
        'Ugr' => chr(0x003A5),
        'ugr' => chr(0x003C5),
        'Xgr' => chr(0x0039E),
        'xgr' => chr(0x003BE),
        'Zgr' => chr(0x00396),
        'zgr' => chr(0x003B6),
    }
}}

# ISOGRK2
push @names, 'isogrk2';
{ my $rv; sub isogrk2 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Aacgr' => chr(0x00386),
        'aacgr' => chr(0x003AC),
        'Eacgr' => chr(0x00388),
        'eacgr' => chr(0x003AD),
        'EEacgr' => chr(0x00389),
        'eeacgr' => chr(0x003AE),
        'Iacgr' => chr(0x0038A),
        'iacgr' => chr(0x003AF),
        'idiagr' => chr(0x00390),
        'Idigr' => chr(0x003AA),
        'idigr' => chr(0x003CA),
        'Oacgr' => chr(0x0038C),
        'oacgr' => chr(0x003CC),
        'OHacgr' => chr(0x0038F),
        'ohacgr' => chr(0x003CE),
        'Uacgr' => chr(0x0038E),
        'uacgr' => chr(0x003CD),
        'udiagr' => chr(0x003B0),
        'Udigr' => chr(0x003AB),
        'udigr' => chr(0x003CB),
    }
}}

# ISOGRK3
push @names, 'isogrk3';
{ my $rv; sub isogrk3 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'alpha' => chr(0x003B1),
        'beta' => chr(0x003B2),
        'chi' => chr(0x003C7),
        'Delta' => chr(0x00394),
        'delta' => chr(0x003B4),
        'epsi' => chr(0x003F5),
        'epsiv' => chr(0x003B5),
        'eta' => chr(0x003B7),
        'Gamma' => chr(0x00393),
        'gamma' => chr(0x003B3),
        'Gammad' => chr(0x003DC),
        'gammad' => chr(0x003DD),
        'iota' => chr(0x003B9),
        'kappa' => chr(0x003BA),
        'kappav' => chr(0x003F0),
        'Lambda' => chr(0x0039B),
        'lambda' => chr(0x003BB),
        'mu' => chr(0x003BC),
        'nu' => chr(0x003BD),
        'Omega' => chr(0x003A9),
        'omega' => chr(0x003C9),
        'Phi' => chr(0x003A6),
        'phi' => chr(0x003D5),
        'phiv' => chr(0x003C6),
        'Pi' => chr(0x003A0),
        'pi' => chr(0x003C0),
        'piv' => chr(0x003D6),
        'Psi' => chr(0x003A8),
        'psi' => chr(0x003C8),
        'rho' => chr(0x003C1),
        'rhov' => chr(0x003F1),
        'Sigma' => chr(0x003A3),
        'sigma' => chr(0x003C3),
        'sigmav' => chr(0x003C2),
        'tau' => chr(0x003C4),
        'Theta' => chr(0x00398),
        'theta' => chr(0x003B8),
        'thetav' => chr(0x003D1),
        'Upsi' => chr(0x003D2),
        'upsi' => chr(0x003C5),
        'Xi' => chr(0x0039E),
        'xi' => chr(0x003BE),
        'zeta' => chr(0x003B6),
    }
}}

# ISOGRK4
push @names, 'isogrk4';
{ my $rv; sub isogrk4 {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
    }
}}

# ISOMFRK
push @names, 'isomfrk';
{ my $rv; sub isomfrk {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Afr' => chr(0x1D504),
        'afr' => chr(0x1D51E),
        'Bfr' => chr(0x1D505),
        'bfr' => chr(0x1D51F),
        'Cfr' => chr(0x0212D),
        'cfr' => chr(0x1D520),
        'Dfr' => chr(0x1D507),
        'dfr' => chr(0x1D521),
        'Efr' => chr(0x1D508),
        'efr' => chr(0x1D522),
        'Ffr' => chr(0x1D509),
        'ffr' => chr(0x1D523),
        'Gfr' => chr(0x1D50A),
        'gfr' => chr(0x1D524),
        'Hfr' => chr(0x0210C),
        'hfr' => chr(0x1D525),
        'Ifr' => chr(0x02111),
        'ifr' => chr(0x1D526),
        'Jfr' => chr(0x1D50D),
        'jfr' => chr(0x1D527),
        'Kfr' => chr(0x1D50E),
        'kfr' => chr(0x1D528),
        'Lfr' => chr(0x1D50F),
        'lfr' => chr(0x1D529),
        'Mfr' => chr(0x1D510),
        'mfr' => chr(0x1D52A),
        'Nfr' => chr(0x1D511),
        'nfr' => chr(0x1D52B),
        'Ofr' => chr(0x1D512),
        'ofr' => chr(0x1D52C),
        'Pfr' => chr(0x1D513),
        'pfr' => chr(0x1D52D),
        'Qfr' => chr(0x1D514),
        'qfr' => chr(0x1D52E),
        'Rfr' => chr(0x0211C),
        'rfr' => chr(0x1D52F),
        'Sfr' => chr(0x1D516),
        'sfr' => chr(0x1D530),
        'Tfr' => chr(0x1D517),
        'tfr' => chr(0x1D531),
        'Ufr' => chr(0x1D518),
        'ufr' => chr(0x1D532),
        'Vfr' => chr(0x1D519),
        'vfr' => chr(0x1D533),
        'Wfr' => chr(0x1D51A),
        'wfr' => chr(0x1D534),
        'Xfr' => chr(0x1D51B),
        'xfr' => chr(0x1D535),
        'Yfr' => chr(0x1D51C),
        'yfr' => chr(0x1D536),
        'Zfr' => chr(0x02128),
        'zfr' => chr(0x1D537),
    }
}}

# ISOMOPF
push @names, 'isomopf';
{ my $rv; sub isomopf {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Aopf' => chr(0x1D538),
        'Bopf' => chr(0x1D539),
        'Copf' => chr(0x02102),
        'Dopf' => chr(0x1D53B),
        'Eopf' => chr(0x1D53C),
        'Fopf' => chr(0x1D53D),
        'Gopf' => chr(0x1D53E),
        'Hopf' => chr(0x0210D),
        'Iopf' => chr(0x1D540),
        'Jopf' => chr(0x1D541),
        'Kopf' => chr(0x1D542),
        'Lopf' => chr(0x1D543),
        'Mopf' => chr(0x1D544),
        'Nopf' => chr(0x02115),
        'Oopf' => chr(0x1D546),
        'Popf' => chr(0x02119),
        'Qopf' => chr(0x0211A),
        'Ropf' => chr(0x0211D),
        'Sopf' => chr(0x1D54A),
        'Topf' => chr(0x1D54B),
        'Uopf' => chr(0x1D54C),
        'Vopf' => chr(0x1D54D),
        'Wopf' => chr(0x1D54E),
        'Xopf' => chr(0x1D54F),
        'Yopf' => chr(0x1D550),
        'Zopf' => chr(0x02124),
    }
}}

# ISOMSCR
push @names, 'isomscr';
{ my $rv; sub isomscr {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'Ascr' => chr(0x1D49C),
        'ascr' => chr(0x1D4B6),
        'Bscr' => chr(0x0212C),
        'bscr' => chr(0x1D4B7),
        'Cscr' => chr(0x1D49E),
        'cscr' => chr(0x1D4B8),
        'Dscr' => chr(0x1D49F),
        'dscr' => chr(0x1D4B9),
        'Escr' => chr(0x02130),
        'escr' => chr(0x0212F),
        'Fscr' => chr(0x02131),
        'fscr' => chr(0x1D4BB),
        'Gscr' => chr(0x1D4A2),
        'gscr' => chr(0x0210A),
        'Hscr' => chr(0x0210B),
        'hscr' => chr(0x1D4BD),
        'Iscr' => chr(0x02110),
        'iscr' => chr(0x1D4BE),
        'Jscr' => chr(0x1D4A5),
        'jscr' => chr(0x1D4BF),
        'Kscr' => chr(0x1D4A6),
        'kscr' => chr(0x1D4C0),
        'Lscr' => chr(0x02112),
        'lscr' => chr(0x1D4C1),
        'Mscr' => chr(0x02133),
        'mscr' => chr(0x1D4C2),
        'Nscr' => chr(0x1D4A9),
        'nscr' => chr(0x1D4C3),
        'Oscr' => chr(0x1D4AA),
        'oscr' => chr(0x02134),
        'Pscr' => chr(0x1D4AB),
        'pscr' => chr(0x1D4C5),
        'Qscr' => chr(0x1D4AC),
        'qscr' => chr(0x1D4C6),
        'Rscr' => chr(0x0211B),
        'rscr' => chr(0x1D4C7),
        'Sscr' => chr(0x1D4AE),
        'sscr' => chr(0x1D4C8),
        'Tscr' => chr(0x1D4AF),
        'tscr' => chr(0x1D4C9),
        'Uscr' => chr(0x1D4B0),
        'uscr' => chr(0x1D4CA),
        'Vscr' => chr(0x1D4B1),
        'vscr' => chr(0x1D4CB),
        'Wscr' => chr(0x1D4B2),
        'wscr' => chr(0x1D4CC),
        'Xscr' => chr(0x1D4B3),
        'xscr' => chr(0x1D4CD),
        'Yscr' => chr(0x1D4B4),
        'yscr' => chr(0x1D4CE),
        'Zscr' => chr(0x1D4B5),
        'zscr' => chr(0x1D4CF),
    }
}}

# ISOTECH
push @names, 'isotech';
{ my $rv; sub isotech {
    # Return cached value if there is one.
    if ($rv) { return $rv }
    return $rv = {
        'acd' => chr(0x0223F),
        'aleph' => chr(0x02135),
        'And' => chr(0x02A53),
        'and' => chr(0x02227),
        'andand' => chr(0x02A55),
        'andd' => chr(0x02A5C),
        'andslope' => chr(0x02A58),
        'andv' => chr(0x02A5A),
        'angrt' => chr(0x0221F),
        'angsph' => chr(0x02222),
        'angst' => chr(0x0212B),
        'ap' => chr(0x02248),
        'apacir' => chr(0x02A6F),
        'awconint' => chr(0x02233),
        'awint' => chr(0x02A11),
        'becaus' => chr(0x02235),
        'bernou' => chr(0x0212C),
        'bne' => chr(0x0003D).chr(0x020E5),
        'bnequiv' => chr(0x02261).chr(0x020E5),
        'bNot' => chr(0x02AED),
        'bnot' => chr(0x02310),
        'bottom' => chr(0x022A5),
        'cap' => chr(0x02229),
        'Cconint' => chr(0x02230),
        'cirfnint' => chr(0x02A10),
        'compfn' => chr(0x02218),
        'cong' => chr(0x02245),
        'Conint' => chr(0x0222F),
        'conint' => chr(0x0222E),
        'ctdot' => chr(0x022EF),
        'cup' => chr(0x0222A),
        'cwconint' => chr(0x02232),
        'cwint' => chr(0x02231),
        'cylcty' => chr(0x0232D),
        'disin' => chr(0x022F2),
        'Dot' => chr(0x000A8),
        'dsol' => chr(0x029F6),
        'dtdot' => chr(0x022F1),
        'dwangle' => chr(0x029A6),
        'elinters' => chr(0x0FFFD),
        'epar' => chr(0x022D5),
        'eparsl' => chr(0x029E3),
        'equiv' => chr(0x02261),
        'eqvparsl' => chr(0x029E5),
        'exist' => chr(0x02203),
        'fltns' => chr(0x025B1),
        'fnof' => chr(0x00192),
        'forall' => chr(0x02200),
        'fpartint' => chr(0x02A0D),
        'ge' => chr(0x02265),
        'hamilt' => chr(0x0210B),
        'iff' => chr(0x021D4),
        'iinfin' => chr(0x029DC),
        'imped' => chr(0x001B5),
        'infin' => chr(0x0221E),
        'infintie' => chr(0x029DD),
        'Int' => chr(0x0222C),
        'int' => chr(0x0222B),
        'intlarhk' => chr(0x02A17),
        'isin' => chr(0x02208),
        'isindot' => chr(0x022F5),
        'isinE' => chr(0x022F9),
        'isins' => chr(0x022F4),
        'isinsv' => chr(0x022F3),
        'isinv' => chr(0x02208),
        'lagran' => chr(0x02112),
        'Lang' => chr(0x0300A),
        'lang' => chr(0x02329),
        'lArr' => chr(0x021D0),
        'lbbrk' => chr(0x03014),
        'le' => chr(0x02264),
        'loang' => chr(0x03018),
        'lobrk' => chr(0x0301A),
        'lopar' => chr(0x02985),
        'lowast' => chr(0x02217),
        'minus' => chr(0x02212),
        'mnplus' => chr(0x02213),
        'nabla' => chr(0x02207),
        'ne' => chr(0x02260),
        'nedot' => chr(0x02250).chr(0x00338),
        'nhpar' => chr(0x02AF2),
        'ni' => chr(0x0220B),
        'nis' => chr(0x022FC),
        'nisd' => chr(0x022FA),
        'niv' => chr(0x0220B),
        'Not' => chr(0x02AEC),
        'notin' => chr(0x02209),
        'notindot' => chr(0x022F5).chr(0x00338),
        'notinE' => chr(0x022F9).chr(0x00338),
        'notinva' => chr(0x02209),
        'notinvb' => chr(0x022F7),
        'notinvc' => chr(0x022F6),
        'notni' => chr(0x0220C),
        'notniva' => chr(0x0220C),
        'notnivb' => chr(0x022FE),
        'notnivc' => chr(0x022FD),
        'nparsl' => chr(0x02AFD).chr(0x020E5),
        'npart' => chr(0x02202).chr(0x00338),
        'npolint' => chr(0x02A14),
        'nvinfin' => chr(0x029DE),
        'olcross' => chr(0x029BB),
        'Or' => chr(0x02A54),
        'or' => chr(0x02228),
        'ord' => chr(0x02A5D),
        'order' => chr(0x02134),
        'oror' => chr(0x02A56),
        'orslope' => chr(0x02A57),
        'orv' => chr(0x02A5B),
        'par' => chr(0x02225),
        'parsl' => chr(0x02AFD),
        'part' => chr(0x02202),
        'permil' => chr(0x02030),
        'perp' => chr(0x022A5),
        'pertenk' => chr(0x02031),
        'phmmat' => chr(0x02133),
        'pointint' => chr(0x02A15),
        'Prime' => chr(0x02033),
        'prime' => chr(0x02032),
        'profalar' => chr(0x0232E),
        'profline' => chr(0x02312),
        'profsurf' => chr(0x02313),
        'prop' => chr(0x0221D),
        'qint' => chr(0x02A0C),
        'qprime' => chr(0x02057),
        'quatint' => chr(0x02A16),
        'radic' => chr(0x0221A),
        'Rang' => chr(0x0300B),
        'rang' => chr(0x0232A),
        'rArr' => chr(0x021D2),
        'rbbrk' => chr(0x03015),
        'roang' => chr(0x03019),
        'robrk' => chr(0x0301B),
        'ropar' => chr(0x02986),
        'rppolint' => chr(0x02A12),
        'scpolint' => chr(0x02A13),
        'sim' => chr(0x0223C),
        'simdot' => chr(0x02A6A),
        'sime' => chr(0x02243),
        'smeparsl' => chr(0x029E4),
        'square' => chr(0x025A1),
        'squarf' => chr(0x025AA),
        'strns' => chr(0x000AF),
        'sub' => chr(0x02282),
        'sube' => chr(0x02286),
        'sup' => chr(0x02283),
        'supe' => chr(0x02287),
        'there4' => chr(0x02234),
        'tint' => chr(0x0222D),
        'top' => chr(0x022A4),
        'topbot' => chr(0x02336),
        'topcir' => chr(0x02AF1),
        'tprime' => chr(0x02034),
        'utdot' => chr(0x022F0),
        'uwangle' => chr(0x029A7),
        'vangrt' => chr(0x0299C),
        'veeeq' => chr(0x0225A),
        'Verbar' => chr(0x02016),
        'wedgeq' => chr(0x02259),
        'xnis' => chr(0x022FB),
    }
}}

sub all {
    no strict 'refs';
    return {map %{$_->()}, @names}
}

sub names {
    return @names
}

sub char2entity {
    my ($subname) = @_;
    no strict 'refs';
    my $ent2char = $subname->();
    use strict;
    my %char2ent;
    local $/ = ';';
    while (my($entity, $char) = each(%$ent2char)) {
        chomp $entity;  # $/ eq ';' so this is just a faster version of s/;\z//
        $char2ent{$char} = "&$entity;";
    }
    return \%char2ent;
}

1

__END__
