"""Editors and adaptors for PyTable and BasicProperty-based objects"""
from nevow import inevow, tags, rend, loaders
from basicproperty import propertied, common, basic

class PropTextWidget( rend.Fragment ):
	"""Editor widget for a simple textual entry field
	
	Rendered as a styled text input field
	"""
	docFactory = loaders.stand(
		tags.input(
			type='text',
			render=tags.directive( 'configure' ),
			
		)
	)
	def render_configure( self, ctx, value ):
		"""Render the final text widget for this value"""
		prop,client = value.property, value.client 
		clientID = IClientID( client ).id()
		
		ctx.tag.attributes['name'] = '%s.property.%s'%( clientID, prop.name )
		ctx.tag.attributes['title'] = property.__doc__
		try:
			value = property.__get__( client )
		except Exception, err:
			value = ''
		ctx.tag.attributes['value'] = value 
		return ctx.tag
	
	
			
