#------------------------------------------------------------------------------
# File:         Shortcuts.pm
#
# Description:  Definitions for tag shortcuts
#
# Revisions:    02/07/2004 - P. Harvey Moved out of Exif.pm
#------------------------------------------------------------------------------

package Image::ExifTool::Shortcuts;

use strict;
use vars qw($VERSION);

$VERSION = '1.00';

# this is a special table used to define command-line shortcuts
%Image::ExifTool::Shortcuts::Main = (
    Common => [ 'FileName',
                'FileSize',
                'Model',
                'DateTimeOriginal',
                'ImageSize',
                'Quality',
                'FocalLength',
                'ShutterSpeed',
                'Aperture',
                'ISO',
                'WhiteBalance',
                'Flash',
    ],
    Canon => [  'FileName',
                'Model',
                'DateTimeOriginal',
                'ShootingMode',
                'ShutterSpeed',
                'Aperture',
                'MeteringMode',
                'ExposureCompensation',
                'ISO',
                'Lens',
                'FocalLength',
                'ImageSize',
                'Quality',
                'FlashOn',
                'FlashType',
                'ConditionalFEC',
                'RedEyeReduction',
                'ShutterCurtainHack',
                'WhiteBalance',
                'FocusMode',
                'Contrast',
                'Sharpness',
                'Saturation',
                'ColorTone',
                'FileSize',
                'FileNumber',
                'DriveMode',
                'OwnerName',
                'SerialNumber',
    ],
);


1; # end
