/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class LoadGoodsMessage
extends DOMMessage {
    private final String locationId;
    private final String goodsTypeId;
    private final String amountString;
    private final String carrierId;

    public LoadGoodsMessage(Location loc, GoodsType type, int amount, Unit carrier) {
        super(LoadGoodsMessage.getXMLElementTagName());
        this.locationId = loc.getId();
        this.goodsTypeId = type.getId();
        this.amountString = Integer.toString(amount);
        this.carrierId = carrier.getId();
    }

    public LoadGoodsMessage(Game game, Element element) {
        super(LoadGoodsMessage.getXMLElementTagName());
        this.locationId = element.getAttribute("location");
        this.goodsTypeId = element.getAttribute("type");
        this.amountString = element.getAttribute("amount");
        this.carrierId = element.getAttribute("carrier");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int amount;
        Unit carrier;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        FreeColGameObject fcgo = player.getGame().getFreeColGameObject(this.locationId);
        if (fcgo == null || !(fcgo instanceof Location)) {
            return DOMMessage.clientError("Not a location: " + this.locationId);
        }
        try {
            carrier = player.getOurFreeColGameObject(this.carrierId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!carrier.canCarryGoods()) {
            return DOMMessage.clientError("Not a goods carrier: " + this.carrierId);
        }
        if (carrier.getTradeLocation() == null) {
            return DOMMessage.clientError("Not at a trade location: " + this.carrierId);
        }
        GoodsType type = server.getSpecification().getGoodsType(this.goodsTypeId);
        if (type == null) {
            return DOMMessage.clientError("Not a goods type: " + this.goodsTypeId);
        }
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad amount: " + this.amountString);
        }
        if (amount <= 0) {
            return DOMMessage.clientError("Amount must be positive: " + this.amountString);
        }
        return server.getInGameController().loadGoods(serverPlayer, (Location)((Object)fcgo), type, amount, carrier);
    }

    @Override
    public Element toXMLElement() {
        return LoadGoodsMessage.createMessage(LoadGoodsMessage.getXMLElementTagName(), "location", this.locationId, "type", this.goodsTypeId, "amount", this.amountString, "carrier", this.carrierId);
    }

    public static String getXMLElementTagName() {
        return "loadGoods";
    }
}

