/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHLiteral
extends SimpleNode {
    public Object value;

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        if (this.value == null) {
            throw new InterpreterError("Null in bsh literal: " + this.value);
        }
        return this.value;
    }

    private final char getEscapeChar(char c) {
        switch (c) {
            case 'b': {
                c = (char)8;
                break;
            }
            case 't': {
                c = (char)9;
                break;
            }
            case 'n': {
                c = (char)10;
                break;
            }
            case 'f': {
                c = (char)12;
                break;
            }
            case 'r': {
                c = (char)13;
                break;
            }
            case '\"': 
            case '\'': 
            case '\\': {
                break;
            }
        }
        return c;
    }

    public void charSetup(String string) {
        char c = string.charAt(0);
        if (c == '\\') {
            c = string.charAt(1);
            c = Character.isDigit(c) ? (char)Integer.parseInt(string.substring(1), 8) : this.getEscapeChar(c);
        }
        this.value = new Primitive(new Character(c));
    }

    void stringSetup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                if (Character.isDigit(c = string.charAt(++n))) {
                    int n2 = n;
                    while (n2 < n + 2) {
                        if (!Character.isDigit(string.charAt(n2 + 1))) break;
                        ++n2;
                    }
                    c = (char)Integer.parseInt(string.substring(n, n2 + 1), 8);
                    n = n2;
                } else {
                    c = this.getEscapeChar(c);
                }
            }
            stringBuffer.append(c);
            ++n;
        }
        this.value = stringBuffer.toString();
    }

    BSHLiteral(int n) {
        super(n);
    }
}

