<?php header ("Content-Type: text/html; charset=utf-8", true); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html>
<head>
	<title><?php echo clean(CompanyWebsite::instance()->getCompany()->getFirstName()) . ' - ' . PRODUCT_NAME ?></title>
	<link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,300' rel='stylesheet' type='text/css'>
	<?php $favicon_name = 'favicon.ico';
		Hook::fire('change_favicon', null, $favicon_name); ?>
	<?php echo link_tag(with_slash(ROOT_URL).$favicon_name, "rel", "shortcut icon") ?>
	<?php echo add_javascript_to_page("og/app.js") // loaded first because it's needed for translating?>
	<?php echo add_javascript_to_page(get_url("access", "get_javascript_translation")); ?>
	<?php if (Localization::instance()->getLocale() != 'en_us') { // don't download the same language pack again if the locale is the same as default
		echo add_javascript_to_page(get_url("access", "get_javascript_translation_default")); 
	}?>
	<!--[if IE 7]>
	<?php echo stylesheet_tag("og/ie7.css"); ?>
	<![endif]-->
	<!--[if IE 8]>
	<?php echo stylesheet_tag("og/ie8.css"); ?>
	<?php echo add_javascript_to_page("jquery/jquery.js")?>
	<?php echo add_javascript_to_page("bootstrap/bootstrap.min.js")?>
	<?php echo add_javascript_to_page("bootstrap/bootstrap-timepicker.js")?>

	<![endif]-->
	<?php $loading_url = get_image_url("layout/loading.gif");
		Hook::fire('change_loading_img', null, $loading_url); ?>
	<?php echo meta_tag('content-type', 'text/html; charset=utf-8', true) ?>
<?php

	// Old Internet Explorer versions does not allow to import more than 32 css files, so we must use the compressed css.
	include_once ROOT . "/library/browser/Browser.php";
	$is_old_ie = Browser::instance()->getBrowser() == Browser::BROWSER_IE && Browser::instance()->getVersion() < 10;
	
	// By default use compressed css
	if (!defined('COMPRESSED_CSS')) {
		define('COMPRESSED_CSS', true);
	}
	
	$version = product_version();
	if ($is_old_ie || COMPRESSED_CSS) {
		echo stylesheet_tag("ogmin.css");
	} else {
		echo stylesheet_tag('website.css');
	}
	
	// Include plguin specif stylesheets - include all installed plugins, no matter if they they have not been activated
	foreach (Plugins::instance()->getAll() as $p) {
		/* @var $p Plugin */
		$css_file =	PLUGIN_PATH ."/".$p->getSystemName()."/public/assets/css/".$p->getSystemName().".css" ;
		if (is_file($css_file)) {
			echo stylesheet_tag(ROOT_URL."/plugins/".$p->getSystemName()."/public/assets/css/".$p->getSystemName().".css" );
			echo "\n";// exit;
		}
	}
	
	
	
	$theme = config_option('theme', DEFAULT_THEME);
	if (is_file(PUBLIC_FOLDER . "/assets/themes/$theme/stylesheets/custom.css")) {
		echo stylesheet_tag('custom.css');
	}
	$css = array();
	Hook::fire('autoload_stylesheets', null, $css);
	foreach ($css as $c) {
		echo stylesheet_tag($c);
	}

	if (defined('COMPRESSED_JS') && COMPRESSED_JS) {
		$jss = array("ogmin.js");
	} else {
		$jss = include "javascripts.php";
	}
	Hook::fire('autoload_javascripts', null, $jss);
	if (defined('USE_JS_CACHE') && USE_JS_CACHE) {
		echo add_javascript_to_page(with_slash(ROOT_URL)."public/tools/combine.php?version=$version&type=javascript&files=".implode(',', $jss));
	} else {
		foreach ($jss as $onejs) {
			echo add_javascript_to_page($onejs);
		}
	}
	$ext_lang_file = get_ext_language_file(get_locale());
	if ($ext_lang_file)	{
		echo add_javascript_to_page("extjs/locale/$ext_lang_file");
	}
	echo add_javascript_to_page("ckeditor/ckeditor.js");
	
	$html_templates = include "html_templates.php";
	foreach ($html_templates as $template) {
		include $template;
	}
	
	// Include plguin specif templates
	foreach (Plugins::instance()->getActive() as $p) {		
		$templates_file =	PLUGIN_PATH ."/".$p->getSystemName()."/application/views/html_templates.php" ;
		if (is_file($templates_file)) {
			$plugins_html_templates = include $templates_file;
			foreach ($plugins_html_templates as $pl_template) {
				include PLUGIN_PATH ."/".$p->getSystemName()."/application/views/".$pl_template;
			}
		}
	}
	
	// Include plguin specif js
	foreach (Plugins::instance()->getActive() as $p) {
		/* @var $p Plugin */
		$js_file =	PLUGIN_PATH ."/".$p->getSystemName()."/public/assets/javascript/".$p->getSystemName().".js" ;
		if (is_file($js_file)) {
			add_javascript_to_page(get_public_url("assets/javascript/".$p->getSystemName().".js", $p->getSystemName()));
			echo "\n";
		}
	}

	$can_see_billing_info = true;
	Hook::fire('get_can_see_billing_information', array('user'=>logged_user()), $can_see_billing_info);
	$can_see_cost_info = true;
	Hook::fire('get_can_see_cost_information', array('user'=>logged_user()), $can_see_cost_info);
	
	?>
	<style>
		#loading {
		    font-size: 20px;
		    left: 45%;
		    position: absolute;
		    top: 45%;
			color: #333333;
    		line-height: 150%;
		}
	</style>
	<?php echo add_javascript_to_page("react_production/vendors~showEarnedValueWidget~showExpensesProgressWidget~showFinancialsWidget~showWorkedHoursWidget.js")?>
	<?php echo add_javascript_to_page("react_production/vendors~showEarnedValueWidget~showExpensesProgressWidget~showFinancialsWidget~showProjectStatisticsW~f4ed70e4.js")?>
	<?php echo add_javascript_to_page("react_production/showFinancialsWidget.js")?>
	<?php echo add_javascript_to_page("react_production/showEarnedValueWidget.js")?>
	<?php echo add_javascript_to_page("react_production/showExpensesProgressWidget.js")?>
	<?php echo add_javascript_to_page("react_production/showProjectStatisticsWidget.js")?>
	<?php echo add_javascript_to_page("react_production/showWorkedHoursWidget.js")?>
</head>
<body id="body" <?php echo render_body_events() ?>>

<iframe name="_download" style="display:none"></iframe>

<div id="loading">
	<img src="<?php echo $loading_url ?>" width="32" height="32" style="margin-right:8px;vertical-align: middle;"/><?php echo lang("loading") ?>...
</div>

<div id="subWsExpander" onmouseover="clearTimeout(og.eventTimeouts['swst']);" onmouseout="og.eventTimeouts['swst'] = setTimeout('og.HideSubWsTooltip()', 2000);" style="display:none;top:10px;"></div>

<?php 
echo render_page_javascript();
echo render_page_inline_js();
$use_owner_company_logo = owner_company()->hasPicture();
$show_owner_company_name_header = config_option("show_owner_company_name_header");
?>
<!-- header -->
<div id="header">
	<div id="headerContent">
	  <table style="width:100%;"><tr><td id="left-header-cell">
		<div style="float: left;" class="header-content-left">
			<div id="logodiv" onclick="og.Breadcrumbs.resetSelection();">
				<div id="logo_company_margin_top">
					<img src="<?php echo ($use_owner_company_logo) ? owner_company()->getPictureUrl('large') : get_product_logo_url() ?>" name="img_company_margin" id="img_company_margin" style="display: none;"/>
					<script>
						$('#img_company_margin').load(function() {
							var margin = (Ext.isIE) ? 25 : Math.round(parseInt(document.img_company_margin.height) / 2);
							$("#img_company_margin").show();
							var img_h = $("#img_company_margin").height();
							if (img_h < 55) {
								$("#img_company_margin").css('margin-top', ((55-img_h)/2)+'px')
							}
						});
					</script>
				</div>
				<div style="float: left;">
				<?php if($show_owner_company_name_header){?>
					<h1 style="padding-top:10px;line-height: 35px;"><?php echo clean(owner_company()->getObjectName()) ?></h1>
				<?php } ?>
				</div>
			</div>
		</div>
		
	  </td><td id="center-header-cell">
	
		<div id="headerBreadcrumb" class="header-breadcrumb-container">
		  <table><tr><td>
			<div class="header-breadcrumb home" onclick="og.Breadcrumbs.resetSelection();" style="display:none;"><?php echo lang('menu home')?></div>
		  </td><td>
			<div class="breadcrumb-members">
				<div class="primary-breadcrumb"></div>
				<div class="secondary-breadcrumb"></div>
			</div>
		  </td></tr></table>
		</div>
		
	  </td><td id="right-header-cell">
		
		<div class="header-content-right">			
			<ul class="options_menu">
				<li>
					<div class="gen-search">
					<?php
						// General search selector parameters
						if (!isset($genid)) $genid = gen_id();
						$container_id = $genid . '_general_search';
						$extra_param = '0';
						$search_function = 'ogSearchSelector.generalSearch';
						$select_function = 'ogSearchSelector.onGeneralSearchResultSelect';
						$search_placeholder = lang('search');
						$result_limit = '5';
						$search_minLength = 0;
						$search_delay = 1100;
						
						include get_template_path("search_selector_view", "search_selector");			
					?>
					</div>
				</li>	
			  	<li id="userboxWrapper" class="<?php echo config_option('brand_colors_texture',1)?'texture-n-1':''; ?>" onclick="showUserOptionsPanel()">
					<img src="<?php echo logged_user()->getPictureUrl(); ?>" alt="" />
					<a id="userLink" style="margin-right: 5px;" href="#" ><?php echo clean(logged_user()->getObjectName()); ?></a>	
					<div class="account"></div>										
			  	</li>			  				  
			</ul>
			<div class="clear"></div>
			<?php echo render_user_box(logged_user())?>
		</div>
		<?php Hook::fire('render_page_header', null, $ret); 
			  Hook::fire('on_page_load', 'mail', $ret);
		?>
	  </td></tr></table>
	</div>
</div>
<!-- /header -->

<!-- footer -->
<div id="footer">
	<div id="copy">
		<?php if(0 && is_valid_url($owner_company_homepage = owner_company()->getHomepage())) { 
		//FIXME Pepe getHomepage not defined
			?>
			<?php echo lang('footer copy with homepage', date('Y'), $owner_company_homepage, clean(owner_company()->getObjectName())) ?>
		<?php } else { ?>
			<?php echo lang('footer copy without homepage', date('Y'), clean(owner_company()->getObjectName())) ?>
		<?php } // if ?>
	</div>
	<?php Hook::fire('render_page_footer', null, $ret) ?>
	<div id="productSignature"><?php echo product_signature() ?></div>
</div>
<!-- /footer -->

<script>
		

// OG config options
og.hostName = '<?php echo ROOT_URL ?>';
og.sandboxName = <?php echo defined('SANDBOX_URL') ? "'".SANDBOX_URL."'" : 'false'; ?>;
og.maxUploadSize = '<?php echo get_max_upload_size() ?>';
<?php //FIXME initialWS for initialMembers
$initialWS = user_config_option('initialWorkspace');
if ($initialWS === "remember") {
	$initialWS = user_config_option('lastAccessedWorkspace', 0);
}
?>

og.initialWorkspace = '<?php echo $initialWS ?>';
<?php $qs = (trim($_SERVER['QUERY_STRING'])) ? "&" . $_SERVER['QUERY_STRING'] : "";  ?>
og.queryString = '<?php echo $_SERVER['QUERY_STRING'] ?>';

og.initialURL = '<?php echo ROOT_URL ."/?".$_SERVER['QUERY_STRING'] ?>';
<?php if (user_config_option("rememberGUIState")) { ?>
og.initialGUIState = <?php echo json_encode(GUIController::getState()) ?>;
<?php }
if (user_config_option("autodetect_time_zone", null)) {
	$now = DateTimeValueLib::now();
?>
	og.tz_offset = og.calculate_time_zone(new Date(<?php echo $now->getYear() ?>,<?php echo $now->getMonth() - 1 ?>,<?php echo $now->getDay() ?>,<?php echo $now->getHour() ?>,<?php echo $now->getMinute() ?>,<?php echo $now->getSecond() ?>));
	og.openLink(og.getUrl('account', 'set_timezone', {tz_name: jstz.determine().name(), tz_offset: og.tz_offset}), {'hideLoading': true});
<?php 
} ?>
og.CurrentPagingToolbar = <?php echo defined('INFINITE_PAGING') && INFINITE_PAGING ? 'og.InfinitePagingToolbar' : 'og.PagingToolbar' ?>;
og.ownerCompany = {
	id: '<?php echo owner_company()->getId()?>',
	name: '<?php echo escape_character(clean(owner_company()->getObjectName()))?>',
	logo_url: '<?php echo (owner_company()->getPictureFile() != '' ? owner_company()->getPictureUrl() : '')?>',
	small_logo_url: '<?php echo (owner_company()->getPictureFile() != '' ? owner_company()->getPictureUrl('small') : '')?>',
	medium_logo_url: '<?php echo (owner_company()->getPictureFile() != '' ? owner_company()->getPictureUrl('medium') : '')?>',
	large_logo_url: '<?php echo (owner_company()->getPictureFile() != '' ? owner_company()->getPictureUrl('large') : '')?>',
	email: '<?php echo escape_character(clean(owner_company()->getEmailAddress('work'))) ?>',
	phone: '<?php echo escape_character(clean(owner_company()->getPhoneNumber('work'))) ?>',
	address: '<?php echo str_replace("\n", " ", escape_character(clean(owner_company()->getStringAddress('work')))) ?>',
	homepage: '<?php echo escape_character(clean(owner_company()->getWebpageUrl('work'))) ?>'
};
og.loggedUser = {
	id: <?php echo logged_user()->getId() ?>,
	username: <?php echo json_encode(logged_user()->getUsername()) ?>,
	displayName: <?php echo json_encode(logged_user()->getObjectName()) ?>,
	isAdmin: <?php echo logged_user()->isAdministrator() ? 'true' : 'false' ?>,
	isGuest: <?php echo logged_user()->isGuest() ? 'true' : 'false' ?>,
	type: <?php echo logged_user()->getUserType() ?>,
	localization: '<?php echo logged_user()->getLocale() ?>',
	can_instantiate_templates: <?php echo can_instantiate_templates(logged_user()) ? 'true' : 'false'?>,
	can_manage_tasks: <?php echo can_manage_tasks(logged_user()) ? 'true' : 'false' ?>,
	can_see_billing_info: <?php echo $can_see_billing_info ? 'true' : 'false' ?>,
	can_see_cost_info: <?php echo $can_see_cost_info ? 'true' : 'false' ?>,
	tz: {
		id: '<?php echo logged_user()->getUserTimezoneId() ?>',
		name: '<?php echo Timezones::getTimezoneName(logged_user()->getUserTimezoneId()) ?>',
		offset: '<?php echo logged_user()->getUserTimezoneValue() ?>'
	}
};
og.zipSupported = <?php echo zip_supported() ? 1 : 0 ?>;
og.hasNewVersions = <?php
	if (config_option('upgrade_last_check_new_version', false) && logged_user()->isAdministrator()) {
		echo json_encode(lang('new Feng Office version available', "#", "og.openLink(og.getUrl('administration', 'upgrade'))"));
	} else {
		echo "false";
	}
?>;
og.config = {
	'mails_per_page': <?php echo json_encode(user_config_option('mails_per_page',50)) ?>,
	'contacts_per_page': <?php echo json_encode(user_config_option('contacts_per_page',50)) ?>,
	'files_per_page': <?php echo json_encode(config_option('files_per_page', 50)) ?>,
	'days_on_trash': <?php echo json_encode(config_option("days_on_trash", 0)) ?>,
	'checkout_notification_dialog': <?php echo json_encode(config_option('checkout_notification_dialog', 0)) ?>,
	'use_time_in_task_dates': <?php echo json_encode(config_option('use_time_in_task_dates')) ?>,
	'working_days': <?php echo json_encode(user_config_option('pushUseWorkingDays')) ?>,
	'can_assign_tasks_to_companies': <?php echo json_encode(config_option('can_assign_tasks_to_companies')) ?>,
	'enable_notes_module': <?php echo json_encode(module_enabled("messages")) ?>,
	'enable_email_module': <?php echo json_encode(module_enabled("mails")) ?>,
	'enable_contacts_module': <?php echo json_encode(module_enabled("contacts")) ?>,
	'enable_calendar_module': <?php echo json_encode(module_enabled("calendar")) ?>,
	'enable_documents_module': <?php echo json_encode(module_enabled("documents")) ?>,
	'enable_tasks_module': <?php echo json_encode(module_enabled("tasks")) ?>,
	'enable_weblinks_module': <?php echo json_encode(module_enabled('weblinks')) ?>,
	'enable_time_module': <?php echo json_encode(module_enabled("time") && can_manage_time(logged_user())) ?>,
	'enable_reporting_module': <?php echo json_encode(module_enabled("reporting")) ?>,
	'use_tasks_dependencies': <?php echo json_encode(module_enabled("tasks")) ?>,
	'customers_module': <?php echo json_encode(module_enabled("customers")) ?>,
	'default_country_address': <?php echo json_encode(config_option('default_country_address', '')) ?>,
	'default_type_address': <?php echo json_encode(config_option('default_type_address', '')) ?>,
	'enabled_dimensions': Ext.util.JSON.decode('<?php echo json_encode(config_option('enabled_dimensions')) ?>'),
	'brand_colors': {
		brand_colors_head_back: '<?php echo config_option('brand_colors_head_back')?>',
		brand_colors_head_font: '<?php echo config_option('brand_colors_head_font')?>',
		brand_colors_tabs_back: '<?php echo config_option('brand_colors_tabs_back')?>',
		brand_colors_tabs_font: '<?php echo config_option('brand_colors_tabs_font')?>',
		brand_colors_texture: '<?php echo config_option('brand_colors_texture')?>'
	},
	'with_perm_user_types': Ext.util.JSON.decode('<?php echo json_encode(config_option('give_member_permissions_to_new_users'))?>'),
	'member_selector_page_size': 100,
	'show_company_info_report_print': <?php echo config_option('show_company_info_report_print') ? '1' : '0' ?>,
	'currency_code': '<?php config_option('currency_code', '$') ?>',
	'minimum_characters_dimension_search': <?php echo json_encode(config_option("minimum_characters_dimension_search", 3)) ?>
};
var advanced_billing_active = <?php echo Plugins::instance()->isActivePlugin('advanced_billing') ? '1' : '0'; ?>;
if (advanced_billing_active){
	og.config['use_is_billable_value_in_tasks'] ='<?php echo config_option('use_is_billable_value_in_tasks')?>';
	og.config['show_financial_tab_in_task_form'] ='<?php echo config_option('show_financial_tab_in_task_form')?>';
}

var mail_active = <?php echo Plugins::instance()->isActivePlugin('mail') ? '1' : '0'; ?>;
if (mail_active) {
	og.config['spam_deletion_days'] = <?php echo json_encode(config_option('spam_deletion_days', 30)) ?>;
	og.config['spam_delete_limit_per_run'] = <?php echo json_encode(config_option('spam_delete_limit_per_run', 100)) ?>;
}

og.preferences = {
	'viewContactsChecked': <?php echo json_encode(user_config_option('viewContactsChecked')) ?>,
	'viewUsersChecked': <?php echo json_encode(user_config_option('viewUsersChecked')) ?>,
	'viewCompaniesChecked': <?php echo json_encode(user_config_option('viewCompaniesChecked')) ?>,
	'rememberGUIState': <?php echo user_config_option('rememberGUIState') ? '1' : '0' ?>,
	'time_format_use_24': <?php echo json_encode(user_config_option('time_format_use_24')) ?>,
	'show_unread_on_title': <?php echo user_config_option('show_unread_on_title') ? '1' : '0' ?>,
	'email_polling': <?php echo json_encode(user_config_option('email_polling')) ?> ,
	'email_check_acc_errors': <?php echo json_encode(user_config_option('mail_account_err_check_interval')) ?> ,
	'date_format': <?php echo json_encode(user_config_option('date_format')) ?>,
	'date_format_tip': <?php echo json_encode(date_format_tip(user_config_option('date_format'))) ?>,
	'start_monday': <?php echo user_config_option('start_monday') ? '1' : '0' ?>,
	'draft_autosave_timeout': <?php echo json_encode(user_config_option('draft_autosave_timeout')) ?>,
	'drag_drop_prompt': <?php echo json_encode(user_config_option('drag_drop_prompt')) ?>,
	'mail_drag_drop_prompt': <?php echo json_encode(user_config_option('mail_drag_drop_prompt')) ?>,
	'access_member_after_add': <?php echo user_config_option('access_member_after_add') ? '1' : '0' ?>,
	'access_member_after_add_remember': <?php echo user_config_option('access_member_after_add_remember') ? '1' : '0' ?>,
	'listing_preferences': [],
	'breadcrumb_member_count': <?php echo user_config_option('breadcrumb_member_count') ?>,
	'can_modify_navigation_panel': <?php echo user_config_option('can_modify_navigation_panel') ? '1' : '0' ?>,
	'show_birthdays_in_calendar': <?php echo user_config_option('show_birthdays_in_calendar') ? '1' : '0' ?>,
	'enableArchiveConfirmation': <?php echo user_config_option('enable_archive_confirmation') ? '1' : '0' ?>,
	'enableTrashConfirmation': <?php echo user_config_option('enable_trash_confirmation') ? '1' : '0' ?>,
	'trash_objects_in_member_after_delete': <?php echo user_config_option('trash_objects_in_member_after_delete') ? '1' : '0' ?>,
	'decimals_separator': '<?php echo user_config_option('decimals_separator') ?>',
	'thousand_separator': '<?php echo user_config_option('thousand_separator') ?>',
	'decimal_digits': <?php echo user_config_option('decimal_digits') ?>,
};

// Add object type dimensions that are used in forms as member selectors
og.dimensionsByObjectTypeInMemberSelector = {};
<?php 
$all_object_types = ObjectTypes::getAvailableObjectTypes();
foreach($all_object_types as $object_type) {
	$object_type_id = $object_type->getId();
	$object_type_name = $object_type->getName();
	$all_dimensions = Dimensions::getAllowedDimensions($object_type_id);
	Hook::fire("allowed_dimensions_in_member_selector", array('ot' => $object_type_id), $all_dimensions);
	?>
	og.dimensionsByObjectTypeInMemberSelector['<?php echo $object_type_name?>'] = [];
	<?php foreach ($all_dimensions as $dimension) { ?>
		og.dimensionsByObjectTypeInMemberSelector['<?php echo $object_type_name?>'].push(<?php echo $dimension['dimension_id']?>);
	<?php }
} ?>

og.userRoles = {};
<?php $all_roles = PermissionGroups::instance()->getNonPersonalSameLevelPermissionsGroups();
	foreach ($all_roles as $role) {?>
		og.userRoles[<?php echo $role->getId()?>] = {
			code:'<?php echo $role->getName() ?>', 
			name:'<?php echo escape_character(lang($role->getName()))?>', 
			parent:'<?php echo $role->getParentId()?>',
			hint:'<?php echo escape_character(lang($role->getName().' user role description') . '&nbsp;<a href="http://www.fengoffice.com/web/user_types.php" target="_blank">'.lang('more information about user roles').'</a>') ?>'
		};
<?php } ?>

og.userTypes = {};
<?php $all_user_types = PermissionGroups::instance()->getUserTypeGroups();
	foreach ($all_user_types as $type) {?>
		og.userTypes[<?php echo $type->getId()?>] = {code:'<?php echo $type->getName() ?>', name:'<?php echo escape_character(lang($type->getName()))?>'};
<?php } ?>
og.defaultRoleByType = {};
<?php $default_roles_by_type = PermissionGroups::instance()->getDefaultRolesByType();
	foreach ($default_roles_by_type as $type => $role) {?>
		og.defaultRoleByType[<?php echo $type?>] = <?php echo $role?>;
<?php } ?>

<?php
$rolePermissions = SystemPermissions::getAllRolesPermissions();
echo "og.userRolesPermissions =".json_encode($rolePermissions).";";
$maxRolePermissions = MaxSystemPermissions::getAllMaxRolesPermissions();
echo "og.userMaxRolesPermissions =".json_encode($maxRolePermissions).";";

echo "og.defaultRoleObjectTypePermissions = ".json_encode(RoleObjectTypePermissions::getAllRoleObjectTypePermissionsInfo()).";";
echo "og.maxRoleObjectTypePermissions = ".json_encode(MaxRoleObjectTypePermissions::getAllMaxRoleObjectTypePermissionsInfo()).";";
?>

<?php 
$tabs_allowed = TabPanelPermissions::getAllRolesModules();
echo "og.tabs_allowed=".json_encode($tabs_allowed).";";
$guest_groups = PermissionGroups::instance()->getGuestPermissionGroups();
echo "og.guest_permission_group_ids = [];";
foreach ($guest_groups as $gg) {
	echo "og.guest_permission_group_ids.push(".$gg->getId().");";
}
$executive_groups = PermissionGroups::instance()->getExecutivePermissionGroups();
echo "og.executive_permission_group_ids = [];";
foreach ($executive_groups as $eg) {
	echo "og.executive_permission_group_ids.push(".$eg->getId().");";
}
?>

<?php 
$allUsers = Contacts::getAllUsers(null, true);
foreach($allUsers as $usr) {
    $usr_info = $usr->getArrayInfo();
    $allUsers_array[$usr->getId()] = $usr_info;
}
?>
og.allUsers =  <?php echo clean(str_replace('"',"'", escape_character(json_encode($allUsers_array)))) ?>;

<?php 
$object_types = ObjectTypes::getAllObjectTypes();

foreach ($object_types as $ot) {
    
	$c_name = $ot->getObjectTypeName();
    $c_name_plural = $ot->getPluralObjectTypeName();
	
	$types[$ot->getId()] = array(
		"id" => $ot->getId(),
		"name" => $ot->getName(),
	    "c_name" => $c_name,
	    "c_name_plural" => $c_name_plural,
		"icon" => $ot->getIconClass(),
		"type" => $ot->getType()
	);
	if ($ot->getType() == 'content_object') {
		$types[$ot->getId()]['controller'] = $ot->getObjectTypeController();
		$types[$ot->getId()]['add_action'] = $ot->getObjectTypeAddAction();

		$allow_generic_type = true;
		Hook::fire('allow_generic_type_object_subtypes_ot', $ot, $allow_generic_type);
		$types[$ot->getId()]['allow_generic_type'] = $allow_generic_type;
	}
}
?>
og.objectTypes =  <?php echo clean(str_replace('"',"'", escape_character(json_encode($types)))) ?>;

<?php
	$listing_preferences = ContactConfigOptions::getOptionsByCategoryName('listing preferences');
	foreach ($listing_preferences as $lp) {
		if (str_starts_with($lp->getName(), 'lp_dim_')) {
			$dcode = str_replace('lp_dim_', '', str_replace('_show_as_column', '', $lp->getName()));
			$dim = Dimensions::findByCode($dcode);
			?>og.preferences['listing_preferences']['<?php echo 'lp_dim_'.$dim->getId().'_show_as_column' ?>'] = <?php echo user_config_option($lp->getName()) ? '1' : '0'?>;<?php
		}
	} 
?>
og.breadcrumbs_skipped_dimensions = [];

Ext.Ajax.timeout = <?php echo get_max_execution_time()*1100 // give a 10% margin to PHP's timeout ?>;
//og.musicSound = new Sound();
//og.systemSound = new Sound();

<?php 
	$all_dimension_associations = DimensionMemberAssociations::instance()->getAllAssociationsInfo();
	$json_options = null;
	if (defined('JSON_HEX_APOS')) $json_options = JSON_HEX_APOS;
?>
og.dimension_member_associations = Ext.util.JSON.decode('<?php echo json_encode($all_dimension_associations, $json_options)?>');


<?php if (!defined('DISABLE_JS_POLLING') || !DISABLE_JS_POLLING) { ?>
var isActiveBrowserTab = true;
if (Ext.isIE) {
	document.onfocusin = function () {
	  isActiveBrowserTab = true;
	};
	document.onfocusout = function () {
	  isActiveBrowserTab = false;
	};
} else {
	window.onfocus = function () {
	  isActiveBrowserTab = true;
	};
	window.onblur = function () {
	  isActiveBrowserTab = false;
	};
}

og.dimensions_check_date = new Date();

setInterval(function() {
	// document.hidden is false when the current tab is the active tab
	if (!document.hidden) {
		og.openLink(og.getUrl('object', 'popup_reminders'), {
			hideLoading: true,
			hideErrors: true,
			preventPanelLoad: true,
			post: {
				dims_check_date: Math.floor(og.dimensions_check_date.getTime()/1000)
			},
			callback: function(success, data) {

				//reload og.dimensions
				if (data && data.reload_dims) {
					ogMemberCache.reset_dimensions_cache();										
				}
			}
		});
	}
}, 60000);
<?php } ?>

og.additional_dashboard_actions = [];
<?php 
//additional buttons in dashboard objects list
$actions = array();
Hook::fire('additional_dashboard_actions', null, $actions);
$i=0;
foreach ($actions as $action) {
	$i++;
	?>
	og.additional_dashboard_actions.push(
		new Ext.Action({
			id: "add-action-<?php echo $action['id']?>",
			assoc_ot: <?php echo array_var($action, 'assoc_ot', '0')?>,
			assoc_dim: <?php echo array_var($action, 'assoc_dim', '0')?>,
			text: "<?php echo $action['name']?>",
			tooltip: "<?php echo $action['name']?>",
			cls: "x-btn-text-icon dash-additional-action",
			iconCls: "<?php echo $action['class']?>",
			handler: function() {
				<?php echo $action['onclick']?>
			},
			scope: this
		})
	);
	<?php
}
?>

<?php if (Plugins::instance()->isActivePlugin('mail')) { ?>
	og.loadEmailAccounts('view');
	og.loadEmailAccounts('edit');
	og.loggedUserHasEmailAccounts = <?php echo logged_user()->hasEmailAccounts() ? 'true' : 'false' ?>;
	og.emailFilters = {};
	og.emailFilters.classif = '<?php echo user_config_option('mails classification filter') ?>';
	og.emailFilters.read = '<?php echo user_config_option('mails read filter') ?>';
	<?php
		$acc = MailAccounts::instance()->findById(user_config_option('mails account filter'));
		if ($acc instanceof MailAccount) {
			?>
			og.emailFilters.account = '<?php echo user_config_option('mails account filter') ?>';
			og.emailFilters.accountName = '<?php echo mysqli_real_escape_string(DB::connection()->getLink(), $acc->getName()) ?>';
			<?php
		} else { 
			?>
			og.emailFilters.account = '';
			og.emailFilters.accountName = '';
			<?php
		}
	?>
<?php } ?>
og.lastSelectedRow = {messages:0, mails:0, contacts:0, documents:0, weblinks:0, overview:0, linkedobjs:0, archived:0};

og.menuPanelCollapsed = false;

og.dimensionPanels = [
	<?php
	$dim_obj_type_descendants = array();
	$enabled_dimensions = config_option("enabled_dimensions");
	$dimensionController = new DimensionController();
	$first = true; 
	$dimensions = $dimensionController->get_context();
	foreach ( $dimensions['dimensions'] as $dimension ):
	 	if (!in_array($dimension->getId(), $enabled_dimensions)) {
	 		continue;
	 	}
	 		
		/* @var $dimension Dimension */
		$title = $dimension->getName();
		if (!$first) echo ",";
		$first = false;
		
		$reloadDimensions = get_associated_dimensions_to_reload_json($dimension->getId());
		
		?>
		{	
			reloadDimensions: <?php echo $reloadDimensions ?>,
			xtype: 'member-tree',
			id: 'dimension-panel-<?php echo $dimension->getId() ; ?>',
			lines: false,
			dimensionId: <?php echo $dimension->getId() ; ?>,
			dimensionCode: '<?php echo $dimension->getCode() ; ?>',
			dimensionOptions: '{"defaultAjax":{"controller":"dashboard", "action": "main_dashboard"}}',
			isDefault: '<?php echo (int) $dimension->isDefault() ; ?>',
			title: "<?php echo $title ?>",
			multipleSelection: <?php echo (int)$dimension->getAllowsMultipleSelection() ?>,
			isRoot: <?php echo (int) $dimension->getIsRoot(); ?>,
			requiredObjectTypes: <?php echo json_encode($dimension->getRequiredObjectTypes()) ?>,
			hidden: <?php echo (int) ! $dimension->getIsRoot(); ?>,
			isManageable: <?php echo (int) $dimension->getIsManageable() ?>,
			quickAdd: <?php echo ( intval($dimension->getOptionValue('quickAdd')) ) ? 'true' : 'false'  ?>,
			minHeight: 10,
			filterOnChange: true
			//animate: false,
			//animCollapse: false
			
		}	
	<?php
		$dim_obj_types = DimensionObjectTypes::getObjectTypeIdsByDimension($dimension->getId());
		$dim_obj_type_descendants[$dimension->getId()] = array();
		foreach ($dim_obj_types as $ot_id) {
			$all_child_ots = DimensionObjectTypeHierarchies::getAllChildrenObjectTypeIds($dimension->getId(), $ot_id);
			$dim_obj_type_descendants[$dimension->getId()][$ot_id] = array_values($all_child_ots);
		}
	?>
	<?php endforeach; ?>
];
og.dimension_object_type_descendants = Ext.util.JSON.decode('<?php echo json_encode($dim_obj_type_descendants)?>');

og.contextManager.construct();
og.objPickerTypeFilters = [];
<?php
	$obj_picker_type_filters = ObjectTypes::instance()->findAll(array("conditions" => "`type` = 'content_object'
		AND (plugin_id IS NULL OR plugin_id = 0 OR plugin_id IN (SELECT distinct(id) FROM ".TABLE_PREFIX."plugins WHERE is_installed = 1 AND is_activated = 1 ))
		AND `name` <> 'file revision' AND name <> 'template_task' AND name <> 'template_milestone' AND `id` NOT IN (
			SELECT `object_type_id` FROM ".TabPanels::instance()->getTableName(true)." WHERE `enabled` = 0
		)  OR `type` = 'comment' OR `name` = 'milestone'"));
	
	$pg_ids = logged_user()->getPermissionGroupIds();
	if (!is_array($pg_ids) || count($pg_ids) == 0) $pg_ids = array(0);
	
	foreach ($obj_picker_type_filters as $type) {
		if (! $type instanceof  ObjectType ) continue ;
		/* @var $type ObjectType */
		$linkable = $type->getIsLinkableObjectType();
		if ($linkable) {
			$tab_ids = DB::executeAll("SELECT id FROM ".TABLE_PREFIX."tab_panels WHERE object_type_id = ".$type->getId());
			if (is_array($tab_ids) && count($tab_ids) > 0) {
				$tab_id = $tab_ids[0]['id'];
				if (!TabPanelPermissions::isModuleEnabled($tab_id, implode(',', $pg_ids))) {
					continue;
				}
			}
?>
			og.objPickerTypeFilters.push({
				id: '<?php echo $type->getName() ?>',
				name: '<?php echo lang($type->getName()) ?>',
				type: '<?php echo $type->getName() ?>',
				filter: 'type',
				iconCls: 'ico-<?php echo $type->getIcon() ?>'
			});
<?php
		}
	}
?>


	og.additional_list_columns = [];
	og.additional_on_dimension_object_click = [];
	og.dimension_object_types = [];
<?php
	$dimension_object_types = ObjectTypes::instance()->findAll(array('conditions' => "`type` IN ('dimension_object', 'dimension_group')"));
	foreach ($dimension_object_types as $dot) { ?>
		og.dimension_object_types[<?php echo $dot->getId()?>] = '<?php echo $dot->getName()?>';
<?php
	}
	foreach (Plugins::instance()->getActive() as $p) {
		$js_code = 'if (og.'.$p->getName().' && og.'.$p->getName().'.init) og.'.$p->getName().'.init();'."\n";
		echo $js_code;
	} 
?>

og.dimension_object_type_contents = {};
<?php 
	$dotcs = DimensionObjectTypeContents::instance()->findAll();
	foreach ($dotcs as $dotc) { /* @var $dotc DimensionObjectTypeContent */?>
		var dim = <?php echo $dotc->getDimensionId() ?>;
		var dot = <?php echo $dotc->getDimensionObjectTypeId() ?>;
		var cot = <?php echo $dotc->getContentObjectTypeId() ?>;
		if (!og.dimension_object_type_contents[dim]) og.dimension_object_type_contents[dim] = [];
		if (!og.dimension_object_type_contents[dim][dot]) og.dimension_object_type_contents[dim][dot] = [];
		og.dimension_object_type_contents[dim][dot][cot] = {required:<?php echo $dotc->getIsRequired()?"1":"0"?>, multiple:<?php echo $dotc->getIsMultiple()?"1":"0"?>};
<?php
	} 
?>

function showUserOptionsPanel() {
    $('div.user-box-actions').slideToggle();  
}

og.getting_started_step = '<?php echo config_option('getting_started_step') ?>';

$(document).ready(function() {

	og.createBrandColorsSheet(og.config.brand_colors);
	
	var logo_link = document.getElementById("change-logo-link");
	if (logo_link) {
		logo_link.onclick = function(e){
			if(e && e.stopPropagation) {
				e.stopPropagation();
			} else {
				e = window.event;
				e.cancelBubble = true;
			}
		}
	}

	og.custom_properties_by_type = {};
	og.openLink(og.getUrl('object', 'get_cusotm_property_columns'), {
		callback: function(success, data){
			if (typeof data.properties != 'undefined' && !(data.properties instanceof Array )) {
				og.custom_properties_by_type = data.properties;
			}
		}
	});

	og.openLink(og.getUrl('dimension', 'load_dimensions_info'), {
		hideLoading: true,
		hideErrors: true,
		preventPanelLoad: true,
		callback: function(s, d) {
			if (d.dim_names) {
				og.dimensions_info = d.dim_names;
				// Add enabled dimensions by code
				og.enabled_dimensions_by_code = {};
				for(const [key, value] of Object.entries(og.dimensions_info)) {
					og.enabled_dimensions_by_code[value.code] = key;
				}
			}
			og.eventManager.fireEvent('after dimensions info loaded', null);
		}
	});

	var all_steps = 99;
	if (og.getting_started_step < all_steps) {
		og.more_panel_int = setInterval(function() {
			var more_panel = Ext.getCmp('more-panel');
			if (more_panel) {
				var tp = Ext.getCmp('tabs-panel');
				if (tp) tp.setActiveTab(more_panel);
				clearInterval(og.more_panel_int);
			}
		}, 500);
	}

	setTimeout(function() {
		og.Breadcrumbs.resizeHeaderBreadcrumbs();
	}, 250);
	
	$(window).resize(function() {
		og.Breadcrumbs.resizeHeaderBreadcrumbs();
		og.checkAndAdjustTabsSize();
	});


<?php 
	$all_telephone_types = TelephoneTypes::getAllTelephoneTypesInfo();
	$all_address_types = AddressTypes::getAllAddressTypesInfo();
	$all_webpage_types = WebpageTypes::getAllWebpageTypesInfo();
	$all_email_types = EmailTypes::getAllEmailTypesInfo();
?>
	og.telephone_types = Ext.util.JSON.decode('<?php echo json_encode($all_telephone_types)?>');
	og.address_types = Ext.util.JSON.decode('<?php echo json_encode($all_address_types)?>');
	og.webpage_types = Ext.util.JSON.decode('<?php echo json_encode($all_webpage_types)?>');
	og.email_types = Ext.util.JSON.decode('<?php echo json_encode($all_email_types)?>');
	
});

<?php
$default_currency = Currencies::getDefaultCurrencyInfo();
if (is_array($default_currency) && count($default_currency) > 0) {
	?>og.default_currency = Ext.util.JSON.decode('<?php echo json_encode($default_currency)?>');<?php
} 
?>

og.all_currencies = Ext.util.JSON.decode('<?php echo json_encode(Currencies::getCurrenciesInfo()) ?>');


og.loadedScripts = [];
<?php 
$revision = product_version_revision();
if($revision != "") {
	$revision = "?rev=".$revision;
}
foreach ($jss as $onejs) {
	?>og.loadedScripts['<?php echo get_javascript_url($onejs . $revision) ?>'] = true;<?php 
}
?>



//listener to hide jquery popovers when clicking outside
$('html').on('click', function(e) {
	if (typeof $(e.target).data('original-title') == 'undefined' && !$(e.target).parents().is('.popover.in')) {
		$('[data-original-title]').popover('hide');
	}
});


</script>
<?php include_once(Env::getLayoutPath("listeners"));?>
	<div style="height:100%;width:100%;display:none;position:fixed;top:0px;left:0px;z-index: 2000;overflow-y: auto;" id="modal-forms-container"></div>

	<div id="quick-form" > 
            <div id="close_text" style="float: right; cursor: pointer;height: 12px;position: absolute;right: 19px;top: 2px;"><a href="#" onclick="$('.close').click();"><?php echo lang('close')?></a></div>
            <div id="close_ico" class="close" style="float: right;"></div>
            <div class="form-container"></div>
	</div>
</body>
</html>

<?php Hook::fire('page_rendered', null, $ret); ?>

