/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Window
extends Container
implements Accessible {
    private static final long serialVersionUID = 4497834738069338734L;
    private static transient long next_window_number;
    private String warningString;
    private int windowSerializedDataVersion;
    private int state;
    private boolean focusableWindowState;
    private transient Vector ownedWindows;
    private transient WindowListener windowListener;
    private transient WindowFocusListener windowFocusListener;
    private transient WindowStateListener windowStateListener;
    private transient GraphicsConfiguration graphicsConfiguration;
    private transient boolean shown;
    transient Component windowFocusOwner;
    static /* synthetic */ Class class$java$awt$event$WindowListener;
    static /* synthetic */ Class class$java$awt$event$WindowFocusListener;
    static /* synthetic */ Class class$java$awt$event$WindowStateListener;

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && !this.parent.isDisplayable()) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.addNotify();
            }
            Iterator e = this.ownedWindows.iterator();
            while (true) {
                if (!e.hasNext()) {
                    this.validate();
                    super.show();
                    this.toFront();
                    KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    manager.setGlobalFocusedWindow(this);
                    if (!this.shown) {
                        FocusTraversalPolicy policy = this.getFocusTraversalPolicy();
                        Component initialFocusOwner = null;
                        if (policy != null) {
                            initialFocusOwner = policy.getInitialComponent(this);
                        }
                        if (initialFocusOwner != null) {
                            initialFocusOwner.requestFocusInWindow();
                        }
                        this.shown = true;
                    }
                    return;
                }
                Window w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    if (!w.isVisible()) continue;
                    w.getPeer().setVisible(true);
                    continue;
                }
                e.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hide() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator e = this.ownedWindows.iterator();
            while (e.hasNext()) {
                Window w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    if (!w.isVisible() || w.getPeer() == null) continue;
                    w.getPeer().setVisible(false);
                    continue;
                }
                e.remove();
            }
        }
        super.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.hide();
        var1_1 = this.getTreeLock();
        synchronized (var1_1) {
            e = this.ownedWindows.iterator();
            while (true) {
                block6: {
                    if (e.hasNext()) break block6;
                    i = 0;
                    if (true) ** GOTO lbl23
                }
                w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    w.dispose();
                    continue;
                }
                e.remove();
            }
            do {
                this.component[i].removeNotify();
                ++i;
lbl23:
                // 2 sources

            } while (i < this.ncomponents);
            this.removeNotify();
            we = new WindowEvent(this, 202);
            this.getToolkit().getSystemEventQueue().postEvent(we);
            return;
        }
    }

    public void toBack() {
        if (this.peer != null) {
            WindowPeer wp = (WindowPeer)this.peer;
            wp.toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            WindowPeer wp = (WindowPeer)this.peer;
            wp.toFront();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Window[] getOwnedWindows() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Window[] validList = new Window[this.ownedWindows.size()];
            Iterator e = this.ownedWindows.iterator();
            int numValid = 0;
            while (true) {
                if (!e.hasNext()) break;
                Window w = (Window)((Reference)e.next()).get();
                if (w != null) {
                    validList[numValid++] = w;
                    continue;
                }
                e.remove();
            }
            if (numValid == validList.length) return validList;
            Window[] trimmedList = new Window[numValid];
            System.arraycopy(validList, 0, trimmedList, 0, numValid);
            return trimmedList;
        }
    }

    public synchronized void addWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, listener);
    }

    public synchronized void removeWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, listener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        Class clazz = class$java$awt$event$WindowListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowListener = Window.class("[Ljava.awt.event.WindowListener;", false);
        }
        return (WindowListener[])AWTEventMulticaster.getListeners(this.windowListener, clazz);
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        Class clazz = class$java$awt$event$WindowFocusListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowFocusListener = Window.class("[Ljava.awt.event.WindowFocusListener;", false);
        }
        return (WindowFocusListener[])AWTEventMulticaster.getListeners(this.windowFocusListener, clazz);
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        Class clazz = class$java$awt$event$WindowStateListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowStateListener = Window.class("[Ljava.awt.event.WindowStateListener;", false);
        }
        return (WindowStateListener[])AWTEventMulticaster.getListeners(this.windowStateListener, clazz);
    }

    public void addWindowFocusListener(WindowFocusListener wfl) {
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, wfl);
    }

    public void addWindowStateListener(WindowStateListener wsl) {
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, wsl);
    }

    public void removeWindowFocusListener(WindowFocusListener wfl) {
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, wfl);
    }

    public void removeWindowStateListener(WindowStateListener wsl) {
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, wsl);
    }

    public EventListener[] getListeners(Class listenerType) {
        Class clazz = class$java$awt$event$WindowListener;
        if (clazz == null) {
            clazz = class$java$awt$event$WindowListener = Window.class("[Ljava.awt.event.WindowListener;", false);
        }
        if (listenerType == clazz) {
            return this.getWindowListeners();
        }
        return super.getListeners(listenerType);
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 209 && e.id >= 200 && (this.windowListener != null || this.windowFocusListener != null || this.windowStateListener != null || (this.eventMask & 0x40L) != 0L)) {
            this.processEvent(e);
        } else if (e.id == 101) {
            this.validate();
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected void processEvent(AWTEvent evt) {
        if (evt instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)evt);
        } else {
            super.processEvent(evt);
        }
    }

    protected void processWindowEvent(WindowEvent evt) {
        int id = evt.getID();
        if (id == 207 || id == 208) {
            this.processWindowFocusEvent(evt);
        } else if (id == 209) {
            this.processWindowStateEvent(evt);
        } else if (this.windowListener != null) {
            switch (evt.getID()) {
                case 205: {
                    this.windowListener.windowActivated(evt);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(evt);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(evt);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(evt);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(evt);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(evt);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(evt);
                    break;
                }
            }
        }
    }

    public boolean isActive() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean bl = false;
        if (manager.getActiveWindow() == this) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocused() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean bl = false;
        if (manager.getFocusedWindow() == this) {
            bl = true;
        }
        return bl;
    }

    public Component getFocusOwner() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = manager.getActiveWindow();
        if (activeWindow == this) {
            return manager.getFocusOwner();
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        return this.windowFocusOwner;
    }

    void setFocusOwner(Component windowFocusOwner) {
        this.windowFocusOwner = windowFocusOwner;
    }

    public boolean postEvent(Event e) {
        return this.handleEvent(e);
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public void setLocationRelativeTo(Component c) {
        if (c == null || !c.isShowing()) {
            int x = 0;
            int y = 0;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point center = ge.getCenterPoint();
            x = center.x - this.width / 2;
            y = center.y - this.height / 2;
            this.setLocation(x, y);
        }
    }

    public void createBufferStrategy(int numBuffers) {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Window.createBufferStrategy: window is not displayable");
        }
        BufferStrategy newStrategy = null;
        try {
            newStrategy = new WindowFlipBufferStrategy(numBuffers);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        if (newStrategy == null) {
            newStrategy = new WindowBltBufferStrategy(numBuffers, true);
        }
        this.bufferStrategy = newStrategy;
    }

    public void createBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (caps == null) {
            throw new IllegalArgumentException("Window.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = caps.isPageFlipping() ? new WindowFlipBufferStrategy(numBuffers) : new WindowBltBufferStrategy(numBuffers, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void applyResourceBundle(ResourceBundle rb) {
        throw new Error("Not implemented");
    }

    public void applyResourceBundle(String rbName) {
        ResourceBundle rb = ResourceBundle.getBundle(rbName, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        if (rb != null) {
            this.applyResourceBundle(rb);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow();
        }
        return this.accessibleContext;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        if (this.peer != null) {
            return this.peer.getGraphicsConfiguration();
        }
        return null;
    }

    protected void processWindowFocusEvent(WindowEvent event) {
        if (this.windowFocusListener != null) {
            switch (event.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(event);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(event);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent event) {
        if (this.windowStateListener != null && event.getID() == 209) {
            this.windowStateListener.windowStateChanged(event);
        }
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        return this instanceof Dialog || this instanceof Frame;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public void setFocusableWindowState(boolean focusableWindowState) {
        this.focusableWindowState = focusableWindowState;
    }

    String generateName() {
        return "win" + Window.getUniqueLong();
    }

    private static final synchronized long getUniqueLong() {
        return next_window_number++;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.warningString = null;
        this.windowSerializedDataVersion = 0;
        this.state = 0;
        this.focusableWindowState = true;
        this.ownedWindows = new Vector();
    }

    Window() {
        this.this();
        this.visible = false;
        this.focusCycleRoot = true;
        this.setLayout(new BorderLayout());
        this.addWindowFocusListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void windowGainedFocus(WindowEvent event) {
                block5: {
                    if (Window.this.windowFocusOwner != null) {
                        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        EventQueue eventQueue = eq;
                        synchronized (eventQueue) {
                            block4: {
                                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component currentFocusOwner = manager.getGlobalPermanentFocusOwner();
                                if (currentFocusOwner == null) break block4;
                                eq.postEvent(new FocusEvent(currentFocusOwner, 1005, false, Window.this.windowFocusOwner));
                                eq.postEvent(new FocusEvent(Window.this.windowFocusOwner, 1004, false, currentFocusOwner));
                                break block5;
                            }
                            eq.postEvent(new FocusEvent(Window.this.windowFocusOwner, 1004, false));
                        }
                    }
                }
            }
        });
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.graphicsConfiguration = g.getDefaultScreenDevice().getDefaultConfiguration();
    }

    Window(GraphicsConfiguration gc) {
        this();
        this.graphicsConfiguration = gc;
    }

    public Window(Frame owner) {
        this(owner, owner.getGraphicsConfiguration());
    }

    public Window(Window owner) {
        this(owner, owner.getGraphicsConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Window(Window owner, GraphicsConfiguration gc) {
        this();
        Object object = this.getTreeLock();
        synchronized (object) {
            if (owner == null) {
                throw new IllegalArgumentException("owner must not be null");
            }
            this.parent = owner;
            owner.ownedWindows.add(new WeakReference(this));
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null && !s.checkTopLevelWindow(this)) {
            this.warningString = System.getProperty("awt.appletWarning");
        }
        if (gc != null && gc.getDevice().getType() != 0) {
            throw new IllegalArgumentException("gc must be from a screen device");
        }
        if (gc == null) {
            this.graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            return;
        }
        this.graphicsConfiguration = gc;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WindowFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        WindowFlipBufferStrategy(int numBuffers) throws AWTException {
            super(numBuffers, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WindowBltBufferStrategy
    extends Component.BltBufferStrategy {
        WindowBltBufferStrategy(int numBuffers, boolean accelerated) {
            super(numBuffers, new BufferCapabilities(new ImageCapabilities(accelerated), new ImageCapabilities(accelerated), BufferCapabilities.FlipContents.COPIED));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 4215068635060671780L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Window.this.isActive()) {
                states.add(AccessibleState.ACTIVE);
            }
            return states;
        }

        protected AccessibleAWTWindow() {
        }
    }
}

