/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.BeanInfoEmbryo;
import gnu.java.beans.ExplicitBeanInfo;
import gnu.java.beans.IntrospectionIncubator;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.ExplicitInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;

public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    static String[] beanInfoSearchPath = new String[]{"gnu.java.beans.info"};
    static Hashtable beanInfoCache = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        Class clazz = beanClass;
        synchronized (clazz) {
            BeanInfo cachedInfo = (BeanInfo)beanInfoCache.get(beanClass);
            if (cachedInfo != null) {
                return cachedInfo;
            }
            cachedInfo = Introspector.getBeanInfo(beanClass, null);
            beanInfoCache.put(beanClass, cachedInfo);
            return cachedInfo;
        }
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        ExplicitInfo.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void flushFromCaches(Class clz) {
        Class clazz = clz;
        synchronized (clazz) {
            beanInfoCache.remove(clz);
            return;
        }
    }

    public static BeanInfo getBeanInfo(Class beanClass, Class stopClass) throws IntrospectionException {
        MethodDescriptor[] m;
        EventSetDescriptor[] e;
        ExplicitInfo explicit = new ExplicitInfo(beanClass, stopClass);
        IntrospectionIncubator ii = new IntrospectionIncubator();
        ii.setPropertyStopClass(explicit.propertyStopClass);
        ii.setEventStopClass(explicit.eventStopClass);
        ii.setMethodStopClass(explicit.methodStopClass);
        ii.addMethods(beanClass.getMethods());
        BeanInfoEmbryo currentInfo = ii.getBeanInfoEmbryo();
        PropertyDescriptor[] p = explicit.explicitPropertyDescriptors;
        if (p != null) {
            int i = 0;
            while (i < p.length) {
                if (!currentInfo.hasProperty(p[i])) {
                    currentInfo.addProperty(p[i]);
                }
                ++i;
            }
            if (explicit.defaultProperty != -1) {
                currentInfo.setDefaultPropertyName(p[explicit.defaultProperty].getName());
            }
        }
        if ((e = explicit.explicitEventSetDescriptors) != null) {
            int i = 0;
            while (i < e.length) {
                if (!currentInfo.hasEvent(e[i])) {
                    currentInfo.addEvent(e[i]);
                }
                ++i;
            }
            if (explicit.defaultEvent != -1) {
                currentInfo.setDefaultEventName(e[explicit.defaultEvent].getName());
            }
        }
        if ((m = explicit.explicitMethodDescriptors) != null) {
            int i = 0;
            while (i < m.length) {
                if (!currentInfo.hasMethod(m[i])) {
                    currentInfo.addMethod(m[i]);
                }
                ++i;
            }
        }
        currentInfo.setBeanDescriptor(explicit.explicitBeanDescriptor == null ? new BeanDescriptor(beanClass, null) : explicit.explicitBeanDescriptor);
        currentInfo.setAdditionalBeanInfo(explicit.explicitBeanInfo);
        currentInfo.setIcons(explicit.im);
        return currentInfo.getBeanInfo();
    }

    public static String[] getBeanInfoSearchPath() {
        return beanInfoSearchPath;
    }

    public static void setBeanInfoSearchPath(String[] beanInfoSearchPath) {
        Introspector.beanInfoSearchPath = beanInfoSearchPath;
    }

    public static String decapitalize(String name) {
        try {
            if (!Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            try {
                if (Character.isUpperCase(name.charAt(1))) {
                    return name;
                }
                char[] c = name.toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                return new String(c);
            }
            catch (StringIndexOutOfBoundsException E) {
                char[] c = new char[]{Character.toLowerCase(name.charAt(0))};
                return new String(c);
            }
        }
        catch (StringIndexOutOfBoundsException E) {
            return name;
        }
        catch (NullPointerException E) {
            return null;
        }
    }

    static BeanInfo copyBeanInfo(BeanInfo b) {
        Image[] icons = new Image[4];
        int i = 1;
        while (i <= 4) {
            icons[i - 1] = b.getIcon(i);
            ++i;
        }
        return new ExplicitBeanInfo(b.getBeanDescriptor(), b.getAdditionalBeanInfo(), b.getPropertyDescriptors(), b.getDefaultPropertyIndex(), b.getEventSetDescriptors(), b.getDefaultEventIndex(), b.getMethodDescriptors(), icons);
    }

    private Introspector() {
    }
}

