/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SortedListModel<T>
extends ArrayList<T>
implements ListModel<T> {
    private Timer sortTimer = null;
    private static final Timer dummyTimer = new Timer(1000, event -> {});
    private Comparator<? super T> comparator;
    private final ArrayList<ListDataListener> dataListeners = new ArrayList();
    private int numItems = 0;

    public SortedListModel(Comparator<? super T> newComparator) {
        this.comparator = newComparator;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.dataListeners.add(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.dataListeners.remove(listener);
    }

    @Override
    public T getElementAt(int index) {
        return (T)this.get(index);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public void setAndSort(Collection<T> objects) {
        this.clear();
        for (T object : objects) {
            super.add(object);
        }
        this.numItems = this.size();
        this.sortNow();
        this.changed(0, 0, this.numItems - 1);
    }

    @Override
    public boolean add(T obj) {
        if (obj == null) {
            return false;
        }
        int size = this.size();
        int insertPoint = -1;
        for (int i = 0; i < size; ++i) {
            Object peer = this.get(i);
            if (peer == null) {
                insertPoint = i;
                continue;
            }
            if (!obj.equals(peer)) continue;
            this.set(i, obj);
            this.changed(0, i, i);
            return false;
        }
        this.scheduleSort();
        ++this.numItems;
        if (insertPoint >= 0) {
            this.set(insertPoint, obj);
            this.changed(0, insertPoint, insertPoint);
        } else {
            super.add(obj);
            this.changed(1, size, size);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T aC : c) {
            this.add(aC);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean remove(Object obj) {
        if (obj != null) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (!obj.equals(this.get(i))) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public T remove(int index) {
        Object result = this.get(index);
        if (result != null) {
            --this.numItems;
            this.set(index, null);
            this.changed(0, index, index);
            this.scheduleSort();
        }
        return (T)result;
    }

    public void setComparator(Comparator<? super T> newComparator) {
        this.comparator = newComparator;
        this.sortNow();
    }

    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    public void changed(T entry) {
        if (entry == null) {
            return;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!entry.equals(this.get(i))) continue;
            this.changed(0, i, i);
            if (i > 0 && !this.inOrder(this.get(i - 1), entry) || i + 1 < size && !this.inOrder(entry, this.get(i + 1))) {
                this.scheduleSort();
            }
            return;
        }
    }

    private boolean inOrder(T a, T b) {
        return a != null && b != null && this.comparator.compare(a, b) <= 0;
    }

    private void changed(int eventType, int loIndex, int hiIndex) {
        ListDataEvent event = new ListDataEvent(this, eventType, loIndex, hiIndex);
        for (ListDataListener listener : this.dataListeners) {
            if (event.getType() == 0) {
                listener.contentsChanged(event);
                continue;
            }
            if (event.getType() == 1) {
                listener.intervalAdded(event);
                continue;
            }
            listener.intervalRemoved(event);
        }
    }

    @Override
    public void clear() {
        int oldSize = this.size();
        super.clear();
        this.numItems = 0;
        if (oldSize > 0) {
            this.changed(2, 0, oldSize);
        }
    }

    public void scheduleSort() {
        if (this.numItems <= 1) {
            this.sortNow();
        } else if (this.sortTimer == null) {
            this.sortTimer = new Timer(2500, event -> this.sort());
            this.sortTimer.setRepeats(false);
            this.sortTimer.start();
        }
    }

    public void sortNow() {
        if (this.sortTimer != dummyTimer) {
            if (this.sortTimer != null) {
                this.sortTimer.stop();
            }
            this.sortTimer = dummyTimer;
            SwingUtilities.invokeLater(this::sort);
        }
    }

    protected void sort() {
        this.sortTimer = null;
        int loChange = Integer.MAX_VALUE;
        int hiChange = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != null) continue;
            if (loChange > i) {
                loChange = i;
            }
            if (this.size() - 1 > hiChange) {
                hiChange = this.size() - 1;
            }
            super.remove(i--);
        }
        if (this.numItems > 1) {
            ArrayList tmp = new ArrayList(this);
            Collections.sort(tmp, this.comparator);
            for (int i = 0; i < this.size(); ++i) {
                if (tmp.get(i) == this.get(i)) continue;
                this.set(i, tmp.get(i));
                if (i < loChange) {
                    loChange = i;
                }
                if (i <= hiChange) continue;
                hiChange = i;
            }
        }
        if (loChange < Integer.MAX_VALUE) {
            this.changed(0, loChange, hiChange);
        }
    }
}

