/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-24 18:09:08 +0100 (Mon, 24 Feb 2014) $
//  number=$Revision: 9770 $
//  type=jgo

/**
 * Localized names for the "jgo" locale.
 */
public class LocalizedNamesImpl_jgo extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AI",
        "AR",
        "AL",
        "DZ",
        "AM",
        "IN",
        "AQ",
        "AS",
        "AT",
        "AU",
        "AW",
        "AX",
        "AZ",
        "AO",
        "BA",
        "BB",
        "BD",
        "BE",
        "BG",
        "BH",
        "BL",
        "BM",
        "BN",
        "BQ",
        "BS",
        "BT",
        "BV",
        "BY",
        "BZ",
        "TD",
        "CC",
        "CF",
        "CL",
        "CK",
        "CP",
        "CR",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DG",
        "DK",
        "DM",
        "DO",
        "EA",
        "EE",
        "EH",
        "EU",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "FR",
        "GB",
        "GD",
        "GE",
        "GF",
        "GG",
        "GI",
        "GL",
        "GP",
        "GS",
        "GT",
        "GU",
        "GY",
        "HK",
        "HM",
        "HN",
        "HR",
        "HT",
        "HU",
        "IC",
        "ID",
        "IE",
        "IQ",
        "IM",
        "IO",
        "IR",
        "IS",
        "IL",
        "IT",
        "JP",
        "JE",
        "JM",
        "JO",
        "CM",
        "CA",
        "KG",
        "KH",
        "KI",
        "KN",
        "KP",
        "KR",
        "CU",
        "KW",
        "KY",
        "KZ",
        "CO",
        "KM",
        "CI",
        "CD",
        "CG",
        "KE",
        "LA",
        "LB",
        "LC",
        "LI",
        "LY",
        "LR",
        "LK",
        "LT",
        "LU",
        "RU",
        "RW",
        "LV",
        "LS",
        "RE",
        "MW",
        "ML",
        "MG",
        "YT",
        "BF",
        "BI",
        "BO",
        "BW",
        "BR",
        "BJ",
        "MC",
        "MD",
        "ME",
        "MF",
        "MH",
        "MK",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MS",
        "MT",
        "MU",
        "MV",
        "MY",
        "MR",
        "MA",
        "MZ",
        "MX",
        "NA",
        "NC",
        "NF",
        "NI",
        "NE",
        "NG",
        "DE",
        "DJ",
        "NL",
        "NP",
        "NR",
        "NU",
        "NZ",
        "NO",
        "OM",
        "PA",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "PE",
        "SC",
        "QA",
        "QO",
        "RO",
        "SA",
        "ST",
        "SB",
        "SE",
        "SG",
        "SH",
        "CN",
        "SI",
        "SL",
        "SJ",
        "SK",
        "SM",
        "SR",
        "SS",
        "SD",
        "SV",
        "SZ",
        "CH",
        "SX",
        "SY",
        "SO",
        "RS",
        "SN",
        "TA",
        "TZ",
        "TC",
        "TF",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TO",
        "TR",
        "TT",
        "TN",
        "TV",
        "TW",
        "TG",
        "UA",
        "UM",
        "US",
        "UY",
        "UZ",
        "UG",
        "VA",
        "VC",
        "VG",
        "VI",
        "VN",
        "VU",
        "VE",
        "WF",
        "WS",
        "XK",
        "YE",
        "ZA",
        "ZM",
        "ZW",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GR",
        "EG",
        "EC",
        "ER",
        "ES",
        "ET",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mbí");
    namesMap.put("002", "Afɛlîk");
    namesMap.put("019", "Amɛlîk");
    namesMap.put("142", "Azî");
    namesMap.put("150", "Ʉlôp");
    namesMap.put("AO", "Aŋgɔ́la");
    namesMap.put("AR", "Ajɛntîn");
    namesMap.put("BF", "Mbulukína Fásɔ");
    namesMap.put("BI", "Mbulundí");
    namesMap.put("BJ", "Mbɛnɛ̂ŋ");
    namesMap.put("BO", "Mbɔlivî");
    namesMap.put("BR", "Mbɛlazîl");
    namesMap.put("BW", "Mbɔtswána");
    namesMap.put("CA", "Kanadâ");
    namesMap.put("CD", "Kɔ́ŋgɔ-Kinshása");
    namesMap.put("CG", "Kɔ́ŋgɔ-Mbɛlazavîl");
    namesMap.put("CH", "Sẅísɛ");
    namesMap.put("CI", "Kɔ́t Ndivwâ");
    namesMap.put("CL", "Cíllɛ");
    namesMap.put("CM", "Kamɛlûn");
    namesMap.put("CN", "Shîn");
    namesMap.put("CO", "Kɔllɔmbî");
    namesMap.put("CU", "Kúba");
    namesMap.put("DE", "Njáman");
    namesMap.put("DJ", "Njimbúti");
    namesMap.put("DZ", "Aljɛlî");
    namesMap.put("EC", "Ɛkwandɔ̂");
    namesMap.put("EG", "Ɛjíptɛ");
    namesMap.put("ER", "Ɛlitɛlɛ́ya");
    namesMap.put("ES", "Ɛspániya");
    namesMap.put("ET", "Ɛtiyɔpî");
    namesMap.put("FR", "Fɛlánci");
    namesMap.put("GA", "Ŋgabɔ̂ŋ");
    namesMap.put("GH", "Ŋgána");
    namesMap.put("GM", "Ŋgambî");
    namesMap.put("GN", "Ŋginɛ̂");
    namesMap.put("GQ", "Ŋginɛ̂ Ɛkwatɔliyâl");
    namesMap.put("GR", "Ŋgɛlɛ̂k");
    namesMap.put("GW", "Ŋginɛ̂ Mbisáwu");
    namesMap.put("IL", "Islayɛ̂l");
    namesMap.put("IN", "Ándɛ");
    namesMap.put("IQ", "Ilâk");
    namesMap.put("IT", "Italî");
    namesMap.put("JP", "Japɔ̂n");
    namesMap.put("KE", "Kɛ́nya");
    namesMap.put("KM", "Kɔmɔ́lɔshi");
    namesMap.put("LR", "Libɛrî");
    namesMap.put("LS", "Lɛsɔ́tɔ");
    namesMap.put("LY", "Libî");
    namesMap.put("MA", "Mɔlɔ̂k");
    namesMap.put("MG", "Mándaŋgasɛkâ");
    namesMap.put("ML", "Malî");
    namesMap.put("MR", "Mɔlitanî");
    namesMap.put("MW", "Maláwi");
    namesMap.put("MX", "Mɛksîk");
    namesMap.put("MZ", "Mɔzambîk");
    namesMap.put("NA", "Namimbî");
    namesMap.put("NE", "Nijɛ̂");
    namesMap.put("NG", "Ninjɛliyâ");
    namesMap.put("NO", "Nɔlɛvɛ́jɛ");
    namesMap.put("PE", "Pɛlû");
    namesMap.put("RE", "Lɛ́uniyɔ̂n");
    namesMap.put("RS", "Sɛlɛbî");
    namesMap.put("RU", "Lusî");
    namesMap.put("RW", "Luwánda");
    namesMap.put("SC", "Pɛsɛ́shɛl");
    namesMap.put("SD", "Sundân");
    namesMap.put("SL", "Siyɛ́la Lɛɔ̂n");
    namesMap.put("SN", "Sɛnɛgâl");
    namesMap.put("SO", "Sɔmalî");
    namesMap.put("ST", "Sáwɔŋ Tɔmɛ́ nɛ́ Pɛlínsipɛ");
    namesMap.put("SZ", "Swazilân");
    namesMap.put("TD", "Cât");
    namesMap.put("TG", "Tɔ́ŋgɔ");
    namesMap.put("TN", "Tunizî");
    namesMap.put("TZ", "Tanzanî");
    namesMap.put("UG", "Uŋgánda");
    namesMap.put("VE", "Vɛnɛzwɛ́la");
    namesMap.put("YT", "Mayɔ̂t");
    namesMap.put("ZM", "Zambî");
    namesMap.put("ZW", "Zimbámbwɛ");
    namesMap.put("ZZ", "ŋgɔŋ yi pɛ́ ká kɛ́ jʉɔ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mbí",
        "002": "Afɛlîk",
        "019": "Amɛlîk",
        "142": "Azî",
        "150": "Ʉlôp",
        "AO": "Aŋgɔ́la",
        "AR": "Ajɛntîn",
        "BF": "Mbulukína Fásɔ",
        "BI": "Mbulundí",
        "BJ": "Mbɛnɛ̂ŋ",
        "BO": "Mbɔlivî",
        "BR": "Mbɛlazîl",
        "BW": "Mbɔtswána",
        "CA": "Kanadâ",
        "CD": "Kɔ́ŋgɔ-Kinshása",
        "CG": "Kɔ́ŋgɔ-Mbɛlazavîl",
        "CH": "Sẅísɛ",
        "CI": "Kɔ́t Ndivwâ",
        "CL": "Cíllɛ",
        "CM": "Kamɛlûn",
        "CN": "Shîn",
        "CO": "Kɔllɔmbî",
        "CU": "Kúba",
        "DE": "Njáman",
        "DJ": "Njimbúti",
        "DZ": "Aljɛlî",
        "EC": "Ɛkwandɔ̂",
        "EG": "Ɛjíptɛ",
        "ER": "Ɛlitɛlɛ́ya",
        "ES": "Ɛspániya",
        "ET": "Ɛtiyɔpî",
        "FR": "Fɛlánci",
        "GA": "Ŋgabɔ̂ŋ",
        "GH": "Ŋgána",
        "GM": "Ŋgambî",
        "GN": "Ŋginɛ̂",
        "GQ": "Ŋginɛ̂ Ɛkwatɔliyâl",
        "GR": "Ŋgɛlɛ̂k",
        "GW": "Ŋginɛ̂ Mbisáwu",
        "IL": "Islayɛ̂l",
        "IN": "Ándɛ",
        "IQ": "Ilâk",
        "IT": "Italî",
        "JP": "Japɔ̂n",
        "KE": "Kɛ́nya",
        "KM": "Kɔmɔ́lɔshi",
        "LR": "Libɛrî",
        "LS": "Lɛsɔ́tɔ",
        "LY": "Libî",
        "MA": "Mɔlɔ̂k",
        "MG": "Mándaŋgasɛkâ",
        "ML": "Malî",
        "MR": "Mɔlitanî",
        "MW": "Maláwi",
        "MX": "Mɛksîk",
        "MZ": "Mɔzambîk",
        "NA": "Namimbî",
        "NE": "Nijɛ̂",
        "NG": "Ninjɛliyâ",
        "NO": "Nɔlɛvɛ́jɛ",
        "PE": "Pɛlû",
        "RE": "Lɛ́uniyɔ̂n",
        "RS": "Sɛlɛbî",
        "RU": "Lusî",
        "RW": "Luwánda",
        "SC": "Pɛsɛ́shɛl",
        "SD": "Sundân",
        "SL": "Siyɛ́la Lɛɔ̂n",
        "SN": "Sɛnɛgâl",
        "SO": "Sɔmalî",
        "ST": "Sáwɔŋ Tɔmɛ́ nɛ́ Pɛlínsipɛ",
        "SZ": "Swazilân",
        "TD": "Cât",
        "TG": "Tɔ́ŋgɔ",
        "TN": "Tunizî",
        "TZ": "Tanzanî",
        "UG": "Uŋgánda",
        "VE": "Vɛnɛzwɛ́la",
        "YT": "Mayɔ̂t",
        "ZM": "Zambî",
        "ZW": "Zimbámbwɛ",
        "ZZ": "ŋgɔŋ yi pɛ́ ká kɛ́ jʉɔ"
    };
  }-*/;
}
