<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AIPlatformNotebooks;

class VmImage extends \Google\Model
{
  /**
   * @var string
   */
  public $imageFamily;
  /**
   * @var string
   */
  public $imageName;
  /**
   * @var string
   */
  public $project;

  /**
   * @param string
   */
  public function setImageFamily($imageFamily)
  {
    $this->imageFamily = $imageFamily;
  }
  /**
   * @return string
   */
  public function getImageFamily()
  {
    return $this->imageFamily;
  }
  /**
   * @param string
   */
  public function setImageName($imageName)
  {
    $this->imageName = $imageName;
  }
  /**
   * @return string
   */
  public function getImageName()
  {
    return $this->imageName;
  }
  /**
   * @param string
   */
  public function setProject($project)
  {
    $this->project = $project;
  }
  /**
   * @return string
   */
  public function getProject()
  {
    return $this->project;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VmImage::class, 'Google_Service_AIPlatformNotebooks_VmImage');
