/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.PlaybackInfo;
import org.igoweb.igoweb.client.swing.AdWidget;
import org.igoweb.igoweb.client.swing.AnnounceWindow;
import org.igoweb.igoweb.client.swing.ClientPanel;
import org.igoweb.igoweb.client.swing.CreateRoomWindow;
import org.igoweb.igoweb.client.swing.FriendListWindow;
import org.igoweb.igoweb.client.swing.GetUsernameWindow;
import org.igoweb.igoweb.client.swing.GlobalGamePanel;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.KeepOutWindow;
import org.igoweb.igoweb.client.swing.LeaveMessageWindow;
import org.igoweb.igoweb.client.swing.MessagesWindow;
import org.igoweb.igoweb.client.swing.MotdWindow;
import org.igoweb.igoweb.client.swing.PlaybackChooser;
import org.igoweb.igoweb.client.swing.RegisterWindow;
import org.igoweb.igoweb.client.swing.RoomListWindow;
import org.igoweb.igoweb.client.swing.RoomSubmenu;
import org.igoweb.igoweb.client.swing.ServerStatsWindow;
import org.igoweb.igoweb.client.swing.ShutdownWindow;
import org.igoweb.igoweb.client.swing.WorkingIcon;
import org.igoweb.igoweb.shared.GameContainers;
import org.igoweb.igoweb.shared.Subscription;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.JnlpIo;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SingletonWindow;

public class ClientWindow
extends AFrame {
    private static final String GLOBAL_GAME_LIST_OPEN_PREF = "Iy{jg!Rw";
    private static final String FRONTMOST_PANEL = "4`hzHW3@";
    private static final int EVENT_BASE = 65541;
    private static final int UPLOAD_SGF_EVENT = 65541;
    private static final int UPLOAD_PRIVATE_SGF_EVENT = 65542;
    public static final int EVENT_LIMIT = 65544;
    private final MultiHandler multiHandler = new MultiHandler();
    private boolean isActivatedFlag = true;
    private final SingletonWindow prefsWindow = new SingletonWindow();
    private final SingletonWindow serverStatsWindow = new SingletonWindow();
    private final SingletonWindow leaveMessageWindow = new SingletonWindow();
    private final SingletonWindow buddyListWindow = new SingletonWindow();
    private final SingletonWindow censorListWindow = new SingletonWindow();
    private final SingletonWindow fanListWindow = new SingletonWindow();
    private final SingletonWindow adminTrackListWindow = new SingletonWindow();
    private final JMenuItem serverStatsMI = new JMenuItem(Defs.getString(-903340606));
    private final JMenuItem setPrefsMI = new JMenuItem(Defs.getString(-903340602));
    private final JMenuBar menuBar = new JMenuBar();
    private Timer iconRotator;
    private final JMenu automatchMenu = new JMenu(Defs.getString(-903340581));
    private final JCheckBoxMenuItem startAutomatch = new JCheckBoxMenuItem(Defs.getString(-903340601));
    private final JMenuItem configAutomatch = new JMenuItem(Defs.getString(-903340567));
    private final JMenu adminMenu = new JMenu(Defs.getString(-903340811));
    private final JMenu recentPlaybackMenu = new JMenu(Defs.getString(-903340460));
    private boolean wasSubscribed;
    private final JMenuItem playbackMI = new JMenuItem(Defs.getString(-903340471));
    private final JMenuItem regMI = new JMenuItem(Defs.getString(-903340632));
    private final JMenuItem editSelfMI = new JMenuItem(Defs.getString(-903340748));
    private final JMenuItem viewOtherMI = new JMenuItem(Defs.getString(-903340554));
    private final JMenuItem readMessagesMI = new JMenuItem(Defs.getString(-903340516));
    private final JMenuItem leaveMessageMI = new JMenuItem(Defs.getString(-903340528));
    private final JMenuItem buddyListMI = new JMenuItem(Defs.getString(-1538213164));
    private final JMenuItem censorListMI = new JMenuItem(Defs.getString(-1538213163));
    private final JMenuItem fanListMI = new JMenuItem(Defs.getString(-1538213162));
    private final JMenuItem adminTrackListMI = new JMenuItem(Defs.getString(-1538213161));
    private final JCheckBoxMenuItem noChatsMI = new JCheckBoxMenuItem(Defs.getString(-903340479));
    private final JMenuItem forceOutMI = new JMenuItem(Defs.getString(-903340733));
    private final JMenuItem clearKeepOutMI = new JMenuItem(Defs.getString(-903340681));
    private final JMenuItem delAcctMI = new JMenuItem(Defs.getString(-903340763));
    private final JMenuItem kickMI = new JMenuItem(Defs.getString(-903340651));
    private final JMenuItem showRoomListMI = new JMenuItem(Defs.getString(-903340616));
    private final JMenuItem createRoomMI = new JMenuItem(Defs.getString(-903340769));
    private final EnumMap<GameContainers, JCheckBoxMenuItem> globalMIs = new EnumMap(GameContainers.class);
    private EnumMap<GameContainers, GlobalGamePanel> globalGamePanels = new EnumMap(GameContainers.class);
    private final JMenuItem announceMI = new JMenuItem(Defs.getString(-903340696));
    private final JMenuItem shutdownMI = new JMenuItem(Defs.getString(-903340598));
    private final JMenuItem motdMI = new JMenuItem(Defs.getString(-903340691));
    private final JMenuItem logOutMI = new JMenuItem(Defs.getString(-903340700));
    private final JMenuItem aboutMI = new JMenuItem(Defs.getString(-903340822));
    private final JMenuItem helpMI = new JMenuItem(Defs.getString(1436228516));
    private final JMenuItem tosMI = new JMenuItem(Defs.getString(-903340538));
    public final SingletonWindow roomList = new SingletonWindow();
    private SingletonWindow configAutomatchWindow = new SingletonWindow();
    private int oldAuthLevel = 0;
    private final JTabbedPane tabPane = new JTabbedPane();
    private final Client client;
    private JPanel roomPane;

    public ClientWindow(final Client newClient) {
        super(Defs.getString(-903340695));
        this.client = newClient;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                newClient.logout();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                ClientWindow.this.isActivatedFlag = true;
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                ClientWindow.this.isActivatedFlag = false;
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.roomPane = new JPanel(new GridLayout(0, 1, 2, 2));
        this.roomPane.setOpaque(false);
        this.getContentPane().add(this.roomPane);
        this.tabPane.setOpaque(false);
        this.tabPane.addChangeListener(this.multiHandler);
        AdWidget ad = new AdWidget(newClient, 0, 468, 60, (JComponent)this.getContentPane(), "North");
        ad.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        ad = new AdWidget(newClient, 0, 728, 90, (JComponent)this.getContentPane(), "North");
        ad.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        ad = new AdWidget(newClient, 1, 120, 240, (JComponent)this.getContentPane(), "North");
        ad.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.setJMenuBar(this.menuBar);
        JMenu m = new JMenu(Defs.getString(-903340739));
        m.setEnabled(false);
        m.add(this.motdMI);
        this.motdMI.addActionListener(this.multiHandler);
        m.add(this.serverStatsMI);
        this.serverStatsMI.addActionListener(this.multiHandler);
        m.add(this.setPrefsMI);
        this.setPrefsMI.addActionListener(this.multiHandler);
        if (Defs.isApp()) {
            m.add(new RoomSubmenu(Defs.getString(-903340576), newClient, 10, this.multiHandler, 65541, null));
            m.add(new RoomSubmenu(Defs.getString(-903340485), newClient, -5, this.multiHandler, 65542, null));
        }
        m.addSeparator();
        m.add(this.logOutMI);
        this.logOutMI.addActionListener(this.multiHandler);
        this.logOutMI.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.menuBar.add(m);
        this.menuBar.add(this.automatchMenu);
        this.automatchMenu.setIcon(new WorkingIcon(false));
        this.automatchMenu.add(this.startAutomatch);
        this.startAutomatch.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.automatchMenu.add(this.configAutomatch);
        this.startAutomatch.addActionListener(this.multiHandler);
        this.configAutomatch.addActionListener(this.multiHandler);
        m = new JMenu(Defs.getString(-903340574));
        this.menuBar.add(m);
        m.setEnabled(false);
        m.add(this.regMI);
        User me = newClient.getMe();
        this.regMI.addActionListener(this.multiHandler);
        m.add(this.editSelfMI);
        this.editSelfMI.addActionListener(this.multiHandler);
        m.add(GuiClientUtil.get(newClient).createUploadPicMenuItem(this));
        this.regMI.setEnabled(me.isGuest());
        this.editSelfMI.setEnabled(!me.isGuest());
        this.readMessagesMI.addActionListener(this.multiHandler);
        m.add(this.readMessagesMI);
        newClient.objects.put(MessagesWindow.MESSAGE_MENU_ITEM_KEY, this.readMessagesMI);
        this.readMessagesMI.setEnabled(MessagesWindow.hasMessages(newClient));
        this.noChatsMI.setToolTipText(Defs.getString(-903340477));
        m.add(this.noChatsMI);
        m.addSeparator();
        m.add(this.buddyListMI);
        this.buddyListMI.addActionListener(this.multiHandler);
        m.add(this.censorListMI);
        this.censorListMI.addActionListener(this.multiHandler);
        m.add(this.fanListMI);
        this.fanListMI.addActionListener(this.multiHandler);
        if (me.getAuthLevel() >= 3) {
            m.add(this.adminTrackListMI);
        }
        this.adminTrackListMI.addActionListener(this.multiHandler);
        m.addSeparator();
        m.add(this.viewOtherMI);
        this.viewOtherMI.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.viewOtherMI.addActionListener(this.multiHandler);
        m.add(this.leaveMessageMI);
        this.leaveMessageMI.addActionListener(this.multiHandler);
        m = new JMenu(Defs.getString(-903340618));
        this.menuBar.add(m);
        m.setEnabled(false);
        m.add(this.showRoomListMI);
        this.showRoomListMI.addActionListener(this.multiHandler);
        m.add(this.createRoomMI);
        this.createRoomMI.addActionListener(this.multiHandler);
        this.createRoomMI.setEnabled(!me.isGuest());
        m.addSeparator();
        for (GameContainers i : GameContainers.values()) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(Defs.getString(1689845736 + i.ordinal()));
            this.globalMIs.put(i, mi);
            m.add(mi);
            mi.addActionListener(this.multiHandler);
            mi.setSelected(Prefs.getBoolean(GLOBAL_GAME_LIST_OPEN_PREF + i.ordinal(), i != GameContainers.FANS));
        }
        this.menuBar.add(GuiClientUtil.get((Client)newClient).windowList);
        GuiClientUtil.get((Client)newClient).windowList.add(this);
        JMenu kgsPlusMenu = new JMenu(Defs.getString(-903340467));
        this.menuBar.add(kgsPlusMenu);
        JMenuItem mi = new JMenuItem(Defs.getString(-903340822));
        kgsPlusMenu.add(mi);
        mi.addActionListener(new UrlDisplayer(-903340465, "/kgsPlus.jsp"));
        mi = new JMenuItem(Defs.getString(-903340466));
        kgsPlusMenu.add(mi);
        mi.addActionListener(new UrlDisplayer(-903340464, "/plusSchedule.jsp"));
        kgsPlusMenu.add(this.recentPlaybackMenu);
        kgsPlusMenu.add(this.playbackMI);
        SingletonWindow playbackChooserWindow = new SingletonWindow();
        this.playbackMI.addActionListener(event -> playbackChooserWindow.setWindow(new PlaybackChooser(newClient, this)));
        m = new JMenu(Defs.getString(1436228516));
        this.menuBar.add(m);
        m.setEnabled(false);
        m.add(this.helpMI);
        this.helpMI.addActionListener(this.multiHandler);
        m.add(this.tosMI);
        this.tosMI.addActionListener(this.multiHandler);
        m.addSeparator();
        m.add(this.aboutMI);
        this.aboutMI.addActionListener(this.multiHandler);
        this.adminMenu.add(this.announceMI);
        this.announceMI.addActionListener(this.multiHandler);
        this.adminMenu.add(this.shutdownMI);
        this.shutdownMI.addActionListener(this.multiHandler);
        this.adminMenu.addSeparator();
        this.adminMenu.add(this.forceOutMI);
        this.forceOutMI.addActionListener(this.multiHandler);
        this.adminMenu.add(this.kickMI);
        this.kickMI.addActionListener(this.multiHandler);
        this.adminMenu.add(this.clearKeepOutMI);
        this.clearKeepOutMI.addActionListener(this.multiHandler);
        this.adminMenu.add(this.delAcctMI);
        this.delAcctMI.addActionListener(this.multiHandler);
        this.pack();
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension prefSize = super.getDefaultPreferredSize();
        Insets insets = this.getInsets();
        int prefW = this.getFontMetrics(this.getFont()).getHeight() * 38;
        int prefH = (prefW * 181 + 128 >> 8) + insets.top + insets.bottom;
        if ((prefW += insets.left + insets.right) > prefSize.width) {
            prefSize.width = prefW;
        }
        if (prefH > prefSize.height) {
            prefSize.height = prefH;
        }
        return prefSize;
    }

    private void doAction(Object source) {
        if (source == this.iconRotator) {
            this.automatchMenu.repaint();
        } else if (source == this.logOutMI) {
            this.client.logout();
        } else if (source == this.serverStatsMI) {
            this.serverStatsWindow.setWindow(new ServerStatsWindow(this.client, this));
        } else if (source == this.setPrefsMI) {
            this.prefsWindow.setWindow(GuiClientUtil.get(this.client).createPrefsWindow(this));
            GuiClientUtil.addToWindowList(this.client, this.prefsWindow.getWindow());
        } else if (source == this.regMI) {
            this.regMI.setEnabled(false);
            new RegisterWindow(this, this.client, this.regMI);
        } else if (source == this.editSelfMI) {
            this.client.requestUserDetails(this.client.getMe().name);
        } else if (source == this.viewOtherMI) {
            new GetUsernameWindow(-903340742, this, event -> this.client.requestUserDetails(event.getActionCommand()), this.client);
        } else if (source == this.readMessagesMI) {
            new MessagesWindow(this, null, this.client);
        } else if (source == this.showRoomListMI) {
            this.roomList.setWindow(new RoomListWindow(this.client, this));
        } else if (source == this.createRoomMI) {
            new CreateRoomWindow(this.client, this);
        } else if (source == this.forceOutMI) {
            new KeepOutWindow(null, this.client, this);
        } else if (source == this.kickMI) {
            new GetUsernameWindow(-903340758, this, event -> this.client.sendKeepOut(event.getActionCommand(), 0, null), this.client);
        } else if (source == this.clearKeepOutMI) {
            new GetUsernameWindow(-903340825, this, event -> this.client.sendClearKeepOut(event.getActionCommand()), this.client);
        } else if (source == this.delAcctMI) {
            new GetUsernameWindow(-903340744, this, event -> this.client.sendDeleteAccountRequest(event.getActionCommand()), this.client);
        } else if (source == this.announceMI) {
            new AnnounceWindow(this.client, this);
        } else if (source == this.shutdownMI) {
            new ShutdownWindow(this.client, this);
        } else if (source == this.motdMI) {
            new MotdWindow(this.client, this);
        } else if (source == this.helpMI) {
            GuiUtil.loadHelp("main.html");
        } else if (source == this.tosMI) {
            GuiUtil.loadHelp("../tos.jsp");
        } else if (source == this.aboutMI) {
            this.makeAboutFrame();
        } else if (source == this.leaveMessageMI) {
            this.leaveMessageWindow.setWindow(new LeaveMessageWindow(this.client, (Component)this));
        } else if (source == this.buddyListMI) {
            FriendListWindow buddyWin = new FriendListWindow(this, this.client, 0);
            buddyWin.pack();
            buddyWin.setVisible(true);
            this.buddyListWindow.setWindow(buddyWin);
            GuiClientUtil.addToWindowList(this.client, buddyWin);
        } else if (source == this.censorListMI) {
            FriendListWindow censorWin = new FriendListWindow(this, this.client, 1);
            censorWin.pack();
            censorWin.setVisible(true);
            this.censorListWindow.setWindow(censorWin);
            GuiClientUtil.addToWindowList(this.client, censorWin);
        } else if (source == this.fanListMI) {
            FriendListWindow fanWin = new FriendListWindow(this, this.client, 2);
            fanWin.pack();
            fanWin.setVisible(true);
            this.fanListWindow.setWindow(fanWin);
            GuiClientUtil.addToWindowList(this.client, fanWin);
        } else if (source == this.adminTrackListMI) {
            FriendListWindow atWin = new FriendListWindow(this, this.client, 3);
            atWin.pack();
            atWin.setVisible(true);
            this.adminTrackListWindow.setWindow(atWin);
            GuiClientUtil.addToWindowList(this.client, atWin);
        } else if (source == this.startAutomatch) {
            if (this.client.isAutomatchRunning()) {
                this.client.sendAutomatchCancel();
            } else {
                GuiClientUtil.get(this.client).sendAutomatchCreate((JComponent)this.getContentPane());
            }
            this.startAutomatch.setSelected(this.client.isAutomatchRunning());
        } else if (source == this.configAutomatch) {
            if (!this.configAutomatchWindow.raiseIfOpen()) {
                this.configAutomatchWindow.setWindow(GuiClientUtil.get(this.client).buildAutomatchWindow(this.client, (JComponent)this.getContentPane()));
            }
        } else {
            for (GameContainers i : GameContainers.values()) {
                if (source != this.globalMIs.get((Object)i)) continue;
                if (this.globalMIs.get((Object)i).isSelected()) {
                    Prefs.putBoolean(GLOBAL_GAME_LIST_OPEN_PREF + (Object)((Object)i), true);
                    this.client.sendJoinGameContainer(i);
                    continue;
                }
                if (this.globalGamePanels.get((Object)i) == null) continue;
                this.globalGamePanels.get((Object)i).close();
            }
        }
    }

    public void updateAutomatchStatus() {
        boolean running = this.client.isAutomatchRunning();
        this.startAutomatch.setSelected(running);
        if (running) {
            if (this.iconRotator == null) {
                this.startAutomatch.setToolTipText(Defs.getString(-903340588));
                this.automatchMenu.setIcon(new WorkingIcon(true));
                this.iconRotator = new Timer(200, this.multiHandler);
                this.iconRotator.start();
            }
        } else if (this.iconRotator != null) {
            this.startAutomatch.setToolTipText(Defs.getString(-903340585));
            this.automatchMenu.setIcon(new WorkingIcon(false));
            this.iconRotator.stop();
            this.iconRotator = null;
        }
    }

    public void updateMe() {
        this.updateAutomatchStatus();
        User me = this.client.getMe();
        int newAuthLevel = me.getAuthLevel();
        if (this.oldAuthLevel != newAuthLevel) {
            JMenuBar mb = this.getJMenuBar();
            if (this.oldAuthLevel >= 3) {
                mb.remove(this.adminMenu);
            }
            if (newAuthLevel >= 3) {
                mb.add(this.adminMenu);
            }
            this.oldAuthLevel = newAuthLevel;
            boolean fullAdmin = newAuthLevel >= 4;
            this.announceMI.setEnabled(fullAdmin);
            this.shutdownMI.setEnabled(fullAdmin);
            this.delAcctMI.setEnabled(fullAdmin);
            this.kickMI.setEnabled(fullAdmin);
            this.clearKeepOutMI.setEnabled(fullAdmin);
        }
        if (me.isInTourn() && me.getAuthLevel() < 4) {
            Component comp;
            int i;
            ArrayList<Component> panels = new ArrayList<Component>();
            for (i = this.tabPane.getComponentCount() - 1; i >= 0; --i) {
                comp = this.tabPane.getComponent(i);
                if (!(comp instanceof ClientPanel)) continue;
                panels.add(comp);
            }
            for (i = this.roomPane.getComponentCount() - 1; i >= 0; --i) {
                comp = this.roomPane.getComponent(i);
                if (!(comp instanceof ClientPanel)) continue;
                panels.add(comp);
            }
            for (Component rawPanel : panels) {
                ClientPanel panel = (ClientPanel)rawPanel;
                if (!panel.closeForTournament()) continue;
                panel.close();
            }
        }
        if (this.wasSubscribed != me.isSubscribed()) {
            this.setPlaybackList(this.client.getPlaybackList());
        }
    }

    @Override
    protected String getSavePositionPref() {
        return "b4O?(h46";
    }

    public final void addChat(ClientPanel cp, boolean makeSelected) {
        cp.addListener(this.multiHandler);
        if (this.roomPane.getComponentCount() > 0) {
            if (this.tabPane.getComponentCount() == 0) {
                this.transfer((ClientPanel)this.roomPane.getComponent(0), true, -1);
                this.transfer(cp, true, -1);
                this.roomPane.add((Component)this.tabPane, 0);
            } else {
                this.addToTabPane(cp);
            }
            if (makeSelected) {
                this.tabPane.setSelectedComponent(cp);
            }
        } else {
            this.roomPane.add(cp);
            this.transfer(cp, false, -2);
        }
        this.roomPane.revalidate();
        this.roomPane.repaint();
    }

    public final void removeChat(JPanel cp) {
        Component comp0;
        if (this.tabPane.indexOfComponent(cp) == -1) {
            this.roomPane.remove(cp);
        } else {
            this.tabPane.remove(cp);
            if (this.tabPane.getComponentCount() == 1) {
                this.roomPane.remove(this.tabPane);
                this.transfer((ClientPanel)this.tabPane.getComponent(0), false, 0);
            }
        }
        if (this.roomPane.getComponentCount() > 0 && (comp0 = this.roomPane.getComponent(0)) instanceof ClientPanel) {
            ((ClientPanel)comp0).setPopEnabled(false);
        }
        this.roomPane.revalidate();
        this.repaint();
    }

    public void makeAboutFrame() {
        DFrame f = new DFrame(Defs.getString(-903340568), this);
        String beta = Config.get("version.beta");
        JLabel newLabel = new JLabel(Defs.getString(-903340770, new Object[]{Integer.valueOf(Config.get("version.major")), Integer.valueOf(Config.get("version.minor")), Integer.valueOf(Config.get("version.bugfix"))}) + (beta == null ? "" : " beta" + beta), 0);
        newLabel.setFont(newLabel.getFont().deriveFont(1));
        f.getMainPanel().add(newLabel);
        f.getMainPanel().add("x=0", new JLabel("\u00a9 William Shubert", 0));
        f.getMainPanel().add("x=0", new JLabel("jspeex \u00a9 1999-2003 Wimba S.A.", 0));
        f.getMainPanel().add("x=0", new JLabel(Defs.getString(-903340732), 0));
        f.getMainPanel().add("x=0", new JLabel(Config.get("adminEmail"), 0));
        String credits = Defs.getString(-903340579);
        if (credits != null && !credits.isEmpty()) {
            f.getMainPanel().add("x=0", new JLabel(credits, 0));
        }
        f.addButton(Defs.getString(1436228518), event -> f.dispose());
        f.pack(this);
        f.setResizable(false);
        GuiClientUtil.addToWindowList(this.client, f);
        f.setVisible(true);
    }

    public boolean isActivated() {
        return this.isActivatedFlag;
    }

    public void loginSuccess() {
        this.updateMe();
        for (GameContainers gc : GameContainers.values()) {
            this.doAction(this.globalMIs.get((Object)gc));
        }
        this.client.sendSync(this.multiHandler);
        for (int i = 0; i < this.menuBar.getComponentCount(); ++i) {
            Component comp = this.menuBar.getComponent(i);
            if (!(comp instanceof JMenu)) continue;
            comp.setEnabled(true);
        }
    }

    private void doEvent(Event event) {
        ClientPanel cp = event.source instanceof ClientPanel ? (ClientPanel)event.source : null;
        switch (event.type) {
            case 65541: 
            case 65542: {
                GuiClientUtil.get(this.client).uploadFile((CRoom)event.source, this, event.type == 65542);
                break;
            }
            case 65537: 
            case 65538: {
                int ioc;
                if (this.tabPane.getSelectedComponent() == event.source || (ioc = this.tabPane.indexOfComponent(cp)) < 0) break;
                this.tabPane.setBackgroundAt(ioc, event.type == 65537 ? UIManager.getColor("org.igoweb.selTextBg") : null);
                break;
            }
            case 65539: {
                if (this.tabPane.indexOfComponent(cp) == -1) {
                    if (this.roomPane.getComponent(0) != cp) {
                        if (this.tabPane.getComponentCount() == 0) {
                            this.transfer((ClientPanel)this.roomPane.getComponent(0), true, -1);
                            this.transfer(cp, true, -1);
                            this.roomPane.add((Component)this.tabPane, 0);
                        } else {
                            this.transfer(cp, true, 1);
                        }
                        this.tabPane.setSelectedComponent(cp);
                    }
                } else if (this.tabPane.getComponentCount() > 1) {
                    this.transfer(cp, false, -1);
                    if (this.tabPane.getComponentCount() == 1) {
                        this.roomPane.remove(this.tabPane);
                        ClientPanel topPanel = (ClientPanel)this.tabPane.getComponent(0);
                        this.transfer(topPanel, false, 0);
                        topPanel.setPopEnabled(false);
                    }
                }
                cp.revalidate();
                this.roomPane.revalidate();
                this.roomPane.repaint();
                break;
            }
            case 65540: {
                GlobalGamePanel gp = (GlobalGamePanel)cp;
                Prefs.putBoolean(GLOBAL_GAME_LIST_OPEN_PREF + (Object)((Object)gp.getType()), false);
                this.removeChat(gp);
                this.globalGamePanels.put(gp.getType(), null);
                this.globalMIs.get((Object)gp.getType()).setSelected(false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void transfer(ClientPanel cp, boolean toTabPane, int mpIndex) {
        cp.setBorder(toTabPane ? null : BorderFactory.createBevelBorder(0));
        if (toTabPane) {
            this.roomPane.remove(cp);
            this.addToTabPane(cp);
            cp.setPopEnabled(true);
        } else if (mpIndex != -2) {
            this.tabPane.remove(cp);
            this.roomPane.add((Component)cp, mpIndex);
            this.tabPane.validate();
            cp.setVisible(true);
        }
    }

    @Override
    public void dispose() {
        int i;
        Component comp;
        if (this.iconRotator != null) {
            this.iconRotator.stop();
            this.iconRotator = null;
        }
        if ((comp = this.tabPane.getSelectedComponent()) != null && comp instanceof ClientPanel) {
            Prefs.putString(FRONTMOST_PANEL, ((ClientPanel)comp).getSortKey());
        }
        for (i = this.tabPane.getComponentCount() - 1; i >= 0; --i) {
            comp = this.tabPane.getComponent(i);
            if (!(comp instanceof ClientPanel)) continue;
            ((ClientPanel)comp).logoutNotify();
        }
        for (i = this.roomPane.getComponentCount() - 1; i >= 0; --i) {
            comp = this.roomPane.getComponent(i);
            if (!(comp instanceof ClientPanel)) continue;
            ((ClientPanel)comp).logoutNotify();
        }
        super.dispose();
    }

    Component getAlwaysEnabledWidget() {
        return this.tabPane;
    }

    public boolean isNewChatOk(User peer) {
        return !this.noChatsMI.isSelected() || this.client.getFriendsGroup(0).contains(peer);
    }

    void setPlaybackList(TreeMap<Long, PlaybackInfo> playbackList) {
        this.wasSubscribed = this.client.getMe().isSubscribed();
        this.recentPlaybackMenu.removeAll();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        Date date = new Date(0L);
        for (Map.Entry<Long, PlaybackInfo> longPlaybackInfoEntry : playbackList.tailMap(System.currentTimeMillis() - Subscription.ALWAYS_SEND_LIMIT).entrySet()) {
            PlaybackInfo playback = longPlaybackInfoEntry.getValue();
            date.setTime(playback.id);
            JMenuItem mi = new JMenuItem(playback.gameSummary.getLocalDesc() + " \u2014 " + df.format(date));
            mi.setEnabled(PlaybackChooser.isPlaybackEnabled(playback, this.client));
            long when = playback.id;
            mi.addActionListener(event -> this.client.sendStartPlayback(when));
            this.recentPlaybackMenu.add(mi);
        }
    }

    private void addToTabPane(ClientPanel cp) {
        int pos;
        if (cp instanceof GlobalGamePanel) {
            GlobalGamePanel ggp = (GlobalGamePanel)cp;
            this.globalGamePanels.put(ggp.getType(), ggp);
        }
        String sortKey = cp.getSortKey();
        Collator collator = Collator.getInstance();
        for (pos = 0; pos < this.tabPane.getComponentCount() && collator.compare(sortKey, ((ClientPanel)this.tabPane.getComponentAt(pos)).getSortKey()) >= 0; ++pos) {
        }
        this.tabPane.add((Component)cp, pos);
    }

    private void loginComplete() {
        ClientPanel firstRoom = null;
        String sortKey = Prefs.getString(FRONTMOST_PANEL, null);
        for (int i = 0; i < this.tabPane.getComponentCount(); ++i) {
            Component comp = this.tabPane.getComponent(i);
            if (!(comp instanceof ClientPanel)) continue;
            ClientPanel cp = (ClientPanel)comp;
            if (cp.getSortKey().equals(sortKey)) {
                this.tabPane.setSelectedComponent(cp);
                return;
            }
            if (firstRoom != null || !cp.getSortKey().startsWith("1 ")) continue;
            firstRoom = cp;
        }
        if (firstRoom != null) {
            this.tabPane.setSelectedComponent(firstRoom);
        }
    }

    private class UrlDisplayer
    implements ActionListener {
        private int msgId;
        private String url;

        public UrlDisplayer(int newMsgId, String newUrl) {
            this.msgId = newMsgId;
            this.url = "http://" + Config.get("webHost") + newUrl;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!Defs.isApp()) {
                Defs.loadWebPage(this.url, false);
            } else if (JnlpIo.isAvailable()) {
                try {
                    JnlpIo.showUrl(new URL(this.url));
                }
                catch (MalformedURLException excep) {
                    throw new RuntimeException(this.url);
                }
            } else {
                new MsgOut(Defs.getString(-903340709), Defs.getString(this.msgId, Config.get("webHost")), 1, (Component)ClientWindow.this);
            }
        }
    }

    private class MultiHandler
    implements ActionListener,
    EventListener,
    ChangeListener,
    Runnable {
        @Override
        public void actionPerformed(ActionEvent event) {
            ClientWindow.this.doAction(event.getSource());
        }

        @Override
        public void handleEvent(Event event) {
            ClientWindow.this.doEvent(event);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            int seli = ClientWindow.this.tabPane.getSelectedIndex();
            if (seli >= 0) {
                ClientWindow.this.tabPane.setBackgroundAt(seli, null);
            }
        }

        @Override
        public void run() {
            ClientWindow.this.loginComplete();
        }
    }
}

