/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos;

import [Ljava.lang.String;;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.util.SwingUtility;

public class AllDemos
extends JFrame {
    private static Log log = LogFactory.getLog(AllDemos.class);
    private static final String[] DEMO_CLASS_NAMES = new String[]{"org.flexdock.demos.maximizing.MaximizationDemo", "org.flexdock.demos.perspective.PerspectivesDemo", "org.flexdock.demos.perspective.XMLPerspectivesDemo", "org.flexdock.demos.raw.adapter.AdapterDemo", "org.flexdock.demos.raw.border.BorderDemo", "org.flexdock.demos.raw.CompoundDemo", "org.flexdock.demos.raw.elegant.ElegantDemo", "org.flexdock.demos.raw.jmf.JMFDemo", "org.flexdock.demos.raw.SimpleDemo", "org.flexdock.demos.raw.SplitPaneDemo", "org.flexdock.demos.raw.TabbedPaneDemo", "org.flexdock.demos.view.ViewDemo"};

    public AllDemos() {
        super("FlexDock Demos");
        TreeMap<String, String> sorted_class_names = new TreeMap<String, String>();
        for (int i = 0; i < DEMO_CLASS_NAMES.length; ++i) {
            String full_class_name = DEMO_CLASS_NAMES[i];
            String just_class_name = full_class_name.substring(full_class_name.lastIndexOf(46) + 1);
            sorted_class_names.put(just_class_name, full_class_name);
        }
        this.getContentPane().setLayout(new GridLayout(0, 1, 3, 3));
        Iterator iter = sorted_class_names.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            final String full_class_name = (String)entry.getValue();
            String just_class_name = (String)entry.getKey();
            JButton button = new JButton(just_class_name);
            button.setToolTipText("Runs " + full_class_name);
            this.getContentPane().add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AllDemos.this.launchClass(full_class_name);
                }
            });
        }
        this.pack();
    }

    private void launchClass(String full_class_name) {
        try {
            Class<?> c = Class.forName(full_class_name);
            Method m = c.getMethod("main", String;.class);
            log.debug("Launching using: " + m);
            m.invoke(null, new Object[]{null});
        }
        catch (Throwable t) {
            String message = "Error occurred when calling main(String[]) on class " + full_class_name;
            log.error(message, t);
            DemoUtility.showErrorDialog(this, message, t);
        }
    }

    public static void main(String[] args) {
        try {
            final AllDemos a = new AllDemos();
            a.setDefaultCloseOperation(3);
            DemoUtility.setDemoDisableExitOnClose();
            SwingUtility.centerOnScreen(a);
            a.setVisible(true);
            for (int i = 0; i < args.length; ++i) {
                final String full_class_name = args[i];
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        a.launchClass(full_class_name);
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

