<?php

/**
 * BaseLeave
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                     $id                                            Type: integer(4), primary key
 * @property string                                  $date                                          Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property float                                   $length_hours                                  Type: decimal(6)
 * @property float                                   $length_days                                   Type: decimal(6)
 * @property int                                     $status                                        Type: integer(2)
 * @property string                                  $comments                                      Type: string(256)
 * @property int                                     $leave_request_id                              Type: integer(4)
 * @property int                                     $leave_type_id                                 Type: integer(4)
 * @property int                                     $emp_number                                    Type: integer(4)
 * @property string                                  $start_time                                    Type: time(25), Time in ISO-8601 format (HH:MI:SS)
 * @property string                                  $end_time                                      Type: time(25), Time in ISO-8601 format (HH:MI:SS)
 * @property int                                     $duration_type                                 Type: int
 * @property Doctrine_Collection|LeaveEntitlement[]  $LeaveEntitlements                             
 * @property LeaveRequest                            $LeaveRequest                                  
 * @property LeaveType                               $LeaveType                                     
 * @property Doctrine_Collection|LeaveComment[]      $LeaveComment                                  
 *  
 * @method int                                       getId()                                        Type: integer(4), primary key
 * @method string                                    getDate()                                      Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method float                                     getLengthHours()                               Type: decimal(6)
 * @method float                                     getLengthDays()                                Type: decimal(6)
 * @method int                                       getStatus()                                    Type: integer(2)
 * @method string                                    getComments()                                  Type: string(256)
 * @method int                                       getLeaveRequestId()                            Type: integer(4)
 * @method int                                       getLeaveTypeId()                               Type: integer(4)
 * @method int                                       getEmpNumber()                                 Type: integer(4)
 * @method string                                    getStartTime()                                 Type: time(25), Time in ISO-8601 format (HH:MI:SS)
 * @method string                                    getEndTime()                                   Type: time(25), Time in ISO-8601 format (HH:MI:SS)
 * @method int                                       getDurationType()                              Type: int
 * @method Doctrine_Collection|LeaveEntitlement[]    getLeaveEntitlements()                         
 * @method LeaveRequest                              getLeaveRequest()                              
 * @method LeaveType                                 getLeaveType()                                 
 * @method Doctrine_Collection|LeaveComment[]        getLeaveComment()                              
 *  
 * @method Leave                                     setId(int $val)                                Type: integer(4), primary key
 * @method Leave                                     setDate(string $val)                           Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Leave                                     setLengthHours(float $val)                     Type: decimal(6)
 * @method Leave                                     setLengthDays(float $val)                      Type: decimal(6)
 * @method Leave                                     setStatus(int $val)                            Type: integer(2)
 * @method Leave                                     setComments(string $val)                       Type: string(256)
 * @method Leave                                     setLeaveRequestId(int $val)                    Type: integer(4)
 * @method Leave                                     setLeaveTypeId(int $val)                       Type: integer(4)
 * @method Leave                                     setEmpNumber(int $val)                         Type: integer(4)
 * @method Leave                                     setStartTime(string $val)                      Type: time(25), Time in ISO-8601 format (HH:MI:SS)
 * @method Leave                                     setEndTime(string $val)                        Type: time(25), Time in ISO-8601 format (HH:MI:SS)
 * @method Leave                                     setDurationType(int $val)                      Type: int
 * @method Leave                                     setLeaveEntitlements(Doctrine_Collection $val) 
 * @method Leave                                     setLeaveRequest(LeaveRequest $val)             
 * @method Leave                                     setLeaveType(LeaveType $val)                   
 * @method Leave                                     setLeaveComment(Doctrine_Collection $val)      
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeave extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_leave');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('date', 'date', 25, array(
             'type' => 'date',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('length_hours', 'decimal', 6, array(
             'type' => 'decimal',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 6,
             'scale' => '4',
             ));
        $this->hasColumn('length_days', 'decimal', 6, array(
             'type' => 'decimal',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 6,
             'scale' => '4',
             ));
        $this->hasColumn('status', 'integer', 2, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 2,
             ));
        $this->hasColumn('comments', 'string', 256, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 256,
             ));
        $this->hasColumn('leave_request_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('leave_type_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('emp_number', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('start_time', 'time', 25, array(
             'type' => 'time',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('end_time', 'time', 25, array(
             'type' => 'time',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
        $this->hasColumn('duration_type', 'int', null, array(
             'type' => 'int',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('LeaveEntitlement as LeaveEntitlements', array(
             'refClass' => 'LeaveLeaveEntitlement',
             'local' => 'leave_id',
             'foreign' => 'entitlement_id'));

        $this->hasOne('LeaveRequest', array(
             'local' => 'leave_request_id',
             'foreign' => 'id'));

        $this->hasOne('LeaveType', array(
             'local' => 'leave_type_id',
             'foreign' => 'id'));

        $this->hasMany('LeaveComment', array(
             'local' => 'id',
             'foreign' => 'leave_id'));
    }
}