require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NILFS_FS_H)) {
    eval 'sub _NILFS_FS_H () {1;}' unless defined(&_NILFS_FS_H);
    eval 'sub NILFS_SECRM_FL () {0x1;}' unless defined(&NILFS_SECRM_FL);
    eval 'sub NILFS_UNRM_FL () {0x2;}' unless defined(&NILFS_UNRM_FL);
    eval 'sub NILFS_SYNC_FL () {0x8;}' unless defined(&NILFS_SYNC_FL);
    eval 'sub NILFS_IMMUTABLE_FL () {0x10;}' unless defined(&NILFS_IMMUTABLE_FL);
    eval 'sub NILFS_APPEND_FL () {0x20;}' unless defined(&NILFS_APPEND_FL);
    eval 'sub NILFS_NODUMP_FL () {0x40;}' unless defined(&NILFS_NODUMP_FL);
    eval 'sub NILFS_NOATIME_FL () {0x80;}' unless defined(&NILFS_NOATIME_FL);
    eval 'sub NILFS_NOTAIL_FL () {0x8000;}' unless defined(&NILFS_NOTAIL_FL);
    eval 'sub NILFS_DIRSYNC_FL () {0x10000;}' unless defined(&NILFS_DIRSYNC_FL);
    eval 'sub NILFS_FL_USER_VISIBLE () {0x3dfff;}' unless defined(&NILFS_FL_USER_VISIBLE);
    eval 'sub NILFS_FL_USER_MODIFIABLE () {0x380ff;}' unless defined(&NILFS_FL_USER_MODIFIABLE);
    eval 'sub NILFS_INODE_BMAP_SIZE () {7;}' unless defined(&NILFS_INODE_BMAP_SIZE);
    eval 'sub NILFS_BMAP_SIZE () {( &NILFS_INODE_BMAP_SIZE * $sizeof{ &uint64_t});}' unless defined(&NILFS_BMAP_SIZE);
    eval 'sub NILFS_BMAP_INVALID_PTR () {0;}' unless defined(&NILFS_BMAP_INVALID_PTR);
    eval 'sub NILFS_DIRECT_NBLOCKS () {( &NILFS_BMAP_SIZE / $sizeof{ &uint64_t} - 1);}' unless defined(&NILFS_DIRECT_NBLOCKS);
    eval 'sub NILFS_DIRECT_KEY_MIN () {0;}' unless defined(&NILFS_DIRECT_KEY_MIN);
    eval 'sub NILFS_DIRECT_KEY_MAX () {( &NILFS_DIRECT_NBLOCKS - 1);}' unless defined(&NILFS_DIRECT_KEY_MAX);
    eval 'sub NILFS_BMAP_SMALL_LOW () { &NILFS_DIRECT_KEY_MIN;}' unless defined(&NILFS_BMAP_SMALL_LOW);
    eval 'sub NILFS_BMAP_SMALL_HIGH () { &NILFS_DIRECT_KEY_MAX;}' unless defined(&NILFS_BMAP_SMALL_HIGH);
    eval 'sub NILFS_BMAP_LARGE_LOW () { &NILFS_BTREE_ROOT_NCHILDREN_MAX;}' unless defined(&NILFS_BMAP_LARGE_LOW);
    eval 'sub NILFS_BMAP_LARGE_HIGH () { &NILFS_BTREE_KEY_MAX;}' unless defined(&NILFS_BMAP_LARGE_HIGH);
    eval 'sub NILFS_BTREE_NODE_ROOT () {0x1;}' unless defined(&NILFS_BTREE_NODE_ROOT);
    eval 'sub NILFS_BMAP_LARGE () {0x1;}' unless defined(&NILFS_BMAP_LARGE);
    eval 'sub NILFS_BTREE_LEVEL_DATA () {0;}' unless defined(&NILFS_BTREE_LEVEL_DATA);
    eval 'sub NILFS_BTREE_LEVEL_NODE_MIN () {( &NILFS_BTREE_LEVEL_DATA + 1);}' unless defined(&NILFS_BTREE_LEVEL_NODE_MIN);
    eval 'sub NILFS_BTREE_LEVEL_MAX () {14;}' unless defined(&NILFS_BTREE_LEVEL_MAX);
    eval 'sub NILFS_BTREE_ROOT_SIZE () { &NILFS_BMAP_SIZE;}' unless defined(&NILFS_BTREE_ROOT_SIZE);
    eval 'sub NILFS_BTREE_ROOT_NCHILDREN_MAX () {(( &NILFS_BTREE_ROOT_SIZE - $sizeof{\'struct nilfs_btree_node\'}) / ($sizeof{ &uint64_t } + $sizeof{ &uint64_t }));}' unless defined(&NILFS_BTREE_ROOT_NCHILDREN_MAX);
    eval 'sub NILFS_BTREE_ROOT_NCHILDREN_MIN () {0;}' unless defined(&NILFS_BTREE_ROOT_NCHILDREN_MIN);
    eval 'sub NILFS_BTREE_NODE_EXTRA_PAD_SIZE () {($sizeof{ &uint64_t});}' unless defined(&NILFS_BTREE_NODE_EXTRA_PAD_SIZE);
    eval 'sub NILFS_BTREE_NODE_NCHILDREN_MAX {
        my($nodesize) = @_;
	    eval q(((($nodesize) - $sizeof{\'struct nilfs_btree_node\'} -  &NILFS_BTREE_NODE_EXTRA_PAD_SIZE) / ($sizeof{ &uint64_t } + $sizeof{ &uint64_t })));
    }' unless defined(&NILFS_BTREE_NODE_NCHILDREN_MAX);
    eval 'sub NILFS_BTREE_NODE_NCHILDREN_MIN {
        my($nodesize) = @_;
	    eval q((( &NILFS_BTREE_NODE_NCHILDREN_MAX($nodesize) - 1) / 2+ 1));
    }' unless defined(&NILFS_BTREE_NODE_NCHILDREN_MIN);
    eval 'sub NILFS_BTREE_KEY_MIN () {( ( &uint64_t) 0);}' unless defined(&NILFS_BTREE_KEY_MIN);
    eval 'sub NILFS_BTREE_KEY_MAX () {(~( &uint64_t) 0);}' unless defined(&NILFS_BTREE_KEY_MAX);
    eval 'sub NILFS_ROOT_INO () {2;}' unless defined(&NILFS_ROOT_INO);
    eval 'sub NILFS_DAT_INO () {3;}' unless defined(&NILFS_DAT_INO);
    eval 'sub NILFS_CPFILE_INO () {4;}' unless defined(&NILFS_CPFILE_INO);
    eval 'sub NILFS_SUFILE_INO () {5;}' unless defined(&NILFS_SUFILE_INO);
    eval 'sub NILFS_IFILE_INO () {6;}' unless defined(&NILFS_IFILE_INO);
    eval 'sub NILFS_ATIME_INO () {7;}' unless defined(&NILFS_ATIME_INO);
    eval 'sub NILFS_XATTR_INO () {8;}' unless defined(&NILFS_XATTR_INO);
    eval 'sub NILFS_SKETCH_INO () {10;}' unless defined(&NILFS_SKETCH_INO);
    eval 'sub NILFS_USER_INO () {11;}' unless defined(&NILFS_USER_INO);
    eval 'sub i_device_code () { $i_bmap[0];}' unless defined(&i_device_code);
    eval 'sub NILFS_SR_MDT_OFFSET {
        my($inode_size, $i) = @_;
	    eval q((( &uint32_t)(0)-> &sr_dat + ($inode_size) * ($i)));
    }' unless defined(&NILFS_SR_MDT_OFFSET);
    eval 'sub NILFS_SR_DAT_OFFSET {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 0));
    }' unless defined(&NILFS_SR_DAT_OFFSET);
    eval 'sub NILFS_SR_CPFILE_OFFSET {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 1));
    }' unless defined(&NILFS_SR_CPFILE_OFFSET);
    eval 'sub NILFS_SR_SUFILE_OFFSET {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 2));
    }' unless defined(&NILFS_SR_SUFILE_OFFSET);
    eval 'sub NILFS_SR_BYTES () {($sizeof{\'struct nilfs_super_root\'});}' unless defined(&NILFS_SR_BYTES);
    eval 'sub NILFS_DFL_MAX_MNT_COUNT () {50;}' unless defined(&NILFS_DFL_MAX_MNT_COUNT);
    eval 'sub NILFS_EIO_RETRY_COUNT () {4;}' unless defined(&NILFS_EIO_RETRY_COUNT);
    eval 'sub NILFS_VALID_FS () {0x1;}' unless defined(&NILFS_VALID_FS);
    eval 'sub NILFS_ERROR_FS () {0x2;}' unless defined(&NILFS_ERROR_FS);
    eval 'sub NILFS_RESIZE_FS () {0x4;}' unless defined(&NILFS_RESIZE_FS);
    eval 'sub NILFS_MOUNT_STATE_BITS () {"\\20\\1VALID_FS\\2ERROR_FS\\3RESIZE_FS";}' unless defined(&NILFS_MOUNT_STATE_BITS);
    eval 'sub NILFS_MOUNT_ERROR_MODE () {0x70;}' unless defined(&NILFS_MOUNT_ERROR_MODE);
    eval 'sub NILFS_MOUNT_ERRORS_CONT () {0x10;}' unless defined(&NILFS_MOUNT_ERRORS_CONT);
    eval 'sub NILFS_MOUNT_ERRORS_RO () {0x20;}' unless defined(&NILFS_MOUNT_ERRORS_RO);
    eval 'sub NILFS_MOUNT_ERRORS_PANIC () {0x40;}' unless defined(&NILFS_MOUNT_ERRORS_PANIC);
    eval 'sub NILFS_MOUNT_SNAPSHOT () {0x80;}' unless defined(&NILFS_MOUNT_SNAPSHOT);
    eval 'sub NILFS_MOUNT_BARRIER () {0x1000;}' unless defined(&NILFS_MOUNT_BARRIER);
    eval 'sub NILFS_MOUNT_STRICT_ORDER () {0x2000;}' unless defined(&NILFS_MOUNT_STRICT_ORDER);
    eval 'sub NILFS_SUPER_MAGIC () {0x3434;}' unless defined(&NILFS_SUPER_MAGIC);
    eval 'sub NILFS_SB_OFFSET_BYTES () {1024;}' unless defined(&NILFS_SB_OFFSET_BYTES);
    eval 'sub NILFS_SB2_OFFSET_BYTES {
        my($devsize) = @_;
	    eval q((((($devsize) >> 12) - 1) << 12));
    }' unless defined(&NILFS_SB2_OFFSET_BYTES);
    eval 'sub NILFS_OS_LINUX () {0;}' unless defined(&NILFS_OS_LINUX);
    eval 'sub NILFS_OS_UNK1 () {1;}' unless defined(&NILFS_OS_UNK1);
    eval 'sub NILFS_OS_UNK2 () {2;}' unless defined(&NILFS_OS_UNK2);
    eval 'sub NILFS_OS_UNK3 () {3;}' unless defined(&NILFS_OS_UNK3);
    eval 'sub NILFS_OS_NETBSD () {10;}' unless defined(&NILFS_OS_NETBSD);
    eval 'sub NILFS_CURRENT_REV () {2;}' unless defined(&NILFS_CURRENT_REV);
    eval 'sub NILFS_MINOR_REV () {0;}' unless defined(&NILFS_MINOR_REV);
    eval 'sub NILFS_SB_BYTES () {(( &uint32_t)(0)-> &s_reserved);}' unless defined(&NILFS_SB_BYTES);
    eval 'sub NILFS_LINK_MAX () {32000;}' unless defined(&NILFS_LINK_MAX);
    eval 'sub NILFS_NAME_LEN () {255;}' unless defined(&NILFS_NAME_LEN);
    eval("sub NILFS_FT_UNKNOWN () { 0; }") unless defined(&NILFS_FT_UNKNOWN);
    eval("sub NILFS_FT_REG_FILE () { 1; }") unless defined(&NILFS_FT_REG_FILE);
    eval("sub NILFS_FT_DIR () { 2; }") unless defined(&NILFS_FT_DIR);
    eval("sub NILFS_FT_CHRDEV () { 3; }") unless defined(&NILFS_FT_CHRDEV);
    eval("sub NILFS_FT_BLKDEV () { 4; }") unless defined(&NILFS_FT_BLKDEV);
    eval("sub NILFS_FT_FIFO () { 5; }") unless defined(&NILFS_FT_FIFO);
    eval("sub NILFS_FT_SOCK () { 6; }") unless defined(&NILFS_FT_SOCK);
    eval("sub NILFS_FT_SYMLINK () { 7; }") unless defined(&NILFS_FT_SYMLINK);
    eval("sub NILFS_FT_MAX () { 8; }") unless defined(&NILFS_FT_MAX);
    eval 'sub NILFS_DIR_PAD () {8;}' unless defined(&NILFS_DIR_PAD);
    eval 'sub NILFS_DIR_ROUND () {( &NILFS_DIR_PAD - 1);}' unless defined(&NILFS_DIR_ROUND);
    eval 'sub NILFS_DIR_REC_LEN {
        my($name_len) = @_;
	    eval q(((($name_len) + 12+  &NILFS_DIR_ROUND) & ~ &NILFS_DIR_ROUND));
    }' unless defined(&NILFS_DIR_REC_LEN);
    eval 'sub NILFS_SEGSUM_MAGIC () {0x1eaffa11;}' unless defined(&NILFS_SEGSUM_MAGIC);
    eval 'sub NILFS_SS_LOGBGN () {0x1;}' unless defined(&NILFS_SS_LOGBGN);
    eval 'sub NILFS_SS_LOGEND () {0x2;}' unless defined(&NILFS_SS_LOGEND);
    eval 'sub NILFS_SS_SR () {0x4;}' unless defined(&NILFS_SS_SR);
    eval 'sub NILFS_SS_SYNDT () {0x8;}' unless defined(&NILFS_SS_SYNDT);
    eval 'sub NILFS_SS_GC () {0x10;}' unless defined(&NILFS_SS_GC);
    eval 'sub NILFS_SS_FLAG_BITS () {"\\20\\1LOGBGN\\2LOGEND\\3SR\\4SYNDT\\5GC";}' unless defined(&NILFS_SS_FLAG_BITS);
    eval 'sub NILFS_SEG_MIN_BLOCKS () {16;}' unless defined(&NILFS_SEG_MIN_BLOCKS);
    eval 'sub NILFS_PSEG_MIN_BLOCKS () {2;}' unless defined(&NILFS_PSEG_MIN_BLOCKS);
    eval 'sub NILFS_MIN_NRSVSEGS () {8;}' unless defined(&NILFS_MIN_NRSVSEGS);
    eval 'sub NILFS_CHECKPOINT_SNAPSHOT () {1;}' unless defined(&NILFS_CHECKPOINT_SNAPSHOT);
    eval 'sub NILFS_CHECKPOINT_INVALID () {2;}' unless defined(&NILFS_CHECKPOINT_INVALID);
    eval 'sub NILFS_CHECKPOINT_SKETCH () {4;}' unless defined(&NILFS_CHECKPOINT_SKETCH);
    eval 'sub NILFS_CHECKPOINT_MINOR () {8;}' unless defined(&NILFS_CHECKPOINT_MINOR);
    eval 'sub NILFS_CHECKPOINT_BITS () {"\\20\\1SNAPSHOT\\2INVALID\\3SKETCH\\4MINOR";}' unless defined(&NILFS_CHECKPOINT_BITS);
    eval 'sub NILFS_CPFILE_FIRST_CHECKPOINT_OFFSET () {(($sizeof{\'struct nilfs_cpfile_header\'} + $sizeof{\'struct nilfs_checkpoint\'} - 1) / $sizeof{\'struct nilfs_checkpoint\'});}' unless defined(&NILFS_CPFILE_FIRST_CHECKPOINT_OFFSET);
    eval 'sub NILFS_SEGMENT_USAGE_ACTIVE () {1;}' unless defined(&NILFS_SEGMENT_USAGE_ACTIVE);
    eval 'sub NILFS_SEGMENT_USAGE_DIRTY () {2;}' unless defined(&NILFS_SEGMENT_USAGE_DIRTY);
    eval 'sub NILFS_SEGMENT_USAGE_ERROR () {4;}' unless defined(&NILFS_SEGMENT_USAGE_ERROR);
    eval 'sub NILFS_SEGMENT_USAGE_BITS () {"\\20\\1ACTIVE\\2DIRTY\\3ERROR";}' unless defined(&NILFS_SEGMENT_USAGE_BITS);
    eval 'sub NILFS_SUFILE_FIRST_SEGMENT_USAGE_OFFSET () {(($sizeof{\'struct nilfs_sufile_header\'} + $sizeof{\'struct nilfs_segment_usage\'} - 1) / $sizeof{\'struct nilfs_segment_usage\'});}' unless defined(&NILFS_SUFILE_FIRST_SEGMENT_USAGE_OFFSET);
}
1;
