require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_BOOTBLOCK_H)) {
    eval 'sub _SYS_BOOTBLOCK_H () {1;}' unless defined(&_SYS_BOOTBLOCK_H);
    if(!defined(&__ASSEMBLER__)) {
	require 'sys/cdefs.ph';
	if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	    require 'sys/stdint.ph';
	} else {
	    require 'stdint.ph';
	}
    }
    eval 'sub MBR_BBSECTOR () {0;}' unless defined(&MBR_BBSECTOR);
    eval 'sub MBR_BPB_OFFSET () {11;}' unless defined(&MBR_BPB_OFFSET);
    eval 'sub MBR_BOOTCODE_OFFSET () {90;}' unless defined(&MBR_BOOTCODE_OFFSET);
    eval 'sub MBR_BS_OFFSET () {400;}' unless defined(&MBR_BS_OFFSET);
    eval 'sub MBR_BS_OLD_OFFSET () {404;}' unless defined(&MBR_BS_OLD_OFFSET);
    eval 'sub MBR_GPT_GUID_OFFSET () {424;}' unless defined(&MBR_GPT_GUID_OFFSET);
    eval 'sub MBR_GPT_GUID_DEFAULT () {{0xeee69d04,0x2f4,0x11e0,0x8f,0x5d,{0x,0xe0,0x81,0x52,0x9a,0x6b}};}' unless defined(&MBR_GPT_GUID_DEFAULT);
    eval 'sub MBR_DSN_OFFSET () {440;}' unless defined(&MBR_DSN_OFFSET);
    eval 'sub MBR_BS_MAGIC_OFFSET () {444;}' unless defined(&MBR_BS_MAGIC_OFFSET);
    eval 'sub MBR_PART_OFFSET () {446;}' unless defined(&MBR_PART_OFFSET);
    eval 'sub MBR_MAGIC_OFFSET () {510;}' unless defined(&MBR_MAGIC_OFFSET);
    eval 'sub MBR_MAGIC () {0xaa55;}' unless defined(&MBR_MAGIC);
    eval 'sub MBR_BS_MAGIC () {0xb5e1;}' unless defined(&MBR_BS_MAGIC);
    eval 'sub MBR_PART_COUNT () {4;}' unless defined(&MBR_PART_COUNT);
    eval 'sub MBR_BS_PARTNAMESIZE () {8;}' unless defined(&MBR_BS_PARTNAMESIZE);
    eval 'sub MBR_PFLAG_ACTIVE () {0x80;}' unless defined(&MBR_PFLAG_ACTIVE);
    eval 'sub MBR_PTYPE_UNUSED () {0x;}' unless defined(&MBR_PTYPE_UNUSED);
    eval 'sub MBR_PTYPE_FAT12 () {0x1;}' unless defined(&MBR_PTYPE_FAT12);
    eval 'sub MBR_PTYPE_XENIX_ROOT () {0x2;}' unless defined(&MBR_PTYPE_XENIX_ROOT);
    eval 'sub MBR_PTYPE_XENIX_USR () {0x3;}' unless defined(&MBR_PTYPE_XENIX_USR);
    eval 'sub MBR_PTYPE_FAT16S () {0x4;}' unless defined(&MBR_PTYPE_FAT16S);
    eval 'sub MBR_PTYPE_EXT () {0x5;}' unless defined(&MBR_PTYPE_EXT);
    eval 'sub MBR_PTYPE_FAT16B () {0x6;}' unless defined(&MBR_PTYPE_FAT16B);
    eval 'sub MBR_PTYPE_NTFS () {0x7;}' unless defined(&MBR_PTYPE_NTFS);
    eval 'sub MBR_PTYPE_DELL () {0x8;}' unless defined(&MBR_PTYPE_DELL);
    eval 'sub MBR_PTYPE_AIX_BOOT () {0x9;}' unless defined(&MBR_PTYPE_AIX_BOOT);
    eval 'sub MBR_PTYPE_OS2_BOOT () {0xa;}' unless defined(&MBR_PTYPE_OS2_BOOT);
    eval 'sub MBR_PTYPE_FAT32 () {0xb;}' unless defined(&MBR_PTYPE_FAT32);
    eval 'sub MBR_PTYPE_FAT32L () {0xc;}' unless defined(&MBR_PTYPE_FAT32L);
    eval 'sub MBR_PTYPE_7XXX () {0xd;}' unless defined(&MBR_PTYPE_7XXX);
    eval 'sub MBR_PTYPE_FAT16L () {0xe;}' unless defined(&MBR_PTYPE_FAT16L);
    eval 'sub MBR_PTYPE_EXT_LBA () {0xf;}' unless defined(&MBR_PTYPE_EXT_LBA);
    eval 'sub MBR_PTYPE_OPUS () {0x10;}' unless defined(&MBR_PTYPE_OPUS);
    eval 'sub MBR_PTYPE_OS2_DOS12 () {0x11;}' unless defined(&MBR_PTYPE_OS2_DOS12);
    eval 'sub MBR_PTYPE_COMPAQ_DIAG () {0x12;}' unless defined(&MBR_PTYPE_COMPAQ_DIAG);
    eval 'sub MBR_PTYPE_OS2_DOS16S () {0x14;}' unless defined(&MBR_PTYPE_OS2_DOS16S);
    eval 'sub MBR_PTYPE_OS2_DOS16B () {0x16;}' unless defined(&MBR_PTYPE_OS2_DOS16B);
    eval 'sub MBR_PTYPE_OS2_IFS () {0x17;}' unless defined(&MBR_PTYPE_OS2_IFS);
    eval 'sub MBR_PTYPE_AST_SWAP () {0x18;}' unless defined(&MBR_PTYPE_AST_SWAP);
    eval 'sub MBR_PTYPE_WILLOWTECH () {0x19;}' unless defined(&MBR_PTYPE_WILLOWTECH);
    eval 'sub MBR_PTYPE_HID_FAT32 () {0x1b;}' unless defined(&MBR_PTYPE_HID_FAT32);
    eval 'sub MBR_PTYPE_HID_FAT32_LBA () {0x1c;}' unless defined(&MBR_PTYPE_HID_FAT32_LBA);
    eval 'sub MBR_PTYPE_HID_FAT16_LBA () {0x1d;}' unless defined(&MBR_PTYPE_HID_FAT16_LBA);
    eval 'sub MBR_PTYPE_WILLOWSOFT () {0x20;}' unless defined(&MBR_PTYPE_WILLOWSOFT);
    eval 'sub MBR_PTYPE_RESERVED_x21 () {0x21;}' unless defined(&MBR_PTYPE_RESERVED_x21);
    eval 'sub MBR_PTYPE_RESERVED_x23 () {0x23;}' unless defined(&MBR_PTYPE_RESERVED_x23);
    eval 'sub MBR_PTYPE_RESERVED_x24 () {0x24;}' unless defined(&MBR_PTYPE_RESERVED_x24);
    eval 'sub MBR_PTYPE_RESERVED_x26 () {0x26;}' unless defined(&MBR_PTYPE_RESERVED_x26);
    eval 'sub MBR_PTYPE_RESERVED_x31 () {0x31;}' unless defined(&MBR_PTYPE_RESERVED_x31);
    eval 'sub MBR_PTYPE_NOS () {0x32;}' unless defined(&MBR_PTYPE_NOS);
    eval 'sub MBR_PTYPE_RESERVED_x33 () {0x33;}' unless defined(&MBR_PTYPE_RESERVED_x33);
    eval 'sub MBR_PTYPE_RESERVED_x34 () {0x34;}' unless defined(&MBR_PTYPE_RESERVED_x34);
    eval 'sub MBR_PTYPE_OS2_JFS () {0x35;}' unless defined(&MBR_PTYPE_OS2_JFS);
    eval 'sub MBR_PTYPE_RESERVED_x36 () {0x36;}' unless defined(&MBR_PTYPE_RESERVED_x36);
    eval 'sub MBR_PTYPE_THEOS () {0x38;}' unless defined(&MBR_PTYPE_THEOS);
    eval 'sub MBR_PTYPE_PLAN9 () {0x39;}' unless defined(&MBR_PTYPE_PLAN9);
    eval 'sub MBR_PTYPE_THEOS_4GB () {0x3a;}' unless defined(&MBR_PTYPE_THEOS_4GB);
    eval 'sub MBR_PTYPE_THEOS_EXT () {0x3b;}' unless defined(&MBR_PTYPE_THEOS_EXT);
    eval 'sub MBR_PTYPE_PMRECOVERY () {0x3c;}' unless defined(&MBR_PTYPE_PMRECOVERY);
    eval 'sub MBR_PTYPE_HID_NETWARE () {0x3d;}' unless defined(&MBR_PTYPE_HID_NETWARE);
    eval 'sub MBR_PTYPE_VENIX () {0x40;}' unless defined(&MBR_PTYPE_VENIX);
    eval 'sub MBR_PTYPE_PREP () {0x41;}' unless defined(&MBR_PTYPE_PREP);
    eval 'sub MBR_PTYPE_DRDOS_LSWAP () {0x42;}' unless defined(&MBR_PTYPE_DRDOS_LSWAP);
    eval 'sub MBR_PTYPE_DRDOS_LINUX () {0x43;}' unless defined(&MBR_PTYPE_DRDOS_LINUX);
    eval 'sub MBR_PTYPE_GOBACK () {0x44;}' unless defined(&MBR_PTYPE_GOBACK);
    eval 'sub MBR_PTYPE_BOOT_US () {0x45;}' unless defined(&MBR_PTYPE_BOOT_US);
    eval 'sub MBR_PTYPE_EUMEL_x46 () {0x46;}' unless defined(&MBR_PTYPE_EUMEL_x46);
    eval 'sub MBR_PTYPE_EUMEL_x47 () {0x47;}' unless defined(&MBR_PTYPE_EUMEL_x47);
    eval 'sub MBR_PTYPE_EUMEL_x48 () {0x48;}' unless defined(&MBR_PTYPE_EUMEL_x48);
    eval 'sub MBR_PTYPE_ALFS_THIN () {0x4a;}' unless defined(&MBR_PTYPE_ALFS_THIN);
    eval 'sub MBR_PTYPE_OBERON () {0x4c;}' unless defined(&MBR_PTYPE_OBERON);
    eval 'sub MBR_PTYPE_QNX4X () {0x4d;}' unless defined(&MBR_PTYPE_QNX4X);
    eval 'sub MBR_PTYPE_QNX4X_2 () {0x4e;}' unless defined(&MBR_PTYPE_QNX4X_2);
    eval 'sub MBR_PTYPE_QNX4X_3 () {0x4f;}' unless defined(&MBR_PTYPE_QNX4X_3);
    eval 'sub MBR_PTYPE_DM () {0x50;}' unless defined(&MBR_PTYPE_DM);
    eval 'sub MBR_PTYPE_DM6_AUX1 () {0x51;}' unless defined(&MBR_PTYPE_DM6_AUX1);
    eval 'sub MBR_PTYPE_CPM () {0x52;}' unless defined(&MBR_PTYPE_CPM);
    eval 'sub MBR_PTYPE_DM6_AUX3 () {0x53;}' unless defined(&MBR_PTYPE_DM6_AUX3);
    eval 'sub MBR_PTYPE_DM6_DDO () {0x54;}' unless defined(&MBR_PTYPE_DM6_DDO);
    eval 'sub MBR_PTYPE_EZDRIVE () {0x55;}' unless defined(&MBR_PTYPE_EZDRIVE);
    eval 'sub MBR_PTYPE_GOLDEN_BOW () {0x56;}' unless defined(&MBR_PTYPE_GOLDEN_BOW);
    eval 'sub MBR_PTYPE_DRIVE_PRO () {0x57;}' unless defined(&MBR_PTYPE_DRIVE_PRO);
    eval 'sub MBR_PTYPE_PRIAM_EDISK () {0x5c;}' unless defined(&MBR_PTYPE_PRIAM_EDISK);
    eval 'sub MBR_PTYPE_SPEEDSTOR () {0x61;}' unless defined(&MBR_PTYPE_SPEEDSTOR);
    eval 'sub MBR_PTYPE_HURD () {0x63;}' unless defined(&MBR_PTYPE_HURD);
    eval 'sub MBR_PTYPE_NOVELL_2XX () {0x64;}' unless defined(&MBR_PTYPE_NOVELL_2XX);
    eval 'sub MBR_PTYPE_NOVELL_3XX () {0x65;}' unless defined(&MBR_PTYPE_NOVELL_3XX);
    eval 'sub MBR_PTYPE_NOVELL_386 () {0x66;}' unless defined(&MBR_PTYPE_NOVELL_386);
    eval 'sub MBR_PTYPE_NOVELL_x67 () {0x67;}' unless defined(&MBR_PTYPE_NOVELL_x67);
    eval 'sub MBR_PTYPE_NOVELL_x68 () {0x68;}' unless defined(&MBR_PTYPE_NOVELL_x68);
    eval 'sub MBR_PTYPE_NOVELL_x69 () {0x69;}' unless defined(&MBR_PTYPE_NOVELL_x69);
    eval 'sub MBR_PTYPE_DISKSECURE () {0x70;}' unless defined(&MBR_PTYPE_DISKSECURE);
    eval 'sub MBR_PTYPE_RESERVED_x71 () {0x71;}' unless defined(&MBR_PTYPE_RESERVED_x71);
    eval 'sub MBR_PTYPE_RESERVED_x73 () {0x73;}' unless defined(&MBR_PTYPE_RESERVED_x73);
    eval 'sub MBR_PTYPE_RESERVED_x74 () {0x74;}' unless defined(&MBR_PTYPE_RESERVED_x74);
    eval 'sub MBR_PTYPE_PCIX () {0x75;}' unless defined(&MBR_PTYPE_PCIX);
    eval 'sub MBR_PTYPE_RESERVED_x76 () {0x76;}' unless defined(&MBR_PTYPE_RESERVED_x76);
    eval 'sub MBR_PTYPE_M2FS_M2CS () {0x77;}' unless defined(&MBR_PTYPE_M2FS_M2CS);
    eval 'sub MBR_PTYPE_XOSL_FS () {0x78;}' unless defined(&MBR_PTYPE_XOSL_FS);
    eval 'sub MBR_PTYPE_MINIX_14A () {0x80;}' unless defined(&MBR_PTYPE_MINIX_14A);
    eval 'sub MBR_PTYPE_MINIX_14B () {0x81;}' unless defined(&MBR_PTYPE_MINIX_14B);
    eval 'sub MBR_PTYPE_LNXSWAP () {0x82;}' unless defined(&MBR_PTYPE_LNXSWAP);
    eval 'sub MBR_PTYPE_LNXEXT2 () {0x83;}' unless defined(&MBR_PTYPE_LNXEXT2);
    eval 'sub MBR_PTYPE_OS2_C () {0x84;}' unless defined(&MBR_PTYPE_OS2_C);
    eval 'sub MBR_PTYPE_EXT_LNX () {0x85;}' unless defined(&MBR_PTYPE_EXT_LNX);
    eval 'sub MBR_PTYPE_NTFATVOL () {0x86;}' unless defined(&MBR_PTYPE_NTFATVOL);
    eval 'sub MBR_PTYPE_NTFSVOL () {0x87;}' unless defined(&MBR_PTYPE_NTFSVOL);
    eval 'sub MBR_PTYPE_LNX_KERNEL () {0x8a;}' unless defined(&MBR_PTYPE_LNX_KERNEL);
    eval 'sub MBR_PTYPE_FT_FAT32 () {0x8b;}' unless defined(&MBR_PTYPE_FT_FAT32);
    eval 'sub MBR_PTYPE_FT_FAT32_EXT () {0x8c;}' unless defined(&MBR_PTYPE_FT_FAT32_EXT);
    eval 'sub MBR_PTYPE_HID_FR_FD_12 () {0x8d;}' unless defined(&MBR_PTYPE_HID_FR_FD_12);
    eval 'sub MBR_PTYPE_LNX_LVM () {0x8e;}' unless defined(&MBR_PTYPE_LNX_LVM);
    eval 'sub MBR_PTYPE_HID_FR_FD_16 () {0x90;}' unless defined(&MBR_PTYPE_HID_FR_FD_16);
    eval 'sub MBR_PTYPE_HID_FR_FD_EXT () {0x91;}' unless defined(&MBR_PTYPE_HID_FR_FD_EXT);
    eval 'sub MBR_PTYPE_HID_FR_FD_16B () {0x92;}' unless defined(&MBR_PTYPE_HID_FR_FD_16B);
    eval 'sub MBR_PTYPE_AMOEBA_FS () {0x93;}' unless defined(&MBR_PTYPE_AMOEBA_FS);
    eval 'sub MBR_PTYPE_AMOEBA_BAD () {0x94;}' unless defined(&MBR_PTYPE_AMOEBA_BAD);
    eval 'sub MBR_PTYPE_MIT_EXOPC () {0x95;}' unless defined(&MBR_PTYPE_MIT_EXOPC);
    eval 'sub MBR_PTYPE_HID_FR_FD_32 () {0x97;}' unless defined(&MBR_PTYPE_HID_FR_FD_32);
    eval 'sub MBR_PTYPE_DATALIGHT () {0x98;}' unless defined(&MBR_PTYPE_DATALIGHT);
    eval 'sub MBR_PTYPE_MYLEX () {0x99;}' unless defined(&MBR_PTYPE_MYLEX);
    eval 'sub MBR_PTYPE_HID_FR_FD_16L () {0x9a;}' unless defined(&MBR_PTYPE_HID_FR_FD_16L);
    eval 'sub MBR_PTYPE_HID_FR_FD_EXL () {0x9b;}' unless defined(&MBR_PTYPE_HID_FR_FD_EXL);
    eval 'sub MBR_PTYPE_BSDI () {0x9f;}' unless defined(&MBR_PTYPE_BSDI);
    eval 'sub MBR_PTYPE_IBM_HIB () {0xa0;}' unless defined(&MBR_PTYPE_IBM_HIB);
    eval 'sub MBR_PTYPE_HP_VOL_xA1 () {0xa1;}' unless defined(&MBR_PTYPE_HP_VOL_xA1);
    eval 'sub MBR_PTYPE_HP_VOL_xA3 () {0xa3;}' unless defined(&MBR_PTYPE_HP_VOL_xA3);
    eval 'sub MBR_PTYPE_HP_VOL_xA4 () {0xa4;}' unless defined(&MBR_PTYPE_HP_VOL_xA4);
    eval 'sub MBR_PTYPE_386BSD () {0xa5;}' unless defined(&MBR_PTYPE_386BSD);
    eval 'sub MBR_PTYPE_OPENBSD () {0xa6;}' unless defined(&MBR_PTYPE_OPENBSD);
    eval 'sub MBR_PTYPE_NEXTSTEP_486 () {0xa7;}' unless defined(&MBR_PTYPE_NEXTSTEP_486);
    eval 'sub MBR_PTYPE_APPLE_UFS () {0xa8;}' unless defined(&MBR_PTYPE_APPLE_UFS);
    eval 'sub MBR_PTYPE_NETBSD () {0xa9;}' unless defined(&MBR_PTYPE_NETBSD);
    eval 'sub MBR_PTYPE_OLIVETTI () {0xaa;}' unless defined(&MBR_PTYPE_OLIVETTI);
    eval 'sub MBR_PTYPE_APPLE_BOOT () {0xab;}' unless defined(&MBR_PTYPE_APPLE_BOOT);
    eval 'sub MBR_PTYPE_SHAG_OS () {0xae;}' unless defined(&MBR_PTYPE_SHAG_OS);
    eval 'sub MBR_PTYPE_APPLE_HFS () {0xaf;}' unless defined(&MBR_PTYPE_APPLE_HFS);
    eval 'sub MBR_PTYPE_BOOTSTAR_DUM () {0xb0;}' unless defined(&MBR_PTYPE_BOOTSTAR_DUM);
    eval 'sub MBR_PTYPE_RESERVED_xB1 () {0xb1;}' unless defined(&MBR_PTYPE_RESERVED_xB1);
    eval 'sub MBR_PTYPE_RESERVED_xB3 () {0xb3;}' unless defined(&MBR_PTYPE_RESERVED_xB3);
    eval 'sub MBR_PTYPE_RESERVED_xB4 () {0xb4;}' unless defined(&MBR_PTYPE_RESERVED_xB4);
    eval 'sub MBR_PTYPE_RESERVED_xB6 () {0xb6;}' unless defined(&MBR_PTYPE_RESERVED_xB6);
    eval 'sub MBR_PTYPE_BSDI_386 () {0xb7;}' unless defined(&MBR_PTYPE_BSDI_386);
    eval 'sub MBR_PTYPE_BSDI_SWAP () {0xb8;}' unless defined(&MBR_PTYPE_BSDI_SWAP);
    eval 'sub MBR_PTYPE_BOOT_WIZARD () {0xbb;}' unless defined(&MBR_PTYPE_BOOT_WIZARD);
    eval 'sub MBR_PTYPE_SOLARIS_8 () {0xbe;}' unless defined(&MBR_PTYPE_SOLARIS_8);
    eval 'sub MBR_PTYPE_SOLARIS () {0xbf;}' unless defined(&MBR_PTYPE_SOLARIS);
    eval 'sub MBR_PTYPE_CTOS () {0xc0;}' unless defined(&MBR_PTYPE_CTOS);
    eval 'sub MBR_PTYPE_DRDOS_FAT12 () {0xc1;}' unless defined(&MBR_PTYPE_DRDOS_FAT12);
    eval 'sub MBR_PTYPE_HID_LNX () {0xc2;}' unless defined(&MBR_PTYPE_HID_LNX);
    eval 'sub MBR_PTYPE_HID_LNX_SWAP () {0xc3;}' unless defined(&MBR_PTYPE_HID_LNX_SWAP);
    eval 'sub MBR_PTYPE_DRDOS_FAT16S () {0xc4;}' unless defined(&MBR_PTYPE_DRDOS_FAT16S);
    eval 'sub MBR_PTYPE_DRDOS_EXT () {0xc5;}' unless defined(&MBR_PTYPE_DRDOS_EXT);
    eval 'sub MBR_PTYPE_DRDOS_FAT16B () {0xc6;}' unless defined(&MBR_PTYPE_DRDOS_FAT16B);
    eval 'sub MBR_PTYPE_SYRINX () {0xc7;}' unless defined(&MBR_PTYPE_SYRINX);
    eval 'sub MBR_PTYPE_DRDOS_8_xC8 () {0xc8;}' unless defined(&MBR_PTYPE_DRDOS_8_xC8);
    eval 'sub MBR_PTYPE_DRDOS_8_xC9 () {0xc9;}' unless defined(&MBR_PTYPE_DRDOS_8_xC9);
    eval 'sub MBR_PTYPE_DRDOS_8_xCA () {0xca;}' unless defined(&MBR_PTYPE_DRDOS_8_xCA);
    eval 'sub MBR_PTYPE_DRDOS_74_CHS () {0xcb;}' unless defined(&MBR_PTYPE_DRDOS_74_CHS);
    eval 'sub MBR_PTYPE_DRDOS_74_LBA () {0xcc;}' unless defined(&MBR_PTYPE_DRDOS_74_LBA);
    eval 'sub MBR_PTYPE_CTOS_MEMDUMP () {0xcd;}' unless defined(&MBR_PTYPE_CTOS_MEMDUMP);
    eval 'sub MBR_PTYPE_DRDOS_74_16X () {0xce;}' unless defined(&MBR_PTYPE_DRDOS_74_16X);
    eval 'sub MBR_PTYPE_DRDOS_74_EXT () {0xcf;}' unless defined(&MBR_PTYPE_DRDOS_74_EXT);
    eval 'sub MBR_PTYPE_REAL32 () {0xd0;}' unless defined(&MBR_PTYPE_REAL32);
    eval 'sub MBR_PTYPE_MDOS_FAT12 () {0xd1;}' unless defined(&MBR_PTYPE_MDOS_FAT12);
    eval 'sub MBR_PTYPE_MDOS_FAT16S () {0xd4;}' unless defined(&MBR_PTYPE_MDOS_FAT16S);
    eval 'sub MBR_PTYPE_MDOS_EXT () {0xd5;}' unless defined(&MBR_PTYPE_MDOS_EXT);
    eval 'sub MBR_PTYPE_MDOS_FAT16B () {0xd6;}' unless defined(&MBR_PTYPE_MDOS_FAT16B);
    eval 'sub MBR_PTYPE_CPM_86 () {0xd8;}' unless defined(&MBR_PTYPE_CPM_86);
    eval 'sub MBR_PTYPE_CONCURRENT () {0xdb;}' unless defined(&MBR_PTYPE_CONCURRENT);
    eval 'sub MBR_PTYPE_HID_CTOS_MEM () {0xdd;}' unless defined(&MBR_PTYPE_HID_CTOS_MEM);
    eval 'sub MBR_PTYPE_DELL_UTIL () {0xde;}' unless defined(&MBR_PTYPE_DELL_UTIL);
    eval 'sub MBR_PTYPE_DGUX_VIRTUAL () {0xdf;}' unless defined(&MBR_PTYPE_DGUX_VIRTUAL);
    eval 'sub MBR_PTYPE_STMICROELEC () {0xe0;}' unless defined(&MBR_PTYPE_STMICROELEC);
    eval 'sub MBR_PTYPE_DOS_ACCESS () {0xe1;}' unless defined(&MBR_PTYPE_DOS_ACCESS);
    eval 'sub MBR_PTYPE_STORDIM () {0xe3;}' unless defined(&MBR_PTYPE_STORDIM);
    eval 'sub MBR_PTYPE_SPEEDSTOR_16S () {0xe4;}' unless defined(&MBR_PTYPE_SPEEDSTOR_16S);
    eval 'sub MBR_PTYPE_RESERVED_xE5 () {0xe5;}' unless defined(&MBR_PTYPE_RESERVED_xE5);
    eval 'sub MBR_PTYPE_RESERVED_xE6 () {0xe6;}' unless defined(&MBR_PTYPE_RESERVED_xE6);
    eval 'sub MBR_PTYPE_BEOS () {0xeb;}' unless defined(&MBR_PTYPE_BEOS);
    eval 'sub MBR_PTYPE_PMBR () {0xee;}' unless defined(&MBR_PTYPE_PMBR);
    eval 'sub MBR_PTYPE_EFI () {0xef;}' unless defined(&MBR_PTYPE_EFI);
    eval 'sub MBR_PTYPE_LNX_PA_RISC () {0xf0;}' unless defined(&MBR_PTYPE_LNX_PA_RISC);
    eval 'sub MBR_PTYPE_SPEEDSTOR_X () {0xf1;}' unless defined(&MBR_PTYPE_SPEEDSTOR_X);
    eval 'sub MBR_PTYPE_DOS33_SEC () {0xf2;}' unless defined(&MBR_PTYPE_DOS33_SEC);
    eval 'sub MBR_PTYPE_RESERVED_xF3 () {0xf3;}' unless defined(&MBR_PTYPE_RESERVED_xF3);
    eval 'sub MBR_PTYPE_SPEEDSTOR_L () {0xf4;}' unless defined(&MBR_PTYPE_SPEEDSTOR_L);
    eval 'sub MBR_PTYPE_PROLOGUE () {0xf5;}' unless defined(&MBR_PTYPE_PROLOGUE);
    eval 'sub MBR_PTYPE_RESERVED_xF6 () {0xf6;}' unless defined(&MBR_PTYPE_RESERVED_xF6);
    eval 'sub MBR_PTYPE_PCACHE () {0xf9;}' unless defined(&MBR_PTYPE_PCACHE);
    eval 'sub MBR_PTYPE_BOCHS () {0xfa;}' unless defined(&MBR_PTYPE_BOCHS);
    eval 'sub MBR_PTYPE_VMWARE () {0xfb;}' unless defined(&MBR_PTYPE_VMWARE);
    eval 'sub MBR_PTYPE_VMWARE_SWAP () {0xfc;}' unless defined(&MBR_PTYPE_VMWARE_SWAP);
    eval 'sub MBR_PTYPE_LNX_RAID () {0xfd;}' unless defined(&MBR_PTYPE_LNX_RAID);
    eval 'sub MBR_PTYPE_LANSTEP () {0xfe;}' unless defined(&MBR_PTYPE_LANSTEP);
    eval 'sub MBR_PTYPE_XENIX_BAD () {0xff;}' unless defined(&MBR_PTYPE_XENIX_BAD);
    if(defined(&MBRPTYPENAMES)) {
    }
    eval 'sub MBR_PSECT {
        my($s) = @_;
	    eval q((($s) & 0x3f));
    }' unless defined(&MBR_PSECT);
    eval 'sub MBR_PCYL {
        my($c, $s) = @_;
	    eval q((($c) + ((($s) & 0xc0) << 2)));
    }' unless defined(&MBR_PCYL);
    eval 'sub MBR_IS_EXTENDED {
        my($x) = @_;
	    eval q((($x) ==  &MBR_PTYPE_EXT || ($x) ==  &MBR_PTYPE_EXT_LBA || ($x) ==  &MBR_PTYPE_EXT_LNX));
    }' unless defined(&MBR_IS_EXTENDED);
    eval 'sub MBR_BS_ACTIVE () {0x1;}' unless defined(&MBR_BS_ACTIVE);
    eval 'sub MBR_BS_EXTINT13 () {0x2;}' unless defined(&MBR_BS_EXTINT13);
    eval 'sub MBR_BS_READ_LBA () {0x4;}' unless defined(&MBR_BS_READ_LBA);
    eval 'sub MBR_BS_EXTLBA () {0x8;}' unless defined(&MBR_BS_EXTLBA);
    eval 'sub MBR_BS_ASCII () {0x10;}' unless defined(&MBR_BS_ASCII);
    eval 'sub MBR_BS_NEWMBR () {0x80;}' unless defined(&MBR_BS_NEWMBR);
    if(!defined(&__ASSEMBLER__) ) {
	eval 'sub MBR_FAT32_FATNUM () {0xf;}' unless defined(&MBR_FAT32_FATNUM);
	eval 'sub MBR_FAT32_FATMIRROR () {0x80;}' unless defined(&MBR_FAT32_FATMIRROR);
	eval 'sub MBR_FAT32_FSVERS () {0;}' unless defined(&MBR_FAT32_FSVERS);
    }
    if(!defined(&__ASSEMBLER__) ) {
	eval 'sub SHARED_BBINFO_MAXBLOCKS () {118;}' unless defined(&SHARED_BBINFO_MAXBLOCKS);
	eval 'sub bb_secsize () { $bb_data[60];}' unless defined(&bb_secsize);
	eval 'sub bb_secstart () { $bb_data[61];}' unless defined(&bb_secstart);
	eval 'sub bb_flags () { $bb_data[62];}' unless defined(&bb_flags);
	eval 'sub ALPHA_BOOT_BLOCK_OFFSET () {0;}' unless defined(&ALPHA_BOOT_BLOCK_OFFSET);
	eval 'sub ALPHA_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&ALPHA_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub ALPHA_BOOT_BLOCK_CKSUM {
	    my($bb,$cksum) = @_;
    	    eval q( &do {  &const \'struct alpha_boot_block\' * &_bb = ($bb);  &uint64_t  &_cksum; \'size_t\'  &_i;  &_cksum = 0;  &for ( &_i = 0;  &_i < ( &sizeof  ($_$bb->{bb_data}) /  &sizeof  ($_$bb->{bb_data[0]}));  &_i++)  &_cksum +=  &le64toh( ($_$bb->{bb_data[&_i]})); *($cksum) =  &htole64( &_cksum); }  &while ( 0));
	}' unless defined(&ALPHA_BOOT_BLOCK_CKSUM);
	eval 'sub APPLE_DRVR_TYPE_MACINTOSH () {1;}' unless defined(&APPLE_DRVR_TYPE_MACINTOSH);
	eval 'sub APPLE_DRVR_MAP_MAGIC () {0x4552;}' unless defined(&APPLE_DRVR_MAP_MAGIC);
	eval 'sub APPLE_DRVR_MAP_MAX_DESCRIPTORS () {61;}' unless defined(&APPLE_DRVR_MAP_MAX_DESCRIPTORS);
	eval 'sub APPLE_PART_MAP_ENTRY_MAGIC () {0x504d;}' unless defined(&APPLE_PART_MAP_ENTRY_MAGIC);
	eval 'sub APPLE_PS_VALID () {0x1;}' unless defined(&APPLE_PS_VALID);
	eval 'sub APPLE_PS_ALLOCATED () {0x2;}' unless defined(&APPLE_PS_ALLOCATED);
	eval 'sub APPLE_PS_IN_USE () {0x4;}' unless defined(&APPLE_PS_IN_USE);
	eval 'sub APPLE_PS_BOOT_INFO () {0x8;}' unless defined(&APPLE_PS_BOOT_INFO);
	eval 'sub APPLE_PS_READABLE () {0x10;}' unless defined(&APPLE_PS_READABLE);
	eval 'sub APPLE_PS_WRITABLE () {0x20;}' unless defined(&APPLE_PS_WRITABLE);
	eval 'sub APPLE_PS_BOOT_CODE_PIC () {0x40;}' unless defined(&APPLE_PS_BOOT_CODE_PIC);
	eval 'sub APPLE_PS_CC_DRVR () {0x100;}' unless defined(&APPLE_PS_CC_DRVR);
	eval 'sub APPLE_PS_RL_DRVR () {0x200;}' unless defined(&APPLE_PS_RL_DRVR);
	eval 'sub APPLE_PS_CH_DRVR () {0x400;}' unless defined(&APPLE_PS_CH_DRVR);
	eval 'sub APPLE_PS_AUTO_MOUNT () {0x40000000;}' unless defined(&APPLE_PS_AUTO_MOUNT);
	eval 'sub APPLE_PS_STARTUP () {0x80000000;}' unless defined(&APPLE_PS_STARTUP);
	eval 'sub APPLE_PART_TYPE_DRIVER () {"APPLE_DRIVER";}' unless defined(&APPLE_PART_TYPE_DRIVER);
	eval 'sub APPLE_PART_TYPE_DRIVER43 () {"APPLE_DRIVER43";}' unless defined(&APPLE_PART_TYPE_DRIVER43);
	eval 'sub APPLE_PART_TYPE_DRIVERATA () {"APPLE_DRIVER_ATA";}' unless defined(&APPLE_PART_TYPE_DRIVERATA);
	eval 'sub APPLE_PART_TYPE_DRIVERIOKIT () {"APPLE_DRIVER_IOKIT";}' unless defined(&APPLE_PART_TYPE_DRIVERIOKIT);
	eval 'sub APPLE_PART_TYPE_FWDRIVER () {"APPLE_FWDRIVER";}' unless defined(&APPLE_PART_TYPE_FWDRIVER);
	eval 'sub APPLE_PART_TYPE_FWB_COMPONENT () {"FWB DRIVER COMPONENTS";}' unless defined(&APPLE_PART_TYPE_FWB_COMPONENT);
	eval 'sub APPLE_PART_TYPE_FREE () {"APPLE_FREE";}' unless defined(&APPLE_PART_TYPE_FREE);
	eval 'sub APPLE_PART_TYPE_MAC () {"APPLE_HFS";}' unless defined(&APPLE_PART_TYPE_MAC);
	eval 'sub APPLE_PART_TYPE_NETBSD () {"NETBSD";}' unless defined(&APPLE_PART_TYPE_NETBSD);
	eval 'sub APPLE_PART_TYPE_NBSD_PPCBOOT () {"NETBSD/MACPPC";}' unless defined(&APPLE_PART_TYPE_NBSD_PPCBOOT);
	eval 'sub APPLE_PART_TYPE_NBSD_68KBOOT () {"NETBSD/MAC68K";}' unless defined(&APPLE_PART_TYPE_NBSD_68KBOOT);
	eval 'sub APPLE_PART_TYPE_PATCHES () {"APPLE_PATCHES";}' unless defined(&APPLE_PART_TYPE_PATCHES);
	eval 'sub APPLE_PART_TYPE_PARTMAP () {"APPLE_PARTITION_MAP";}' unless defined(&APPLE_PART_TYPE_PARTMAP);
	eval 'sub APPLE_PART_TYPE_PATCHES () {"APPLE_PATCHES";}' unless defined(&APPLE_PART_TYPE_PATCHES);
	eval 'sub APPLE_PART_TYPE_SCRATCH () {"APPLE_SCRATCH";}' unless defined(&APPLE_PART_TYPE_SCRATCH);
	eval 'sub APPLE_PART_TYPE_UNIX () {"APPLE_UNIX_SVR2";}' unless defined(&APPLE_PART_TYPE_UNIX);
	eval 'sub APPLE_BZB_MAGIC () {0xabadbabe;}' unless defined(&APPLE_BZB_MAGIC);
	eval 'sub APPLE_BZB_TYPEFS () {1;}' unless defined(&APPLE_BZB_TYPEFS);
	eval 'sub APPLE_BZB_TYPESWAP () {3;}' unless defined(&APPLE_BZB_TYPESWAP);
	eval 'sub APPLE_BZB_ROOTFS () {0x8000;}' unless defined(&APPLE_BZB_ROOTFS);
	eval 'sub APPLE_BZB_USRFS () {0x4000;}' unless defined(&APPLE_BZB_USRFS);
	eval 'sub EWS4800MIPS_BBINFO_MAGIC () {"NetBSD/ews4800mips     20040611";}' unless defined(&EWS4800MIPS_BBINFO_MAGIC);
	eval 'sub EWS4800MIPS_BOOT_BLOCK_OFFSET () {0;}' unless defined(&EWS4800MIPS_BOOT_BLOCK_OFFSET);
	eval 'sub EWS4800MIPS_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&EWS4800MIPS_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub EWS4800MIPS_BOOT_BLOCK_MAX_SIZE () {(512* 8);}' unless defined(&EWS4800MIPS_BOOT_BLOCK_MAX_SIZE);
	eval 'sub HP300_VOL_ID () {-32768;}' unless defined(&HP300_VOL_ID);
	eval 'sub HP300_VOL_OCT () {4096;}' unless defined(&HP300_VOL_OCT);
	eval 'sub HP300_DIR_TYPE () {-5822;}' unless defined(&HP300_DIR_TYPE);
	eval 'sub HP300_DIR_FLAG () {0x8001;}' unless defined(&HP300_DIR_FLAG);
	eval 'sub HP300_SECTSIZE () {256;}' unless defined(&HP300_SECTSIZE);
	eval 'sub HPPA_LIF_VOL_ID () {0x8000;}' unless defined(&HPPA_LIF_VOL_ID);
	eval 'sub HPPA_LIF_VOL_OCT () {0x1000;}' unless defined(&HPPA_LIF_VOL_OCT);
	eval 'sub HPPA_LIF_DIR_SWAP () {0x5243;}' unless defined(&HPPA_LIF_DIR_SWAP);
	eval 'sub HPPA_LIF_DIR_FS () {0xcd38;}' unless defined(&HPPA_LIF_DIR_FS);
	eval 'sub HPPA_LIF_DIR_IOMAP () {0xcd60;}' unless defined(&HPPA_LIF_DIR_IOMAP);
	eval 'sub HPPA_LIF_DIR_HPUX () {0xcd80;}' unless defined(&HPPA_LIF_DIR_HPUX);
	eval 'sub HPPA_LIF_DIR_ISL () {0xce00;}' unless defined(&HPPA_LIF_DIR_ISL);
	eval 'sub HPPA_LIF_DIR_PAD () {0xcffe;}' unless defined(&HPPA_LIF_DIR_PAD);
	eval 'sub HPPA_LIF_DIR_AUTO () {0xcfff;}' unless defined(&HPPA_LIF_DIR_AUTO);
	eval 'sub HPPA_LIF_DIR_EST () {0xd001;}' unless defined(&HPPA_LIF_DIR_EST);
	eval 'sub HPPA_LIF_DIR_TYPE () {0xe942;}' unless defined(&HPPA_LIF_DIR_TYPE);
	eval 'sub HPPA_LIF_DIR_FLAG () {0x8001;}' unless defined(&HPPA_LIF_DIR_FLAG);
	eval 'sub HPPA_LIF_SECTSIZE () {256;}' unless defined(&HPPA_LIF_SECTSIZE);
	eval 'sub HPPA_LIF_NUMDIR () {8;}' unless defined(&HPPA_LIF_NUMDIR);
	eval 'sub HPPA_LIF_VOLSTART () {0;}' unless defined(&HPPA_LIF_VOLSTART);
	eval 'sub HPPA_LIF_VOLSIZE () {$sizeof{\'struct hppa_lifvol\'};}' unless defined(&HPPA_LIF_VOLSIZE);
	eval 'sub HPPA_LIF_DIRSTART () {2048;}' unless defined(&HPPA_LIF_DIRSTART);
	eval 'sub HPPA_LIF_DIRSIZE () {( &HPPA_LIF_NUMDIR * $sizeof{\'struct hppa_lifdir\'});}' unless defined(&HPPA_LIF_DIRSIZE);
	eval 'sub HPPA_LIF_FILESTART () {4096;}' unless defined(&HPPA_LIF_FILESTART);
	eval 'sub hppa_btolifs {
	    my($b) = @_;
    	    eval q(((($b) + ( &HPPA_LIF_SECTSIZE - 1)) /  &HPPA_LIF_SECTSIZE));
	}' unless defined(&hppa_btolifs);
	eval 'sub hppa_lifstob {
	    my($s) = @_;
    	    eval q((($s) *  &HPPA_LIF_SECTSIZE));
	}' unless defined(&hppa_lifstob);
	eval 'sub hppa_lifstodb {
	    my($s) = @_;
    	    eval q((($s) *  &HPPA_LIF_SECTSIZE /  &DEV_BSIZE));
	}' unless defined(&hppa_lifstodb);
    }
    eval 'sub X86_BOOT_MAGIC {
        my($n) = @_;
	    eval q((ord(\'x\' << 24 | 0x86b << 12 | \'m\') << 4| ($n)));
    }' unless defined(&X86_BOOT_MAGIC);
    eval 'sub X86_BOOT_MAGIC_1 () { &X86_BOOT_MAGIC(1);}' unless defined(&X86_BOOT_MAGIC_1);
    eval 'sub X86_BOOT_MAGIC_2 () { &X86_BOOT_MAGIC(2);}' unless defined(&X86_BOOT_MAGIC_2);
    eval 'sub X86_BOOT_MAGIC_PXE () { &X86_BOOT_MAGIC(3);}' unless defined(&X86_BOOT_MAGIC_PXE);
    eval 'sub X86_BOOT_MAGIC_FAT () { &X86_BOOT_MAGIC(4);}' unless defined(&X86_BOOT_MAGIC_FAT);
    eval 'sub X86_BOOT_MAGIC_EFI () { &X86_BOOT_MAGIC(5);}' unless defined(&X86_BOOT_MAGIC_EFI);
    eval 'sub X86_MBR_GPT_MAGIC () {0xedb88320;}' unless defined(&X86_MBR_GPT_MAGIC);
    eval 'sub X86_BP_FLAGS_RESET_VIDEO () {1;}' unless defined(&X86_BP_FLAGS_RESET_VIDEO);
    eval 'sub X86_BP_FLAGS_PASSWORD () {2;}' unless defined(&X86_BP_FLAGS_PASSWORD);
    eval 'sub X86_BP_FLAGS_NOMODULES () {4;}' unless defined(&X86_BP_FLAGS_NOMODULES);
    eval 'sub X86_BP_FLAGS_NOBOOTCONF () {8;}' unless defined(&X86_BP_FLAGS_NOBOOTCONF);
    eval 'sub X86_BP_FLAGS_LBA64VALID () {0x10;}' unless defined(&X86_BP_FLAGS_LBA64VALID);
    eval 'sub X86_BP_CONSDEV_PC () {0;}' unless defined(&X86_BP_CONSDEV_PC);
    eval 'sub X86_BP_CONSDEV_COM0 () {1;}' unless defined(&X86_BP_CONSDEV_COM0);
    eval 'sub X86_BP_CONSDEV_COM1 () {2;}' unless defined(&X86_BP_CONSDEV_COM1);
    eval 'sub X86_BP_CONSDEV_COM2 () {3;}' unless defined(&X86_BP_CONSDEV_COM2);
    eval 'sub X86_BP_CONSDEV_COM3 () {4;}' unless defined(&X86_BP_CONSDEV_COM3);
    eval 'sub X86_BP_CONSDEV_COM0KBD () {5;}' unless defined(&X86_BP_CONSDEV_COM0KBD);
    eval 'sub X86_BP_CONSDEV_COM1KBD () {6;}' unless defined(&X86_BP_CONSDEV_COM1KBD);
    eval 'sub X86_BP_CONSDEV_COM2KBD () {7;}' unless defined(&X86_BP_CONSDEV_COM2KBD);
    eval 'sub X86_BP_CONSDEV_COM3KBD () {8;}' unless defined(&X86_BP_CONSDEV_COM3KBD);
    if(!defined(&__ASSEMBLER__) ) {
    }
    eval 'sub LANDISK_BOOT_MAGIC_1 () {0x20031125;}' unless defined(&LANDISK_BOOT_MAGIC_1);
    eval 'sub LANDISK_BOOT_MAGIC_2 () {0x20041110;}' unless defined(&LANDISK_BOOT_MAGIC_2);
    if(!defined(&__ASSEMBLER__) ) {
	eval 'sub MACPPC_BOOT_BLOCK_OFFSET () {2048;}' unless defined(&MACPPC_BOOT_BLOCK_OFFSET);
	eval 'sub MACPPC_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&MACPPC_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub MACPPC_BOOT_BLOCK_MAX_SIZE () {2048;}' unless defined(&MACPPC_BOOT_BLOCK_MAX_SIZE);
	eval 'sub MACPPC_BBINFO_MAGIC () {"NetBSD/macppc bootxx   20020515";}' unless defined(&MACPPC_BBINFO_MAGIC);
	eval 'sub NEWS_BOOT_BLOCK_LABELOFFSET () {64;}' unless defined(&NEWS_BOOT_BLOCK_LABELOFFSET);
	eval 'sub NEWS_BOOT_BLOCK_OFFSET () {0;}' unless defined(&NEWS_BOOT_BLOCK_OFFSET);
	eval 'sub NEWS_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&NEWS_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub NEWS_BOOT_BLOCK_MAX_SIZE () {(512* 16);}' unless defined(&NEWS_BOOT_BLOCK_MAX_SIZE);
	eval 'sub NEWS68K_BBINFO_MAGIC () {"NetBSD/news68k bootxx  20020518";}' unless defined(&NEWS68K_BBINFO_MAGIC);
	eval 'sub NEWSMIPS_BBINFO_MAGIC () {"NetBSD/newsmips bootxx 20020518";}' unless defined(&NEWSMIPS_BBINFO_MAGIC);
	eval 'sub NEXT68K_LABEL_MAXPARTITIONS () {8;}' unless defined(&NEXT68K_LABEL_MAXPARTITIONS);
	eval 'sub NEXT68K_LABEL_CPULBLLEN () {24;}' unless defined(&NEXT68K_LABEL_CPULBLLEN);
	eval 'sub NEXT68K_LABEL_MAXDNMLEN () {24;}' unless defined(&NEXT68K_LABEL_MAXDNMLEN);
	eval 'sub NEXT68K_LABEL_MAXTYPLEN () {24;}' unless defined(&NEXT68K_LABEL_MAXTYPLEN);
	eval 'sub NEXT68K_LABEL_MAXBFLEN () {24;}' unless defined(&NEXT68K_LABEL_MAXBFLEN);
	eval 'sub NEXT68K_LABEL_MAXHNLEN () {32;}' unless defined(&NEXT68K_LABEL_MAXHNLEN);
	eval 'sub NEXT68K_LABEL_MAXMPTLEN () {16;}' unless defined(&NEXT68K_LABEL_MAXMPTLEN);
	eval 'sub NEXT68K_LABEL_MAXFSTLEN () {8;}' unless defined(&NEXT68K_LABEL_MAXFSTLEN);
	eval 'sub NEXT68K_LABEL_NBAD () {1670;}' unless defined(&NEXT68K_LABEL_NBAD);
	eval 'sub NEXT68K_LABEL_cd_checksum () { &cd_checksum;}' unless defined(&NEXT68K_LABEL_cd_checksum);
	eval 'sub NEXT68K_LABEL_cd_v3_checksum () { ($cd_un->{CD_v3_checksum});}' unless defined(&NEXT68K_LABEL_cd_v3_checksum);
	eval 'sub NEXT68K_LABEL_cd_bad () { ($cd_un->{CD_bad});}' unless defined(&NEXT68K_LABEL_cd_bad);
	eval 'sub NEXT68K_LABEL_SECTOR () {0;}' unless defined(&NEXT68K_LABEL_SECTOR);
	eval 'sub NEXT68K_LABEL_OFFSET () {0;}' unless defined(&NEXT68K_LABEL_OFFSET);
	eval 'sub NEXT68K_LABEL_SIZE () {8192;}' unless defined(&NEXT68K_LABEL_SIZE);
	eval 'sub NEXT68K_LABEL_CD_V1 () {0x4e655854;}' unless defined(&NEXT68K_LABEL_CD_V1);
	eval 'sub NEXT68K_LABEL_CD_V2 () {0x646c5632;}' unless defined(&NEXT68K_LABEL_CD_V2);
	eval 'sub NEXT68K_LABEL_CD_V3 () {0x646c5633;}' unless defined(&NEXT68K_LABEL_CD_V3);
	eval 'sub NEXT68K_LABEL_DEFAULTFRONTPORCH () {(160* 2);}' unless defined(&NEXT68K_LABEL_DEFAULTFRONTPORCH);
	eval 'sub NEXT68K_LABEL_DEFAULTBOOT0_1 () {(32* 2);}' unless defined(&NEXT68K_LABEL_DEFAULTBOOT0_1);
	eval 'sub NEXT68K_LABEL_DEFAULTBOOT0_2 () {(96* 2);}' unless defined(&NEXT68K_LABEL_DEFAULTBOOT0_2);
	eval 'sub PMAX_BOOT_MAGIC () {0x2757a;}' unless defined(&PMAX_BOOT_MAGIC);
	eval 'sub PMAX_BOOTMODE_CONTIGUOUS () {0;}' unless defined(&PMAX_BOOTMODE_CONTIGUOUS);
	eval 'sub PMAX_BOOTMODE_SCATTERED () {1;}' unless defined(&PMAX_BOOTMODE_SCATTERED);
	eval 'sub PMAX_BOOT_BLOCK_OFFSET () {0;}' unless defined(&PMAX_BOOT_BLOCK_OFFSET);
	eval 'sub PMAX_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&PMAX_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub SGI_BOOT_BLOCK_SIZE_VOLHDR () {3135;}' unless defined(&SGI_BOOT_BLOCK_SIZE_VOLHDR);
	eval 'sub SGI_BOOT_BLOCK_MAGIC () {0xbe5a941;}' unless defined(&SGI_BOOT_BLOCK_MAGIC);
	eval 'sub SGI_BOOT_BLOCK_MAXPARTITIONS () {16;}' unless defined(&SGI_BOOT_BLOCK_MAXPARTITIONS);
	eval 'sub SGI_BOOT_BLOCK_MAXVOLDIRS () {15;}' unless defined(&SGI_BOOT_BLOCK_MAXVOLDIRS);
	eval 'sub SGI_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&SGI_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub SGI_PTYPE_VOLHDR () {0;}' unless defined(&SGI_PTYPE_VOLHDR);
	eval 'sub SGI_PTYPE_TRKREPL () {1;}' unless defined(&SGI_PTYPE_TRKREPL);
	eval 'sub SGI_PTYPE_SECREPL () {2;}' unless defined(&SGI_PTYPE_SECREPL);
	eval 'sub SGI_PTYPE_RAW () {3;}' unless defined(&SGI_PTYPE_RAW);
	eval 'sub SGI_PTYPE_BSD () {4;}' unless defined(&SGI_PTYPE_BSD);
	eval 'sub SGI_PTYPE_SYSV () {5;}' unless defined(&SGI_PTYPE_SYSV);
	eval 'sub SGI_PTYPE_VOLUME () {6;}' unless defined(&SGI_PTYPE_VOLUME);
	eval 'sub SGI_PTYPE_EFS () {7;}' unless defined(&SGI_PTYPE_EFS);
	eval 'sub SGI_PTYPE_LVOL () {8;}' unless defined(&SGI_PTYPE_LVOL);
	eval 'sub SGI_PTYPE_RLVOL () {9;}' unless defined(&SGI_PTYPE_RLVOL);
	eval 'sub SGI_PTYPE_XFS () {10;}' unless defined(&SGI_PTYPE_XFS);
	eval 'sub SGI_PTYPE_XFSLOG () {11;}' unless defined(&SGI_PTYPE_XFSLOG);
	eval 'sub SGI_PTYPE_XLV () {12;}' unless defined(&SGI_PTYPE_XLV);
	eval 'sub SGI_PTYPE_XVM () {13;}' unless defined(&SGI_PTYPE_XVM);
	eval 'sub SPARC_BOOT_BLOCK_OFFSET () {512;}' unless defined(&SPARC_BOOT_BLOCK_OFFSET);
	eval 'sub SPARC_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&SPARC_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub SPARC_BOOT_BLOCK_MAX_SIZE () {(512* 15);}' unless defined(&SPARC_BOOT_BLOCK_MAX_SIZE);
	eval 'sub SPARC_BBINFO_MAGIC () {"NetBSD/sparc bootxx    20020515";}' unless defined(&SPARC_BBINFO_MAGIC);
	eval 'sub SPARC64_BOOT_BLOCK_OFFSET () {512;}' unless defined(&SPARC64_BOOT_BLOCK_OFFSET);
	eval 'sub SPARC64_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&SPARC64_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub SPARC64_BOOT_BLOCK_MAX_SIZE () {(512* 15);}' unless defined(&SPARC64_BOOT_BLOCK_MAX_SIZE);
	eval 'sub SUN68K_BOOT_BLOCK_OFFSET () {512;}' unless defined(&SUN68K_BOOT_BLOCK_OFFSET);
	eval 'sub SUN68K_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&SUN68K_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub SUN68K_BOOT_BLOCK_MAX_SIZE () {(512* 15);}' unless defined(&SUN68K_BOOT_BLOCK_MAX_SIZE);
	eval 'sub SUN68K_BBINFO_MAGIC () {"NetBSD/sun68k bootxx   20020515";}' unless defined(&SUN68K_BBINFO_MAGIC);
	eval 'sub VAX_BOOT_MAGIC1 () {0x18;}' unless defined(&VAX_BOOT_MAGIC1);
	eval 'sub VAX_BOOT_VOLINFO_NONE () {0x;}' unless defined(&VAX_BOOT_VOLINFO_NONE);
	eval 'sub VAX_BOOT_VOLINFO_SS () {0x1;}' unless defined(&VAX_BOOT_VOLINFO_SS);
	eval 'sub VAX_BOOT_VOLINFO_DS () {0x81;}' unless defined(&VAX_BOOT_VOLINFO_DS);
	eval 'sub VAX_BOOT_SIZE () {15;}' unless defined(&VAX_BOOT_SIZE);
	eval 'sub VAX_BOOT_LOAD () {0;}' unless defined(&VAX_BOOT_LOAD);
	eval 'sub VAX_BOOT_ENTRY () {0x200;}' unless defined(&VAX_BOOT_ENTRY);
	eval 'sub VAX_BOOT_BLOCK_OFFSET () {0;}' unless defined(&VAX_BOOT_BLOCK_OFFSET);
	eval 'sub VAX_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&VAX_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub X68K_BOOT_BLOCK_OFFSET () {0;}' unless defined(&X68K_BOOT_BLOCK_OFFSET);
	eval 'sub X68K_BOOT_BLOCK_BLOCKSIZE () {512;}' unless defined(&X68K_BOOT_BLOCK_BLOCKSIZE);
	eval 'sub X68K_BOOT_BLOCK_MAX_SIZE () {(512* 16);}' unless defined(&X68K_BOOT_BLOCK_MAX_SIZE);
	eval 'sub X68K_BBINFO_MAGIC () {"NetBSD/x68k bootxx     20020601";}' unless defined(&X68K_BBINFO_MAGIC);
    }
}
1;
