'''OpenGL extension VERSION.GL_4_6

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_4_6 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_4_6.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_4_6 import *
from OpenGL.raw.GL.VERSION.GL_4_6 import _EXTENSION_NAME

def glInitGl46VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glSpecializeShader.pConstantIndex size not checked against numSpecializationConstants
# INPUT glSpecializeShader.pConstantValue size not checked against numSpecializationConstants
glSpecializeShader=wrapper.wrapper(glSpecializeShader).setInputArraySize(
    'pConstantIndex', None
).setInputArraySize(
    'pConstantValue', None
)
### END AUTOGENERATED SECTION