/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BaseMode
implements IMode {
    protected String name;
    protected int state;
    protected IBlockCipher cipher;
    protected int cipherBlockSize;
    protected int modeBlockSize;
    protected byte[] iv;
    protected Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(byte[] byArray, int n, byte[] byArray2, int n2) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 1: {
                    this.encryptBlock(byArray, n, byArray2, n2);
                    break;
                }
                case 2: {
                    this.decryptBlock(byArray, n, byArray2, n2);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return;
        }
    }

    public String name() {
        return this.name + '(' + this.cipher.name() + ')';
    }

    public int defaultBlockSize() {
        return this.cipherBlockSize;
    }

    public int defaultKeySize() {
        return this.cipher.defaultKeySize();
    }

    public Iterator blockSizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(this.cipherBlockSize));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Iterator keySizes() {
        return this.cipher.keySizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(Map map) throws InvalidKeyException, IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            Integer n;
            if (this.state != -1) {
                throw new IllegalStateException();
            }
            Integer n2 = (Integer)map.get("gnu.crypto.mode.state");
            if (n2 != null) {
                switch (n2) {
                    case 1: {
                        this.state = 1;
                        break;
                    }
                    case 2: {
                        this.state = 2;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.modeBlockSize = (n = (Integer)map.get("gnu.crypto.mode.block.size")) == null ? this.cipherBlockSize : n;
            byte[] byArray = (byte[])map.get("gnu.crypto.mode.iv");
            this.iv = byArray != null ? (byte[])byArray.clone() : new byte[this.modeBlockSize];
            this.cipher.init(map);
            this.setup();
            return;
        }
    }

    public int currentBlockSize() {
        if (this.state == -1) {
            throw new IllegalStateException();
        }
        return this.modeBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.state = -1;
            this.iv = null;
            this.cipher.reset();
            this.teardown();
            return;
        }
    }

    public boolean selfTest() {
        Iterator iterator = this.keySizes();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Iterator iterator2 = this.blockSizes();
            while (iterator2.hasNext()) {
                if (this.testSymmetry(n, (Integer)iterator2.next())) continue;
                return false;
            }
        }
        return true;
    }

    public abstract Object clone();

    public abstract void setup();

    public abstract void teardown();

    public abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    public abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    private final boolean testSymmetry(int n, int n2) {
        try {
            IMode iMode = (IMode)this.clone();
            byte[] byArray = new byte[this.cipherBlockSize];
            byte[] byArray2 = new byte[n];
            int n3 = 0;
            while (n3 < n) {
                byArray2[n3] = (byte)n3;
                ++n3;
            }
            int n4 = 5;
            int n5 = n4 * n2;
            byte[] byArray3 = new byte[n5];
            n3 = 0;
            while (n3 < n5) {
                byArray3[n3] = (byte)n3;
                ++n3;
            }
            byte[] byArray4 = new byte[n5];
            byte[] byArray5 = new byte[n5];
            HashMap hashMap = new HashMap();
            hashMap.put("gnu.crypto.cipher.key.material", byArray2);
            hashMap.put("gnu.crypto.cipher.block.size", new Integer(this.cipherBlockSize));
            hashMap.put("gnu.crypto.mode.state", new Integer(1));
            hashMap.put("gnu.crypto.mode.iv", byArray);
            hashMap.put("gnu.crypto.mode.block.size", new Integer(n2));
            iMode.reset();
            iMode.init(hashMap);
            n3 = 0;
            while (n3 < n4) {
                iMode.update(byArray3, n3 * n2, byArray4, n3 * n2);
                ++n3;
            }
            iMode.reset();
            hashMap.put("gnu.crypto.mode.state", new Integer(2));
            iMode.init(hashMap);
            n3 = 0;
            while (n3 < n4) {
                iMode.update(byArray4, n3 * n2, byArray5, n3 * n2);
                ++n3;
            }
            return Arrays.equals(byArray3, byArray5);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
    }

    protected BaseMode(String string, IBlockCipher iBlockCipher, int n) {
        this.this();
        this.name = string;
        this.cipher = iBlockCipher;
        this.cipherBlockSize = n;
        this.state = -1;
    }
}

