/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.DefaultTypeFactory;
import org.apache.xmlrpc.TypeFactory;
import org.apache.xmlrpc.XmlWriter;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XmlRpc
extends HandlerBase {
    public static final String version = "Apache XML-RPC 1.2-a3-dev";
    private static final String DEFAULT_PARSER = (class$uk$co$wilson$xml$MinML == null ? (class$uk$co$wilson$xml$MinML = XmlRpc.class$("uk.co.wilson.xml.MinML")) : class$uk$co$wilson$xml$MinML).getName();
    private static int maxThreads = 100;
    String methodName;
    private static Class parserClass;
    private static Hashtable saxDrivers;
    Stack values;
    Value currentValue;
    StringBuffer cdata;
    boolean readCdata;
    static final int STRING = 0;
    static final int INTEGER = 1;
    static final int BOOLEAN = 2;
    static final int DOUBLE = 3;
    static final int DATE = 4;
    static final int BASE64 = 5;
    static final int STRUCT = 6;
    static final int ARRAY = 7;
    int errorLevel;
    String errorMsg;
    static final int NONE = 0;
    static final int RECOVERABLE = 1;
    static final int FATAL = 2;
    static boolean keepalive;
    public static boolean debug;
    static final String[] types;
    static String encoding;
    private TypeFactory typeFactory;
    static /* synthetic */ Class class$uk$co$wilson$xml$MinML;
    static /* synthetic */ Class class$org$apache$xmlrpc$TypeFactory;
    static /* synthetic */ Class class$org$apache$xmlrpc$DefaultTypeFactory;

    protected XmlRpc() {
        this(System.getProperty((class$org$apache$xmlrpc$TypeFactory == null ? (class$org$apache$xmlrpc$TypeFactory = XmlRpc.class$("org.apache.xmlrpc.TypeFactory")) : class$org$apache$xmlrpc$TypeFactory).getName()));
    }

    protected XmlRpc(String string) {
        Class<?> clazz = null;
        if (string != null && string.length() > 0) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Error loading TypeFactory specified by the " + (class$org$apache$xmlrpc$TypeFactory == null ? (class$org$apache$xmlrpc$TypeFactory = XmlRpc.class$("org.apache.xmlrpc.TypeFactory")) : class$org$apache$xmlrpc$TypeFactory).getName() + " property, using default instead: " + classNotFoundException.getMessage());
            }
        }
        this.typeFactory = this.createTypeFactory(clazz);
    }

    private TypeFactory createTypeFactory(Class clazz) {
        if (clazz == null || (class$org$apache$xmlrpc$DefaultTypeFactory == null ? (class$org$apache$xmlrpc$DefaultTypeFactory = XmlRpc.class$("org.apache.xmlrpc.DefaultTypeFactory")) : class$org$apache$xmlrpc$DefaultTypeFactory).equals(clazz)) {
            return new DefaultTypeFactory();
        }
        try {
            return (TypeFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Unable to create configured TypeFactory '" + clazz.getName() + "': " + exception.getMessage() + ": Using default");
            return this.createTypeFactory(null);
        }
    }

    public static void setDriver(String string) throws ClassNotFoundException {
        String string2 = null;
        try {
            string2 = (String)saxDrivers.get(string);
            if (string2 == null) {
                string2 = string;
            }
            parserClass = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException("SAX driver not found: " + string2);
        }
    }

    public static void setDriver(Class clazz) {
        parserClass = clazz;
    }

    public static void setEncoding(String string) {
        encoding = string;
    }

    public String getEncoding() {
        return XmlWriter.canonicalizeEncoding(encoding);
    }

    public static int getMaxThreads() {
        return maxThreads;
    }

    public static void setMaxThreads(int n) {
        maxThreads = n;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static void setKeepAlive(boolean bl) {
        keepalive = bl;
    }

    public static boolean getKeepAlive() {
        return keepalive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void parse(InputStream inputStream) throws Exception {
        Object object;
        this.errorLevel = 0;
        this.errorMsg = null;
        this.values = new Stack();
        if (this.cdata == null) {
            this.cdata = new StringBuffer(128);
        } else {
            this.cdata.setLength(0);
        }
        this.readCdata = false;
        this.currentValue = null;
        long l = System.currentTimeMillis();
        if (parserClass == null) {
            try {
                object = System.getProperty("sax.driver", DEFAULT_PARSER);
            }
            catch (SecurityException securityException) {
                object = DEFAULT_PARSER;
            }
            XmlRpc.setDriver((String)object);
        }
        object = null;
        try {
            object = (Parser)parserClass.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new Exception("Can't create Parser: " + parserClass);
        }
        object.setDocumentHandler(this);
        object.setErrorHandler(this);
        if (debug) {
            System.out.println("Beginning parsing XML input stream");
        }
        try {
            object.parse(new InputSource(inputStream));
            Object var7_6 = null;
            if (this.cdata.length() > 512) {
                this.cdata = null;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.cdata.length() > 512) {
                this.cdata = null;
            }
            throw throwable;
        }
        if (debug) {
            System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis parsing");
        }
    }

    protected abstract void objectParsed(Object var1);

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.readCdata) {
            this.cdata.append(cArray, n, n2);
        }
    }

    public void endElement(String string) throws SAXException {
        int n;
        if (debug) {
            System.out.println("endElement: " + string);
        }
        if (this.currentValue != null && this.readCdata) {
            this.currentValue.characterData(this.cdata.toString());
            this.cdata.setLength(0);
            this.readCdata = false;
        }
        if ("value".equals(string) && ((n = this.values.size()) < 2 || this.values.elementAt(n - 2).hashCode() != 6)) {
            Value value = this.currentValue;
            this.values.pop();
            if (n < 2) {
                this.objectParsed(value.value);
                this.currentValue = null;
            } else {
                this.currentValue = (Value)this.values.peek();
                this.currentValue.endElement(value);
            }
        }
        if ("member".equals(string)) {
            Value value = this.currentValue;
            this.values.pop();
            this.currentValue = (Value)this.values.peek();
            this.currentValue.endElement(value);
        } else if ("methodName".equals(string)) {
            this.methodName = this.cdata.toString();
            this.cdata.setLength(0);
            this.readCdata = false;
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (debug) {
            System.out.println("startElement: " + string);
        }
        if ("value".equals(string)) {
            Value value = new Value();
            this.values.push(value);
            this.currentValue = value;
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("methodName".equals(string)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("name".equals(string)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("string".equals(string)) {
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("i4".equals(string) || "int".equals(string)) {
            this.currentValue.setType(1);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("boolean".equals(string)) {
            this.currentValue.setType(2);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("double".equals(string)) {
            this.currentValue.setType(3);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("dateTime.iso8601".equals(string)) {
            this.currentValue.setType(4);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("base64".equals(string)) {
            this.currentValue.setType(5);
            this.cdata.setLength(0);
            this.readCdata = true;
        } else if ("struct".equals(string)) {
            this.currentValue.setType(6);
        } else if ("array".equals(string)) {
            this.currentValue.setType(7);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Error parsing XML: " + sAXParseException);
        this.errorLevel = 1;
        this.errorMsg = sAXParseException.toString();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Fatal error parsing XML: " + sAXParseException);
        this.errorLevel = 2;
        this.errorMsg = sAXParseException.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        saxDrivers = new Hashtable(8);
        saxDrivers.put("xerces", "org.apache.xerces.parsers.SAXParser");
        saxDrivers.put("xp", "com.jclark.xml.sax.Driver");
        saxDrivers.put("ibm1", "com.ibm.xml.parser.SAXDriver");
        saxDrivers.put("ibm2", "com.ibm.xml.parsers.SAXParser");
        saxDrivers.put("aelfred", "com.microstar.xml.SAXDriver");
        saxDrivers.put("oracle1", "oracle.xml.parser.XMLParser");
        saxDrivers.put("oracle2", "oracle.xml.parser.v2.SAXParser");
        saxDrivers.put("openxml", "org.openxml.parser.XMLSAXParser");
        keepalive = false;
        debug = false;
        types = new String[]{"String", "Integer", "Boolean", "Double", "Date", "Base64", "Struct", "Array"};
        encoding = "ISO8859_1";
    }

    class Value {
        int type = 0;
        Object value;
        String nextMemberName;
        Hashtable struct;
        Vector array;

        public void endElement(Value value) {
            switch (this.type) {
                case 7: {
                    this.array.addElement(value.value);
                    break;
                }
                case 6: {
                    this.struct.put(this.nextMemberName, value.value);
                }
            }
        }

        public void setType(int n) {
            this.type = n;
            switch (n) {
                case 7: {
                    this.value = this.array = new Vector();
                    break;
                }
                case 6: {
                    this.value = this.struct = new Hashtable();
                }
            }
        }

        public void characterData(String string) {
            switch (this.type) {
                case 1: {
                    this.value = XmlRpc.this.typeFactory.createInteger(string);
                    break;
                }
                case 2: {
                    this.value = XmlRpc.this.typeFactory.createBoolean(string);
                    break;
                }
                case 3: {
                    this.value = XmlRpc.this.typeFactory.createDouble(string);
                    break;
                }
                case 4: {
                    this.value = XmlRpc.this.typeFactory.createDate(string);
                    break;
                }
                case 5: {
                    this.value = XmlRpc.this.typeFactory.createBase64(string);
                    break;
                }
                case 0: {
                    this.value = XmlRpc.this.typeFactory.createString(string);
                    break;
                }
                case 6: {
                    this.nextMemberName = string;
                }
            }
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            return types[this.type] + " element " + this.value;
        }
    }
}

