<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dfareporting;

class FloodlightActivity extends \Google\Collection
{
  protected $collection_key = 'userDefinedVariableTypes';
  public $accountId;
  public $advertiserId;
  protected $advertiserIdDimensionValueType = DimensionValue::class;
  protected $advertiserIdDimensionValueDataType = '';
  public $attributionEnabled;
  public $cacheBustingType;
  public $countingMethod;
  protected $defaultTagsType = FloodlightActivityDynamicTag::class;
  protected $defaultTagsDataType = 'array';
  public $expectedUrl;
  public $floodlightActivityGroupId;
  public $floodlightActivityGroupName;
  public $floodlightActivityGroupTagString;
  public $floodlightActivityGroupType;
  public $floodlightConfigurationId;
  protected $floodlightConfigurationIdDimensionValueType = DimensionValue::class;
  protected $floodlightConfigurationIdDimensionValueDataType = '';
  public $floodlightTagType;
  public $id;
  protected $idDimensionValueType = DimensionValue::class;
  protected $idDimensionValueDataType = '';
  public $kind;
  public $name;
  public $notes;
  protected $publisherTagsType = FloodlightActivityPublisherDynamicTag::class;
  protected $publisherTagsDataType = 'array';
  public $secure;
  public $sslCompliant;
  public $sslRequired;
  public $status;
  public $subaccountId;
  public $tagFormat;
  public $tagString;
  public $userDefinedVariableTypes;

  public function setAccountId($accountId)
  {
    $this->accountId = $accountId;
  }
  public function getAccountId()
  {
    return $this->accountId;
  }
  public function setAdvertiserId($advertiserId)
  {
    $this->advertiserId = $advertiserId;
  }
  public function getAdvertiserId()
  {
    return $this->advertiserId;
  }
  /**
   * @param DimensionValue
   */
  public function setAdvertiserIdDimensionValue(DimensionValue $advertiserIdDimensionValue)
  {
    $this->advertiserIdDimensionValue = $advertiserIdDimensionValue;
  }
  /**
   * @return DimensionValue
   */
  public function getAdvertiserIdDimensionValue()
  {
    return $this->advertiserIdDimensionValue;
  }
  public function setAttributionEnabled($attributionEnabled)
  {
    $this->attributionEnabled = $attributionEnabled;
  }
  public function getAttributionEnabled()
  {
    return $this->attributionEnabled;
  }
  public function setCacheBustingType($cacheBustingType)
  {
    $this->cacheBustingType = $cacheBustingType;
  }
  public function getCacheBustingType()
  {
    return $this->cacheBustingType;
  }
  public function setCountingMethod($countingMethod)
  {
    $this->countingMethod = $countingMethod;
  }
  public function getCountingMethod()
  {
    return $this->countingMethod;
  }
  /**
   * @param FloodlightActivityDynamicTag[]
   */
  public function setDefaultTags($defaultTags)
  {
    $this->defaultTags = $defaultTags;
  }
  /**
   * @return FloodlightActivityDynamicTag[]
   */
  public function getDefaultTags()
  {
    return $this->defaultTags;
  }
  public function setExpectedUrl($expectedUrl)
  {
    $this->expectedUrl = $expectedUrl;
  }
  public function getExpectedUrl()
  {
    return $this->expectedUrl;
  }
  public function setFloodlightActivityGroupId($floodlightActivityGroupId)
  {
    $this->floodlightActivityGroupId = $floodlightActivityGroupId;
  }
  public function getFloodlightActivityGroupId()
  {
    return $this->floodlightActivityGroupId;
  }
  public function setFloodlightActivityGroupName($floodlightActivityGroupName)
  {
    $this->floodlightActivityGroupName = $floodlightActivityGroupName;
  }
  public function getFloodlightActivityGroupName()
  {
    return $this->floodlightActivityGroupName;
  }
  public function setFloodlightActivityGroupTagString($floodlightActivityGroupTagString)
  {
    $this->floodlightActivityGroupTagString = $floodlightActivityGroupTagString;
  }
  public function getFloodlightActivityGroupTagString()
  {
    return $this->floodlightActivityGroupTagString;
  }
  public function setFloodlightActivityGroupType($floodlightActivityGroupType)
  {
    $this->floodlightActivityGroupType = $floodlightActivityGroupType;
  }
  public function getFloodlightActivityGroupType()
  {
    return $this->floodlightActivityGroupType;
  }
  public function setFloodlightConfigurationId($floodlightConfigurationId)
  {
    $this->floodlightConfigurationId = $floodlightConfigurationId;
  }
  public function getFloodlightConfigurationId()
  {
    return $this->floodlightConfigurationId;
  }
  /**
   * @param DimensionValue
   */
  public function setFloodlightConfigurationIdDimensionValue(DimensionValue $floodlightConfigurationIdDimensionValue)
  {
    $this->floodlightConfigurationIdDimensionValue = $floodlightConfigurationIdDimensionValue;
  }
  /**
   * @return DimensionValue
   */
  public function getFloodlightConfigurationIdDimensionValue()
  {
    return $this->floodlightConfigurationIdDimensionValue;
  }
  public function setFloodlightTagType($floodlightTagType)
  {
    $this->floodlightTagType = $floodlightTagType;
  }
  public function getFloodlightTagType()
  {
    return $this->floodlightTagType;
  }
  public function setId($id)
  {
    $this->id = $id;
  }
  public function getId()
  {
    return $this->id;
  }
  /**
   * @param DimensionValue
   */
  public function setIdDimensionValue(DimensionValue $idDimensionValue)
  {
    $this->idDimensionValue = $idDimensionValue;
  }
  /**
   * @return DimensionValue
   */
  public function getIdDimensionValue()
  {
    return $this->idDimensionValue;
  }
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  public function getKind()
  {
    return $this->kind;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  public function setNotes($notes)
  {
    $this->notes = $notes;
  }
  public function getNotes()
  {
    return $this->notes;
  }
  /**
   * @param FloodlightActivityPublisherDynamicTag[]
   */
  public function setPublisherTags($publisherTags)
  {
    $this->publisherTags = $publisherTags;
  }
  /**
   * @return FloodlightActivityPublisherDynamicTag[]
   */
  public function getPublisherTags()
  {
    return $this->publisherTags;
  }
  public function setSecure($secure)
  {
    $this->secure = $secure;
  }
  public function getSecure()
  {
    return $this->secure;
  }
  public function setSslCompliant($sslCompliant)
  {
    $this->sslCompliant = $sslCompliant;
  }
  public function getSslCompliant()
  {
    return $this->sslCompliant;
  }
  public function setSslRequired($sslRequired)
  {
    $this->sslRequired = $sslRequired;
  }
  public function getSslRequired()
  {
    return $this->sslRequired;
  }
  public function setStatus($status)
  {
    $this->status = $status;
  }
  public function getStatus()
  {
    return $this->status;
  }
  public function setSubaccountId($subaccountId)
  {
    $this->subaccountId = $subaccountId;
  }
  public function getSubaccountId()
  {
    return $this->subaccountId;
  }
  public function setTagFormat($tagFormat)
  {
    $this->tagFormat = $tagFormat;
  }
  public function getTagFormat()
  {
    return $this->tagFormat;
  }
  public function setTagString($tagString)
  {
    $this->tagString = $tagString;
  }
  public function getTagString()
  {
    return $this->tagString;
  }
  public function setUserDefinedVariableTypes($userDefinedVariableTypes)
  {
    $this->userDefinedVariableTypes = $userDefinedVariableTypes;
  }
  public function getUserDefinedVariableTypes()
  {
    return $this->userDefinedVariableTypes;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FloodlightActivity::class, 'Google_Service_Dfareporting_FloodlightActivity');
