# -*- encoding: utf-8 -*-

require File.dirname(__FILE__) + '/helper.rb'

class TestTraditional < Test::Unit::TestCase

  T = Color::RGB::JP::Traditional

  def test_alias
    assert_same(Color::RGB::JP::Traditional, Color::RGB::JP::Trad)
  end

  def test_bracket_utf8
    assert_equal(T::SakuraIro, T["sakurairo"])
    assert_equal(T::SakuraIro, T["SakuraIro"])
    assert_equal(T::SakuraIro, T["Sakura-Iro"])

    assert_equal(T::SakuraIro, T[Fixture::UTF_8::SakuraIroKanji])
    assert_equal(T::SakuraIro, T[Fixture::UTF_8::SakuraIroHiragana])
    assert_equal(T::SakuraIro, T[Fixture::UTF_8::SakuraIroKatakana])

    assert_equal(T::SakuraIro, T[Fixture::UTF_8::SakuraIroKanji, "UTF-8"])
    assert_equal(T::SakuraIro, T[Fixture::UTF_8::SakuraIroHiragana, "UTF-8"])
    assert_equal(T::SakuraIro, T[Fixture::UTF_8::SakuraIroKatakana, "UTF-8"])
  end

  def test_bracket_sjis
    assert_equal(T::SakuraIro, T[Fixture::Shift_JIS::SakuraIroKanji, "Shift_JIS"])
    assert_equal(T::SakuraIro, T[Fixture::Shift_JIS::SakuraIroHiragana, "Shift_JIS"])
    assert_equal(T::SakuraIro, T[Fixture::Shift_JIS::SakuraIroKatakana, "Shift_JIS"])
  end

  def test_bracket_eucjp
    assert_equal(T::SakuraIro, T[Fixture::EUC_JP::SakuraIroKanji, "EUC-JP"])
    assert_equal(T::SakuraIro, T[Fixture::EUC_JP::SakuraIroHiragana, "EUC-JP"])
    assert_equal(T::SakuraIro, T[Fixture::EUC_JP::SakuraIroKatakana, "EUC-JP"])
  end

end
