/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.file;

import gnu.classpath.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Connection
extends URLConnection {
    private static final String DEFAULT_PERMISSION = "read";
    private File file;
    private byte[] directoryListing;
    private InputStream inputStream;
    private OutputStream outputStream;
    private FilePermission permission = new FilePermission(this.getURL().getFile(), "read");

    public static String unquote(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length() * 3];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            char c = string.charAt(n2);
            if (c == '%') {
                if (n2 + 2 >= string.length()) {
                    throw new MalformedURLException(string + " : Invalid quoted character");
                }
                int n4 = Character.digit(string.charAt(++n2), 16);
                if ((n3 = Character.digit(string.charAt(++n2), 16)) < 0 || n4 < 0) {
                    throw new MalformedURLException(string + " : Invalid quoted character");
                }
                byArray[n++] = (byte)(n4 * 16 + n3);
            } else if (c > '\u007f') {
                try {
                    byte[] byArray2 = Character.toString(c).getBytes("utf-8");
                    n3 = byArray2.length;
                    System.arraycopy(byArray2, 0, byArray, n, n3);
                    n += n3;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw (Error)new InternalError().initCause(unsupportedEncodingException);
                }
            } else {
                byArray[n++] = (byte)c;
            }
            ++n2;
        }
        try {
            return new String(byArray, 0, n, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (Error)new InternalError().initCause(unsupportedEncodingException);
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.file = new File(Connection.unquote(this.getURL().getFile()));
        if (!this.file.isDirectory()) {
            if (this.doInput) {
                this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
            }
            if (this.doOutput) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            }
        } else {
            if (this.doInput) {
                this.inputStream = new ByteArrayInputStream(this.getDirectoryListing());
            }
            if (this.doOutput) {
                throw new ProtocolException("file: protocol does not support output on directories");
            }
        }
        this.connected = true;
    }

    byte[] getDirectoryListing() throws IOException {
        if (this.directoryListing == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            String[] stringArray = this.file.list();
            int n = 0;
            while (n < stringArray.length) {
                outputStreamWriter.write(stringArray[n]);
                outputStreamWriter.write(StaticData.lineSeparator);
                ++n;
            }
            this.directoryListing = byteArrayOutputStream.toByteArray();
        }
        return this.directoryListing;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.outputStream;
    }

    public long getLastModified() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.file.lastModified();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHeaderField(String string) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (string.equals("content-type")) {
                return Connection.guessContentTypeFromName(this.file.getName());
            }
            if (string.equals("content-length")) {
                if (!this.file.isDirectory()) return Long.toString(this.file.length());
                return Integer.toString(this.getContentLength());
            }
            if (!string.equals("last-modified")) return null;
            SimpleDateFormat simpleDateFormat = StaticData.dateFormat;
            synchronized (simpleDateFormat) {
                return StaticData.dateFormat.format(new Date(this.file.lastModified()));
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (this.file.isDirectory()) {
                return this.getDirectoryListing().length;
            }
            return (int)this.file.length();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Permission getPermission() throws IOException {
        return this.permission;
    }

    public Connection(URL uRL) {
        super(uRL);
    }

    private static class StaticData {
        static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", new Locale("En", "Us", "Unix"));
        static String lineSeparator = SystemProperties.getProperty("line.separator");

        private StaticData() {
        }
    }
}

