/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.properties.DefaultPropertyTypeResolver;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.internal.tasks.properties.ScriptSourceAwareImplementationResolver;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.properties.annotations.DefaultTypeMetadataStore;
import org.gradle.internal.properties.annotations.MissingPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.NoOpPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyTypeResolver;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.bean.DefaultPropertyWalker;
import org.gradle.internal.properties.bean.ImplementationResolver;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class InspectionSchemeFactory {
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> allKnownPropertyHandlers;
    private final ImmutableList<TypeAnnotationHandler> allKnownTypeHandlers;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final CrossBuildInMemoryCacheFactory cacheFactory;

    public InspectionSchemeFactory(List<? extends TypeAnnotationHandler> allKnownTypeHandlers, List<? extends PropertyAnnotationHandler> allKnownPropertyHandlers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PropertyAnnotationHandler propertyAnnotationHandler : allKnownPropertyHandlers) {
            builder.put((Object)propertyAnnotationHandler.getAnnotationType(), (Object)propertyAnnotationHandler);
        }
        this.allKnownTypeHandlers = ImmutableList.copyOf(allKnownTypeHandlers);
        this.allKnownPropertyHandlers = builder.build();
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.cacheFactory = cacheFactory;
    }

    public InspectionScheme inspectionScheme(Collection<Class<? extends Annotation>> annotations, Collection<Class<? extends Annotation>> propertyModifiers, InstantiationScheme instantiationScheme) {
        return this.inspectionScheme(annotations, propertyModifiers, instantiationScheme, MissingPropertyAnnotationHandler.MISSING_INPUT_OUTPUT_HANDLER);
    }

    public InspectionScheme inspectionScheme(Collection<Class<? extends Annotation>> annotations, Collection<Class<? extends Annotation>> propertyModifiers, InstantiationScheme instantiationScheme, MissingPropertyAnnotationHandler missingAnnotationProblemHandler) {
        ImmutableList.Builder propertyHandlers = ImmutableList.builderWithExpectedSize((int)annotations.size());
        for (Class<? extends Annotation> annotation : annotations) {
            PropertyAnnotationHandler propertyHandler = this.allKnownPropertyHandlers.get(annotation);
            if (propertyHandler == null) {
                throw new IllegalArgumentException(String.format("@%s is not a registered property type annotation.", annotation.getSimpleName()));
            }
            propertyHandlers.add((Object)propertyHandler);
        }
        for (Class<? extends Annotation> annotation : instantiationScheme.getInjectionAnnotations()) {
            if (annotations.contains(annotation)) continue;
            propertyHandlers.add((Object)new NoOpPropertyAnnotationHandler(annotation));
        }
        return new InspectionSchemeImpl((List<TypeAnnotationHandler>)this.allKnownTypeHandlers, (List<PropertyAnnotationHandler>)propertyHandlers.build(), propertyModifiers, this.typeAnnotationMetadataStore, this.cacheFactory, missingAnnotationProblemHandler);
    }

    private static class InspectionSchemeImpl
    implements InspectionScheme {
        private final DefaultPropertyWalker propertyWalker;
        private final DefaultTypeMetadataStore metadataStore;

        public InspectionSchemeImpl(List<TypeAnnotationHandler> typeHandlers, List<PropertyAnnotationHandler> propertyHandlers, Collection<Class<? extends Annotation>> propertyModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory, MissingPropertyAnnotationHandler missingAnnotationProblemHandler) {
            DefaultPropertyTypeResolver propertyTypeResolver = new DefaultPropertyTypeResolver();
            this.metadataStore = new DefaultTypeMetadataStore(typeHandlers, propertyHandlers, propertyModifiers, typeAnnotationMetadataStore, (PropertyTypeResolver)propertyTypeResolver, cacheFactory, missingAnnotationProblemHandler);
            this.propertyWalker = new DefaultPropertyWalker((TypeMetadataStore)this.metadataStore, (ImplementationResolver)new ScriptSourceAwareImplementationResolver(), propertyHandlers);
        }

        @Override
        public TypeMetadataStore getMetadataStore() {
            return this.metadataStore;
        }

        @Override
        public PropertyWalker getPropertyWalker() {
            return this.propertyWalker;
        }
    }
}

