/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.EvaluationContext;
import org.gradle.api.internal.provider.OrElseValueProducer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;

class OrElseFixedValueProvider<T>
extends AbstractProviderWithValue<T> {
    private final ProviderInternal<? extends T> provider;
    private final T fallbackValue;

    public OrElseFixedValueProvider(ProviderInternal<? extends T> provider, T fallbackValue) {
        this.provider = provider;
        this.fallbackValue = fallbackValue;
    }

    @Override
    protected String toStringNoReentrance() {
        return String.format("or(%s, fixed(%s))", this.provider, this.fallbackValue);
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return (Class)Cast.uncheckedCast(this.provider.getType());
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        try (EvaluationContext.ScopeContext context = this.openScope();){
            OrElseValueProducer orElseValueProducer = new OrElseValueProducer(context, this.provider);
            return orElseValueProducer;
        }
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        try (EvaluationContext.ScopeContext ignored = this.openScope();){
            ValueSupplier.ExecutionTimeValue<T> value = this.provider.calculateExecutionTimeValue();
            if (value.isMissing()) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = ValueSupplier.ExecutionTimeValue.fixedValue(this.fallbackValue);
                return executionTimeValue;
            }
            if (value.hasFixedValue()) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = value;
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<? extends T> executionTimeValue = ValueSupplier.ExecutionTimeValue.changingValue(new OrElseFixedValueProvider<T>(value.getChangingValue(), this.fallbackValue));
            return executionTimeValue;
        }
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationContext.ScopeContext ignored = this.openScope();){
            ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
            if (value.isMissing()) {
                ValueSupplier.Value<T> value2 = ValueSupplier.Value.of(this.fallbackValue);
                return value2;
            }
            ValueSupplier.Value<T> value3 = value;
            return value3;
        }
    }
}

