/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.StringTokenizer;

class TransformerOutputProperties
extends Properties {
    final Properties defaultProperties;
    final Stylesheet stylesheet;
    boolean dirty;

    public String getProperty(String string) {
        String string2 = super.getProperty(string);
        if (string2 == null) {
            string2 = this.defaultProperties.getProperty(string);
        }
        return string2;
    }

    public Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        this.dirty = true;
        return object3;
    }

    public void clear() {
        super.clear();
        this.dirty = true;
    }

    void apply() {
        if (!this.dirty) {
            return;
        }
        String string = this.getProperty("method");
        if ("xml".equals(string)) {
            this.stylesheet.outputMethod = 0;
        } else if ("html".equals(string)) {
            this.stylesheet.outputMethod = 1;
        } else if ("text".equals(string)) {
            this.stylesheet.outputMethod = 2;
        }
        this.stylesheet.outputVersion = this.getProperty("version");
        this.stylesheet.outputEncoding = this.getProperty("encoding");
        this.stylesheet.outputOmitXmlDeclaration = "yes".equals(this.getProperty("omit-xml-declaration"));
        this.stylesheet.outputStandalone = "yes".equals(this.getProperty("standalone"));
        this.stylesheet.outputPublicId = this.getProperty("doctype-public");
        this.stylesheet.outputSystemId = this.getProperty("doctype-system");
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProperty("cdata-section-elements"));
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(stringTokenizer.nextToken());
        }
        this.stylesheet.outputCdataSectionElements = linkedHashSet;
        this.stylesheet.outputIndent = "yes".equals(this.getProperty("indent"));
        this.stylesheet.outputMediaType = this.getProperty("media-type");
        this.dirty = false;
    }

    TransformerOutputProperties(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
        this.defaultProperties = new Properties();
        switch (stylesheet.outputMethod) {
            case 0: {
                this.defaultProperties.put("method", "xml");
                break;
            }
            case 1: {
                this.defaultProperties.put("method", "html");
                break;
            }
            case 2: {
                this.defaultProperties.put("method", "text");
                break;
            }
        }
        if (stylesheet.outputVersion != null) {
            this.defaultProperties.put("version", stylesheet.outputVersion);
        }
        if (stylesheet.outputEncoding != null) {
            this.defaultProperties.put("encoding", stylesheet.outputEncoding);
        }
        this.defaultProperties.put("omit-xml-declaration", stylesheet.outputOmitXmlDeclaration ? "yes" : "no");
        this.defaultProperties.put("standalone", stylesheet.outputStandalone ? "yes" : "no");
        if (stylesheet.outputPublicId != null) {
            this.defaultProperties.put("doctype-public", stylesheet.outputPublicId);
        }
        if (stylesheet.outputSystemId != null) {
            this.defaultProperties.put("doctype-system", stylesheet.outputSystemId);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = stylesheet.outputCdataSectionElements.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append((String)iterator.next());
        }
        this.defaultProperties.put("cdata-section-elements", stringBuffer.toString());
        this.defaultProperties.put("indent", stylesheet.outputIndent ? "yes" : "no");
        if (stylesheet.outputMediaType != null) {
            this.defaultProperties.put("media-type", stylesheet.outputMediaType);
        }
    }
}

