/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class UnsignedIntType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};
    static final String MAX_VALUE = "4294967295";
    static final int LENGTH = "4294967295".length();

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        if (n == 0) {
            throw new DatatypeException(0, "invalid unsigned int value");
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c;
            if (n - n2 > LENGTH) {
                throw new DatatypeException(n2, "invalid unsigned int value");
            }
            if (n - n2 == LENGTH) {
                bl = true;
            }
            if ((c = string.charAt(n2)) >= '0' && c <= '9') {
                if (bl) {
                    char c2 = MAX_VALUE.charAt(n2);
                    if (Character.digit(c, 10) > Character.digit(c2, 10)) {
                        throw new DatatypeException(n2, "invalid unsigned int value");
                    }
                }
            } else {
                throw new DatatypeException(n2, "invalid unsigned int value");
            }
            ++n2;
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    UnsignedIntType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt"), TypeLibrary.UNSIGNED_LONG);
    }
}

