#!/bin/sh

#if [ x"$XDG_CONFIG_HOME" = x"" ] ; then
if [ x"$CHOICESPATH" = x"" ] ; then
  XDG_CONFIG_HOME="$HOME/.config"
else
  XDG_CONFIG_HOME=`echo $CHOICESPATH | sed s/:.*//`
fi
#fi

# Ensure theme is cached, or window manager may freeze while loading it...
echo < `dirname $0`/themerc > /dev/null

[ -d "$XDG_CONFIG_HOME/OroboROX" ] || mkdir -p "$XDG_CONFIG_HOME"/OroboROX
cd "$XDG_CONFIG_HOME"/OroboROX || exit 1

dirname "$0" > current_theme

orobopid=`xprop -root _NET_WM_PID | cut -d' ' -f3`
kill -HUP $orobopid
