/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.CharIndexedString;
import gnu.regexp.CharIndexedStringBuffer;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenEndSub;
import gnu.regexp.RETokenLookAhead;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import gnu.regexp.RETokenWordBoundary;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class RE
extends REToken {
    private static final String VERSION = "1.1.5-dev";
    private static ResourceBundle messages = PropertyResourceBundle.getBundle("gnu/regexp/MessagesBundle", Locale.getDefault());
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;
    public static final int REG_NO_INTERPOLATE = 128;
    private REToken firstToken;
    private REToken lastToken;
    private int numSubs;
    private int minimumLength;

    public static final String version() {
        return VERSION;
    }

    static final String getLocalizedMessage(String key) {
        return messages.getString(key);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void initialize(Object patternObj, int cflags, RESyntax syntax, int myIndex, int nextSub) throws REException {
        if (patternObj instanceof String) {
            pattern = ((String)patternObj).toCharArray();
        } else if (patternObj instanceof char[]) {
            pattern = (char[])patternObj;
        } else if (patternObj instanceof StringBuffer) {
            pattern = new char[((StringBuffer)patternObj).length()];
            ((StringBuffer)patternObj).getChars(0, pattern.length, pattern, 0);
        } else {
            pattern = patternObj.toString().toCharArray();
        }
        pLength = pattern.length;
        this.numSubs = 0;
        branches = null;
        this.lastToken = null;
        this.firstToken = null;
        v0 = false;
        if ((cflags & 2) > 0) {
            v0 = true;
        }
        insens = v0;
        index = 0;
        unit = new CharUnit();
        minMax = new IntPair();
        currentToken /* !! */  = null;
        quot = false;
        while (index < pLength) {
            block135: {
                block134: {
                    block133: {
                        block132: {
                            block131: {
                                index = RE.getCharUnit(pattern, index, unit, quot);
                                if (unit.bk) {
                                    if (unit.ch == 'Q') {
                                        quot = true;
                                        continue;
                                    }
                                    if (unit.ch == 'E') {
                                        quot = false;
                                        continue;
                                    }
                                }
                                if (quot) {
                                    unit.bk = false;
                                }
                                if (unit.ch != '|') break block131;
                                v1 = syntax.get(14);
                                v2 = false;
                                if (unit.bk || quot) {
                                    v2 = true;
                                }
                                if (v1 != v2) break block132;
                            }
                            if (!syntax.get(10) || unit.ch != '\n' || unit.bk || quot) break block133;
                        }
                        if (!syntax.get(9)) {
                            this.addToken(currentToken /* !! */ );
                            theBranch = new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength);
                            this.minimumLength = 0;
                            if (branches == null) {
                                branches = new Vector();
                            }
                            branches.addElement(theBranch);
                            currentToken /* !! */  = null;
                            this.lastToken = null;
                            this.firstToken = null;
                            continue;
                        }
                    }
                    if (unit.ch == '{' && syntax.get(8)) {
                        v3 = syntax.get(11);
                        v4 = false;
                        if (unit.bk || quot) {
                            v4 = true;
                        }
                        if (v3 != v4) {
                            newIndex = this.getMinMax(pattern, index, minMax, syntax);
                            if (newIndex > index) {
                                if (minMax.first > minMax.second) {
                                    throw new REException(RE.getLocalizedMessage("interval.order"), 1, newIndex);
                                }
                                if (currentToken /* !! */  == null) {
                                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, newIndex);
                                }
                                if (currentToken /* !! */  instanceof RETokenRepeated) {
                                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, newIndex);
                                }
                                if (currentToken /* !! */  instanceof RETokenWordBoundary || currentToken /* !! */  instanceof RETokenWordBoundary) {
                                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, newIndex);
                                }
                                if (currentToken /* !! */ .getMinimumLength() == 0 && minMax.second == 0x7FFFFFFF) {
                                    throw new REException(RE.getLocalizedMessage("repeat.empty.token"), 1, newIndex);
                                }
                                index = newIndex;
                                currentToken /* !! */  = RE.setRepeated(currentToken /* !! */ , minMax.first, minMax.second, index);
                                continue;
                            }
                            this.addToken(currentToken /* !! */ );
                            currentToken /* !! */  = new RETokenChar(this.subIndex, unit.ch, insens);
                            continue;
                        }
                    }
                    if (unit.ch != '[' || unit.bk || quot) break block134;
                    options = new Vector();
                    negative = false;
                    lastChar = '\u0000';
                    if (index == pLength) {
                        throw new REException(RE.getLocalizedMessage("unmatched.bracket"), 4, index);
                    }
                    ch = pattern[index];
                    if (ch == '^') {
                        negative = true;
                        if (++index == pLength) {
                            throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
                        }
                        ch = pattern[index];
                    }
                    if (ch != ']') ** GOTO lbl165
                    lastChar = ch;
                    if (++index != pLength) ** GOTO lbl165
                    throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
lbl-1000:
                    // 1 sources

                    {
                        if (ch == '-' && lastChar != '\u0000') {
                            if (index == pLength) {
                                throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
                            }
                            ch = pattern[index];
                            if (ch == ']') {
                                options.addElement(new RETokenChar(this.subIndex, lastChar, insens));
                                lastChar = '-';
                            } else {
                                options.addElement(new RETokenRange(this.subIndex, lastChar, ch, insens));
                                lastChar = '\u0000';
                                ++index;
                            }
                        } else if (ch == '\\' && syntax.get(0)) {
                            if (index == pLength) {
                                throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
                            }
                            posixID = -1;
                            negate = false;
                            asciiEsc = '\u0000';
                            if ("dswDSW".indexOf(pattern[index]) != -1 && syntax.get(24)) {
                                switch (pattern[index]) {
                                    case 'D': {
                                        negate = true;
                                    }
                                    case 'd': {
                                        posixID = 4;
                                        break;
                                    }
                                    case 'S': {
                                        negate = true;
                                    }
                                    case 's': {
                                        posixID = 9;
                                        break;
                                    }
                                    case 'W': {
                                        negate = true;
                                    }
                                    case 'w': {
                                        posixID = 0;
                                        break;
                                    }
                                }
                            } else if ("nrt".indexOf(pattern[index]) != -1) {
                                switch (pattern[index]) {
                                    case 'n': {
                                        asciiEsc = '\n';
                                        break;
                                    }
                                    case 't': {
                                        asciiEsc = '\t';
                                        break;
                                    }
                                    case 'r': {
                                        asciiEsc = '\r';
                                        break;
                                    }
                                }
                            }
                            if (lastChar != '\u0000') {
                                options.addElement(new RETokenChar(this.subIndex, lastChar, insens));
                            }
                            if (posixID != -1) {
                                options.addElement(new RETokenPOSIX(this.subIndex, posixID, insens, negate));
                            } else {
                                lastChar = asciiEsc != '\u0000' ? asciiEsc : pattern[index];
                            }
                            ++index;
                        } else if (ch == '[' && syntax.get(2) && index < pLength && pattern[index] == ':') {
                            posixSet = new StringBuffer();
                            index = RE.getPosixSet(pattern, index + 1, posixSet);
                            posixId = RETokenPOSIX.intValue(posixSet.toString());
                            if (posixId != -1) {
                                options.addElement(new RETokenPOSIX(this.subIndex, posixId, insens, false));
                            }
                        } else {
                            if (lastChar != '\u0000') {
                                options.addElement(new RETokenChar(this.subIndex, lastChar, insens));
                            }
                            lastChar = ch;
                        }
                        if (index != pLength) continue;
                        throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
lbl165:
                        // 3 sources

                        ** while ((ch = pattern[index++]) != ']')
                    }
lbl166:
                    // 1 sources

                    if (lastChar != '\u0000') {
                        options.addElement(new RETokenChar(this.subIndex, lastChar, insens));
                    }
                    this.addToken(currentToken /* !! */ );
                    options.trimToSize();
                    currentToken /* !! */  = new RETokenOneOf(this.subIndex, options, negative);
                    continue;
                }
                if (unit.ch != '(') break block135;
                v5 = syntax.get(12);
                v6 = false;
                if (unit.bk || quot) {
                    v6 = true;
                }
                if (v5 == v6) break block135;
                pure = false;
                comment = false;
                lookAhead = false;
                negativelh = false;
                if (index + 1 < pLength && pattern[index] == '?') {
                    switch (pattern[index + 1]) {
                        case '!': {
                            if (!syntax.get(21)) break;
                            pure = true;
                            negativelh = true;
                            lookAhead = true;
                            index += 2;
                            break;
                        }
                        case '=': {
                            if (!syntax.get(21)) break;
                            pure = true;
                            lookAhead = true;
                            index += 2;
                            break;
                        }
                        case ':': {
                            if (!syntax.get(20)) break;
                            pure = true;
                            index += 2;
                            break;
                        }
                        case '#': {
                            if (!syntax.get(23)) break;
                            comment = true;
                            break;
                        }
                        default: {
                            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                        }
                    }
                }
                if (index >= pLength) {
                    throw new REException(RE.getLocalizedMessage("unmatched.paren"), 8, index);
                }
                endIndex = index;
                nextIndex = index;
                nested = 0;
                if (true) ** GOTO lbl233
                while (true) {
                    if ((endIndex = nextIndex) >= pLength) {
                        throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, nextIndex);
                    }
                    if (unit.ch != '(') ** GOTO lbl-1000
                    v7 = syntax.get(12);
                    v8 = false;
                    if (unit.bk || quot) {
                        v8 = true;
                    }
                    if (v7 != v8) {
                        ++nested;
                    } else if (unit.ch == ')') {
                        v9 = syntax.get(12);
                        v10 = false;
                        if (unit.bk || quot) {
                            v10 = true;
                        }
                        if (v9 != v10) {
                            --nested;
                        }
                    }
lbl233:
                    // 7 sources

                    nextIndex = RE.getCharUnit(pattern, endIndex, unit, false);
                    if (nextIndex <= 0) break;
                    if (nested != 0 || unit.ch != ')') continue;
                    v11 = syntax.get(12);
                    v12 = false;
                    if (unit.bk || quot) {
                        v12 = true;
                    }
                    if (v11 != v12) break;
                }
                if (comment) {
                    index = nextIndex;
                    continue;
                }
                this.addToken(currentToken /* !! */ );
                if (!pure) {
                    ++this.numSubs;
                }
                v13 = 0;
                if (!pure && !lookAhead) {
                    v13 = nextSub + this.numSubs;
                }
                useIndex = v13;
                currentToken /* !! */  = new RE(String.valueOf(pattern, index, endIndex - index).toCharArray(), cflags, syntax, useIndex, nextSub + this.numSubs);
                this.numSubs += ((RE)currentToken /* !! */ ).getNumSubs();
                if (lookAhead) {
                    currentToken /* !! */  = new RETokenLookAhead(currentToken /* !! */ , negativelh);
                }
                index = nextIndex;
                continue;
            }
            if (!syntax.get(16) && unit.ch == ')') {
                v14 = syntax.get(12);
                v15 = false;
                if (unit.bk || quot) {
                    v15 = true;
                }
                if (v14 != v15) {
                    throw new REException(RE.getLocalizedMessage("unmatched.paren"), 7, index);
                }
            }
            if (unit.ch == '^' && !unit.bk && !quot) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = null;
                this.addToken(new RETokenStart(this.subIndex, (cflags & 8) > 0 ? syntax.getLineSeparator() : null));
                continue;
            }
            if (unit.ch == '$' && !unit.bk && !quot) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = null;
                this.addToken(new RETokenEnd(this.subIndex, (cflags & 8) > 0 ? syntax.getLineSeparator() : null));
                continue;
            }
            if (unit.ch == '.' && !unit.bk && !quot) {
                this.addToken(currentToken /* !! */ );
                v16 = false;
                if (syntax.get(6) || (cflags & 4) > 0) {
                    v16 = true;
                }
                currentToken /* !! */  = new RETokenAny(this.subIndex, v16, syntax.get(7));
                continue;
            }
            if (unit.ch == '*' && !unit.bk && !quot) {
                if (currentToken /* !! */  == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                }
                if (currentToken /* !! */  instanceof RETokenRepeated) {
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, index);
                }
                if (currentToken /* !! */  instanceof RETokenWordBoundary || currentToken /* !! */  instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, index);
                }
                if (currentToken /* !! */ .getMinimumLength() == 0) {
                    throw new REException(RE.getLocalizedMessage("repeat.empty.token"), 1, index);
                }
                currentToken /* !! */  = RE.setRepeated(currentToken /* !! */ , 0, 0x7FFFFFFF, index);
                continue;
            }
            if (unit.ch == '+' && !syntax.get(9)) {
                v17 = syntax.get(1) ^ true;
                v18 = false;
                if (unit.bk || quot) {
                    v18 = true;
                }
                if (v17 != v18) {
                    if (currentToken /* !! */  == null) {
                        throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                    }
                    if (currentToken /* !! */  instanceof RETokenRepeated) {
                        tokenRep = (RETokenRepeated)currentToken /* !! */ ;
                        if (syntax.get(25) && !tokenRep.isPossessive() && !tokenRep.isStingy()) {
                            tokenRep.makePossessive();
                            continue;
                        }
                        throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, index);
                    }
                    if (currentToken /* !! */  instanceof RETokenWordBoundary || currentToken /* !! */  instanceof RETokenWordBoundary) {
                        throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, index);
                    }
                    if (currentToken /* !! */ .getMinimumLength() == 0) {
                        throw new REException(RE.getLocalizedMessage("repeat.empty.token"), 1, index);
                    }
                    currentToken /* !! */  = RE.setRepeated(currentToken /* !! */ , 1, 0x7FFFFFFF, index);
                    continue;
                }
            }
            if (unit.ch == '?' && !syntax.get(9)) {
                v19 = syntax.get(1) ^ true;
                v20 = false;
                if (unit.bk || quot) {
                    v20 = true;
                }
                if (v19 != v20) {
                    if (currentToken /* !! */  == null) {
                        throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                    }
                    if (currentToken /* !! */  instanceof RETokenRepeated) {
                        tokenRep = (RETokenRepeated)currentToken /* !! */ ;
                        if (syntax.get(18) && !tokenRep.isStingy() && !tokenRep.isPossessive()) {
                            tokenRep.makeStingy();
                            continue;
                        }
                        throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, index);
                    }
                    if (currentToken /* !! */  instanceof RETokenWordBoundary || currentToken /* !! */  instanceof RETokenWordBoundary) {
                        throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, index);
                    }
                    currentToken /* !! */  = RE.setRepeated(currentToken /* !! */ , 0, 1, index);
                    continue;
                }
            }
            if (unit.bk && Character.isDigit(unit.ch) && !syntax.get(13)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenBackRef(this.subIndex, Character.digit(unit.ch, 10), insens);
                continue;
            }
            if (unit.bk && unit.ch == 'A' && syntax.get(22)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenStart(this.subIndex, null);
                continue;
            }
            if (unit.bk && unit.ch == 'b' && syntax.get(22)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenWordBoundary(this.subIndex, 3, false);
                continue;
            }
            if (unit.bk && unit.ch == '<') {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenWordBoundary(this.subIndex, 1, false);
                continue;
            }
            if (unit.bk && unit.ch == '>') {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenWordBoundary(this.subIndex, 2, false);
                continue;
            }
            if (unit.bk && unit.ch == 'B' && syntax.get(22)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenWordBoundary(this.subIndex, 3, true);
                continue;
            }
            if (unit.bk && unit.ch == 'd' && syntax.get(19)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenPOSIX(this.subIndex, 4, insens, false);
                continue;
            }
            if (unit.bk && unit.ch == 'D' && syntax.get(19)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenPOSIX(this.subIndex, 4, insens, true);
                continue;
            }
            if (unit.bk && unit.ch == 'n') {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenChar(this.subIndex, '\n', false);
                continue;
            }
            if (unit.bk && unit.ch == 'r') {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenChar(this.subIndex, '\r', false);
                continue;
            }
            if (unit.bk && unit.ch == 's' && syntax.get(19)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenPOSIX(this.subIndex, 9, insens, false);
                continue;
            }
            if (unit.bk && unit.ch == 'S' && syntax.get(19)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenPOSIX(this.subIndex, 9, insens, true);
                continue;
            }
            if (unit.bk && unit.ch == 't') {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenChar(this.subIndex, '\t', false);
                continue;
            }
            if (unit.bk && unit.ch == 'w' && syntax.get(19)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenPOSIX(this.subIndex, 0, insens, false);
                continue;
            }
            if (unit.bk && unit.ch == 'W' && syntax.get(19)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenPOSIX(this.subIndex, 0, insens, true);
                continue;
            }
            if (unit.bk && unit.ch == 'Z' && syntax.get(22)) {
                this.addToken(currentToken /* !! */ );
                currentToken /* !! */  = new RETokenEnd(this.subIndex, null);
                continue;
            }
            this.addToken(currentToken /* !! */ );
            currentToken /* !! */  = new RETokenChar(this.subIndex, unit.ch, insens);
        }
        this.addToken(currentToken /* !! */ );
        if (branches != null) {
            branches.addElement(new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength));
            branches.trimToSize();
            this.minimumLength = 0;
            this.lastToken = null;
            this.firstToken = null;
            this.addToken(new RETokenOneOf(this.subIndex, branches, false));
        } else {
            this.addToken(new RETokenEndSub(this.subIndex));
        }
    }

    private static final int getCharUnit(char[] input, int index, CharUnit unit, boolean quot) throws REException {
        unit.ch = input[index++];
        boolean bl = false;
        if (!(unit.ch != '\\' || quot && index < input.length && input[index] != 'E')) {
            bl = unit.bk = true;
        }
        if (unit.bk) {
            if (index < input.length) {
                unit.ch = input[index++];
            } else {
                throw new REException(RE.getLocalizedMessage("ends.with.backslash"), 10, index);
            }
        }
        return index;
    }

    public boolean isMatch(Object input) {
        return this.isMatch(input, 0, 0);
    }

    public boolean isMatch(Object input, int index) {
        return this.isMatch(input, index, 0);
    }

    public boolean isMatch(Object input, int index, int eflags) {
        return this.isMatchImpl(RE.makeCharIndexed(input, index), index, eflags);
    }

    private final boolean isMatchImpl(CharIndexed input, int index, int eflags) {
        if (this.firstToken == null) {
            boolean bl = false;
            if (input.charAt(0) == (char)-1) {
                bl = true;
            }
            return bl;
        }
        REMatch m = new REMatch(this.numSubs, index, eflags);
        if (this.firstToken.match(input, m)) {
            while (m != null) {
                if (input.charAt(m.index) == (char)-1) {
                    return true;
                }
                m = m.next;
            }
        }
        return false;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    void setUncle(REToken uncle) {
        if (this.lastToken != null) {
            this.lastToken.setUncle(uncle);
        } else {
            super.setUncle(uncle);
        }
    }

    boolean chain(REToken next) {
        super.chain(next);
        this.setUncle(next);
        return true;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public REMatch[] getAllMatches(Object input) {
        return this.getAllMatches(input, 0, 0);
    }

    public REMatch[] getAllMatches(Object input, int index) {
        return this.getAllMatches(input, index, 0);
    }

    public REMatch[] getAllMatches(Object input, int index, int eflags) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(input, index), index, eflags);
    }

    private final REMatch[] getAllMatchesImpl(CharIndexed input, int index, int eflags) {
        Vector all = new Vector();
        REMatch m = null;
        while ((m = this.getMatchImpl(input, index, eflags, null)) != null) {
            all.addElement(m);
            index = m.getEndIndex();
            if (m.end[0] == 0) {
                ++index;
                input.move(1);
            } else {
                input.move(m.end[0]);
            }
            if (!input.isValid()) break;
        }
        Object[] mset = new REMatch[all.size()];
        all.copyInto(mset);
        return mset;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        if (this.firstToken == null) {
            return this.next(input, mymatch);
        }
        mymatch.start[this.subIndex] = mymatch.index;
        return this.firstToken.match(input, mymatch);
    }

    public REMatch getMatch(Object input) {
        return this.getMatch(input, 0, 0);
    }

    public REMatch getMatch(Object input, int index) {
        return this.getMatch(input, index, 0);
    }

    public REMatch getMatch(Object input, int index, int eflags) {
        return this.getMatch(input, index, eflags, null);
    }

    public REMatch getMatch(Object input, int index, int eflags, StringBuffer buffer) {
        return this.getMatchImpl(RE.makeCharIndexed(input, index), index, eflags, buffer);
    }

    REMatch getMatchImpl(CharIndexed input, int anchor, int eflags, StringBuffer buffer) {
        REMatch mymatch = new REMatch(this.numSubs, anchor, eflags);
        do {
            if ((this.minimumLength == 0 || input.charAt(this.minimumLength - 1) != (char)-1) && this.match(input, mymatch)) {
                REMatch longest = mymatch;
                while ((mymatch = mymatch.next) != null) {
                    if (mymatch.index <= longest.index) continue;
                    longest = mymatch;
                }
                longest.end[0] = longest.index;
                longest.finish(input);
                return longest;
            }
            mymatch.clear(++anchor);
            if (buffer == null || input.charAt(0) == (char)-1) continue;
            buffer.append(input.charAt(0));
        } while (input.move(1));
        if (this.minimumLength == 0 && this.match(input, mymatch)) {
            mymatch.finish(input);
            return mymatch;
        }
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object input) {
        return this.getMatchEnumeration(input, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object input, int index) {
        return this.getMatchEnumeration(input, index, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object input, int index, int eflags) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(input, index), index, eflags);
    }

    public String substitute(Object input, String replace) {
        return this.substitute(input, replace, 0, 0);
    }

    public String substitute(Object input, String replace, int index) {
        return this.substitute(input, replace, index, 0);
    }

    public String substitute(Object input, String replace, int index, int eflags) {
        return this.substituteImpl(RE.makeCharIndexed(input, index), replace, index, eflags);
    }

    private final String substituteImpl(CharIndexed input, String replace, int index, int eflags) {
        StringBuffer buffer = new StringBuffer();
        REMatch m = this.getMatchImpl(input, index, eflags, buffer);
        if (m == null) {
            return buffer.toString();
        }
        buffer.append((eflags & 0x80) > 0 ? replace : m.substituteInto(replace));
        if (input.move(m.end[0])) {
            do {
                buffer.append(input.charAt(0));
            } while (input.move(1));
        }
        return buffer.toString();
    }

    public String substituteAll(Object input, String replace) {
        return this.substituteAll(input, replace, 0, 0);
    }

    public String substituteAll(Object input, String replace, int index) {
        return this.substituteAll(input, replace, index, 0);
    }

    public String substituteAll(Object input, String replace, int index, int eflags) {
        return this.substituteAllImpl(RE.makeCharIndexed(input, index), replace, index, eflags);
    }

    private final String substituteAllImpl(CharIndexed input, String replace, int index, int eflags) {
        REMatch m;
        StringBuffer buffer = new StringBuffer();
        while ((m = this.getMatchImpl(input, index, eflags, buffer)) != null) {
            buffer.append((eflags & 0x80) > 0 ? replace : m.substituteInto(replace));
            index = m.getEndIndex();
            if (m.end[0] == 0) {
                char ch = input.charAt(0);
                if (ch != (char)-1) {
                    buffer.append(ch);
                }
                input.move(1);
            } else {
                input.move(m.end[0]);
            }
            if (!input.isValid()) break;
        }
        return buffer.toString();
    }

    private final void addToken(REToken next) {
        if (next == null) {
            return;
        }
        this.minimumLength += next.getMinimumLength();
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = next;
        } else if (this.lastToken.chain(next)) {
            this.lastToken = next;
        }
    }

    private static final REToken setRepeated(REToken current, int min, int max, int index) throws REException {
        if (current == null) {
            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
        }
        return new RETokenRepeated(current.subIndex, current, min, max);
    }

    private static final int getPosixSet(char[] pattern2, int index, StringBuffer buf) {
        int i = index;
        while (i < pattern2.length - 1) {
            if (pattern2[i] == ':' && pattern2[i + 1] == ']') {
                return i + 2;
            }
            buf.append(pattern2[i]);
            ++i;
        }
        return index;
    }

    private final int getMinMax(char[] input, int index, IntPair minMax, RESyntax syntax) throws REException {
        boolean mustMatch = syntax.get(11) ^ true;
        int startIndex = index;
        if (index == input.length) {
            if (mustMatch) {
                throw new REException(RE.getLocalizedMessage("unmatched.brace"), 3, index);
            }
            return startIndex;
        }
        int max = 0;
        CharUnit unit = new CharUnit();
        StringBuffer buf = new StringBuffer();
        do {
            index = RE.getCharUnit(input, index, unit, false);
            if (!Character.isDigit(unit.ch)) continue;
            buf.append(unit.ch);
        } while (index != input.length && Character.isDigit(unit.ch));
        if (buf.length() == 0) {
            if (mustMatch) {
                throw new REException(RE.getLocalizedMessage("interval.error"), 3, index);
            }
            return startIndex;
        }
        int min = Integer.parseInt(buf.toString());
        if (unit.ch == '}' && syntax.get(11) != unit.bk) {
            max = min;
        } else {
            if (index == input.length) {
                if (mustMatch) {
                    throw new REException(RE.getLocalizedMessage("interval.no.end"), 3, index);
                }
                return startIndex;
            }
            if (unit.ch == ',' && !unit.bk) {
                buf = new StringBuffer();
                while ((index = RE.getCharUnit(input, index, unit, false)) != input.length && Character.isDigit(unit.ch)) {
                    buf.append(unit.ch);
                }
                if (unit.ch != '}' || syntax.get(11) == unit.bk) {
                    if (mustMatch) {
                        throw new REException(RE.getLocalizedMessage("interval.error"), 3, index);
                    }
                    return startIndex;
                }
                max = buf.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(buf.toString());
            } else {
                if (mustMatch) {
                    throw new REException(RE.getLocalizedMessage("interval.error"), 3, index);
                }
                return startIndex;
            }
        }
        minMax.first = min;
        minMax.second = max;
        return index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.dump(sb);
        return sb.toString();
    }

    void dump(StringBuffer os) {
        os.append('(');
        if (this.subIndex == 0) {
            os.append("?:");
        }
        if (this.firstToken != null) {
            this.firstToken.dumpAll(os);
        }
        os.append(')');
    }

    private static final CharIndexed makeCharIndexed(Object input, int index) {
        if (input instanceof String) {
            return new CharIndexedString((String)input, index);
        }
        if (input instanceof char[]) {
            return new CharIndexedCharArray((char[])input, index);
        }
        if (input instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)input, index);
        }
        if (input instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)input, index);
        }
        if (input instanceof CharIndexed) {
            return (CharIndexed)input;
        }
        return new CharIndexedString(input.toString(), index);
    }

    public RE(Object pattern2) throws REException {
        this(pattern2, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object pattern2, int cflags) throws REException {
        this(pattern2, cflags, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object pattern2, int cflags, RESyntax syntax) throws REException {
        this(pattern2, cflags, syntax, 0, 0);
    }

    private RE(REToken first, REToken last, int subs, int subIndex, int minLength) {
        super(subIndex);
        this.firstToken = first;
        this.lastToken = last;
        this.numSubs = subs;
        this.minimumLength = minLength;
        this.addToken(new RETokenEndSub(subIndex));
    }

    private RE(Object patternObj, int cflags, RESyntax syntax, int myIndex, int nextSub) throws REException {
        super(myIndex);
        this.initialize(patternObj, cflags, syntax, myIndex, nextSub);
    }

    protected RE() {
        super(0);
    }

    private static final class CharUnit
    implements Serializable {
        public char ch;
        public boolean bk;

        private CharUnit() {
        }
    }

    private static final class IntPair
    implements Serializable {
        public int first;
        public int second;

        private IntPair() {
        }
    }
}

