/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class US_ASCII
extends Charset {
    public final boolean contains(Charset cs) {
        return cs instanceof US_ASCII;
    }

    public final CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public final CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    US_ASCII() {
        super("US-ASCII", new String[]{"iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "ASCII", "us", "IBM367", "cp367", "csASCII", "ANSI_X3.4-1968", "iso_646.irv:1983", "ascii7", "646", "windows-20127"});
    }

    private static final class Decoder
    extends CharsetDecoder {
        protected final CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                byte b = in.get();
                if (b < 0) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                out.put((char)b);
            }
            return CoderResult.UNDERFLOW;
        }

        Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        protected final CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                char c = in.get();
                if (c > '\u007f') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)c);
            }
            return CoderResult.UNDERFLOW;
        }

        Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }
    }
}

