/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ValidationConsumer
extends EventFilter {
    private static final boolean warnNonDeterministic = false;
    private static final String fakeRootName = ":Nobody:in:their_Right.Mind_would:use:this-name:1x:";
    static final String[] types = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "NMTOKEN", "NMTOKENS", "ENTITY", "ENTITIES"};
    private static final Recognizer ANY = new Recognizer(null);
    private static final int F_LOOPHEAD = 1;
    private static final int F_LOOPNEXT = 2;
    private static int nodeCount;
    private String rootName;
    private Stack contentStack;
    private boolean disableDeclarations;
    private boolean disableReset;
    private Hashtable elements;
    private Hashtable ids;
    private Vector notations;
    private Vector nDeferred;
    private Vector unparsed;
    private Vector uDeferred;

    private final void resetState() {
        if (!this.disableReset) {
            this.rootName = null;
            this.contentStack.removeAllElements();
            this.elements.clear();
            this.ids.clear();
            this.notations.removeAllElements();
            this.nDeferred.removeAllElements();
            this.unparsed.removeAllElements();
            this.uDeferred.removeAllElements();
        }
    }

    private final void warning(String description) throws SAXException {
        ErrorHandler errHandler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        if (errHandler == null) {
            return;
        }
        SAXParseException err = locator == null ? new SAXParseException(description, null, null, -1, -1) : new SAXParseException(description, locator);
        errHandler.warning(err);
    }

    private final void error(String description) throws SAXException {
        ErrorHandler errHandler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        SAXParseException err = locator == null ? new SAXParseException(description, null, null, -1, -1) : new SAXParseException(description, locator);
        if (errHandler == null) {
            throw err;
        }
        errHandler.error(err);
    }

    private final void fatalError(String description) throws SAXException {
        ErrorHandler errHandler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        SAXParseException err = locator != null ? new SAXParseException(description, locator) : new SAXParseException(description, null, null, -1, -1);
        if (errHandler != null) {
            errHandler.fatalError(err);
        }
        throw err;
    }

    private static final boolean isExtender(char c) {
        boolean bl = false;
        if (c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe') {
            bl = true;
        }
        return bl;
    }

    private final boolean isName(String name, String context, String id) throws SAXException {
        char[] buf = name.toCharArray();
        boolean pass = true;
        if (!Character.isUnicodeIdentifierStart(buf[0]) && ":_".indexOf(buf[0]) == -1) {
            pass = false;
        } else {
            int max = buf.length;
            int i = 1;
            while (pass && i < max) {
                char c = buf[i];
                if (!Character.isUnicodeIdentifierPart(c) && ":-_.".indexOf(c) == -1 && !ValidationConsumer.isExtender(c)) {
                    pass = false;
                }
                ++i;
            }
        }
        if (!pass) {
            this.error("In " + context + " for " + id + ", '" + name + "' is not a name");
        }
        return pass;
    }

    private final boolean isNmtoken(String nmtoken, String context, String id) throws SAXException {
        char[] buf = nmtoken.toCharArray();
        boolean pass = true;
        int max = buf.length;
        int i = 0;
        while (pass && i < max) {
            char c = buf[i];
            if (!Character.isUnicodeIdentifierPart(c) && ":-_.".indexOf(c) == -1 && !ValidationConsumer.isExtender(c)) {
                pass = false;
            }
            ++i;
        }
        if (!pass) {
            this.error("In " + context + " for " + id + ", '" + nmtoken + "' is not a name token");
        }
        return pass;
    }

    private final void checkEnumeration(String value, String type, String name) throws SAXException {
        if (!ValidationConsumer.hasMatch(value, type)) {
            this.error("Value '" + value + "' for attribute '" + name + "' is not permitted: " + type);
        }
    }

    static final boolean hasMatch(String value, String orList) {
        int len = value.length();
        int max = orList.length() - len;
        int start = 0;
        while ((start = orList.indexOf(value, start)) != -1) {
            if (start > max) break;
            char c = orList.charAt(start - 1);
            if (!(c != '|' && c != '(' || (c = orList.charAt(start + len)) != '|' && c != ')')) {
                return true;
            }
            ++start;
        }
        return false;
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        this.rootName = name;
        super.startDTD(name, publicId, systemId);
    }

    public final void endDTD() throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        int length = this.nDeferred.size();
        int i = 0;
        while (i < length) {
            String notation = (String)this.nDeferred.elementAt(i);
            if (!this.notations.contains(notation)) {
                this.error("A declaration referred to notation '" + notation + "' which was never declared");
            }
            ++i;
        }
        this.nDeferred.removeAllElements();
        length = this.uDeferred.size();
        i = 0;
        while (i < length) {
            String entity = (String)this.uDeferred.elementAt(i);
            if (!this.unparsed.contains(entity)) {
                this.error("An attribute default referred to entity '" + entity + "' which was never declared");
            }
            ++i;
        }
        this.uDeferred.removeAllElements();
        super.endDTD();
    }

    public final void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        String name;
        String token;
        if (this.disableDeclarations) {
            return;
        }
        ElementInfo info = (ElementInfo)this.elements.get(eName);
        AttributeInfo ainfo = new AttributeInfo();
        boolean checkOne = false;
        boolean interned = false;
        int i = 0;
        while (i < types.length) {
            if (types[i].equals(type)) {
                type = types[i];
                interned = true;
                break;
            }
            ++i;
        }
        if ("#FIXED".equals(mode)) {
            mode = "#FIXED";
        } else if ("#REQUIRED".equals(mode)) {
            mode = "#REQUIRED";
        }
        ainfo.type = type;
        ainfo.mode = mode;
        ainfo.value = value;
        if (info == null) {
            info = new ElementInfo(eName);
            this.elements.put(eName, info);
        }
        if ("ID" == type) {
            checkOne = true;
            if ("#REQUIRED" != mode && !"#IMPLIED".equals(mode)) {
                this.error("ID attribute '" + aName + "' must be #IMPLIED or #REQUIRED");
            }
        } else if (!interned && type.startsWith("NOTATION ")) {
            checkOne = true;
            StringTokenizer tokens = new StringTokenizer(type.substring(10, type.lastIndexOf(41)), "|");
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (this.notations.contains(token)) continue;
                this.nDeferred.addElement(token);
            }
        }
        if (checkOne) {
            Enumeration e = info.attributes.keys();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                AttributeInfo ainfo2 = (AttributeInfo)info.attributes.get(name);
                if (type != ainfo2.type && interned) continue;
                this.error("Element '" + eName + "' already has an attribute of type " + (interned ? "NOTATION" : type) + " ('" + name + "') so '" + aName + "' is a validity error");
            }
        }
        if (value != null && "CDATA" != type) {
            if ("NMTOKEN" == type) {
                this.isNmtoken(value, "attribute default", aName);
            } else if ("NMTOKENS" == type) {
                StringTokenizer tokens = new StringTokenizer(value);
                if (!tokens.hasMoreTokens()) {
                    this.error("Default for attribute '" + aName + "' must have at least one name token.");
                } else {
                    do {
                        token = tokens.nextToken();
                        this.isNmtoken(token, "attribute default", aName);
                    } while (tokens.hasMoreTokens());
                }
            } else if ("IDREF" == type || "ENTITY" == type) {
                this.isName(value, "attribute default", aName);
                if ("ENTITY" == type && !this.unparsed.contains(value)) {
                    this.uDeferred.addElement(value);
                }
            } else if ("IDREFS" == type || "ENTITIES" == type) {
                StringTokenizer names = new StringTokenizer(value);
                if (!names.hasMoreTokens()) {
                    this.error("Default for attribute '" + aName + "' must have at least one name.");
                } else {
                    do {
                        name = names.nextToken();
                        this.isName(name, "attribute default", aName);
                        if ("ENTITIES" != type || this.unparsed.contains(name)) continue;
                        this.uDeferred.addElement(value);
                    } while (names.hasMoreTokens());
                }
            } else if (type.charAt(0) == '(') {
                this.checkEnumeration(value, type, aName);
            } else if (!interned && checkOne) {
                this.isName(value, "attribute default", aName);
                if (!this.notations.contains(value)) {
                    this.nDeferred.addElement(value);
                }
                this.checkEnumeration(value, type, aName);
            } else if ("ID" != type) {
                throw new RuntimeException("illegal attribute type: " + type);
            }
        }
        if (info.attributes.get(aName) == null) {
            info.attributes.put(aName, ainfo);
        }
        if (!(!"xml:space".equals(aName) || "(default|preserve)".equals(type) || "(preserve|default)".equals(type) || "(preserve)".equals(type) || "(default)".equals(type))) {
            this.error("xml:space attribute type must be like '(default|preserve)' not '" + type + '\'');
        }
        super.attributeDecl(eName, aName, type, mode, value);
    }

    public final void elementDecl(String name, String model) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        ElementInfo info = (ElementInfo)this.elements.get(name);
        if (info == null) {
            info = new ElementInfo(name);
            this.elements.put(name, info);
        }
        if (info.model != null) {
            this.error("Element type '" + name + "' was already declared.");
        } else {
            info.model = model;
            if (model.charAt(1) == '#') {
                info.getRecognizer(this);
            }
        }
        super.elementDecl(name, model);
    }

    public final void internalEntityDecl(String name, String value) throws SAXException {
        if (!this.disableDeclarations) {
            super.internalEntityDecl(name, value);
        }
    }

    public final void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (!this.disableDeclarations) {
            super.externalEntityDecl(name, publicId, systemId);
        }
    }

    public final void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        this.notations.addElement(name);
        super.notationDecl(name, publicId, systemId);
    }

    public final void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        this.unparsed.addElement(name);
        if (!this.notations.contains(notationName)) {
            this.nDeferred.addElement(notationName);
        }
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public final void startDocument() throws SAXException {
        this.resetState();
        super.startDocument();
    }

    private static final boolean isAsciiLetter(char c) {
        boolean bl = false;
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            bl = true;
        }
        return bl;
    }

    public final void skippedEntity(String name) throws SAXException {
        this.fatalError("may not skip entities");
    }

    private final String expandDefaultRefs(String s) throws SAXException {
        if (s.indexOf(38) < 0) {
            return s;
        }
        String message = "Can't expand refs in attribute default: " + s;
        this.warning(message);
        return s;
    }

    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Hashtable table;
        AttributeInfo ainfo;
        String aname;
        if (this.contentStack.isEmpty()) {
            if (!qName.equals(this.rootName)) {
                if (this.rootName == null) {
                    this.warning("This document has no DTD, can't be valid");
                } else {
                    this.error("Root element type '" + qName + "' was declared to be '" + this.rootName + '\'');
                }
            }
        } else {
            Recognizer state = (Recognizer)this.contentStack.peek();
            if (state != null) {
                Recognizer newstate = state.acceptElement(qName);
                if (newstate == null) {
                    this.error("Element type '" + qName + "' in element '" + state.type.name + "' violates content model " + state.type.model);
                }
                if (newstate != state) {
                    this.contentStack.pop();
                    this.contentStack.push(newstate);
                }
            }
        }
        ElementInfo info = (ElementInfo)this.elements.get(qName);
        if (info == null || info.model == null) {
            this.error("Element type '" + qName + "' was not declared");
            this.contentStack.push(null);
            this.elementDecl(qName, "ANY");
        } else {
            this.contentStack.push(info.getRecognizer(this));
        }
        int len = atts != null ? atts.getLength() : 0;
        int i = 0;
        while (i < len) {
            aname = atts.getQName(i);
            if (info == null || (ainfo = (AttributeInfo)info.attributes.get(aname)) == null) {
                this.error("Attribute '" + aname + "' was not declared for element type " + qName);
            } else {
                String expanded;
                String value = atts.getValue(i);
                if ("#FIXED" == ainfo.mode && !value.equals(expanded = this.expandDefaultRefs(ainfo.value))) {
                    this.error("Attribute '" + aname + "' must match " + expanded);
                } else if ("CDATA" != ainfo.type) {
                    StringTokenizer tokens;
                    if ("ID" == ainfo.type) {
                        if (this.isName(value, "ID attribute", aname)) {
                            if (Boolean.TRUE == this.ids.get(value)) {
                                this.error("ID attribute " + aname + " uses an ID value '" + value + "' which was already declared.");
                            } else {
                                this.ids.put(value, Boolean.TRUE);
                            }
                        }
                    } else if ("IDREF" == ainfo.type) {
                        if (this.isName(value, "IDREF attribute", aname) && this.ids.get(value) == null) {
                            this.ids.put(value, Boolean.FALSE);
                        }
                    } else if ("IDREFS" == ainfo.type) {
                        tokens = new StringTokenizer(value, " ");
                        if (!tokens.hasMoreTokens()) {
                            this.error("IDREFS attribute " + aname + " must have at least one ID ref");
                        } else {
                            do {
                                String id;
                                if (!this.isName(id = tokens.nextToken(), "IDREFS attribute", aname) || this.ids.get(id) != null) continue;
                                this.ids.put(id, Boolean.FALSE);
                            } while (tokens.hasMoreTokens());
                        }
                    } else if ("NMTOKEN" == ainfo.type) {
                        this.isNmtoken(value, "NMTOKEN attribute", aname);
                    } else if ("NMTOKENS" == ainfo.type) {
                        tokens = new StringTokenizer(value, " ");
                        if (!tokens.hasMoreTokens()) {
                            this.error("NMTOKENS attribute " + aname + " must have at least one name token");
                        } else {
                            do {
                                String token = tokens.nextToken();
                                this.isNmtoken(token, "NMTOKENS attribute", aname);
                            } while (tokens.hasMoreTokens());
                        }
                    } else if ("ENTITY" == ainfo.type) {
                        if (!this.unparsed.contains(value)) {
                            this.error("Value of attribute '" + aname + "' refers to unparsed entity '" + value + "' which was not declared.");
                        }
                    } else if ("ENTITIES" == ainfo.type) {
                        tokens = new StringTokenizer(value, " ");
                        if (!tokens.hasMoreTokens()) {
                            this.error("ENTITIES attribute " + aname + " must have at least one name token");
                        } else {
                            do {
                                String entity;
                                if (this.unparsed.contains(entity = tokens.nextToken())) continue;
                                this.error("Value of attribute '" + aname + "' refers to unparsed entity '" + entity + "' which was not declared.");
                            } while (tokens.hasMoreTokens());
                        }
                    } else if (ainfo.type.charAt(0) == '(' || ainfo.type.startsWith("NOTATION ")) {
                        this.checkEnumeration(value, ainfo.type, aname);
                    }
                }
            }
            ++i;
        }
        if (info != null && (table = info.attributes).size() != 0) {
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                aname = (String)e.nextElement();
                ainfo = (AttributeInfo)table.get(aname);
                if ("#REQUIRED" != ainfo.mode || atts.getValue(aname) != null) continue;
                this.error("Attribute '" + aname + "' must be specified for element type " + qName);
            }
        }
        super.startElement(uri, localName, qName, atts);
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        Recognizer state = this.contentStack.empty() ? null : (Recognizer)this.contentStack.peek();
        if (state != null && !state.acceptCharacters()) {
            this.error("Character content not allowed in element " + state.type.name);
        }
        super.characters(ch, start, length);
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            Recognizer state = (Recognizer)this.contentStack.pop();
            if (state != null && !state.completed()) {
                this.error("Premature end for element '" + state.type.name + "', content model " + state.type.model);
            }
        }
        catch (EmptyStackException e) {
            this.fatalError("endElement without startElement: " + qName + (uri == null ? "" : " { '" + uri + "', " + localName + " }"));
        }
        super.endElement(uri, localName, qName);
    }

    public final void endDocument() throws SAXException {
        Enumeration idNames = this.ids.keys();
        while (idNames.hasMoreElements()) {
            String id = (String)idNames.nextElement();
            if (Boolean.FALSE != this.ids.get(id)) continue;
            this.error("Undeclared ID value '" + id + "' was referred to by an IDREF/IDREFS attribute");
        }
        this.resetState();
        super.endDocument();
    }

    static final /* synthetic */ int access$2() {
        return 1;
    }

    static final /* synthetic */ int access$3() {
        return 2;
    }

    static final /* synthetic */ boolean access$4() {
        return false;
    }

    private final /* synthetic */ void this() {
        this.contentStack = new Stack();
        this.elements = new Hashtable();
        this.ids = new Hashtable();
        this.notations = new Vector(5, 5);
        this.nDeferred = new Vector(5, 5);
        this.unparsed = new Vector(5, 5);
        this.uDeferred = new Vector(5, 5);
    }

    public ValidationConsumer() {
        this(null);
    }

    public ValidationConsumer(EventConsumer next) {
        super(next);
        this.this();
        this.setContentHandler(this);
        this.setDTDHandler(this);
        try {
            this.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ValidationConsumer(String rootName, String publicId, String systemId, String internalSubset, EntityResolver resolver, String minimalDocument) throws SAXException, IOException {
        this(null);
        this.disableReset = true;
        if (rootName == null) {
            rootName = fakeRootName;
        }
        StringWriter writer = new StringWriter();
        writer.write("<!DOCTYPE ");
        writer.write(rootName);
        if (systemId != null) {
            writer.write("\n  ");
            if (publicId != null) {
                writer.write("PUBLIC '");
                writer.write(publicId);
                writer.write("'\n\t'");
            } else {
                writer.write("SYSTEM '");
            }
            writer.write(systemId);
            writer.write("'");
        }
        writer.write(" [ ");
        if (rootName == fakeRootName) {
            writer.write("\n<!ELEMENT ");
            writer.write(rootName);
            writer.write(" EMPTY>");
        }
        if (internalSubset != null) {
            writer.write(internalSubset);
        }
        writer.write("\n ]>");
        if (minimalDocument != null) {
            writer.write("\n");
            writer.write(minimalDocument);
            writer.write("\n");
        } else {
            writer.write(" <");
            writer.write(rootName);
            writer.write("/>\n");
        }
        minimalDocument = writer.toString();
        XMLReader producer = XMLReaderFactory.createXMLReader();
        ValidationConsumer.bind(producer, this);
        if (resolver != null) {
            producer.setEntityResolver(resolver);
        }
        InputSource in = new InputSource(new StringReader(minimalDocument));
        producer.parse(in);
        this.disableDeclarations = true;
        if (rootName == fakeRootName) {
            this.rootName = null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class ElementInfo {
        String name;
        String model;
        Hashtable attributes;
        private Recognizer recognizer;

        final Recognizer getRecognizer(ValidationConsumer consumer) throws SAXException {
            if (this.recognizer == null) {
                this.recognizer = "ANY".equals(this.model) ? ANY : ("EMPTY".equals(this.model) ? new EmptyRecognizer(this) : ('#' == this.model.charAt(1) ? new MixedRecognizer(this, consumer) : new ChildrenRecognizer(this, consumer)));
            }
            return this.recognizer;
        }

        private final /* synthetic */ void this() {
            this.attributes = new Hashtable(11);
        }

        ElementInfo(String n) {
            this.this();
            this.name = n;
        }
    }

    private static final class AttributeInfo {
        String type;
        String mode;
        String value;

        private AttributeInfo() {
        }
    }

    private static class Recognizer {
        final ElementInfo type;

        boolean acceptCharacters() throws SAXException {
            return true;
        }

        Recognizer acceptElement(String name) throws SAXException {
            return this;
        }

        boolean completed() throws SAXException {
            return true;
        }

        public String toString() {
            return this.type == null ? "ANY" : this.type.model;
        }

        Recognizer(ElementInfo t) {
            this.type = t;
        }
    }

    private static final class ChildrenRecognizer
    extends Recognizer
    implements Cloneable {
        private ValidationConsumer consumer;
        private Recognizer[] components;
        private String name;
        private Recognizer next;
        private int flags;

        private final void copyIn(ChildrenRecognizer node2) {
            this.components = node2.components;
            this.name = node2.name;
            this.next = node2.next;
            this.flags = node2.flags;
        }

        private final ChildrenRecognizer shallowClone() {
            try {
                return (ChildrenRecognizer)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("clone");
            }
        }

        private final ChildrenRecognizer deepClone() {
            return this.deepClone(new Hashtable(37));
        }

        private final ChildrenRecognizer deepClone(Hashtable table) {
            ChildrenRecognizer retval;
            if ((this.flags & 1) != 0) {
                retval = (ChildrenRecognizer)table.get(this);
                if (retval != null) {
                    return this;
                }
                retval = this.shallowClone();
                table.put(this, retval);
            } else {
                retval = this.shallowClone();
            }
            if (this.next != null) {
                if (this.next instanceof ChildrenRecognizer) {
                    retval.next = ((ChildrenRecognizer)this.next).deepClone(table);
                } else if (!(this.next instanceof EmptyRecognizer)) {
                    throw new RuntimeException("deepClone");
                }
            }
            if (this.components != null) {
                retval.components = new Recognizer[this.components.length];
                int i = 0;
                while (i < this.components.length) {
                    Recognizer temp = this.components[i];
                    if (temp == null) {
                        retval.components[i] = null;
                    } else if (temp instanceof ChildrenRecognizer) {
                        retval.components[i] = ((ChildrenRecognizer)temp).deepClone(table);
                    } else if (!(temp instanceof EmptyRecognizer)) {
                        throw new RuntimeException("deepClone");
                    }
                    ++i;
                }
            }
            return retval;
        }

        private final void patchNext(Recognizer theNext, Hashtable table) {
            if ((this.flags & 2) != 0) {
                return;
            }
            if (table != null && table.get(this) != null) {
                return;
            }
            if (table == null) {
                table = new Hashtable();
            }
            if (this.name != null) {
                if (this.next == null) {
                    this.next = theNext;
                } else if (this.next instanceof ChildrenRecognizer) {
                    ((ChildrenRecognizer)this.next).patchNext(theNext, table);
                } else if (!(this.next instanceof EmptyRecognizer)) {
                    throw new RuntimeException("patchNext");
                }
                return;
            }
            int i = 0;
            while (i < this.components.length) {
                if (this.components[i] == null) {
                    this.components[i] = theNext;
                } else if (this.components[i] instanceof ChildrenRecognizer) {
                    ((ChildrenRecognizer)this.components[i]).patchNext(theNext, table);
                } else if (!(this.components[i] instanceof EmptyRecognizer)) {
                    throw new RuntimeException("patchNext");
                }
                ++i;
            }
            if (table != null && (this.flags & 1) != 0) {
                table.put(this, this);
            }
        }

        private final int populate(char[] parseBuf, int startPos) {
            char c;
            int nextPos = startPos + 1;
            if (nextPos < 0 || nextPos >= parseBuf.length) {
                throw new IndexOutOfBoundsException();
            }
            if (parseBuf[startPos] != '(') {
                boolean done = false;
                do {
                    c = parseBuf[nextPos];
                    switch (c) {
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '?': 
                        case '|': {
                            done = true;
                            break;
                        }
                        default: {
                            ++nextPos;
                            break;
                        }
                    }
                } while (!done);
                this.name = new String(parseBuf, startPos, nextPos - startPos);
            } else {
                ChildrenRecognizer first = new ChildrenRecognizer(this.consumer, this.type);
                nextPos = first.populate(parseBuf, nextPos);
                if ((c = parseBuf[nextPos++]) == ',' || c == '|') {
                    ChildrenRecognizer current = first;
                    char separator = c;
                    Vector v = null;
                    if (separator == '|') {
                        v = new Vector();
                        v.addElement(first);
                    }
                    do {
                        ChildrenRecognizer link = new ChildrenRecognizer(this.consumer, this.type);
                        nextPos = link.populate(parseBuf, nextPos);
                        if (separator == ',') {
                            current.patchNext(link, null);
                            current = link;
                            continue;
                        }
                        v.addElement(link);
                    } while ((c = parseBuf[nextPos++]) == separator);
                    if (separator == '|') {
                        this.components = new Recognizer[v.size()];
                        int i = 0;
                        while (i < this.components.length) {
                            this.components[i] = (Recognizer)v.elementAt(i);
                            ++i;
                        }
                    } else {
                        this.copyIn(first);
                    }
                } else {
                    this.copyIn(first);
                }
                if (c != ')') {
                    throw new RuntimeException("corrupt content model");
                }
            }
            if (nextPos < parseBuf.length && ((c = parseBuf[nextPos]) == '?' || c == '*' || c == '+')) {
                ++nextPos;
                if (c == '?') {
                    ChildrenRecognizer once = this.shallowClone();
                    this.components = new Recognizer[2];
                    this.components[0] = once;
                    this.name = null;
                    this.next = null;
                    this.flags = 0;
                } else if (c == '*') {
                    ChildrenRecognizer loop = this.shallowClone();
                    loop.patchNext(this, null);
                    loop.flags |= 2;
                    this.flags = 1;
                    this.components = new Recognizer[2];
                    this.components[0] = loop;
                    this.name = null;
                    this.next = null;
                } else if (c == '+') {
                    ChildrenRecognizer loop = this.deepClone();
                    ChildrenRecognizer choice = new ChildrenRecognizer(this.consumer, this.type);
                    loop.patchNext(choice, null);
                    loop.flags |= 2;
                    choice.flags = 1;
                    choice.components = new Recognizer[2];
                    choice.components[0] = loop;
                    this.patchNext(choice, null);
                }
            }
            return nextPos;
        }

        final boolean acceptCharacters() {
            return false;
        }

        final Recognizer acceptElement(String type) throws SAXException {
            if (this.name != null) {
                if (this.name.equals(type)) {
                    return this.next;
                }
                return null;
            }
            Recognizer retval = null;
            int i = 0;
            while (i < this.components.length) {
                Recognizer temp = this.components[i].acceptElement(type);
                if (temp != null) {
                    return temp;
                }
                ++i;
            }
            return retval;
        }

        final boolean completed() throws SAXException {
            if (this.name != null) {
                return false;
            }
            int i = 0;
            while (i < this.components.length) {
                if (this.components[i].completed()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public ChildrenRecognizer(ElementInfo type, ValidationConsumer vc) {
            this(vc, type);
            this.populate(type.model.toCharArray(), 0);
            this.patchNext(new EmptyRecognizer(type), null);
        }

        private ChildrenRecognizer(ValidationConsumer vc, ElementInfo type) {
            super(type);
            this.consumer = vc;
        }
    }

    private static final class MixedRecognizer
    extends Recognizer {
        private String[] permitted;

        final Recognizer acceptElement(String name) {
            int length = this.permitted.length;
            int i = 0;
            while (i < length) {
                if (this.permitted[i] == name) {
                    return this;
                }
                ++i;
            }
            i = 0;
            while (i < length) {
                if (this.permitted[i].equals(name)) {
                    return this;
                }
                ++i;
            }
            return null;
        }

        public MixedRecognizer(ElementInfo t, ValidationConsumer v) throws SAXException {
            super(t);
            StringTokenizer tokens = new StringTokenizer(t.model.substring(8, t.model.lastIndexOf(41)), "|");
            Vector vec = new Vector();
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (vec.contains(token)) {
                    v.error("element " + token + " is repeated in mixed content model: " + t.model);
                    continue;
                }
                vec.addElement(token.intern());
            }
            this.permitted = new String[vec.size()];
            int i = 0;
            while (i < this.permitted.length) {
                this.permitted[i] = (String)vec.elementAt(i);
                ++i;
            }
        }
    }

    private static final class EmptyRecognizer
    extends Recognizer {
        final boolean acceptCharacters() {
            return false;
        }

        final Recognizer acceptElement(String name) {
            return null;
        }

        public EmptyRecognizer(ElementInfo type) {
            super(type);
        }
    }
}

