/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;
    private boolean tightPixelPacking;

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new ComponentSampleModel(this.dataType, w, h, this.pixelStride, this.scanlineStride, this.bankIndices, this.bandOffsets);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        int numBands = bands.length;
        int[] bankIndices = new int[numBands];
        int[] bandOffsets = new int[numBands];
        int b = 0;
        while (b < numBands) {
            bankIndices[b] = this.bankIndices[bands[b]];
            bandOffsets[b] = this.bandOffsets[bands[b]];
            ++b;
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, bankIndices, bandOffsets);
    }

    public DataBuffer createDataBuffer() {
        int highestOffset = 0;
        int b = 0;
        while (b < this.numBands) {
            highestOffset = Math.max(highestOffset, this.bandOffsets[b]);
            ++b;
        }
        int size = this.pixelStride * (this.width - 1) + this.scanlineStride * (this.height - 1) + highestOffset + 1;
        return Buffers.createBuffer(this.getDataType(), size, this.numBanks);
    }

    public int getOffset(int x, int y) {
        return this.getOffset(x, y, 0);
    }

    public int getOffset(int x, int y, int b) {
        return this.bandOffsets[b] + this.pixelStride * x + this.scanlineStride * y;
    }

    public final int[] getSampleSize() {
        int size = DataBuffer.getDataTypeSize(this.getDataType());
        int[] sizes = new int[this.numBands];
        Arrays.fill(sizes, size);
        return sizes;
    }

    public final int getSampleSize(int band) {
        return DataBuffer.getDataTypeSize(this.getDataType());
    }

    public final int[] getBankIndices() {
        return this.bankIndices;
    }

    public final int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.numBands;
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int xyOffset = this.pixelStride * x + this.scanlineStride * y;
        int[] totalBandDataOffsets = new int[this.numBands];
        int[] bankOffsets = data.getOffsets();
        int b = 0;
        while (b < this.numBands) {
            totalBandDataOffsets[b] = this.bandOffsets[b] + bankOffsets[this.bankIndices[b]] + xyOffset;
            ++b;
        }
        try {
            switch (this.getTransferType()) {
                case 0: {
                    DataBufferByte inByte = (DataBufferByte)data;
                    byte[] outByte = (byte[])obj;
                    if (outByte == null) {
                        outByte = new byte[this.numBands];
                    }
                    int b2 = 0;
                    while (b2 < this.numBands) {
                        int dOffset = totalBandDataOffsets[b2];
                        outByte[b2] = inByte.getData(this.bankIndices[b2])[dOffset];
                        ++b2;
                    }
                    return outByte;
                }
                case 1: {
                    DataBufferUShort inUShort = (DataBufferUShort)data;
                    short[] outUShort = (short[])obj;
                    if (outUShort == null) {
                        outUShort = new short[this.numBands];
                    }
                    int b3 = 0;
                    while (b3 < this.numBands) {
                        int dOffset = totalBandDataOffsets[b3];
                        outUShort[b3] = inUShort.getData(this.bankIndices[b3])[dOffset];
                        ++b3;
                    }
                    return outUShort;
                }
                case 2: {
                    DataBufferShort inShort = (DataBufferShort)data;
                    short[] outShort = (short[])obj;
                    if (outShort == null) {
                        outShort = new short[this.numBands];
                    }
                    int b4 = 0;
                    while (b4 < this.numBands) {
                        int dOffset = totalBandDataOffsets[b4];
                        outShort[b4] = inShort.getData(this.bankIndices[b4])[dOffset];
                        ++b4;
                    }
                    return outShort;
                }
                case 3: {
                    DataBufferInt inInt = (DataBufferInt)data;
                    int[] outInt = (int[])obj;
                    if (outInt == null) {
                        outInt = new int[this.numBands];
                    }
                    int b5 = 0;
                    while (b5 < this.numBands) {
                        int dOffset = totalBandDataOffsets[b5];
                        outInt[b5] = inInt.getData(this.bankIndices[b5])[dOffset];
                        ++b5;
                    }
                    return outInt;
                }
                case 4: {
                    DataBufferFloat inFloat = (DataBufferFloat)data;
                    float[] outFloat = (float[])obj;
                    if (outFloat == null) {
                        outFloat = new float[this.numBands];
                    }
                    int b6 = 0;
                    while (b6 < this.numBands) {
                        int dOffset = totalBandDataOffsets[b6];
                        outFloat[b6] = inFloat.getData(this.bankIndices[b6])[dOffset];
                        ++b6;
                    }
                    return outFloat;
                }
                case 5: {
                    DataBufferDouble inDouble = (DataBufferDouble)data;
                    double[] outDouble = (double[])obj;
                    if (outDouble == null) {
                        outDouble = new double[this.numBands];
                    }
                    int b7 = 0;
                    while (b7 < this.numBands) {
                        int dOffset = totalBandDataOffsets[b7];
                        outDouble[b7] = inDouble.getData(this.bankIndices[b7])[dOffset];
                        ++b7;
                    }
                    return outDouble;
                }
            }
            throw new IllegalStateException("unknown transfer type " + this.getTransferType());
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "While reading data elements, x=" + x + ", y=" + y + ", , xyOffset=" + xyOffset + ", data.getSize()=" + data.getSize() + ": " + aioobe;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        if (!this.tightPixelPacking) {
            return super.getDataElements(x, y, w, h, obj, data);
        }
        int rowSize = w * this.numBands;
        int dataSize = rowSize * h;
        DataBuffer transferBuffer = Buffers.createBuffer(this.getTransferType(), obj, dataSize);
        obj = Buffers.getData(transferBuffer);
        int inOffset = this.pixelStride * x + this.scanlineStride * y + data.getOffset();
        if (this.scanlineStride == rowSize) {
            rowSize *= h;
            h = 1;
        }
        int outOffset = 0;
        Object inArray = Buffers.getData(data);
        int yd = 0;
        while (yd < h) {
            System.arraycopy(inArray, inOffset, obj, outOffset, rowSize);
            inOffset += this.scanlineStride;
            outOffset += rowSize;
            ++yd;
        }
        return obj;
    }

    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        if (!this.tightPixelPacking) {
            super.setDataElements(x, y, w, h, obj, data);
            return;
        }
        int rowSize = w * this.numBands;
        int dataSize = rowSize * h;
        DataBuffer transferBuffer = Buffers.createBufferFromData(this.getTransferType(), obj, dataSize);
        int[] bankOffsets = data.getOffsets();
        int outOffset = this.pixelStride * x + this.scanlineStride * y + bankOffsets[0];
        if (this.scanlineStride == rowSize) {
            rowSize *= h;
            h = 1;
        }
        int inOffset = 0;
        Object outArray = Buffers.getData(data);
        int yd = 0;
        while (yd < h) {
            System.arraycopy(obj, inOffset, outArray, outOffset, rowSize);
            outOffset += this.scanlineStride;
            inOffset += rowSize;
            ++yd;
        }
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        int b = 0;
        while (b < this.numBands) {
            iArray[b] = data.getElem(this.bankIndices[b], offset + this.bandOffsets[b]);
            ++b;
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        if (iArray == null) {
            iArray = new int[this.numBands * w * h];
        }
        int outOffset = 0;
        y = 0;
        while (y < h) {
            int lineOffset = offset;
            x = 0;
            while (x < w) {
                int b = 0;
                while (b < this.numBands) {
                    iArray[outOffset++] = data.getElem(this.bankIndices[b], lineOffset + this.bandOffsets[b]);
                    ++b;
                }
                lineOffset += this.pixelStride;
                ++x;
            }
            offset += this.scanlineStride;
            ++y;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        return data.getElem(this.bankIndices[b], this.getOffset(x, y, b));
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        int[] totalBandDataOffsets = new int[this.numBands];
        int[] bankOffsets = data.getOffsets();
        int b = 0;
        while (b < this.numBands) {
            totalBandDataOffsets[b] = this.bandOffsets[b] + bankOffsets[this.bankIndices[b]] + offset;
            ++b;
        }
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte out = (DataBufferByte)data;
                byte[] in = (byte[])obj;
                int b2 = 0;
                while (b2 < this.numBands) {
                    out.getData((int)this.bankIndices[b2])[totalBandDataOffsets[b2]] = in[b2];
                    ++b2;
                }
                return;
            }
            case 1: {
                DataBufferUShort out = (DataBufferUShort)data;
                short[] in = (short[])obj;
                int b3 = 0;
                while (b3 < this.numBands) {
                    out.getData((int)this.bankIndices[b3])[totalBandDataOffsets[b3]] = in[b3];
                    ++b3;
                }
                return;
            }
            case 2: {
                DataBufferShort out = (DataBufferShort)data;
                short[] in = (short[])obj;
                int b4 = 0;
                while (b4 < this.numBands) {
                    out.getData((int)this.bankIndices[b4])[totalBandDataOffsets[b4]] = in[b4];
                    ++b4;
                }
                return;
            }
            case 3: {
                DataBufferInt out = (DataBufferInt)data;
                int[] in = (int[])obj;
                int b5 = 0;
                while (b5 < this.numBands) {
                    out.getData((int)this.bankIndices[b5])[totalBandDataOffsets[b5]] = in[b5];
                    ++b5;
                }
                return;
            }
            case 4: {
                DataBufferFloat out = (DataBufferFloat)data;
                float[] in = (float[])obj;
                int b6 = 0;
                while (b6 < this.numBands) {
                    out.getData((int)this.bankIndices[b6])[totalBandDataOffsets[b6]] = in[b6];
                    ++b6;
                }
                return;
            }
            case 5: {
                DataBufferDouble out = (DataBufferDouble)data;
                double[] in = (double[])obj;
                int b7 = 0;
                while (b7 < this.numBands) {
                    out.getData((int)this.bankIndices[b7])[totalBandDataOffsets[b7]] = in[b7];
                    ++b7;
                }
                return;
            }
        }
        throw new UnsupportedOperationException("transfer type not implemented");
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        int b = 0;
        while (b < this.numBands) {
            data.setElem(this.bankIndices[b], offset + this.bandOffsets[b], iArray[b]);
            ++b;
        }
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        data.setElem(this.bankIndices[b], this.getOffset(x, y, b), s);
    }

    private final /* synthetic */ void this() {
        this.tightPixelPacking = false;
    }

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bandOffsets) {
        this(dataType, w, h, pixelStride, scanlineStride, new int[bandOffsets.length], bandOffsets);
    }

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, bandOffsets.length);
        this.this();
        if (pixelStride < 0 || scanlineStride < 0 || bandOffsets.length < 1 || bandOffsets.length != bankIndices.length) {
            throw new IllegalArgumentException();
        }
        this.bandOffsets = bandOffsets;
        this.bankIndices = bankIndices;
        this.numBands = bandOffsets.length;
        this.numBanks = 0;
        int b = 0;
        while (b < bankIndices.length) {
            this.numBanks = Math.max(this.numBanks, bankIndices[b] + 1);
            ++b;
        }
        this.scanlineStride = scanlineStride;
        this.pixelStride = pixelStride;
        if (pixelStride == this.numBands) {
            this.tightPixelPacking = true;
            b = 0;
            while (b < this.numBands) {
                if (bandOffsets[b] != b || bankIndices[b] != 0) {
                    this.tightPixelPacking = false;
                    break;
                }
                ++b;
            }
        }
    }
}

