<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- $Id: tex-refs-pdf.xsl 146 2005-05-14 15:34:22Z mw $ -->

  <!-- we use an XML catalog to resolve this file -->
  <xsl:import href="http://db2latex.sourceforge.net/xsl/docbook.xsl"/>

  <xsl:output method="text" encoding="ISO-8859-1" indent="yes"/>

  <xsl:param name="latex.documentclass">scrbook</xsl:param>
  <xsl:param name="latex.documentclass.book">twoside,openright,tocleft,listsleft,smallheadings,10pt,halfparskip</xsl:param>

  <xsl:param name="latex.hyperref.param.common">bookmarksnumbered,backref,breaklinks,linktocpage</xsl:param>

  <xsl:variable name="latex.math.support">1</xsl:variable>

  <!-- we use the Latin Modern fonts -->
  <!-- <xsl:variable name="latex.document.font">lmodern</xsl:variable> -->
  <xsl:variable name="latex.document.font"></xsl:variable>

  <xsl:variable name="latex.documentclass.common"></xsl:variable>
  <xsl:variable name="latex.babel.language">english</xsl:variable>
  
  <xsl:variable name="latex.hyphenation.tttricks">1</xsl:variable>

  <xsl:param name="latex.inline.monoseq.style">\texttt</xsl:param>

  <xsl:variable name="latex.admonition.environment">
    <xsl:text>% ---------------------------------------------- &#10;</xsl:text>
    <xsl:text>% Define a new LaTeX environment (adminipage)    &#10;</xsl:text>
    <xsl:text>% Modified for DAHB, M. Wiedmann, 2003.07.25     &#10;</xsl:text>
    <xsl:text>% ---------------------------------------------- &#10;</xsl:text>
    <xsl:text>\newenvironment{admminipage}%&#10;</xsl:text>
    <xsl:text>{ % this code corresponds to the \begin{adminipage} command&#10;</xsl:text>
    <xsl:text> \begin{Sbox}%&#10;</xsl:text>
    <xsl:text> \begin{minipage}%&#10;</xsl:text>
    <xsl:text>} %done&#10;</xsl:text>
    <xsl:text>{ % this code corresponds to the \end{adminipage} command&#10;</xsl:text>
    <xsl:text> \end{minipage}&#10;</xsl:text>
    <xsl:text> \end{Sbox}&#10;</xsl:text>
    <xsl:text> \fbox{\TheSbox}&#10;</xsl:text>
    <xsl:text>} %done&#10;</xsl:text>
    <xsl:text>% ---------------------------------------------- &#10;</xsl:text>
    <xsl:text>% Define a new LaTeX length (admlength)          &#10;</xsl:text>
    <xsl:text>% ---------------------------------------------- &#10;</xsl:text>
    <xsl:text>\newlength{\admlength}&#10;</xsl:text>
    <xsl:text>% ---------------------------------------------- &#10;</xsl:text>
    <xsl:text>% Define a new LaTeX environment (admonition)    &#10;</xsl:text>
    <xsl:text>% With 2 parameters:                             &#10;</xsl:text>
    <xsl:text>% #1 The file (e.g. note.pdf)                    &#10;</xsl:text>
    <xsl:text>% #2 The caption                                 &#10;</xsl:text>
    <xsl:text>% ---------------------------------------------- &#10;</xsl:text>
    <xsl:text>\newenvironment{admonition}[2] &#10;</xsl:text>
    <xsl:text>{ % this code corresponds to the \begin{admonition} command&#10;</xsl:text>
    <xsl:text> \begin{center}% Added MW&#10;</xsl:text>
    <xsl:text> %\hspace{0mm}\newline\hspace*\fill\newline&#10;</xsl:text>
    <xsl:text> \noindent&#10;</xsl:text>
    <xsl:text> \setlength{\fboxsep}{5pt}&#10;</xsl:text>
    <xsl:text> \setlength{\admlength}{\linewidth}&#10;</xsl:text>
    <xsl:text> \addtolength{\admlength}{-10\fboxsep}&#10;</xsl:text>
    <xsl:text> \addtolength{\admlength}{-10\fboxrule}&#10;</xsl:text>
    <xsl:text> \admminipage{\admlength}&#10;</xsl:text>
    <xsl:text> {\bfseries \sc\normalsize{#2}}</xsl:text>
    <xsl:text> \newline&#10;</xsl:text>
    <xsl:text> \\[0.3ex]&#10;</xsl:text>
    <xsl:text> \sffamily&#10;</xsl:text>
  <!--
       If we cannot find the latex.admonition.path;
       Comment out the next line (\includegraphics).
       This tactic is to avoid deleting the \includegraphics
       altogether, as that could confuse a person trying to
       find the use of parameter #1 in the environment.
  -->
  <xsl:if test="$latex.admonition.path=''">
    <xsl:text>%</xsl:text>
  </xsl:if>
  <xsl:text> \includegraphics[</xsl:text> <xsl:value-of select="$latex.admonition.imagesize" /> <xsl:text>]{#1}&#10;</xsl:text>
  <xsl:text> \addtolength{\admlength}{-1cm}&#10;</xsl:text>
  <xsl:text> \addtolength{\admlength}{10pt}&#10;</xsl:text>
  <xsl:text> \begin{minipage}[lt]{\admlength}&#10;</xsl:text>
  <xsl:text> \parskip=0.5\baselineskip \advance\parskip by 0pt plus 2pt&#10;</xsl:text>
  <xsl:text> \small% Added MW&#10;</xsl:text>
  <xsl:text>} %done&#10;</xsl:text>
  <xsl:text>{ % this code corresponds to the \end{admonition} command&#10;</xsl:text>
  <xsl:text> \vspace{1mm}% Changed MW: from 5 to 1mm &#10;</xsl:text>
  <xsl:text> \end{minipage}&#10;</xsl:text>
  <xsl:text> \endadmminipage&#10;</xsl:text>
  <xsl:text> \vspace{.5em}&#10;</xsl:text>
  <xsl:text> \par&#10;</xsl:text>
  <xsl:text> \end{center}% Added MW&#10;</xsl:text>
  <xsl:text>}&#10;</xsl:text>
</xsl:variable>

  <!-- path to admonition figure graphic files -->
  <!-- <xsl:param name="latex.admonition.path">/usr/share/sgml/docbook/stylesheet/xsl/db2latex/latex/figures</xsl:param> -->
  <xsl:param name="latex.admonition.path"></xsl:param>

  <!-- we use scrbook which provides headers 
       but they do not work yet!
  -->
  <xsl:param name="latex.use.fancyhdr">1</xsl:param>

  <xsl:param name="latex.use.tabularx">1</xsl:param>

  <xsl:variable name="latex.hyperref.param.pdftex">
    pdfauthor={Michael Wiedmann}, 
    pdfpagemode=UseNone, 
    pdfstartview=FitH,
    pdftitle={References for TeX and Friends},
    pdfcreator={DocBook/XML db2latex-xsl},
    pdfsubject={},
    pdfkeywords={TeX, LaTeX},
    pdfpagelabels
  </xsl:variable>

  <xsl:param name="latex.use.parskip">1</xsl:param>
  <xsl:param name="latex.use.makeidx">1</xsl:param>
  <xsl:param name="toc.section.depth">2</xsl:param>

  <xsl:param name="latex.entities"></xsl:param>

  <xsl:param name="latex.use.subfigure">0</xsl:param>
  <xsl:param name="latex.caption.swapskip">0</xsl:param>

  <!-- for customizing LaTeX mapping -->
  <!-- we need this e.g. for 'revhistory' -->
  <xsl:variable name="latex.mapping.xml" select="document('tex-refs-local.mapping.xml')"/>

  <xsl:variable name="latex.book.varsets">
    <xsl:text>%% headings &#10;</xsl:text>
    <xsl:text>%\usepackage[automark]{scrpage2} &#10;</xsl:text>
    <xsl:text>%\pagestyle{scrheadings} &#10;</xsl:text>
    <xsl:text>%% T1 encoding &#10;</xsl:text>
    <xsl:text>\usepackage[T1]{fontenc}&#10;</xsl:text>
    <xsl:text>%% character protruding for pdftex&#10;</xsl:text>
    <xsl:text>\usepackage[activate]{pdfcprot}&#10;</xsl:text>
    <xsl:text>%% load geometry package for setting margins&#10;</xsl:text>
    <xsl:text>\usepackage{geometry}&#10;</xsl:text>
    <xsl:text>\geometry{lmargin=2.5cm,rmargin=2.0cm,tmargin=2.0cm,bmargin=2.0cm,headsep=1.0cm,footskip=1.5cm}&#10;</xsl:text>
    <xsl:text>%% title&#10;</xsl:text>
    <xsl:text>%FIXME&#10;</xsl:text>
    <xsl:text>\pagestyle{plain}&#10;</xsl:text>
    <xsl:text>\titlehead{}&#10;</xsl:text>
    <xsl:text>\uppertitleback{}&#10;</xsl:text>
    <xsl:text>\lowertitleback{}&#10;</xsl:text>
    <xsl:text>\dedication{}&#10;</xsl:text>
    <xsl:text>\subject{}&#10;</xsl:text>
    <xsl:text>\publishers{}&#10;</xsl:text>
    <xsl:text>\date{</xsl:text><xsl:value-of select="/book/bookinfo/date"/><xsl:text>}&#10;</xsl:text>
    <xsl:text>%% support for landscape pages&#10;</xsl:text>
    <xsl:text>\usepackage{lscape}&#10;</xsl:text>
    <xsl:text>%% used by multicolumn!&#10;</xsl:text>
    <xsl:text>\usepackage{calc}&#10;</xsl:text>
    <!--
    <xsl:text>%% end up with even pages&#10;</xsl:text>
    <xsl:text>\AtEndDocument{%&#10;</xsl:text>
    <xsl:text> \newcommand\QuadPages{%&#10;</xsl:text>
    <xsl:text>  \setcounter{subparagraph}{\value{page}}%&#10;</xsl:text>
    <xsl:text>  \divide\value{subparagraph} by 2\relax%&#10;</xsl:text>
    <xsl:text>  \multiply\value{subparagraph} by 2\relax%&#10;</xsl:text>
    <xsl:text>  \ifnum\value{subparagraph}=\value{page}\let\QuadPages=\relax&#10;</xsl:text>
    <xsl:text>   \null\thispagestyle{empty}\clearpage&#10;</xsl:text>
    <xsl:text>  \else\null\newpage\fi&#10;</xsl:text>
    <xsl:text>  \QuadPages}&#10;</xsl:text>
    <xsl:text> \clearpage&#10;</xsl:text>
    <xsl:text> \markboth{Notes}{Notes}\QuadPages&#10;</xsl:text>
    <xsl:text>}&#10;</xsl:text>
    -->
  </xsl:variable>

  <!-- outputs per default \makeglossary which we don't use -->
  <xsl:param name="latex.book.afterauthor"/>

  <xsl:variable name="latex.book.preamble.post">
    <xsl:text>%% get rid of fancyhdr's rulers&#10;</xsl:text>
    <xsl:text>\renewcommand{\headrulewidth}{0pt}&#10;</xsl:text>           
    <xsl:text>\renewcommand{\footrulewidth}{0pt}&#10;</xsl:text>
    <xsl:text>\fancyhead[LE,RO]{\nouppercase{\rightmark}}&#10;</xsl:text>
    <xsl:text>\fancyhead[LO,RE]{\nouppercase{\leftmark}}&#10;</xsl:text>
    <xsl:text>\cfoot{}&#10;</xsl:text>
    <xsl:text>\fancyfoot[LE,RO]{\thepage}&#10;</xsl:text>
    <xsl:text>%%&#10;</xsl:text>
    <xsl:text>%% hyphenation settings&#10;</xsl:text>
    <xsl:text>\setlength\emergencystretch{3em}&#10;</xsl:text>
    <xsl:text>\hyphenpenalty=1000&#10;</xsl:text>
    <xsl:text>\AtBeginDocument{\lefthyphenmin=3\righthyphenmin=3}&#10;</xsl:text>
    <xsl:text>%% more space for floats&#10;</xsl:text>
    <xsl:text>\renewcommand{\textfraction}{0.05}%&#10;</xsl:text>
    <xsl:text>\renewcommand{\topfraction}{0.95}%&#10;</xsl:text>
    <xsl:text>\renewcommand{\bottomfraction}{0.95}%&#10;</xsl:text>
    <xsl:text>\renewcommand{\floatpagefraction}{0.35}%&#10;</xsl:text>
    <xsl:text>%% some special lists &#10;</xsl:text>
    <xsl:text>\usepackage{mdwlist}&#10;</xsl:text>
    <xsl:text>%&#10;</xsl:text>
    <xsl:text>%some special symbols&#10;</xsl:text>
    <xsl:text>\providecommand\BibTeX{\textsc{Bib}\kern-0.08em\TeX}&#10;</xsl:text>
    <xsl:text>\providecommand\Makeindex{\textit{Make\-Index}}&#10;</xsl:text>
    <xsl:text>\providecommand\PiCTeX{P\kern-.12em\lower.5ex\hbox{I}\kern-.075emC\kern-.11em\TeX}&#10;</xsl:text>
    <xsl:text>% Taken from "dtklogos.sty"&#10;</xsl:text>
    <xsl:text><![CDATA[% tbd. for MP/MF]]>&#10;</xsl:text>
    <xsl:text>\usepackage{shorttoc}&#10;</xsl:text>
    <xsl:text>%&#10;</xsl:text>
    <xsl:text>% Code to handle the revhistory, copyright,&#10;</xsl:text>
    <xsl:text>% and legalnotice tags like we want&#10;</xsl:text>
    <xsl:text><![CDATA[\newcommand*\mystartvskip{}
\newcommand*\myendvskip{}
\makeatletter
\begingroup
\def\vspace*#1{#1}
\@tempskipa=\chapterheadstartvskip\relax
\@tempskipa=-\@tempskipa
\xdef\mystartvskip{\the\@tempskipa}
\def\vspace#1{#1}
\@tempskipa=\chapterheadendvskip\relax
%\@tempskipa=-\@tempskipa
\xdef\myendvskip{\the\@tempskipa}
\endgroup

\newcommand\originalsection{}
\let\originalsection=\section
\newcommand*\fakechapter{\@startsection{chapter}{0}{\z@}%
  {\mystartvskip}%
  {\myendvskip}%
  {\raggedsection\normalfont\sectfont\nobreak\size@chapter\nobreak}}
\makeatother
]]>&#10;</xsl:text>
    <xsl:text>% end of special code&#10;</xsl:text>
  </xsl:variable>

  <!-- template overrides -->
  
  <xsl:template match="toc">
    <xsl:text>&#10;\def\dbtolatex@@contentsname{</xsl:text>
      <xsl:variable name="title">
        <xsl:call-template name="extract.object.title">
          <xsl:with-param name="object" select="."/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$title=''">
          <xsl:text>\dbtolatex@@contentsname</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$title"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text>}&#10;</xsl:text>
    <xsl:choose>
      <xsl:when test="starts-with(@condition,'db2latex:')">
        <xsl:text>\shorttoc{\dbtolatex@@contentsname}{</xsl:text>
        <xsl:value-of select="substring-after(@condition,'db2latex:')"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-imports/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- override 'revision'  -->
  <!-- use a more pleasant (IMHO) table layout for the 'revhistory' -->
  <xsl:template match="revhistory/revision">
    <xsl:variable name="revnumber" select=".//revnumber"/>
    <xsl:variable name="revdate"   select=".//date"/>
    <xsl:variable name="revauthor" select=".//authorinitials"/>
    <xsl:variable name="revremark" select=".//revremark|.//revdescription"/>

    <xsl:if test="$revnumber">
      <xsl:call-template name="gentext.element.name"/>
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="$revnumber"/>
    </xsl:if>
    <xsl:text> &amp; </xsl:text>
    <xsl:apply-templates select="$revdate"/>
    <xsl:text> &amp; </xsl:text>
    <xsl:choose>
      <xsl:when test="count($revauthor)=0">
        <xsl:call-template name="dingbat">
          <xsl:with-param name="dingbat">nbsp</xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="$revauthor"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> \\&#10;</xsl:text>
    <xsl:if test="$revremark"> 
      <xsl:text>\multicolumn{3}{@{}l@{}}{\parbox{\linewidth-4\tabcolsep}{</xsl:text>
      <xsl:apply-templates select="$revremark"/> 
      <xsl:choose>
        <xsl:when test="position()!=last()">
          <xsl:text>\\[.2em]~}}\\</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>\\~}}\\</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text>&#10;</xsl:text>
    </xsl:if>
  </xsl:template>


  <!-- override maketile of db2latex -->
  <xsl:variable name="latex.maketitle">
    <xsl:text>\maketitle&#10;</xsl:text>
  </xsl:variable>

  <!-- override "verbatim.apply.templates":
       we support attribute 'role' with different values
       for 'fontsize', 'samepage', and 'lines'
       (see 'fancyvrb' for details) 
       additionally we support 'landscape': places content on
       separate pages in landscape mode
  -->
  <xsl:template name="verbatim.apply.templates">
    <xsl:if test="contains(@role,'landscape')">
      <xsl:text>\begin{landscape}&#10;</xsl:text>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="$latex.use.fancyvrb='1'">
	<xsl:variable name="not_monospaced" select="local-name(.)='literallayout' and @format!='monospaced'"/>
	<xsl:text>&#10;\begin{Verbatim}[</xsl:text>
	<xsl:if test="@linenumbering='numbered'">
	  <xsl:text>,numbers=left</xsl:text>
	</xsl:if>
	<xsl:if test="$not_monospaced">
	  <xsl:text>,fontfamily=default</xsl:text>
	</xsl:if>
        <!-- extensions by MW -->
	<xsl:if test="@role">
	  <xsl:if test="contains(@role,'small')">
	    <xsl:text>,fontsize=\small</xsl:text>
	  </xsl:if>
	  <xsl:if test="contains(@role,'footnotesize')">
	    <xsl:text>,fontsize=\footnotesize</xsl:text>
	  </xsl:if>
	  <xsl:if test="contains(@role,'scriptsize')">
	    <xsl:text>,fontsize=\scriptsize</xsl:text>
	  </xsl:if>
	  <xsl:if test="contains(@role,'large')">
	    <xsl:text>,fontsize=\large</xsl:text>
	  </xsl:if>
	  <xsl:if test="contains(@role,'Large')">
	    <xsl:text>,fontsize=\Large</xsl:text>
	  </xsl:if>
	  <xsl:if test="contains(@role, 'samepage')">
	    <xsl:text>,samepage=true</xsl:text>
	  </xsl:if>
	  <xsl:if test="contains(@role, 'lines')">
	    <xsl:text>,frame=lines</xsl:text>
	  </xsl:if>
	</xsl:if>
	<xsl:text>]&#10;</xsl:text>
	<xsl:choose>
	  <xsl:when test="$not_monospaced">
	    <!-- Needs to be changed to cope with regular characterset! -->
	    <xsl:apply-templates mode="latex.verbatim"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates mode="latex.verbatim"/>
	  </xsl:otherwise>
	</xsl:choose>
	<xsl:text>&#10;\end{Verbatim}&#10;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
	<xsl:text>&#10;\begin{verbatim}&#10;</xsl:text>
	<xsl:apply-templates mode="latex.verbatim"/>
	<xsl:text>&#10;\end{verbatim}&#10;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="contains(@role,'landscape')">
      <xsl:text>\end{landscape}&#10;</xsl:text>
    </xsl:if>
  </xsl:template>

  <!-- override: use 'role="nohyphenation"' to avoid hyphenation in title's -->
  <xsl:template match="filename">
    <xsl:choose>
      <xsl:when test="contains(@role,'nohyphenation')">
	<xsl:call-template name="inline.monoseq"><xsl:with-param name="hyphenation"></xsl:with-param></xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="inline.monoseq"><xsl:with-param name="hyphenation">\docbookhyphenatefilename</xsl:with-param></xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- override floatstyles for figures and tables    -->
  <!-- we use 'floatstyle=plain' for figures and tables -->
  <xsl:template name="latex.float.preamble">
    <xsl:text>% --------------------------------------------&#10;</xsl:text>
    <xsl:text>% Commands to manage/style/create floats      &#10;</xsl:text>
    <xsl:text>% figures, tables, algorithms, examples, eqn  &#10;</xsl:text>
    <xsl:text>% Customized for DAHB by mw, 20030506         &#10;</xsl:text>
    <xsl:text>% --------------------------------------------&#10;</xsl:text>
    <xsl:text> \floatstyle{plain}&#10;</xsl:text>
    <xsl:text> \restylefloat{figure}&#10;</xsl:text>
    <xsl:text> \floatstyle{plain}&#10;</xsl:text>
    <xsl:text> \restylefloat{table}&#10;</xsl:text>
    <xsl:text> \floatstyle{ruled}&#10;</xsl:text>
    <xsl:text> \newfloat{program}{ht}{lop}[section]&#10;</xsl:text>
    <xsl:text> \floatstyle{ruled}&#10;</xsl:text>
    <xsl:text> \newfloat{example}{ht}{loe}[section]&#10;</xsl:text>
    <xsl:text> \floatname{example}{</xsl:text>
    <xsl:call-template name="gentext.element.name">
      <xsl:with-param name="element.name">example</xsl:with-param>
    </xsl:call-template>
    <xsl:text>}&#10;</xsl:text>
    <xsl:text> \floatstyle{ruled}&#10;</xsl:text>
    <xsl:text> \newfloat{dbequation}{ht}{loe}[section]&#10;</xsl:text>
    <xsl:text> \floatname{dbequation}{</xsl:text>
    <xsl:call-template name="gentext.element.name">
      <xsl:with-param name="element.name">equation</xsl:with-param>
    </xsl:call-template>
    <xsl:text>}&#10;</xsl:text>
    <xsl:text> \floatstyle{boxed}&#10;</xsl:text>
    <xsl:text> \newfloat{algorithm}{ht}{loa}[section]&#10;</xsl:text>
    <xsl:text> \floatname{algorithm}{Algorithm}&#10;</xsl:text>
  </xsl:template>

  <!-- override informaltable: we want a smaller font -->
  <xsl:template match="informaltable">
    <xsl:if test="contains(@role,'Large')">
      <xsl:text>\Large&#10;</xsl:text>
    </xsl:if>
    <xsl:if test="contains(@role,'large')">
      <xsl:text>\large&#10;</xsl:text>
    </xsl:if>
    <xsl:if test="contains(@role,'small')">
      <xsl:text>\small&#10;</xsl:text>
    </xsl:if>
    <xsl:if test="contains(@role,'footnotesize')">
      <xsl:text>\footnotesize&#10;</xsl:text>
    </xsl:if>

    <xsl:call-template name="map.begin"/>
    <xsl:apply-templates/>
    <xsl:call-template name="map.end"/>

    <xsl:text>\normalsize&#10;</xsl:text>
  </xsl:template>

  <!-- we want "\noindent" in some cases --> 
  <xsl:template match="para|simpara">
    <xsl:choose>
      <xsl:when test="contains(@role,'db2latex:noindent')">
        <xsl:text>\noindent </xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#10;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates/>
    <xsl:choose>
      <xsl:when test="contains(@role,'db2latex:noindent')">
        <xsl:text>\vspace{1ex}\par</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#10;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>

  <!-- include modified table templates. 
       Snapshot up to 2003-10-01 is buggy.
  -->
  <xsl:include href="db2latex-mw-table.xsl"/>

  <!-- include modified (enhanced) variablelist template -->
  <xsl:include href="db2latex-mw-variablelist.xsl"/>

  <!-- include modified (enhanced) itemizedlist template -->
  <xsl:include href="db2latex-mw-itemizedlist.xsl"/>

  <xsl:template match="bridgehead" name="bridgehead">
    <xsl:param name="renderas" select="@renderas"/>
    <xsl:param name="content"><xsl:apply-templates/></xsl:param>
    <xsl:choose>
      <xsl:when test="$renderas='sect1' or $renderas='sect2' or $renderas='sect3'">
        <xsl:text>&#10;\</xsl:text>
        <xsl:if test="$renderas='sect2'"><xsl:text>sub</xsl:text></xsl:if>   
        <xsl:if test="$renderas='sect3'"><xsl:text>subsub</xsl:text></xsl:if>
        <xsl:text>section*{</xsl:text>
        <xsl:copy-of select="$content"/>
        <xsl:text>}</xsl:text>
        <xsl:call-template name="label.id"/>
        <xsl:text>&#10;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>&#10;&#10;</xsl:text>
        <!-- <xsl:text>\vspace{1em}\noindent{\bfseries </xsl:text><xsl:copy-of select="$content"/><xsl:text>}</xsl:text> -->
        <xsl:text>\noindent\subparagraph*{</xsl:text><xsl:copy-of select="$content"/><xsl:text>}</xsl:text>
        <xsl:call-template name="label.id"/>
        <!-- changed, original was: \par\noindent --> 
        <xsl:text>\par&#10;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="generate.bookinfo.copyright">
    <xsl:apply-templates select="copyright" />
  </xsl:template>

  <xsl:template match="copyright">
    <xsl:if test="count(preceding-sibling::copyright)=0">
      <xsl:text>% switch to fake section&#10;</xsl:text>
      <xsl:text>\let\section=\fakechapter&#10;</xsl:text>
      <xsl:text>\section*{</xsl:text>
      <xsl:call-template name="gentext.element.name"/>
      <xsl:text>}&#10;</xsl:text>
    </xsl:if>
    <xsl:call-template name="gentext.element.name"/>
    <xsl:call-template name='gentext.space'/>
    <xsl:call-template name="dingbat">
      <xsl:with-param name="dingbat">copyright</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name='gentext.space'/>
    <xsl:apply-templates select="year"/>
    <xsl:call-template name='gentext.space'/>
    <xsl:apply-templates select="holder"/>
    <xsl:if test="count(following-sibling::copyright)&gt;0">
      <xsl:text>\newline</xsl:text>
    </xsl:if>
    <xsl:text>&#10;</xsl:text>
  </xsl:template>

  <xsl:template match="legalnotice">
    <xsl:text>\section*{</xsl:text>
        <xsl:call-template name="legalnotice.title"/>
    <xsl:text>}&#10;</xsl:text>
    <xsl:text>\small&#10;</xsl:text>
    <xsl:apply-templates select="node()[not(self::title)]"/>
    <xsl:text>%\vspace{0.6em}\par&#10;</xsl:text>
    <xsl:text>\normalsize\rmfamily&#10;</xsl:text>
    <xsl:text>% switch back to normal section&#10;</xsl:text>
    <xsl:text>\let\section=\originalsection&#10;</xsl:text>
  </xsl:template>

  <xsl:template match="symbol">
    <xsl:param name="entity"><xsl:value-of select="." /></xsl:param>
    <xsl:choose>
      <xsl:when test="$entity='--'"><xsl:text>--</xsl:text></xsl:when>
      <xsl:when test="$entity='BibTeX'"><xsl:text>{\BibTeX{}}</xsl:text></xsl:when>
      <xsl:when test="$entity='LaTeX'"><xsl:text>{\LaTeX{}}</xsl:text></xsl:when>
      <xsl:when test="$entity='LaTeX2e'"><xsl:text>{\LaTeXe{}}</xsl:text></xsl:when>
      <xsl:when test="$entity='Makeindex'"><xsl:text>{\Makeindex{}}</xsl:text></xsl:when>
      <xsl:when test="$entity='PiCTeX'"><xsl:text>{\PiCTeX{}}</xsl:text></xsl:when>
      <xsl:when test="$entity='TeX'"><xsl:text>{\TeX{}}</xsl:text></xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="inline.charseq"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- testing -->

  <xsl:template name="label.id">
    <xsl:text>&#10;% MW: label.id &#10;</xsl:text>
    <xsl:param name="object" select="."/>
    <xsl:text>\label{</xsl:text>
    <xsl:call-template name="generate.label.id">
      <xsl:with-param name="object" select="$object"/>
    </xsl:call-template>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template name="generate.label.id">
    <xsl:param name="object" select="."/>
    <xsl:variable name="id">
      <xsl:choose>
        <xsl:when test="$object/@id">
          <xsl:value-of select="$object/@id"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="generate-id($object)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="normalize-space($id)"/>
  </xsl:template>

</xsl:stylesheet>
