/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.tok;

import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.Position;

class UTF16BigEndianEncoding
extends Encoding {
    final int byteToAscii(byte[] byArray, int n) {
        if (byArray[n] == 0) {
            return (char)byArray[n + 1];
        }
        return -1;
    }

    UTF16BigEndianEncoding() {
        super(2);
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        int n4 = n3;
        while (n != n2) {
            int n5 = (byArray[n++] & 0xFF) << 8;
            cArray[n3++] = (char)(n5 |= byArray[n++] & 0xFF);
        }
        return n3 - n4;
    }

    final boolean charMatches(byte[] byArray, int n, char c) {
        return byArray[n] == 0 && (char)byArray[n + 1] == c;
    }

    final int byteType(byte[] byArray, int n) {
        return Encoding.charTypeTable[byArray[n] & 0xFF][byArray[n + 1] & 0xFF];
    }

    Encoding getUTF16Encoding() {
        return this;
    }

    public int getFixedBytesPerChar() {
        return 2;
    }

    public void movePosition(byte[] byArray, int n, int n2, Position position) {
        int n3 = position.lineNumber;
        int n4 = n - (position.columnNumber << 1);
        block4: while (n != n2) {
            block5: while (byArray[n] == 0) {
                int n5 = ++n;
                ++n;
                switch (byArray[n5]) {
                    case 10: {
                        ++n3;
                        n4 = n;
                        continue block4;
                    }
                    case 13: {
                        if (n != n2 && byArray[n] == 0 && byArray[n + 1] == 10) {
                            n += 2;
                        }
                        ++n3;
                        n4 = n;
                        continue block4;
                    }
                    default: {
                        if (n != n2) continue block5;
                    }
                }
            }
            n += 2;
        }
        position.lineNumber = n3;
        position.columnNumber = n - n4 >> 1;
    }
}

