/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.defaults;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JSplitPane;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.util.DockingUtility;

public class DockingSplitPane
extends JSplitPane
implements DockingConstants {
    protected DockingPort dockingPort;
    protected String region;
    protected boolean dividerLocDetermined;
    protected boolean controllerInTopLeft;
    protected double initialDividerRatio = 0.5;

    public DockingSplitPane(DockingPort port, String region) {
        if (port == null) {
            throw new IllegalArgumentException("'port' cannot be null.");
        }
        if (!DockingManager.isValidDockingRegion(region)) {
            throw new IllegalArgumentException("'" + region + "' is not a valid region.");
        }
        this.region = region;
        this.dockingPort = port;
        this.controllerInTopLeft = !DockingUtility.isRegionTopLeft(region);
        boolean weight = this.controllerInTopLeft;
        this.setResizeWeight((double)weight);
    }

    public void resetToPreferredSizes() {
        Insets i = this.getInsets();
        if (this.getOrientation() == 0) {
            int bottomH;
            int topH;
            int h = this.getHeight() - i.top - i.bottom - this.getDividerSize();
            int extraSpace = h - (topH = this.getTopComponent().getPreferredSize().height) - (bottomH = this.getBottomComponent().getPreferredSize().height);
            if (extraSpace >= 0) {
                this.setDividerLocation(i.top + topH + (int)((double)extraSpace * this.getResizeWeight() + 0.5));
            }
        } else {
            int rightH;
            int leftH;
            int w = this.getWidth() - i.left - i.right - this.getDividerSize();
            int extraSpace = w - (leftH = this.getLeftComponent().getPreferredSize().width) - (rightH = this.getRightComponent().getPreferredSize().width);
            if (extraSpace >= 0) {
                this.setDividerLocation(i.left + leftH + (int)((double)extraSpace * this.getResizeWeight() + 0.5));
            }
        }
    }

    protected boolean isDividerSizeProperlyDetermined() {
        if (this.getDividerLocation() != 0) {
            return true;
        }
        return this.dividerLocDetermined;
    }

    public Component getElderComponent() {
        Component c;
        Component component = c = this.controllerInTopLeft ? this.getLeftComponent() : this.getRightComponent();
        if (c instanceof DockingPort) {
            c = ((DockingPort)((Object)c)).getDockedComponent();
        }
        return c;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isElderTopLeft() {
        return this.controllerInTopLeft;
    }

    public void doLayout() {
        if (!this.isDividerSizeProperlyDetermined()) {
            this.dividerLocDetermined = true;
            this.setDividerLocation(this.initialDividerRatio);
        }
        super.doLayout();
    }

    public void cleanup() {
        this.dockingPort = null;
    }

    public void setInitialDividerRatio(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("ratio (" + ratio + ") must be between [0.0,1,0] inclusive");
        }
        this.initialDividerRatio = ratio;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

