/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.Piece;

public class ChessPiece
extends Piece {
    protected static final int PAWN = 1;
    protected static final int KNIGHT = 2;
    protected static final int BISHOP = 3;
    protected static final int ROOK = 4;
    protected static final int QUEEN = 5;
    protected static final int KING = 6;
    public static final ChessPiece WHITE_PAWN = new ChessPiece(1, 1);
    public static final ChessPiece WHITE_KNIGHT = new ChessPiece(1, 2);
    public static final ChessPiece WHITE_BISHOP = new ChessPiece(1, 3);
    public static final ChessPiece WHITE_ROOK = new ChessPiece(1, 4);
    public static final ChessPiece WHITE_QUEEN = new ChessPiece(1, 5);
    public static final ChessPiece WHITE_KING = new ChessPiece(1, 6);
    public static final ChessPiece BLACK_PAWN = new ChessPiece(-1, 1);
    public static final ChessPiece BLACK_KNIGHT = new ChessPiece(-1, 2);
    public static final ChessPiece BLACK_BISHOP = new ChessPiece(-1, 3);
    public static final ChessPiece BLACK_ROOK = new ChessPiece(-1, 4);
    public static final ChessPiece BLACK_QUEEN = new ChessPiece(-1, 5);
    public static final ChessPiece BLACK_KING = new ChessPiece(-1, 6);

    private ChessPiece(int n, int n2) {
        super(n, n2);
    }

    public static ChessPiece fromShortString(String string) {
        if (string.length() != 1) {
            throw new IllegalArgumentException("The given string must be exactly one character long.");
        }
        char c = string.charAt(0);
        switch (c) {
            case '-': {
                return null;
            }
            case 'P': {
                return WHITE_PAWN;
            }
            case 'N': {
                return WHITE_KNIGHT;
            }
            case 'B': {
                return WHITE_BISHOP;
            }
            case 'R': {
                return WHITE_ROOK;
            }
            case 'Q': {
                return WHITE_QUEEN;
            }
            case 'K': {
                return WHITE_KING;
            }
            case 'p': {
                return BLACK_PAWN;
            }
            case 'n': {
                return BLACK_KNIGHT;
            }
            case 'b': {
                return BLACK_BISHOP;
            }
            case 'r': {
                return BLACK_ROOK;
            }
            case 'q': {
                return BLACK_QUEEN;
            }
            case 'k': {
                return BLACK_KING;
            }
        }
        throw new IllegalArgumentException("Unknown piece: " + string);
    }

    public final boolean isSameColorAs(ChessPiece chessPiece) {
        return this.val * chessPiece.val > 0;
    }

    public final boolean isSameTypeAs(ChessPiece chessPiece) {
        return Math.abs(this.val) == Math.abs(chessPiece.val);
    }

    public final boolean isPawn() {
        return this == WHITE_PAWN || this == BLACK_PAWN;
    }

    public final boolean isKnight() {
        return this == WHITE_KNIGHT || this == BLACK_KNIGHT;
    }

    public final boolean isBishop() {
        return this == WHITE_BISHOP || this == BLACK_BISHOP;
    }

    public final boolean isRook() {
        return this == WHITE_ROOK || this == BLACK_ROOK;
    }

    public final boolean isQueen() {
        return this == WHITE_QUEEN || this == BLACK_QUEEN;
    }

    public final boolean isKing() {
        return this == WHITE_KING || this == BLACK_KING;
    }

    public String toShortString() {
        if (this.isPawn()) {
            return "P";
        }
        if (this.isKnight()) {
            return "N";
        }
        if (this.isBishop()) {
            return "B";
        }
        if (this.isRook()) {
            return "R";
        }
        if (this.isQueen()) {
            return "Q";
        }
        if (this.isKing()) {
            return "K";
        }
        throw new Error("This may never happen");
    }

    public String getTypeName() {
        if (this.isPawn()) {
            return "Pawn";
        }
        if (this.isKnight()) {
            return "Knight";
        }
        if (this.isBishop()) {
            return "Bishop";
        }
        if (this.isRook()) {
            return "Rook";
        }
        if (this.isQueen()) {
            return "Queen";
        }
        if (this.isKing()) {
            return "King";
        }
        throw new Error("This may never happen");
    }
}

