/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.ChessPiece;
import free.chess.DefaultPiecePainter;
import free.chess.Piece;
import free.chess.PiecePainter;
import free.chess.ResourcePiecePainter;
import free.util.IOUtilities;
import free.util.ImageUtilities;
import free.util.TextUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ImagePiecePainter
implements ResourcePiecePainter {
    private static final PiecePainter whileLoadingDelegate = new DefaultPiecePainter();
    private static final ImageFilter SHADING_FILTER = new ShadingFilter();
    private static volatile boolean asyncImageLoad = false;
    private Map[] pieceImages;
    private Map[] shadedPieceImages;
    private final Map imageDataReceivers = new HashMap(2);

    public ImagePiecePainter() {
    }

    public ImagePiecePainter(Map map) {
        int n = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 <= 0) {
                throw new IllegalArgumentException("Image sizes must be positive");
            }
            if (n2 <= n) continue;
            n = n2;
        }
        if (n == 0) {
            throw new IllegalArgumentException("No sizes in the hashtable");
        }
        this.pieceImages = new Map[n + 1];
        this.shadedPieceImages = new Map[n + 1];
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            int n4 = n3;
            Map map2 = (Map)map.get(n3);
            int n5 = map2.size();
            this.pieceImages[n4] = new HashMap(n5);
            this.shadedPieceImages[n4] = new HashMap(n5);
            Iterator iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k = iterator2.next();
                Image image = (Image)map2.get(k);
                Image image2 = ImagePiecePainter.shadeImage(image);
                this.pieceImages[n4].put(k, image);
                this.shadedPieceImages[n4].put(k, image2);
            }
        }
    }

    public static void setAsyncImageLoad(boolean bl) {
        asyncImageLoad = bl;
    }

    private static Image shadeImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), SHADING_FILTER));
    }

    public PiecePainter freshInstance() {
        return this;
    }

    public void load(URL uRL) throws IOException {
        if (this.pieceImages != null) {
            throw new IllegalStateException("This ImagePiecePainter has already been loaded");
        }
        URL uRL2 = new URL(uRL, "definition");
        Properties properties = IOUtilities.loadProperties((URL)uRL2, (boolean)true);
        if (properties == null) {
            throw new IOException("Unable to load " + uRL2);
        }
        String string = properties.getProperty("ext", "gif");
        int[] nArray = TextUtilities.parseIntList((String)properties.getProperty("size.list"), (String)" ");
        this.pieceImages = new HashMap[nArray[nArray.length - 1] + 1];
        this.shadedPieceImages = new HashMap[nArray[nArray.length - 1] + 1];
        Piece[] pieceArray = new Piece[]{ChessPiece.WHITE_KING, ChessPiece.BLACK_KING, ChessPiece.WHITE_QUEEN, ChessPiece.BLACK_QUEEN, ChessPiece.WHITE_ROOK, ChessPiece.BLACK_ROOK, ChessPiece.WHITE_BISHOP, ChessPiece.BLACK_BISHOP, ChessPiece.WHITE_KNIGHT, ChessPiece.BLACK_KNIGHT, ChessPiece.WHITE_PAWN, ChessPiece.BLACK_PAWN};
        String[] stringArray = new String[]{"wk", "bk", "wq", "bq", "wr", "br", "wb", "bb", "wn", "bn", "wp", "bp"};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            HashMap<Piece, URL> hashMap = new HashMap<Piece, URL>(15);
            HashMap<Piece, URL> hashMap2 = new HashMap<Piece, URL>(15);
            for (int j = 0; j < pieceArray.length; ++j) {
                URL uRL3 = new URL(uRL, n + "/" + stringArray[j] + "." + string);
                hashMap.put(pieceArray[j], uRL3);
                hashMap2.put(pieceArray[j], uRL3);
            }
            this.pieceImages[n] = hashMap;
            this.shadedPieceImages[n] = hashMap2;
        }
    }

    protected int bestFitImageSize(int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("Image size must be positive");
        }
        if (n >= this.pieceImages.length) {
            return this.pieceImages.length - 1;
        }
        if (this.pieceImages[n] != null) {
            return n;
        }
        for (n2 = n; n2 > 0; --n2) {
            if (this.pieceImages[n2] == null) continue;
            return n2;
        }
        for (n2 = n + 1; n2 < this.pieceImages.length; ++n2) {
            if (this.pieceImages[n2] == null) continue;
            return n2;
        }
        throw new Error("This can't happen");
    }

    protected synchronized Map loadPieces(int n, boolean bl, Component component) {
        Object object;
        int n2;
        Map map = (bl ? this.shadedPieceImages : this.pieceImages)[n2 = this.bestFitImageSize(n)];
        if (map.values().iterator().next() instanceof Image) {
            return map;
        }
        ImageDataReceiver imageDataReceiver = (ImageDataReceiver)this.imageDataReceivers.get(new Integer(n2));
        if (imageDataReceiver != null) {
            imageDataReceiver.addComponentToRepaint(component);
            return null;
        }
        Set set = map.entrySet();
        Piece[] pieceArray = new Piece[set.size()];
        URL[] uRLArray = new URL[set.size()];
        Iterator iterator = set.iterator();
        for (int i = 0; i < pieceArray.length; ++i) {
            object = iterator.next();
            pieceArray[i] = (Piece)object.getKey();
            uRLArray[i] = (URL)object.getValue();
        }
        Map map2 = this.pieceImages[n2];
        object = this.shadedPieceImages[n2];
        imageDataReceiver = new ImageDataReceiver(asyncImageLoad ? component : null, n2, map2, (Map)object);
        this.imageDataReceivers.put(new Integer(n2), imageDataReceiver);
        if (asyncImageLoad) {
            IOUtilities.loadAsynchronously((URL[])uRLArray, (Object)pieceArray, (IOUtilities.DataReceiver)imageDataReceiver, (boolean)true);
            return null;
        }
        IOUtilities.loadSynchronously((URL[])uRLArray, (Object)pieceArray, (IOUtilities.DataReceiver)imageDataReceiver, (boolean)true);
        return bl ? object : map2;
    }

    public void paintPiece(Piece piece, Graphics graphics, Component component, Rectangle rectangle, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n3 > n4 ? n4 : n3;
        Map map = this.loadPieces(n5, bl, component);
        if (map == null) {
            whileLoadingDelegate.paintPiece(piece, graphics, component, rectangle, bl);
            return;
        }
        Image image = (Image)map.get(piece);
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        graphics.drawImage(image, n + (n3 - n6) / 2, n2 + (n4 - n7) / 2, component);
    }

    private class ImageDataReceiver
    implements IOUtilities.DataReceiver {
        private final Map normalImages;
        private final Map shadedImages;
        private final int imageSize;
        private final Set componentsToRepaint = new HashSet(2);

        public ImageDataReceiver(Component component, int n, Map map, Map map2) {
            this.normalImages = map;
            this.shadedImages = map2;
            this.imageSize = n;
            this.componentsToRepaint.add(component);
        }

        public void addComponentToRepaint(Component component) {
            this.componentsToRepaint.add(component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataRead(URL[] uRLArray, Object object, byte[][] byArray, IOException[] iOExceptionArray) {
            for (int i = 0; i < iOExceptionArray.length; ++i) {
                if (iOExceptionArray[i] == null) continue;
                return;
            }
            ImagePiecePainter imagePiecePainter = ImagePiecePainter.this;
            synchronized (imagePiecePainter) {
                Object object2;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Piece[] pieceArray = (Piece[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    object2 = toolkit.createImage(byArray[i]);
                    Image image = ImagePiecePainter.shadeImage((Image)object2);
                    ImageUtilities.preload((Image)object2);
                    ImageUtilities.preload((Image)image);
                    this.normalImages.put(pieceArray[i], object2);
                    this.shadedImages.put(pieceArray[i], image);
                }
                ImagePiecePainter.this.imageDataReceivers.remove(new Integer(this.imageSize));
                Iterator iterator = this.componentsToRepaint.iterator();
                while (iterator.hasNext()) {
                    object2 = (Component)iterator.next();
                    if (object2 == null) continue;
                    ((Component)object2).repaint();
                }
            }
        }
    }

    private static class ShadingFilter
    extends RGBImageFilter {
        private ShadingFilter() {
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFF;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            n5 = (n5 + 256) / 3;
            n6 = (n6 + 256) / 3;
            n7 = (n7 + 256) / 3;
            return n4 << 24 | n5 << 16 | n6 << 8 | n7;
        }
    }
}

