/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScrollPane
extends Container
implements Accessible {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private static final long serialVersionUID = 7956609840827222915L;
    private ScrollPaneAdjustable hAdjustable;
    private ScrollPaneAdjustable vAdjustable;
    private int scrollbarDisplayPolicy;
    private Point scrollPosition;
    private boolean wheelScrollingEnabled;

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    public Dimension getViewportSize() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        Component[] componentArray = this.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return dimension;
        }
        Dimension dimension2 = componentArray[0].getPreferredSize();
        if (dimension2.width <= 0 && dimension2.height <= 0) {
            return dimension;
        }
        int n = this.getVScrollbarWidth();
        int n2 = this.getHScrollbarHeight();
        if (this.scrollbarDisplayPolicy == 1) {
            dimension.width -= n;
            dimension.height -= n2;
            return dimension;
        }
        if (this.scrollbarDisplayPolicy == 2) {
            return dimension;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (dimension2.height > dimension.height) {
            bl3 = true;
        } else if (dimension2.height > dimension.height - n2) {
            bl = true;
        }
        if (dimension2.width > dimension.width) {
            bl4 = true;
        } else if (dimension2.width > dimension.width - n) {
            bl2 = true;
        }
        if (bl3 && bl2) {
            bl4 = true;
        }
        if (bl4 && bl) {
            bl3 = true;
        }
        if (bl4) {
            dimension.height -= n2;
        }
        if (bl3) {
            dimension.width -= n;
        }
        return dimension;
    }

    public int getHScrollbarHeight() {
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.getPeer();
        if (scrollPanePeer != null) {
            return scrollPanePeer.getHScrollbarHeight();
        }
        return 0;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.getPeer();
        if (scrollPanePeer != null) {
            return scrollPanePeer.getVScrollbarWidth();
        }
        return 0;
    }

    public Point getScrollPosition() {
        int n = 0;
        int n2 = 0;
        Adjustable adjustable = this.getVAdjustable();
        Adjustable adjustable2 = this.getHAdjustable();
        if (adjustable != null) {
            n2 = adjustable.getValue();
        }
        if (adjustable2 != null) {
            n = adjustable2.getValue();
        }
        return new Point(n, n2);
    }

    public void setScrollPosition(Point point) throws IllegalArgumentException {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollPosition(int n, int n2) {
        ScrollPanePeer scrollPanePeer;
        Adjustable adjustable = this.getHAdjustable();
        Adjustable adjustable2 = this.getVAdjustable();
        if (adjustable != null) {
            adjustable.setValue(n);
        }
        if (adjustable2 != null) {
            adjustable2.setValue(n2);
        }
        if ((scrollPanePeer = (ScrollPanePeer)this.getPeer()) != null) {
            scrollPanePeer.setScrollPosition(n, n2);
        }
    }

    public void addNotify() {
        if (this.peer != null) {
            return;
        }
        this.setPeer(this.getToolkit().createScrollPane(this));
        super.addNotify();
        Component[] componentArray = this.getComponents();
        if (componentArray != null && componentArray.length > 0 && !(componentArray[0] instanceof Panel)) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add(componentArray[0], "Center");
            this.add(panel);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected final void addImpl(Component component, Object object, int n) {
        Component[] componentArray = this.getComponents();
        if (componentArray != null && componentArray.length > 0) {
            this.remove(componentArray[0]);
        }
        super.addImpl(component, object, -1);
        this.doLayout();
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null && componentArray.length > 0) {
            ScrollPanePeer scrollPanePeer;
            Dimension dimension = componentArray[0].getPreferredSize();
            Dimension dimension2 = this.getViewportSize();
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
            if ((scrollPanePeer = (ScrollPanePeer)this.getPeer()) != null) {
                scrollPanePeer.childResized(dimension.width, dimension.height);
            }
            componentArray[0].setSize(dimension);
            Point point = this.getScrollPosition();
            if (point.x > dimension.width) {
                point.x = dimension.width;
            }
            if (point.y > dimension.height) {
                point.y = dimension.height;
            }
            this.setScrollPosition(point);
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void printComponents(Graphics graphics) {
        super.printComponents(graphics);
    }

    public String paramString() {
        Insets insets = this.getInsets();
        return this.getName() + ',' + this.getX() + ',' + this.getY() + ',' + this.getWidth() + 'x' + this.getHeight() + ",ScrollPosition=(" + this.scrollPosition.getX() + ',' + this.scrollPosition.getY() + "),Insets=(" + insets.top + ',' + insets.left + ',' + insets.bottom + ',' + insets.right + "),ScrollbarDisplayPolicy=" + this.getScrollbarDisplayPolicy() + ",wheelScrollingEnabled=" + this.isWheelScrollingEnabled();
    }

    protected boolean eventTypeEnabled(int n) {
        if (n == 507) {
            return this.wheelScrollingEnabled;
        }
        return super.eventTypeEnabled(n);
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        this.wheelScrollingEnabled = bl;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollPane();
        }
        return this.accessibleContext;
    }

    private final /* synthetic */ void this() {
        this.scrollPosition = new Point(0, 0);
    }

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int n) {
        this.this();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.scrollbarDisplayPolicy = n;
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("Bad scrollbarDisplayPolicy: " + n);
        }
        if (n != 2) {
            this.hAdjustable = new ScrollPaneAdjustable(this, 0);
            this.vAdjustable = new ScrollPaneAdjustable(this, 1);
        }
        this.wheelScrollingEnabled = true;
        this.setSize(100, 100);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTScrollPane
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 6100703663886637L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }

        protected AccessibleAWTScrollPane() {
        }
    }
}

