/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private static final long serialVersionUID = 3801124242820219131L;
    transient LinkedHashEntry root;
    final boolean accessOrder;

    public void clear() {
        super.clear();
        this.root = null;
    }

    public boolean containsValue(Object object) {
        LinkedHashEntry linkedHashEntry = this.root;
        while (linkedHashEntry != null) {
            if (LinkedHashMap.equals(object, linkedHashEntry.value)) {
                return true;
            }
            linkedHashEntry = linkedHashEntry.succ;
        }
        return false;
    }

    public Object get(Object object) {
        int n = this.hash(object);
        HashMap.HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (LinkedHashMap.equals(object, hashEntry.key)) {
                hashEntry.access();
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        return false;
    }

    void addEntry(Object object, Object object2, int n, boolean bl) {
        LinkedHashEntry linkedHashEntry = new LinkedHashEntry(object, object2);
        linkedHashEntry.next = this.buckets[n];
        this.buckets[n] = linkedHashEntry;
        if (bl && this.removeEldestEntry(this.root)) {
            this.remove(this.root.key);
        }
    }

    void putAllInternal(Map map) {
        this.root = null;
        super.putAllInternal(map);
    }

    Iterator iterator(final int n) {
        return new Iterator(){
            LinkedHashEntry current;
            LinkedHashEntry last;
            int knownMod;

            public final boolean hasNext() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                boolean bl = false;
                if (this.current != null) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = this.current.succ;
                return n == 1 ? this.last.value : (n == 0 ? this.last.key : this.last);
            }

            public final void remove() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                LinkedHashMap.this.remove(this.last.key);
                this.last = null;
                ++this.knownMod;
            }

            private final /* synthetic */ void this() {
                this.current = LinkedHashMap.this.root;
                this.knownMod = LinkedHashMap.this.modCount;
            }
            {
                this.this();
            }
        };
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LinkedHashEntry
    extends HashMap.HashEntry {
        LinkedHashEntry pred;
        LinkedHashEntry succ;

        void access() {
            if (LinkedHashMap.this.accessOrder && this.succ != null) {
                ++LinkedHashMap.this.modCount;
                if (this == LinkedHashMap.this.root) {
                    LinkedHashMap.this.root = this.succ;
                    this.pred.succ = this;
                    this.succ = null;
                } else {
                    this.pred.succ = this.succ;
                    this.succ.pred = this.pred;
                    this.succ = null;
                    this.pred = LinkedHashMap.this.root.pred;
                    this.pred.succ = this;
                    LinkedHashMap.this.root.pred = this;
                }
            }
        }

        Object cleanup() {
            if (this == LinkedHashMap.this.root) {
                LinkedHashMap.this.root = this.succ;
                if (this.succ != null) {
                    this.succ.pred = this.pred;
                }
            } else if (this.succ == null) {
                this.pred.succ = null;
                LinkedHashMap.this.root.pred = this.pred;
            } else {
                this.pred.succ = this.succ;
                this.succ.pred = this.pred;
            }
            return this.value;
        }

        LinkedHashEntry(Object object, Object object2) {
            super(object, object2);
            if (LinkedHashMap.this.root == null) {
                LinkedHashMap.this.root = this;
                this.pred = this;
            } else {
                this.pred = LinkedHashMap.this.root.pred;
                this.pred.succ = this;
                LinkedHashMap.this.root.pred = this;
            }
        }
    }
}

