/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class SwingWorkerParam
implements Runnable {
    private Object value;
    private Vector param;
    private Runnable doFinished;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct(Vector var1);

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setValue(this.construct(this.param));
        }
        finally {
            this.threadVar.clear();
        }
        SwingUtilities.invokeLater(this.doFinished);
    }

    public SwingWorkerParam(Vector constructParameters) {
        this.param = constructParameters;
        this.doFinished = new Runnable(){

            public void run() {
                SwingWorkerParam.this.finished();
            }
        };
        Thread doConstruct = new Thread(this);
        this.threadVar = new ThreadVar(doConstruct);
        doConstruct.start();
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

