#!/usr/bin/env ruby -w

module Borges; end
require 'Borges/Profile/Profile'

require 'Borges/Extensions/Array'
require 'Borges/Extensions/Numeric'
require 'Borges/Extensions/Object'
require 'Borges/Extensions/Proc'
require 'Borges/Extensions/String'

require 'Borges/HTML/HtmlAttributes'
require 'Borges/HTML/HtmlElement'
require 'Borges/HTML/HtmlBuilder'
require 'Borges/HTML/HtmlRenderer'
require 'Borges/HTML/RenderingContext'

require 'Borges/TestCase/Util/HtmlDocument'
require 'Borges/TestCase/Util/CallbackStore'

class HtmlRendererProfiler < Profiler
  
  def initialize
    @url = "http://example.com/"
  end

  def render
    str = ''
    rc = Borges::RenderingContext.new(HtmlDocument.new,
                                      @url, CallbackStore.new)
    yield ::Borges::HtmlRenderer.new(rc)
    return rc.document.to_s
  end

  def start
    1.times do
      render do |r|
        render_document_on r
      end
    end
  end

  def render_document_on(r)
    r.title "Profiler Test Page"

    r.heading "Profiler Test Page"

    10.times do |i|
      r.heading_level "Chunk #{i}", 2
      render_table_on i, r

      render_form_on i, r
    end
  end

  def render_table_on(table_count, r)
    r.heading_level "Table Number #{table_count}", 3

    r.table do
      r.table_headings(*((1..10).map do |x| "Column #{x}" end))

      ('a'..'j').each do |row|
        r.table_row do
          (1..10).each do |col|
            r.table_data do
              r.text "#{col}#{row}"
            end
          end
        end
      end
    end
  end

  def render_form_on form_count, r
    r.heading_level "Form Number #{form_count}", 3

    r.form do
      render_checkboxes_on form_count, r
      render_inputs_on form_count, r
      render_select_on form_count, r
      render_radio_group_on form_count, r
      r.submit_button do end
    end
  end

  def render_checkboxes_on(form_count, r)
    r.fieldset('Checkboxes') do
      sym = "checkbox_#{form_count}a".intern
      r.label_for sym
      r.element_id sym
      r.checkbox do end
      r.break

      sym = "checkbox_#{form_count}b".intern
      r.label_for sym
      r.element_id sym
      r.checkbox do end
    end
  end

  def render_inputs_on(form_count, r)
    r.fieldset('Inputs') do
      sym = "text_#{form_count}a".intern
      r.label_for sym
      r.element_id sym
      r.text_input do end
      r.break

      sym = "text_#{form_count}b".intern
      r.label_for sym
      r.element_id sym
      r.text_input do end
    end
  end

  def render_select_on(form_count, r)
    r.fieldset('Select') do
      sym = "select_#{form_count}a".intern
      r.label_for sym
      r.element_id sym
      r.select(('a'..'e')) do end

      r.break
      sym = "select_#{form_count}b".intern
      r.label_for sym
      r.element_id sym
      r.select(('a'..'e')) do end
    end
  end

  def render_radio_group_on(form_count, r)
    r.fieldset('Radio Group') do
      group = r.radio_group

      sym = "radio_#{form_count}a"
      r.label_for sym
      r.element_id sym
      r.radio_button(group) do end
      r.break

      sym = "radio_#{form_count}b"
      r.label_for sym
      r.element_id sym
      r.radio_button(group) do end
      r.break

      sym = "radio_#{form_count}c"
      r.label_for sym
      r.element_id sym
      r.radio_button(group) do end
    end
  end

end

if $0 == __FILE__ then
  puts HtmlRendererProfiler.profile
end

