/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Bin;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BinningIndexContent {
    private final int mReferenceSequence;
    private final BinList mBinList;
    private final LinearIndex mLinearIndex;

    public BinningIndexContent(int referenceSequence, BinList binList, LinearIndex linearIndex) {
        this.mReferenceSequence = referenceSequence;
        this.mBinList = binList;
        this.mLinearIndex = linearIndex;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public boolean containsBin(Bin bin) {
        return this.mBinList.getBin(bin.getBinNumber()) != null;
    }

    public BinList getBins() {
        return this.mBinList;
    }

    int getNumberOfNonNullBins() {
        return this.mBinList.getNumberOfNonNullBins();
    }

    public List<Chunk> getAllChunks() {
        ArrayList<Chunk> allChunks = new ArrayList<Chunk>();
        for (Bin b : this.mBinList) {
            if (b.getChunkList() == null) continue;
            allChunks.addAll(b.getChunkList());
        }
        return Collections.unmodifiableList(allChunks);
    }

    public LinearIndex getLinearIndex() {
        return this.mLinearIndex;
    }

    public List<Chunk> getChunksOverlapping(int startPos, int endPos) {
        BitSet overlappingBins = GenomicIndexUtil.regionToBins(startPos, endPos);
        if (overlappingBins == null) {
            return null;
        }
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        int index = overlappingBins.nextSetBit(0);
        while (index >= 0) {
            Bin bin = this.getBins().getBin(index);
            if (bin != null) {
                for (Chunk chunk : bin.getChunkList()) {
                    chunkList.add(chunk.clone());
                }
            }
            index = overlappingBins.nextSetBit(index + 1);
        }
        if (chunkList.isEmpty()) {
            return null;
        }
        return Chunk.optimizeChunkList(chunkList, this.getLinearIndex().getMinimumOffset(startPos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinningIndexContent that = (BinningIndexContent)o;
        if (this.mReferenceSequence != that.mReferenceSequence) {
            return false;
        }
        if (!this.mBinList.equals(that.mBinList)) {
            return false;
        }
        return this.mLinearIndex.equals(that.mLinearIndex);
    }

    public int hashCode() {
        int result = this.mReferenceSequence;
        result = 31 * result + this.mBinList.hashCode();
        result = 31 * result + this.mLinearIndex.hashCode();
        return result;
    }

    public static class BinList
    implements Iterable<Bin> {
        private final Bin[] mBinArray;
        public final int numberOfNonNullBins;
        public final int maxBinNumber;

        public BinList(Bin[] binArray, int numberOfNonNullBins) {
            this.mBinArray = binArray;
            this.numberOfNonNullBins = numberOfNonNullBins;
            this.maxBinNumber = this.mBinArray.length - 1;
        }

        public Bin getBin(int binNumber) {
            if (binNumber > this.maxBinNumber) {
                return null;
            }
            return this.mBinArray[binNumber];
        }

        public int getNumberOfNonNullBins() {
            return this.numberOfNonNullBins;
        }

        @Override
        public Iterator<Bin> iterator() {
            return new BinIterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinList bins = (BinList)o;
            if (this.maxBinNumber != bins.maxBinNumber) {
                return false;
            }
            if (this.numberOfNonNullBins != bins.numberOfNonNullBins) {
                return false;
            }
            return Arrays.equals(this.mBinArray, bins.mBinArray);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.mBinArray);
            result = 31 * result + this.numberOfNonNullBins;
            result = 31 * result + this.maxBinNumber;
            return result;
        }

        private class BinIterator
        implements Iterator<Bin> {
            private int nextBin = 0;

            @Override
            public boolean hasNext() {
                while (this.nextBin <= BinList.this.maxBinNumber) {
                    if (BinList.this.getBin(this.nextBin) != null) {
                        return true;
                    }
                    ++this.nextBin;
                }
                return false;
            }

            @Override
            public Bin next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("This BinIterator is currently empty");
                }
                Bin result = BinList.this.getBin(this.nextBin);
                ++this.nextBin;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove from a bin iterator");
            }
        }
    }
}

