/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Signature;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ReferenceTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeSignature(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeClassLoader(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeModifiers(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeFields(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeMethods(byteBuffer, dataOutputStream);
                    break;
                }
                case 6: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 7: {
                    this.executeSourceFile(byteBuffer, dataOutputStream);
                    break;
                }
                case 8: {
                    this.executeNestedTypes(byteBuffer, dataOutputStream);
                    break;
                }
                case 9: {
                    this.executeStatus(byteBuffer, dataOutputStream);
                    break;
                }
                case 10: {
                    this.executeInterfaces(byteBuffer, dataOutputStream);
                    break;
                }
                case 11: {
                    this.executeClassObject(byteBuffer, dataOutputStream);
                    break;
                }
                case 12: {
                    this.executeSourceDebugExtension(byteBuffer, dataOutputStream);
                    break;
                }
                case 13: {
                    this.executeSignatureWithGeneric(byteBuffer, dataOutputStream);
                    break;
                }
                case 14: {
                    this.executeFieldWithGeneric(byteBuffer, dataOutputStream);
                    break;
                }
                case 15: {
                    this.executeMethodsWithGeneric(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ReferenceType Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeSignature(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        String string = Signature.computeClassSignature(referenceTypeId.getType());
        JdwpString.writeString(dataOutputStream, string);
    }

    private final void executeClassLoader(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ClassLoader classLoader = clazz.getClassLoader();
        ObjectId objectId = this.idMan.getObjectId(classLoader);
        objectId.write(dataOutputStream);
    }

    private final void executeModifiers(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        dataOutputStream.writeInt(clazz.getModifiers());
    }

    private final void executeFields(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        Field[] fieldArray = clazz.getFields();
        dataOutputStream.writeInt(fieldArray.length);
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            this.idMan.getObjectId(field).write(dataOutputStream);
            JdwpString.writeString(dataOutputStream, field.getName());
            JdwpString.writeString(dataOutputStream, Signature.computeFieldSignature(field));
            dataOutputStream.writeInt(field.getModifiers());
            ++n;
        }
    }

    private final void executeMethods(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ClassReferenceTypeId classReferenceTypeId = (ClassReferenceTypeId)this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = classReferenceTypeId.getType();
        VMMethod[] vMMethodArray = VMVirtualMachine.getAllClassMethods(clazz);
        dataOutputStream.writeInt(vMMethodArray.length);
        int n = 0;
        while (n < vMMethodArray.length) {
            VMMethod vMMethod = vMMethodArray[n];
            vMMethod.writeId(dataOutputStream);
            JdwpString.writeString(dataOutputStream, vMMethod.getName());
            JdwpString.writeString(dataOutputStream, vMMethod.getSignature());
            dataOutputStream.writeInt(vMMethod.getModifiers());
            ++n;
        }
    }

    private final void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        int n = byteBuffer.getInt();
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            ObjectId objectId = this.idMan.readObjectId(byteBuffer);
            Field field = (Field)objectId.getObject();
            Class clazz2 = field.getDeclaringClass();
            if (clazz2.isAssignableFrom(clazz)) {
                try {
                    field.setAccessible(true);
                    Object object = field.get(null);
                    Value.writeTaggedValue(dataOutputStream, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidFieldException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JdwpInternalErrorException(illegalAccessException);
                }
            } else {
                throw new InvalidFieldException(objectId.getId());
            }
            ++n2;
        }
    }

    private final void executeSourceFile(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        String string = VMVirtualMachine.getSourceFile(clazz);
        JdwpString.writeString(dataOutputStream, string);
    }

    private final void executeNestedTypes(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        Class[] classArray = clazz.getDeclaredClasses();
        dataOutputStream.writeInt(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            Class clazz2 = classArray[n];
            ReferenceTypeId referenceTypeId2 = this.idMan.getReferenceTypeId(clazz2);
            referenceTypeId2.writeTagged(dataOutputStream);
            ++n;
        }
    }

    private final void executeStatus(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        int n = VMVirtualMachine.getClassStatus(clazz);
        dataOutputStream.writeInt(n);
    }

    private final void executeInterfaces(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        Class[] classArray = clazz.getInterfaces();
        dataOutputStream.writeInt(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            Class clazz2 = classArray[n];
            ReferenceTypeId referenceTypeId2 = this.idMan.getReferenceTypeId(clazz2);
            referenceTypeId2.write(dataOutputStream);
            ++n;
        }
    }

    private final void executeClassObject(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ObjectId objectId = this.idMan.getObjectId(clazz);
        objectId.write(dataOutputStream);
    }

    private final void executeSourceDebugExtension(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }

    private final void executeSignatureWithGeneric(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }

    private final void executeFieldWithGeneric(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }

    private final void executeMethodsWithGeneric(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }
}

