/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.Newsrc;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileNewsrc
implements Newsrc {
    private static final String NEWSRC_ENCODING = "US-ASCII";
    protected File file;
    protected List subs;
    protected List groups;
    protected Map lines;
    protected boolean dirty;
    protected boolean debug;

    public void close() {
        if (!this.dirty) {
            return;
        }
        this.save();
    }

    void load() {
        long l;
        long l2 = this.file.length();
        int n = (int)(l2 > (l = Integer.MAX_VALUE) ? l : l2);
        this.groups = new LinkedList();
        this.lines = new HashMap(n / 20);
        this.subs = new LinkedList();
        try {
            long l3 = System.currentTimeMillis();
            if (this.debug) {
                System.err.println("DEBUG: nntp: newsrc loading " + this.file.getPath());
            }
            FileInputStream fileInputStream = new FileInputStream(this.file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, NEWSRC_ENCODING);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, n);
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2;
                int n2 = string.indexOf(58);
                if (n2 > -1) {
                    String string3 = string.substring(0, n2);
                    this.groups.add(string3);
                    this.subs.add(string3);
                    if (++n2 < string.length() && (string2 = string.substring(n2).trim()).length() > 0) {
                        this.lines.put(string3, string2);
                    }
                } else {
                    int n3 = string.indexOf(33);
                    if (n3 > -1) {
                        String string4;
                        string2 = string.substring(0, n3);
                        this.groups.add(string2);
                        if (++n3 < string.length() && (string4 = string.substring(n3).trim()).length() > 0) {
                            this.lines.put(string2, string4);
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            long l4 = System.currentTimeMillis();
            if (this.debug) {
                System.err.println("DEBUG: nntp: newsrc load: " + this.groups.size() + " groups in " + (l4 - l3) + "ms");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println("WARNING: nntp: unable to read newsrc file");
            if (this.debug) {
                iOException.printStackTrace(System.err);
            }
        }
        catch (SecurityException securityException) {
            System.err.println("WARNING: nntp: no read permission on newsrc file");
        }
        this.dirty = false;
    }

    void save() {
        block10: {
            try {
                long l = System.currentTimeMillis();
                if (this.debug) {
                    System.err.println("DEBUG: nntp: newsrc saving " + this.file.getPath());
                }
                int n = this.groups.size() * 20;
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n);
                Iterator iterator = this.groups.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = (String)iterator.next();
                    StringBuffer stringBuffer = new StringBuffer(string);
                    if (this.subs.contains(string)) {
                        stringBuffer.append(':');
                    } else {
                        stringBuffer.append('!');
                    }
                    Object object2 = this.lines.get(string);
                    if (object2 instanceof String) {
                        stringBuffer.append((String)object2);
                    } else {
                        object = (RangeList)object2;
                        if (object != null) {
                            stringBuffer.append(((RangeList)object).toString());
                        }
                    }
                    stringBuffer.append('\n');
                    object = stringBuffer.toString().getBytes(NEWSRC_ENCODING);
                    bufferedOutputStream.write((byte[])object);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                long l2 = System.currentTimeMillis();
                if (this.debug) {
                    System.err.println("DEBUG: nntp: newsrc save: " + this.groups.size() + " groups in " + (l2 - l) + "ms");
                }
            }
            catch (IOException iOException) {
                System.err.println("WARNING: nntp: unable to save newsrc file");
                if (!this.debug) break block10;
                iOException.printStackTrace(System.err);
            }
        }
        this.dirty = false;
    }

    public Iterator list() {
        if (this.subs == null) {
            this.load();
        }
        return this.subs.iterator();
    }

    public boolean isSubscribed(String string) {
        if (this.subs == null) {
            this.load();
        }
        return this.subs.contains(string);
    }

    public void setSubscribed(String string, boolean bl) {
        if (this.subs == null) {
            this.load();
        }
        if (bl && !this.groups.contains(string)) {
            this.groups.add(string);
        }
        boolean bl2 = this.subs.contains(string);
        if (bl && !bl2) {
            this.subs.add(string);
            this.dirty = true;
        } else if (!bl && bl2) {
            this.subs.remove(string);
            this.dirty = true;
        }
    }

    public boolean isSeen(String string, int n) {
        RangeList rangeList;
        Object object;
        if (this.subs == null) {
            this.load();
        }
        if ((object = this.lines.get(string)) instanceof String) {
            object = new RangeList((String)object);
        }
        if ((rangeList = (RangeList)object) != null) {
            return rangeList.isSeen(n);
        }
        return false;
    }

    public void setSeen(String string, int n, boolean bl) {
        RangeList rangeList;
        Object object;
        if (this.subs == null) {
            this.load();
        }
        if ((object = this.lines.get(string)) instanceof String) {
            object = new RangeList((String)object);
        }
        if ((rangeList = (RangeList)object) == null) {
            rangeList = new RangeList();
            this.lines.put(string, rangeList);
            this.dirty = true;
        }
        if (rangeList.isSeen(n) != bl) {
            rangeList.setSeen(n, bl);
            this.dirty = true;
        }
    }

    private final /* synthetic */ void this() {
        this.subs = null;
        this.groups = null;
        this.lines = null;
    }

    public FileNewsrc(File file, boolean bl) {
        this.this();
        this.file = file;
        this.debug = bl;
    }

    static class RangeList {
        List seen = new ArrayList();

        private final void addToken(String string) throws NumberFormatException {
            int n = string.indexOf(45);
            if (n > -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = Integer.parseInt(string2);
                int n3 = Integer.parseInt(string3);
                if (n2 > -1 && n3 > -1) {
                    this.insert(n2, n3);
                }
            } else {
                int n4 = Integer.parseInt(string);
                if (n4 > -1) {
                    this.insert(n4);
                }
            }
        }

        public boolean isSeen(int n) {
            int n2 = this.seen.size();
            Object[] objectArray = new Range[n2];
            this.seen.toArray(objectArray);
            int n3 = 0;
            while (n3 < n2) {
                if (((Range)objectArray[n3]).contains(n)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        public void setSeen(int n, boolean bl) {
            if (bl) {
                this.insert(n);
            } else {
                this.remove(n);
            }
        }

        int indexOf(int n) {
            int n2 = this.seen.size();
            Object[] objectArray = new Range[n2];
            this.seen.toArray(objectArray);
            int n3 = 0;
            while (n3 < n2) {
                if (((Range)objectArray[n3]).contains(n)) {
                    return n3;
                }
                if (((Range)objectArray[n3]).from > n) {
                    return n3;
                }
                if (((Range)objectArray[n3]).to == n - 1) {
                    return n3;
                }
                ++n3;
            }
            return n2;
        }

        void insert(int n, int n2) {
            Range range = new Range(n, n2);
            int n3 = this.indexOf(range.from);
            if (n3 == this.seen.size()) {
                this.seen.add(range);
                return;
            }
            Range range2 = (Range)this.seen.get(n3);
            if (range.to < range2.from) {
                this.seen.add(n3, range);
                return;
            }
            if (range2.from <= range.from && range2.to >= range.to) {
                return;
            }
            int n4 = this.indexOf(range.to);
            Range range3 = (Range)this.seen.get(n4);
            System.err.println("r2 " + range3 + " i2 " + n4);
            int n5 = n4;
            while (n5 >= n3) {
                this.seen.remove(n5);
                --n5;
            }
            n5 = range.from < range2.from ? range.from : range2.from;
            int n6 = range.to > range3.to ? range.to : range3.to;
            range = new Range(n5, n6);
            this.seen.add(n3, range);
        }

        void insert(int n) {
            this.insert(n, n);
        }

        void remove(int n) {
            Range range;
            int n2 = this.indexOf(n);
            Range range2 = (Range)this.seen.get(n2);
            this.seen.remove(n2);
            if (range2.from == range2.to && range2.to == n) {
                return;
            }
            if (range2.to > n) {
                range = new Range(n + 1, range2.to);
                this.seen.add(n2, range);
            }
            if (range2.from < n) {
                range = new Range(range2.from, n - 1);
                this.seen.add(n2, range);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.seen.size();
            int n2 = 0;
            while (n2 < n) {
                Range range = (Range)this.seen.get(n2);
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(range.toString());
                ++n2;
            }
            return stringBuffer.toString();
        }

        RangeList() {
        }

        RangeList(String string) {
            this();
            try {
                int n = 0;
                int n2 = string.indexOf(44);
                while (n2 > n) {
                    String string2 = string.substring(n, n2);
                    this.addToken(string2);
                    n = n2 + 1;
                    n2 = string.indexOf(44, n);
                }
                this.addToken(string.substring(n));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("ERROR: nntp: bad newsrc format: " + string);
            }
        }
    }

    static class Range {
        int from;
        int to;

        public boolean contains(int n) {
            boolean bl = false;
            if (n >= this.from && n <= this.to) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            if (this.from != this.to) {
                return "" + this.from + '-' + this.to;
            }
            return Integer.toString(this.from);
        }

        public Range(int n) {
            this.from = this.to = n;
        }

        public Range(int n, int n2) {
            if (n > n2) {
                this.from = n2;
                this.to = n;
            } else {
                this.from = n;
                this.to = n2;
            }
        }
    }
}

