/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLOT_CLIPBOARD_H__
#define __SG_PLOT_CLIPBOARD_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include "sg_plot.h"

#define SG_PLOT_CLIPBOARD(obj)        GTK_CHECK_CAST (obj, sg_plot_clipboard_get_type (), SGplotClipboard)
#define GTK_TYPE_SG_PLOT_CLIPBOARD   (sg_plot_clipboard_get_type ())

#define SG_PLOT_CLIPBOARD_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plot_clipboard_get_type(), SGplotClipboardClass)
#define GTK_IS_SG_PLOT_CLIPBOARD(obj)     GTK_CHECK_TYPE (obj, sg_plot_clipboard_get_type ())

typedef struct _SGplotClipboard SGplotClipboard;
typedef struct _SGplotClipboardClass SGplotClipboardClass;

struct _SGplotClipboard
{
  GObject object;

  GdkPixmap *pixmap;
};

struct _SGplotClipboardClass
{
  GObjectClass parent_class;
};

GType sg_plot_clipboard_get_type	(void);
GObject *sg_plot_clipboard_new	(void);
void 	sg_plot_clipboard_copy		(SGplotClipboard *clipboard,
					 SGplot *plot);
void 	sg_plot_clipboard_paste		(SGplotClipboard *clipboard,
					 SGplot *plot,
                          		 gdouble x, gdouble y);
void	sg_plot_clipboard_clear		(SGplotClipboard *clipboard);
					 
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLOT_CLIPBOARD_H__ */

